/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.ShutdownManager;

class ShutdownHook
extends Thread {
    private final Thread mainThread;
    private final ShutdownManager shutdownManager;
    private volatile boolean requestShutdown = true;
    private volatile boolean blockJvmExit = true;

    public ShutdownHook(ShutdownManager pShutdownManager) {
        super("Shutdown Hook");
        this.shutdownManager = (ShutdownManager)Preconditions.checkNotNull((Object)pShutdownManager);
        this.mainThread = Thread.currentThread();
    }

    public void disableAndStop() {
        this.blockJvmExit = false;
        this.requestShutdown = false;
        this.interrupt();
    }

    public void disableShutdownRequests() {
        this.requestShutdown = false;
    }

    @Override
    public void run() {
        if (this.requestShutdown && this.mainThread.isAlive()) {
            this.shutdownManager.requestShutdown("The JVM is shutting down, probably because Ctrl+C was pressed.");
        }
        if (this.blockJvmExit) {
            try {
                this.mainThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

