/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.graph.Traverser;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.InvalidComponentException;
import org.sosy_lab.cpachecker.util.CPAs;

@Options
public class CPABuilder {
    private static final CPAConfig SPECIFICATION_PLACEHOLDER = new CPAConfig("$specification");
    private static final String CPA_OPTION_NAME = "cpa";
    private static final String CPA_CLASS_PREFIX = "org.sosy_lab.cpachecker";
    private static final Splitter LIST_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    @Option(secure=true, name="cpa", description="CPA to use (see doc/Configuration.md for more documentation on this)")
    private String cpaName = CompositeCPA.class.getCanonicalName();
    private final Configuration config;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final ReachedSetFactory reachedSetFactory;

    public CPABuilder(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, ReachedSetFactory pReachedSetFactory) throws InvalidConfigurationException {
        this.config = pConfig;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.reachedSetFactory = pReachedSetFactory;
        this.config.inject((Object)this);
    }

    public ConfigurableProgramAnalysis buildCPAs(CFA cfa, Specification specification, AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException, CPAException, InterruptedException {
        return this.buildCPAs(cfa, specification, (List<Automaton>)ImmutableList.of(), pAggregatedReachedSets);
    }

    public ConfigurableProgramAnalysis buildCPAs(CFA cfa, Specification specification, List<Automaton> additionalAutomata, AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException, CPAException, InterruptedException {
        FluentIterable allAutomata = FluentIterable.concat(specification.getSpecificationAutomata(), additionalAutomata);
        CPAConfig rootCpaConfig = this.collectCPAConfigs(CPA_OPTION_NAME, this.cpaName);
        FluentIterable allCpaConfigs = FluentIterable.from((Iterable)Traverser.forTree(CPAConfig::getAllChildren).depthFirstPostOrder((Object)rootCpaConfig));
        if (rootCpaConfig.cpaClass == CompositeCPA.class && rootCpaConfig.getAllChildren().isEmpty() && allAutomata.isEmpty()) {
            throw new InvalidConfigurationException("Please specify a configuration with '-config CONFIG_FILE' or '-CONFIG' (for example, '-default', '-predicateAnalysis', or '-valueAnalysis'). See README.md for more details.");
        }
        this.checkAliasUniqueness((FluentIterable<CPAConfig>)allCpaConfigs, (FluentIterable<Automaton>)allAutomata);
        int placeholderCount = allCpaConfigs.filter(cpa -> cpa.isPlaceholder).size();
        if (placeholderCount > 1) {
            throw new InvalidConfigurationException("Placeholder " + CPABuilder.SPECIFICATION_PLACEHOLDER.name + " must occur at most once in CPA configuration!");
        }
        if (placeholderCount == 0 && !allAutomata.isEmpty()) {
            CPAConfig insertionPoint = (CPAConfig)allCpaConfigs.firstMatch(cpa -> !cpa.children.isEmpty() || cpa.child == null && cpa.alias.equals("CompositeCPA")).toJavaUtil().orElseThrow(() -> new InvalidConfigurationException("Option specification gave specification automata, but no CompositeCPA was used"));
            insertionPoint.children = insertionPoint.children.isEmpty() ? ImmutableList.of((Object)CPAConfig.forClass(LocationCPA.class), (Object)SPECIFICATION_PLACEHOLDER) : FluentIterable.from(insertionPoint.children).append((Object[])new CPAConfig[]{SPECIFICATION_PLACEHOLDER}).toList();
            ++placeholderCount;
        }
        ArrayList<ConfigurableProgramAnalysis> cpas = new ArrayList<ConfigurableProgramAnalysis>();
        for (Automaton automaton : allAutomata) {
            String cpaAlias = automaton.getName();
            CPAFactory factory = ControlAutomatonCPA.factory();
            factory.setConfiguration(Configuration.copyWithNewPrefix((Configuration)this.config, (String)cpaAlias));
            factory.setLogger(this.logger.withComponentName(cpaAlias));
            factory.set(cfa, CFA.class);
            factory.set(pAggregatedReachedSets, AggregatedReachedSets.class);
            factory.set(automaton, Automaton.class);
            factory.setShutdownNotifier(this.shutdownNotifier);
            cpas.add(factory.createInstance());
        }
        ConfigurableProgramAnalysis cpa2 = this.instantiateCPAandChildren(rootCpaConfig, cpas, cfa, specification, pAggregatedReachedSets);
        ImmutableList allCpas = CPAs.asIterable(cpa2).toList();
        Verify.verify((boolean)allCpas.containsAll(cpas), (String)"CPAs for automata missing from final CPA tree", (Object[])new Object[0]);
        Verify.verify((allCpas.size() == allCpaConfigs.size() + cpas.size() - placeholderCount ? 1 : 0) != 0, (String)"Number of CPAs in final CPA tree does not match configured CPAs", (Object[])new Object[0]);
        return cpa2;
    }

    private CPAConfig collectCPAConfigs(String optionName, String optionValue) throws InvalidConfigurationException {
        if ((optionValue = optionValue.trim()).equals(CPABuilder.SPECIFICATION_PLACEHOLDER.name)) {
            return SPECIFICATION_PLACEHOLDER;
        }
        List optionParts = Splitter.onPattern((String)"\\s+").splitToList((CharSequence)optionValue);
        String cpaNameFromOption = (String)optionParts.get(0);
        String cpaAlias = this.getCPAAlias(optionValue, optionName, optionParts, cpaNameFromOption);
        Class<?> cpaClass = this.getCPAClass(optionName, cpaNameFromOption);
        String childOptionName = cpaAlias + ".cpa";
        String childrenOptionName = cpaAlias + ".cpas";
        String childCpaName = this.config.getProperty(childOptionName);
        String childrenCpaNames = this.config.getProperty(childrenOptionName);
        CPAConfig child = null;
        ImmutableList.Builder childrenCpas = ImmutableList.builder();
        if (childCpaName != null) {
            if (childrenCpaNames != null) {
                throw new InvalidConfigurationException("Ambiguous configuration: both " + childOptionName + " and " + childrenOptionName + " are specified!");
            }
            child = this.collectCPAConfigs(childOptionName, childCpaName);
            this.logger.log(Level.FINER, new Object[]{"CPA", cpaAlias, "got child", childCpaName});
        } else if (childrenCpaNames != null) {
            for (String currentChildCpaName : LIST_SPLITTER.split((CharSequence)childrenCpaNames)) {
                childrenCpas.add((Object)this.collectCPAConfigs(childrenOptionName, currentChildCpaName));
            }
            this.logger.log(Level.FINER, new Object[]{"CPA", cpaAlias, "got children", childrenCpaNames});
        }
        return new CPAConfig(cpaNameFromOption, cpaAlias, cpaClass, child, (ImmutableList<CPAConfig>)childrenCpas.build());
    }

    private void checkAliasUniqueness(FluentIterable<CPAConfig> cpas, FluentIterable<Automaton> automata) throws InvalidConfigurationException {
        ImmutableMultiset automataAliases = automata.transform(Automaton::getName).toMultiset();
        ImmutableMultiset cpaAliases = cpas.filter(cpa -> !cpa.isPlaceholder).transform(cpa -> cpa.alias).toMultiset();
        for (Multiset.Entry entry : automataAliases.entrySet()) {
            if (entry.getCount() <= 1) continue;
            throw new InvalidConfigurationException("Alias " + (String)entry.getElement() + " used twice for an automaton.");
        }
        for (Multiset.Entry entry : cpaAliases.entrySet()) {
            if (entry.getCount() <= 1) continue;
            throw new InvalidConfigurationException("Alias " + (String)entry.getElement() + " used twice for a CPA.");
        }
        Multiset aliasIntersection = Multisets.intersection((Multiset)automataAliases, (Multiset)cpaAliases);
        if (!aliasIntersection.isEmpty()) {
            throw new InvalidConfigurationException("The following aliases are used for both automata and CPAs: " + Joiner.on((String)", ").join((Iterable)aliasIntersection.elementSet()));
        }
    }

    private ConfigurableProgramAnalysis instantiateCPAandChildren(CPAConfig cpaConfig, List<ConfigurableProgramAnalysis> cpas, CFA cfa, Specification specification, AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException, CPAException, InterruptedException {
        ConfigurableProgramAnalysis cpa;
        if (cpaConfig.isPlaceholder) {
            if (cpaConfig.equals(SPECIFICATION_PLACEHOLDER)) {
                if (cpas.size() == 1) {
                    return cpas.get(0);
                }
                String count = cpas.isEmpty() ? "none" : Integer.toString(cpas.size());
                throw new InvalidConfigurationException("Configuration requires exactly one specification automaton, but " + count + " were given");
            }
            throw new AssertionError((Object)("unexpected placeholder " + cpaConfig.name));
        }
        String cpaAlias = cpaConfig.alias;
        Class<?> cpaClass = cpaConfig.cpaClass;
        this.logger.log(Level.FINER, new Object[]{"Instantiating CPA " + cpaClass.getName() + " with alias " + cpaAlias});
        CPAFactory factory = this.getFactoryInstance(cpaConfig.name, cpaClass);
        factory.setConfiguration(Configuration.copyWithNewPrefix((Configuration)this.config, (String)cpaAlias));
        factory.setLogger(this.logger.withComponentName(cpaAlias));
        factory.setShutdownNotifier(this.shutdownNotifier);
        factory.set(pAggregatedReachedSets, AggregatedReachedSets.class);
        factory.set(specification, Specification.class);
        if (this.reachedSetFactory != null) {
            factory.set(this.reachedSetFactory, ReachedSetFactory.class);
        }
        if (cfa != null) {
            factory.set(cfa, CFA.class);
        }
        this.createAndSetChildrenCPAs(cpaConfig, factory, cpas, cfa, specification, pAggregatedReachedSets);
        try {
            cpa = factory.createInstance();
        }
        catch (IllegalStateException e) {
            throw new InvalidComponentException(cpaClass, "CPA", e);
        }
        if (cpa == null) {
            throw new InvalidComponentException(cpaClass, "CPA", "Factory returned null.");
        }
        this.logger.log(Level.FINER, new Object[]{"Sucessfully instantiated CPA " + cpa.getClass().getName() + " with alias " + cpaAlias});
        return cpa;
    }

    private String getCPAAlias(String optionValue, String optionName, List<String> optionParts, String pCpaName) throws InvalidConfigurationException {
        if (optionParts.size() == 1) {
            int dotIndex = pCpaName.lastIndexOf(46);
            return dotIndex >= 0 ? pCpaName.substring(dotIndex + 1) : pCpaName;
        }
        if (optionParts.size() == 2) {
            return optionParts.get(1);
        }
        throw new InvalidConfigurationException("Option " + optionName + " contains invalid CPA specification \"" + optionValue + "\"!");
    }

    private Class<?> getCPAClass(String optionName, String pCpaName) throws InvalidConfigurationException {
        Class cpaClass;
        try {
            cpaClass = Classes.forName((String)pCpaName, (String)CPA_CLASS_PREFIX);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Option " + optionName + " is set to unknown CPA " + pCpaName, (Throwable)e);
        }
        if (!ConfigurableProgramAnalysis.class.isAssignableFrom(cpaClass)) {
            throw new InvalidConfigurationException("Option " + optionName + " has to be set to a class implementing the ConfigurableProgramAnalysis interface!");
        }
        Classes.produceClassLoadingWarning((LogManager)this.logger, (Class)cpaClass, ConfigurableProgramAnalysis.class);
        return cpaClass;
    }

    private CPAFactory getFactoryInstance(String pCpaName, Class<?> cpaClass) throws CPAException {
        Object factoryObj;
        Method factoryMethod;
        try {
            factoryMethod = cpaClass.getMethod("factory", null);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidComponentException(cpaClass, "CPA", "No public static method \"factory\" with zero parameters.");
        }
        if (!Modifier.isStatic(factoryMethod.getModifiers())) {
            throw new InvalidComponentException(cpaClass, "CPA", "Factory method is not static.");
        }
        String exception = Classes.verifyDeclaredExceptions((Executable)factoryMethod, (Class[])new Class[]{CPAException.class});
        if (exception != null) {
            throw new InvalidComponentException(cpaClass, "CPA", "Factory method declares the unsupported checked exception " + exception + " .");
        }
        try {
            factoryObj = factoryMethod.invoke(null, (Object[])null);
        }
        catch (IllegalAccessException e) {
            throw new InvalidComponentException(cpaClass, "CPA", "Factory method is not public.");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfPossible((Throwable)cause, CPAException.class);
            throw new Classes.UnexpectedCheckedException("instantiation of CPA " + pCpaName, cause);
        }
        if (!(factoryObj instanceof CPAFactory)) {
            throw new InvalidComponentException(cpaClass, "CPA", "Factory method did not return a CPAFactory instance.");
        }
        return (CPAFactory)factoryObj;
    }

    private void createAndSetChildrenCPAs(CPAConfig cpaConfig, CPAFactory factory, List<ConfigurableProgramAnalysis> cpas, CFA cfa, Specification specification, AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException, CPAException, InterruptedException {
        ImmutableList<CPAConfig> children = cpaConfig.children;
        if (cpaConfig.child != null) {
            ConfigurableProgramAnalysis child = this.instantiateCPAandChildren(cpaConfig.child, cpas, cfa, specification, pAggregatedReachedSets);
            try {
                factory.setChild(child);
            }
            catch (UnsupportedOperationException e) {
                throw new InvalidConfigurationException(cpaConfig.name + " is no wrapper CPA, but was configured to have a child CPA!", (Throwable)e);
            }
        }
        if (!children.isEmpty()) {
            ImmutableList.Builder childrenCpas = ImmutableList.builder();
            for (CPAConfig currentChildCpaConfig : children) {
                if (currentChildCpaConfig.equals(SPECIFICATION_PLACEHOLDER)) {
                    childrenCpas.addAll(cpas);
                    continue;
                }
                childrenCpas.add((Object)this.instantiateCPAandChildren(currentChildCpaConfig, cpas, cfa, specification, pAggregatedReachedSets));
            }
            try {
                factory.setChildren((List<ConfigurableProgramAnalysis>)childrenCpas.build());
            }
            catch (UnsupportedOperationException e) {
                throw new InvalidConfigurationException(cpaConfig.name + " is no wrapper CPA, but was configured to have children CPAs!", (Throwable)e);
            }
        }
    }

    private static class CPAConfig {
        final boolean isPlaceholder;
        final String name;
        final String alias;
        final @Nullable Class<?> cpaClass;
        final @Nullable CPAConfig child;
        ImmutableList<CPAConfig> children;

        CPAConfig(String pName, String pAlias, Class<?> pCpaClass, @Nullable CPAConfig pChild, ImmutableList<CPAConfig> pChildren) {
            this.isPlaceholder = false;
            this.name = (String)Preconditions.checkNotNull((Object)pName);
            this.alias = (String)Preconditions.checkNotNull((Object)pAlias);
            this.cpaClass = (Class)Preconditions.checkNotNull(pCpaClass);
            this.child = pChild;
            this.children = (ImmutableList)Preconditions.checkNotNull(pChildren);
            Preconditions.checkArgument((this.child == null || pChildren.isEmpty() ? 1 : 0) != 0);
        }

        CPAConfig(String pName) {
            this.isPlaceholder = true;
            this.name = (String)Preconditions.checkNotNull((Object)pName);
            this.alias = (String)Preconditions.checkNotNull((Object)pName);
            this.cpaClass = null;
            this.child = null;
            this.children = ImmutableList.of();
        }

        static CPAConfig forClass(Class<? extends ConfigurableProgramAnalysis> cpaClass) {
            return new CPAConfig(cpaClass.getCanonicalName(), cpaClass.getSimpleName(), cpaClass, null, (ImmutableList<CPAConfig>)ImmutableList.of());
        }

        ImmutableList<CPAConfig> getAllChildren() {
            return this.child != null ? ImmutableList.of((Object)this.child) : this.children;
        }
    }
}

