/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Joiner;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.AbstractMBean;
import org.sosy_lab.common.Optionals;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACheck;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.MainCPAStatistics;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ResultProviderReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProviderImpl;

@Options
public class CPAchecker {
    @Option(secure=true, name="analysis.stopAfterError", description="stop after the first error has been found")
    private boolean stopAfterError = true;
    @Option(secure=true, name="analysis.initialStatesFor", description="What CFA nodes should be the starting point of the analysis?")
    private Set<InitialStatesFor> initialStatesFor = Sets.newHashSet((Object[])new InitialStatesFor[]{InitialStatesFor.ENTRY});
    @Option(secure=true, name="analysis.partitionInitialStates", description="Partition the initial states based on the type of location they were created for (see 'initialStatesFor')")
    private boolean partitionInitialStates = false;
    @Option(secure=true, name="specification", description="Comma-separated list of files with specifications that should be checked (cf. config/specification/ for examples). Property files as used in SV-COMP can also be used here, but when these are specified inside a configuration file instead of on the command line, CPAchecker will ignore the entry function in the property file.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private List<Path> specificationFiles = ImmutableList.of();
    @Option(secure=true, name="backwardSpecification", description="comma-separated list of files with specifications that should be used \nin a backwards analysis; used if the analysis starts at the target states!\n(see config/specification/ for examples)")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private List<Path> backwardSpecificationFiles = ImmutableList.of();
    @Option(secure=true, name="analysis.serializedCfaFile", description="if this option is used, the CFA will be loaded from the given file instead of parsed from sourcefile.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private @Nullable Path serializedCfaFile = null;
    @Option(secure=true, name="analysis.unknownAsTrue", description="Do not report unknown if analysis terminated, report true (UNSOUND!).")
    private boolean unknownAsTrue = false;
    @Option(secure=true, name="analysis.counterexampleLimit", description="Maximum number of counterexamples to be created.")
    private int cexLimit = 0;
    private final LogManager logger;
    private final Configuration config;
    private final ShutdownManager shutdownManager;
    private final ShutdownNotifier shutdownNotifier;
    private final CoreComponentsFactory factory;
    private static final String version;

    public static String getVersion(Configuration pConfig) {
        StringJoiner joiner = new StringJoiner(" / ");
        joiner.add("CPAchecker " + CPAchecker.getPlainVersion());
        String analysisName = CPAchecker.getApproachName(pConfig);
        if (analysisName != null) {
            joiner.add(analysisName);
        }
        return joiner.toString();
    }

    public static String getPlainVersion() {
        return version;
    }

    public static String getApproachName(Configuration pConfig) {
        try {
            return new ApproachNameInformation(pConfig).getApproachName();
        }
        catch (InvalidConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String getJavaInformation() {
        return StandardSystemProperty.JAVA_VM_NAME.value() + " " + StandardSystemProperty.JAVA_VERSION.value();
    }

    public CPAchecker(Configuration pConfiguration, LogManager pLogManager, ShutdownManager pShutdownManager) throws InvalidConfigurationException {
        this.config = pConfiguration;
        this.logger = pLogManager;
        this.shutdownManager = pShutdownManager;
        this.shutdownNotifier = pShutdownManager.getNotifier();
        this.config.inject((Object)this);
        this.factory = new CoreComponentsFactory(pConfiguration, pLogManager, this.shutdownNotifier, AggregatedReachedSets.empty());
    }

    /*
     * Exception decompiling
     */
    public CPAcheckerResult run(List<String> programDenotation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CFA parse(List<String> fileNames, MainCPAStatistics stats) throws InvalidConfigurationException, IOException, ParserException, InterruptedException, ClassNotFoundException {
        CFA cfa;
        if (this.serializedCfaFile == null) {
            this.logger.logf(Level.INFO, "Parsing CFA from file(s) \"%s\"", new Object[]{Joiner.on((String)", ").join(fileNames)});
            CFACreator cfaCreator = new CFACreator(this.config, this.logger, this.shutdownNotifier);
            stats.setCFACreator(cfaCreator);
            cfa = cfaCreator.parseFileAndCreateCFA(fileNames);
        } else {
            this.logger.logf(Level.INFO, "Reading CFA from file \"%s\"", new Object[]{this.serializedCfaFile});
            try (InputStream inputStream = Files.newInputStream(this.serializedCfaFile, new OpenOption[0]);
                 GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);
                 ObjectInputStream ois = new ObjectInputStream(gzipInputStream);){
                cfa = (CFA)ois.readObject();
            }
            assert (CFACheck.check(cfa.getMainFunction(), null, cfa.getMachineModel()));
        }
        stats.setCFA(cfa);
        return cfa;
    }

    private void printConfigurationWarnings() {
        Set deprecatedProperties;
        Set unusedProperties = this.config.getUnusedProperties();
        if (!unusedProperties.isEmpty()) {
            this.logger.log(Level.WARNING, new Object[]{"The following configuration options were specified but are not used:\n", Joiner.on((String)"\n ").join((Iterable)unusedProperties), "\n"});
        }
        if (!(deprecatedProperties = this.config.getDeprecatedProperties()).isEmpty()) {
            this.logger.log(Level.WARNING, new Object[]{"The following options are deprecated and will be removed in the future:\n", Joiner.on((String)"\n ").join((Iterable)deprecatedProperties), "\n"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Algorithm.AlgorithmStatus runAlgorithm(Algorithm algorithm, ReachedSet reached, MainCPAStatistics stats) throws CPAException, InterruptedException {
        this.logger.log(Level.INFO, new Object[]{"Starting analysis ..."});
        Algorithm.AlgorithmStatus status = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        CPAcheckerBean mxbean = new CPAcheckerBean(reached, this.logger, this.shutdownManager);
        mxbean.register();
        stats.startAnalysisTimer();
        try {
            int counterExampleCount = 0;
            do {
                status = status.update(algorithm.run(reached));
                if (this.cexLimit <= 0) continue;
                counterExampleCount = Optionals.presentInstances((Iterable)FluentIterable.from((Iterable)reached).filter(AbstractStates::isTargetState).filter(ARGState.class).transform(ARGState::getCounterexampleInformation)).size();
            } while (!this.stopAfterError && reached.hasWaitingState() && (this.cexLimit == 0 || this.cexLimit > counterExampleCount));
            this.logger.log(Level.INFO, new Object[]{"Stopping analysis ..."});
            Algorithm.AlgorithmStatus algorithmStatus = status;
            return algorithmStatus;
        }
        finally {
            stats.stopAnalysisTimer();
            mxbean.unregister();
        }
    }

    private CPAcheckerResult.Result analyzeResult(ReachedSet reached, boolean isSound) {
        if (reached instanceof ResultProviderReachedSet) {
            return ((ResultProviderReachedSet)((Object)reached)).getOverallResult();
        }
        if (reached.hasWaitingState()) {
            this.logger.log(Level.WARNING, new Object[]{"Analysis not completed: there are still states to be processed."});
            return CPAcheckerResult.Result.UNKNOWN;
        }
        if (!isSound) {
            this.logger.log(Level.WARNING, new Object[]{"Analysis incomplete: no errors found, but not everything could be checked."});
            return CPAcheckerResult.Result.UNKNOWN;
        }
        return CPAcheckerResult.Result.TRUE;
    }

    private void addToInitialReachedSet(Set<? extends CFANode> pLocations, Object pPartitionKey, ReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InterruptedException {
        for (CFANode cFANode : pLocations) {
            StateSpacePartition putIntoPartition = this.partitionInitialStates ? StateSpacePartition.getPartitionWithKey(pPartitionKey) : StateSpacePartition.getDefaultPartition();
            AbstractState initialState = pCpa.getInitialState(cFANode, putIntoPartition);
            Precision initialPrecision = pCpa.getInitialPrecision(cFANode, putIntoPartition);
            pReached.add(initialState, initialPrecision);
        }
    }

    private void initializeReachedSet(ReachedSet pReached, ConfigurableProgramAnalysis pCpa, FunctionEntryNode pAnalysisEntryFunction, CFA pCfa) throws InvalidConfigurationException, InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"Creating initial reached set"});
        for (InitialStatesFor isf : this.initialStatesFor) {
            ImmutableSet<CFANode> initialLocations;
            switch (isf) {
                case ENTRY: {
                    initialLocations = ImmutableSet.of((Object)pAnalysisEntryFunction);
                    break;
                }
                case EXIT: {
                    initialLocations = ImmutableSet.of((Object)pAnalysisEntryFunction.getExitNode());
                    break;
                }
                case FUNCTION_ENTRIES: {
                    initialLocations = ImmutableSet.copyOf(pCfa.getAllFunctionHeads());
                    break;
                }
                case FUNCTION_SINKS: {
                    initialLocations = ImmutableSet.builder().addAll(this.getAllEndlessLoopHeads(pCfa.getLoopStructure().orElseThrow())).addAll(this.getAllFunctionExitNodes(pCfa)).build();
                    break;
                }
                case PROGRAM_SINKS: {
                    initialLocations = ImmutableSet.builder().addAll(CFAUtils.getProgramSinks(pCfa, pCfa.getLoopStructure().orElseThrow(), pAnalysisEntryFunction)).build();
                    break;
                }
                case TARGET: {
                    TargetLocationProviderImpl tlp = new TargetLocationProviderImpl(this.shutdownNotifier, this.logger, pCfa);
                    initialLocations = tlp.tryGetAutomatonTargetLocations(pAnalysisEntryFunction, Specification.fromFiles(this.backwardSpecificationFiles, pCfa, this.config, this.logger, this.shutdownNotifier));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled case statement: " + this.initialStatesFor));
                }
            }
            this.addToInitialReachedSet((Set<? extends CFANode>)initialLocations, (Object)isf, pReached, pCpa);
        }
        if (!pReached.hasWaitingState() && !this.initialStatesFor.equals(Collections.singleton(InitialStatesFor.TARGET))) {
            throw new InvalidConfigurationException("Initialization of the set of initial states failed: No analysis target found!");
        }
        this.logger.logf(Level.FINE, "Initial reached set has a waitlist of %d states.", new Object[]{pReached.getWaitlist().size()});
    }

    private Set<CFANode> getAllFunctionExitNodes(CFA cfa) {
        HashSet<CFANode> functionExitNodes = new HashSet<CFANode>();
        for (FunctionEntryNode node : cfa.getAllFunctionHeads()) {
            FunctionExitNode exitNode = node.getExitNode();
            if (!cfa.getAllNodes().contains(exitNode)) continue;
            functionExitNodes.add(exitNode);
        }
        return functionExitNodes;
    }

    private Collection<CFANode> getAllEndlessLoopHeads(LoopStructure structure) {
        return CFAUtils.getEndlessLoopHeads(structure);
    }

    static {
        String v = "(unknown version)";
        try {
            String content;
            URL url = CPAchecker.class.getClassLoader().getResource("org/sosy_lab/cpachecker/VERSION.txt");
            if (url != null && (content = Resources.toString((URL)url, (Charset)StandardCharsets.US_ASCII).trim()).matches("[a-zA-Z0-9 ._+:-]+")) {
                v = content;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        version = v;
    }

    @Options
    private static final class ApproachNameInformation {
        @Option(secure=true, name="analysis.name", description="Name of the used analysis, defaults to the name of the used configuration")
        private String approachName;

        private ApproachNameInformation(Configuration pConfig) throws InvalidConfigurationException {
            pConfig.inject((Object)this);
        }

        private String getApproachName() {
            return this.approachName;
        }
    }

    public static enum InitialStatesFor {
        ENTRY,
        FUNCTION_ENTRIES,
        TARGET,
        EXIT,
        FUNCTION_SINKS,
        PROGRAM_SINKS;

    }

    private static class CPAcheckerBean
    extends AbstractMBean
    implements CPAcheckerMXBean {
        private final ReachedSet reached;
        private final ShutdownManager shutdownManager;

        public CPAcheckerBean(ReachedSet pReached, LogManager logger, ShutdownManager pShutdownManager) {
            super("org.sosy_lab.cpachecker:type=CPAchecker", logger);
            this.reached = pReached;
            this.shutdownManager = pShutdownManager;
        }

        @Override
        public int getReachedSetSize() {
            return this.reached.size();
        }

        @Override
        public void stop() {
            this.shutdownManager.requestShutdown("A stop request was received via the JMX interface.");
        }
    }

    public static interface CPAcheckerMXBean {
        public int getReachedSetSize();

        public void stop();
    }
}

