/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.PrintStream;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ResultProviderReachedSet;

public class CPAcheckerResult {
    private final Result result;
    private final String targetDescription;
    private final @Nullable ReachedSet reached;
    private final @Nullable CFA cfa;
    private final @Nullable Statistics stats;
    private @Nullable Statistics proofGeneratorStats = null;

    CPAcheckerResult(Result result, String targetDescription, @Nullable ReachedSet reached, @Nullable CFA cfa, @Nullable Statistics stats) {
        this.targetDescription = (String)Preconditions.checkNotNull((Object)targetDescription);
        this.result = (Result)((Object)Preconditions.checkNotNull((Object)((Object)result)));
        this.reached = reached;
        this.cfa = cfa;
        this.stats = stats;
    }

    private CPAcheckerResult(Result result) {
        this(result, "");
    }

    private CPAcheckerResult(Result result, String targetDescription) {
        this(result, targetDescription, null, null, null);
    }

    public Result getResult() {
        return this.result;
    }

    public String getTargetDescription() {
        Preconditions.checkState((this.result == Result.FALSE ? 1 : 0) != 0);
        return this.targetDescription;
    }

    public @Nullable ReachedSet getReached() {
        return this.reached;
    }

    public @Nullable CFA getCfa() {
        return this.cfa;
    }

    public void addProofGeneratorStatistics(Statistics pProofGeneratorStatistics) {
        this.proofGeneratorStats = pProofGeneratorStatistics;
    }

    public void printStatistics(PrintStream target) {
        if (this.stats != null) {
            this.stats.printStatistics(target, this.result, this.reached);
        }
        if (this.proofGeneratorStats != null) {
            this.proofGeneratorStats.printStatistics(target, this.result, this.reached);
        }
    }

    public void writeOutputFiles() {
        if (this.result == Result.NOT_YET_STARTED) {
            return;
        }
        this.stats.writeOutputFiles(this.result, this.reached);
        if (this.proofGeneratorStats != null) {
            this.proofGeneratorStats.writeOutputFiles(this.result, this.reached);
        }
    }

    public void printResult(PrintStream out) {
        if (this.result == Result.NOT_YET_STARTED) {
            return;
        }
        if (this.reached instanceof ResultProviderReachedSet) {
            ((ResultProviderReachedSet)((Object)this.reached)).printResults(out);
        }
        if (this.result == Result.DONE) {
            out.println("Finished.");
        } else {
            out.println("Verification result: " + this.getResultString());
        }
    }

    public String getResultString() {
        switch (this.result) {
            case UNKNOWN: {
                return "UNKNOWN, incomplete analysis.";
            }
            case FALSE: {
                StringBuilder sb = new StringBuilder();
                sb.append("FALSE. Property violation");
                if (!this.targetDescription.isEmpty()) {
                    sb.append(" (").append(this.targetDescription).append(")");
                }
                sb.append(" found by chosen configuration.");
                return sb.toString();
            }
            case TRUE: {
                return "TRUE. No property violation found by chosen configuration.";
            }
        }
        throw new AssertionError((Object)this.result);
    }

    public static Optional<CPAcheckerResult> parseResultString(String pResult) {
        Objects.requireNonNull(pResult);
        if (pResult.startsWith("Verification result: ")) {
            String property = pResult.substring(21);
            if (property.equals("TRUE. No property violation found by chosen configuration.")) {
                return Optional.of(new CPAcheckerResult(Result.TRUE));
            }
            if (property.startsWith("FALSE. Property violation")) {
                if (property.contains("(")) {
                    String propertyDesc = property.substring(property.indexOf("(") + 1, property.indexOf(")"));
                    return Optional.of(new CPAcheckerResult(Result.FALSE, propertyDesc));
                }
                return Optional.of(new CPAcheckerResult(Result.FALSE));
            }
            Verify.verify((boolean)property.equals("UNKNOWN, incomplete analysis."));
            return Optional.of(new CPAcheckerResult(Result.UNKNOWN));
        }
        return Optional.empty();
    }

    public Statistics getStatistics() {
        return this.stats;
    }

    public static enum Result {
        NOT_YET_STARTED,
        DONE,
        UNKNOWN,
        FALSE,
        TRUE;

    }
}

