/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Verify;
import java.io.IOException;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.AnalysisWithRefinableEnablerCPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.ArrayAbstractionAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.AssumptionCollectorAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.BDDCPARestrictionAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CEGARAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CounterexampleStoreAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CustomInstructionRequirementsExtractingAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.ExceptionHandlingAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.FaultLocalizationWithCoverage;
import org.sosy_lab.cpachecker.core.algorithm.FaultLocalizationWithTraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.InvariantExportAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.MPIPortfolioAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.NoopAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.ParallelAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.ProgramSplitAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.RandomTestGeneratorAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.RestartAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.RestartWithConditionsAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.RestrictedProgramDomainAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.SelectionAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.TestCaseGeneratorAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.UndefinedFunctionCollectorAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.WitnessToACSLAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.WitnessToInvariantWitnessAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.IMCAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.pdr.PdrAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.composition.CompositionAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck.CounterexampleCheckAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.DistributedSummaryAnalysis;
import org.sosy_lab.cpachecker.core.algorithm.explainer.Explainer;
import org.sosy_lab.cpachecker.core.algorithm.impact.ImpactAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.mpv.MPVAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.mpv.MPVReachedSet;
import org.sosy_lab.cpachecker.core.algorithm.parallel_bam.ParallelBAMAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.pcc.AlgorithmWithPropertyCheck;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ConfigReadingProofCheckAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ProofCheckAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ProofCheckAndExtractCIRequirementsAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ResultCheckAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.ConditionalVerifierAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.ResidualProgramConstructionAfterAnalysisAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.ResidualProgramConstructionAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.TestGoalToConditionConverterAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.slicing.SlicingAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.termination.TerminationAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.termination.validation.NonTerminationWitnessValidator;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.HistoryForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMCounterexampleCheckAlgorithm;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.automaton.CachingTargetLocationProvider;

@Options(prefix="analysis")
public class CoreComponentsFactory {
    @Option(secure=true, name="disable", description="stop CPAchecker after startup (internal option, not intended for users)")
    private boolean disableAnalysis = false;
    @Option(secure=true, description="use assumption collecting algorithm")
    private boolean collectAssumptions = false;
    @Option(secure=true, name="algorithm.conditionAdjustment", description="use adjustable conditions algorithm")
    private boolean useAdjustableConditions = false;
    @Option(secure=true, name="algorithm.pdr", description="use PDR algorithm")
    private boolean usePDR = false;
    @Option(secure=true, name="algorithm.CEGAR", description="use CEGAR algorithm for lazy counter-example guided analysis\nYou need to specify a refiner with the cegar.refiner option.\nCurrently all refiner require the use of the ARGCPA.")
    private boolean useCEGAR = false;
    @Option(secure=true, description="use a second model checking run (e.g., with CBMC or a different CPAchecker configuration) to double-check counter-examples")
    private boolean checkCounterexamples = false;
    @Option(secure=true, description="use counterexample check and the BDDCPA Restriction option")
    private boolean checkCounterexamplesWithBDDCPARestriction = false;
    @Option(secure=true, description="After an incomplete analysis constructs a residual program which contains all program paths which are not fully explored")
    private boolean unexploredPathsAsProgram = false;
    @Option(secure=true, description="Solely construct the residual program for a given condition/assumption.")
    private boolean constructResidualProgram = false;
    @Option(secure=true, description="Construct a residual program from condition and verify residual program")
    private boolean asConditionalVerifier = false;
    @Option(secure=true, description="Construct the program slice for the given configuration.")
    private boolean constructProgramSlice = false;
    @Option(secure=true, name="algorithm.BMC", description="use a BMC like algorithm that checks for satisfiability after the analysis has finished, works only with PredicateCPA")
    private boolean useBMC = false;
    @Option(secure=true, name="algorithm.IMC", description="use McMillan's interpolation-based model checking algorithm, works only with PredicateCPA and large-block encoding")
    private boolean useIMC = false;
    @Option(secure=true, name="algorithm.impact", description="Use McMillan's Impact algorithm for lazy interpolation")
    private boolean useImpactAlgorithm = false;
    @Option(secure=true, name="useCompositionAnalysis", description="select an analysis from a set of analyses after unknown result")
    private boolean useCompositionAlgorithm = false;
    @Option(secure=true, name="useRandomTestCaseGeneratorAlgorithm", description="generate random test cases")
    private boolean useRandomTestCaseGeneratorAlgorithm = false;
    @Option(secure=true, name="useTestCaseGeneratorAlgorithm", description="generate test cases for covered test targets")
    private boolean useTestCaseGeneratorAlgorithm = false;
    @Option(secure=true, name="restartAfterUnknown", description="restart the analysis using a different configuration after unknown result")
    private boolean useRestartingAlgorithm = false;
    @Option(secure=true, name="selectAnalysisHeuristically", description="Use heuristics to select the analysis")
    private boolean useHeuristicSelectionAlgorithm = false;
    @Option(secure=true, name="useParallelAnalyses", description="Use analyses parallely. The resulting reachedset is the one of the first analysis finishing in time. All other analyses are terminated.")
    private boolean useParallelAlgorithm = false;
    @Option(secure=true, description="converts a witness to an ACSL annotated program")
    private boolean useWitnessToACSLAlgorithm = false;
    @Option(secure=true, name="witnessToInvariant", description="converts a graphml witness to invariant witness")
    private boolean useWitnessToInvariantAlgorithm = false;
    @Option(secure=true, name="invariantExport", description="Runs an algorithm that produces and exports invariants")
    private boolean useInvariantExportAlgorithm = false;
    @Option(secure=true, name="algorithm.MPI", description="Use MPI for running analyses in new subprocesses. The resulting reachedset is the one of the first analysis returning in time. All other mpi-processes will get aborted.")
    private boolean useMPIProcessAlgorithm = false;
    @Option(secure=true, name="algorithm.termination", description="Use termination algorithm to prove (non-)termination. This needs the TerminationCPA as root CPA and an automaton CPA with termination_as_reach.spc in the tree of CPAs.")
    private boolean useTerminationAlgorithm = false;
    @Option(secure=true, name="useArrayAbstraction", description="Use array abstraction by program transformation.")
    private boolean useArrayAbstraction = false;
    @Option(secure=true, name="alwaysStoreCounterexamples", description="If not already done by the analysis, store a found counterexample in the ARG for later re-use. Does nothing if no ARGCPA is used")
    private boolean forceCexStore = false;
    @Option(secure=true, name="split.program", description="Split program in subprograms which can be analyzed separately afterwards")
    private boolean splitProgram = false;
    @Option(secure=true, description="memorize previously used (incomplete) reached sets after a restart of the analysis")
    private boolean memorizeReachedAfterRestart = false;
    @Option(secure=true, name="algorithm.analysisWithEnabler", description="use a analysis which proves if the program satisfies a specified property with the help of an enabler CPA to separate differnt program paths")
    private boolean useAnalysisWithEnablerCPAAlgorithm = false;
    @Option(secure=true, name="algorithm.proofCheck", description="use a proof check algorithm to validate a previously generated proof")
    private boolean useProofCheckAlgorithm = false;
    @Option(secure=true, name="algorithm.proofCheckReadConfig", description="use a proof check algorithm to validate a previously generated proofand read the configuration for checking from the proof")
    private boolean useProofCheckAlgorithmWithStoredConfig = false;
    @Option(secure=true, name="algorithm.proofCheckAndGetHWRequirements", description="use a proof check algorithm to validate a previously generated proofand extract requirements on a (reconfigurable) HW from the proof")
    private boolean useProofCheckAndExtractCIRequirementsAlgorithm = false;
    @Option(secure=true, name="algorithm.proofCheckWithARGCMCStrategy", description="use a proof check algorithm that using pcc.strategy=arg.ARG_CMCStrategy to validate a previously generated proof")
    private boolean useProofCheckWithARGCMCStrategy = false;
    @Option(secure=true, name="algorithm.propertyCheck", description="do analysis and then check if reached set fulfills property specified by ConfigurableProgramAnalysisWithPropertyChecker")
    private boolean usePropertyCheckingAlgorithm = false;
    @Option(secure=true, name="checkProof", description="do analysis and then check analysis result")
    private boolean useResultCheckAlgorithm = false;
    @Option(secure=true, name="algorithm.nonterminationWitnessCheck", description="use nontermination witness validator to check a violation witness for termination")
    private boolean useNonTerminationWitnessValidation = false;
    @Option(secure=true, name="algorithm.undefinedFunctionCollector", description="collect undefined functions")
    private boolean useUndefinedFunctionCollector = false;
    @Option(secure=true, name="extractRequirements.customInstruction", description="do analysis and then extract pre- and post conditions for custom instruction from analysis result")
    private boolean useCustomInstructionRequirementExtraction = false;
    @Option(secure=true, name="algorithm.useParallelBAM", description="run the parallel BAM algortihm.")
    private boolean useParallelBAM = false;
    @Option(secure=true, name="unknownIfUnrestrictedProgram", description="stop the analysis with the result unknown if the program does not satisfies certain restrictions.")
    private boolean unknownIfUnrestrictedProgram = false;
    @Option(secure=true, name="algorithm.MPV", description="use MPV algorithm for checking multiple properties")
    private boolean useMPV = false;
    @Option(secure=true, name="algorithm.faultLocalization.by_coverage", description="for found property violation, perform fault localization with coverage")
    private boolean useFaultLocalizationWithCoverage = false;
    @Option(secure=true, name="algorithm.faultLocalization.by_traceformula", description="for found property violation, perform fault localization with trace formulas")
    private boolean useFaultLocalizationWithTraceFormulas = false;
    @Option(secure=true, name="algorithm.faultLocalization.by_distance", description="Use fault localization with distance metrics")
    private boolean useFaultLocalizationWithDistanceMetrics = false;
    @Option(secure=true, name="algorithm.configurableComponents", description="Distribute predicate analysis to multiple workers")
    private boolean useConfigurableComponents = false;
    @Option(secure=true, description="Enable converting test goals to conditions.")
    private boolean testGoalConverter;
    private final Configuration config;
    private final LogManager logger;
    private final @Nullable ShutdownManager shutdownManager;
    private final ShutdownNotifier shutdownNotifier;
    private final ReachedSetFactory reachedSetFactory;
    private final CPABuilder cpaFactory;
    private final AggregatedReachedSets aggregatedReachedSets;
    private final @Nullable AggregatedReachedSets.AggregatedReachedSetManager aggregatedReachedSetManager;

    public CoreComponentsFactory(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException {
        this.config = pConfig;
        this.logger = pLogger;
        this.config.inject((Object)this);
        if (this.analysisNeedsShutdownManager()) {
            this.shutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)pShutdownNotifier);
            this.shutdownNotifier = this.shutdownManager.getNotifier();
        } else {
            this.shutdownManager = null;
            this.shutdownNotifier = pShutdownNotifier;
        }
        if (this.useTerminationAlgorithm) {
            this.aggregatedReachedSetManager = new AggregatedReachedSets.AggregatedReachedSetManager();
            this.aggregatedReachedSetManager.addAggregated(pAggregatedReachedSets);
            this.aggregatedReachedSets = this.aggregatedReachedSetManager.asView();
        } else {
            this.aggregatedReachedSetManager = null;
            this.aggregatedReachedSets = pAggregatedReachedSets;
        }
        this.reachedSetFactory = new ReachedSetFactory(this.config, this.logger);
        this.cpaFactory = new CPABuilder(this.config, this.logger, this.shutdownNotifier, this.reachedSetFactory);
        if (this.checkCounterexamplesWithBDDCPARestriction) {
            this.checkCounterexamples = true;
        }
    }

    private boolean analysisNeedsShutdownManager() {
        return !this.disableAnalysis && !this.useProofCheckAlgorithm && !this.useProofCheckAlgorithmWithStoredConfig && !this.useRestartingAlgorithm && !this.useImpactAlgorithm && (this.useBMC || this.useIMC || this.useInvariantExportAlgorithm);
    }

    public Algorithm createAlgorithm(ConfigurableProgramAnalysis cpa, CFA cfa, Specification specification) throws InvalidConfigurationException, CPAException, InterruptedException {
        Algorithm algorithm;
        this.logger.log(Level.FINE, new Object[]{"Creating algorithms"});
        if (this.disableAnalysis) {
            return NoopAlgorithm.INSTANCE;
        }
        if (this.useUndefinedFunctionCollector) {
            this.logger.log(Level.INFO, new Object[]{"Using undefined function collector"});
            algorithm = new UndefinedFunctionCollectorAlgorithm(this.config, this.logger, this.shutdownNotifier, cfa);
        } else if (this.useNonTerminationWitnessValidation) {
            this.logger.log(Level.INFO, new Object[]{"Using validator for violation witnesses for termination"});
            algorithm = new NonTerminationWitnessValidator(cfa, this.config, this.logger, this.shutdownNotifier, specification.getSpecificationAutomata());
        } else if (this.useProofCheckAlgorithmWithStoredConfig) {
            this.logger.log(Level.INFO, new Object[]{"Using Proof Check Algorithm"});
            algorithm = new ConfigReadingProofCheckAlgorithm(this.config, this.logger, this.shutdownNotifier, cfa, specification);
        } else if (this.useProofCheckAlgorithm || this.useProofCheckWithARGCMCStrategy) {
            this.logger.log(Level.INFO, new Object[]{"Using Proof Check Algorithm"});
            algorithm = new ProofCheckAlgorithm(cpa, this.config, this.logger, this.shutdownNotifier, cfa, specification);
        } else if (this.useProofCheckAndExtractCIRequirementsAlgorithm) {
            this.logger.log(Level.INFO, new Object[]{"Using Proof Check Algorithm"});
            algorithm = new ProofCheckAndExtractCIRequirementsAlgorithm(cpa, this.config, this.logger, this.shutdownNotifier, cfa, specification);
        } else if (this.asConditionalVerifier) {
            this.logger.log(Level.INFO, new Object[]{"Using Conditional Verifier"});
            algorithm = new ConditionalVerifierAlgorithm(this.config, this.logger, this.shutdownNotifier, specification, cfa);
        } else if (this.useHeuristicSelectionAlgorithm) {
            this.logger.log(Level.INFO, new Object[]{"Using heuristics to select analysis"});
            algorithm = new SelectionAlgorithm(cfa, this.shutdownNotifier, this.config, specification, this.logger);
        } else if (this.useRestartingAlgorithm) {
            this.logger.log(Level.INFO, new Object[]{"Using Restarting Algorithm"});
            algorithm = RestartAlgorithm.create(this.config, this.logger, this.shutdownNotifier, specification, cfa);
        } else if (this.useCompositionAlgorithm) {
            this.logger.log(Level.INFO, new Object[]{"Using Composition Algorithm"});
            algorithm = new CompositionAlgorithm(this.config, this.logger, this.shutdownNotifier, specification, cfa);
        } else if (this.useImpactAlgorithm) {
            algorithm = new ImpactAlgorithm(this.config, this.logger, this.shutdownNotifier, cpa, cfa);
        } else if (this.useParallelAlgorithm) {
            algorithm = new ParallelAlgorithm(this.config, this.logger, this.shutdownNotifier, specification, cfa, this.aggregatedReachedSets);
        } else if (this.useWitnessToACSLAlgorithm) {
            algorithm = new WitnessToACSLAlgorithm(this.config, this.logger, this.shutdownNotifier, cfa);
        } else if (this.useMPIProcessAlgorithm) {
            algorithm = new MPIPortfolioAlgorithm(this.config, this.logger, this.shutdownNotifier, specification);
        } else if (this.useWitnessToInvariantAlgorithm) {
            try {
                algorithm = new WitnessToInvariantWitnessAlgorithm(this.config, this.logger, this.shutdownNotifier, cfa, specification);
            }
            catch (IOException e) {
                throw new CPAException("could not instantiate invariant witness writer", e);
            }
        } else if (this.useInvariantExportAlgorithm) {
            algorithm = new InvariantExportAlgorithm(this.config, this.logger, this.shutdownManager, cfa, specification, this.reachedSetFactory, new CachingTargetLocationProvider(this.shutdownNotifier, this.logger, cfa), this.aggregatedReachedSets);
        } else if (this.useFaultLocalizationWithDistanceMetrics) {
            algorithm = new Explainer(this.config, this.logger, this.shutdownNotifier, specification, cfa);
        } else if (this.useArrayAbstraction) {
            algorithm = new ArrayAbstractionAlgorithm(this.config, this.logger, this.shutdownNotifier, specification, cfa);
        } else if (this.useRandomTestCaseGeneratorAlgorithm) {
            algorithm = new RandomTestGeneratorAlgorithm(this.config, this.logger, this.shutdownNotifier, cfa, specification);
        } else {
            algorithm = CPAAlgorithm.create(cpa, this.logger, this.config, this.shutdownNotifier);
            if (this.testGoalConverter) {
                algorithm = new TestGoalToConditionConverterAlgorithm(this.config, this.logger, this.shutdownNotifier, cfa, algorithm, cpa);
            }
            if (this.constructResidualProgram) {
                algorithm = new ResidualProgramConstructionAlgorithm(cfa, this.config, this.logger, this.shutdownNotifier, specification, cpa, algorithm);
            }
            if (this.constructProgramSlice) {
                this.logger.log(Level.INFO, new Object[]{"Constructing program slice. (Sub-)analysis will stop after this and ignore other algorithms in this configuration."});
                algorithm = new SlicingAlgorithm(this.logger, this.shutdownNotifier, this.config, cfa, specification);
            }
            if (this.useParallelBAM) {
                algorithm = new ParallelBAMAlgorithm(cpa, this.config, this.logger, this.shutdownNotifier);
            }
            if (this.useAnalysisWithEnablerCPAAlgorithm) {
                algorithm = new AnalysisWithRefinableEnablerCPAAlgorithm(algorithm, cpa, cfa, this.logger, this.config, this.shutdownNotifier);
            }
            if (this.useCEGAR) {
                algorithm = new CEGARAlgorithm.CEGARAlgorithmFactory(algorithm, cpa, this.logger, this.config, this.shutdownNotifier).newInstance();
            }
            if (this.usePDR) {
                algorithm = new PdrAlgorithm(algorithm, cpa, this.config, this.logger, this.reachedSetFactory, this.shutdownNotifier, cfa, specification, this.aggregatedReachedSets);
            }
            if (this.useBMC) {
                Verify.verifyNotNull((Object)this.shutdownManager);
                algorithm = new BMCAlgorithm(algorithm, cpa, this.config, this.logger, this.reachedSetFactory, this.shutdownManager, cfa, specification, this.aggregatedReachedSets);
            }
            if (this.useIMC) {
                Verify.verifyNotNull((Object)this.shutdownManager);
                algorithm = new IMCAlgorithm(algorithm, cpa, this.config, this.logger, this.reachedSetFactory, this.shutdownManager, cfa, specification, this.aggregatedReachedSets);
            }
            if (this.useTerminationAlgorithm) {
                algorithm = new TerminationAlgorithm(this.config, this.logger, this.shutdownNotifier, cfa, this.reachedSetFactory, this.aggregatedReachedSetManager, algorithm, cpa);
            }
            if (this.checkCounterexamples) {
                algorithm = cpa instanceof BAMCPA ? new BAMCounterexampleCheckAlgorithm(algorithm, cpa, this.config, this.logger, this.shutdownNotifier, specification, cfa) : new CounterexampleCheckAlgorithm(algorithm, cpa, this.config, specification, this.logger, this.shutdownNotifier, cfa);
            }
            algorithm = ExceptionHandlingAlgorithm.create(this.config, algorithm, cpa, this.logger, this.shutdownNotifier, this.checkCounterexamples, this.useCEGAR);
            if (this.checkCounterexamplesWithBDDCPARestriction) {
                algorithm = new BDDCPARestrictionAlgorithm(algorithm, cpa, this.config, this.logger);
            }
            if (this.useTestCaseGeneratorAlgorithm) {
                algorithm = new TestCaseGeneratorAlgorithm(algorithm, cfa, this.config, cpa, this.logger, this.shutdownNotifier, specification);
            }
            if (this.collectAssumptions) {
                algorithm = new AssumptionCollectorAlgorithm(algorithm, cpa, this.config, this.logger, cfa, this.shutdownNotifier);
            }
            if (this.useAdjustableConditions) {
                algorithm = new RestartWithConditionsAlgorithm(algorithm, cpa, this.config, this.logger);
            }
            if (this.splitProgram) {
                algorithm = new ProgramSplitAlgorithm(algorithm, cpa, this.config, this.logger, this.shutdownNotifier);
            }
            if (this.usePropertyCheckingAlgorithm) {
                if (!(cpa instanceof PropertyCheckerCPA)) {
                    throw new InvalidConfigurationException("Property checking algorithm requires CPAWithPropertyChecker as Top CPA");
                }
                algorithm = new AlgorithmWithPropertyCheck(algorithm, this.logger, (PropertyCheckerCPA)cpa);
            }
            if (this.useResultCheckAlgorithm) {
                algorithm = new ResultCheckAlgorithm(algorithm, cfa, this.config, this.logger, this.shutdownNotifier, specification);
            }
            if (this.useCustomInstructionRequirementExtraction) {
                algorithm = new CustomInstructionRequirementsExtractingAlgorithm(algorithm, cpa, this.config, this.logger, this.shutdownNotifier, cfa);
            }
            if (this.unexploredPathsAsProgram) {
                algorithm = new ResidualProgramConstructionAfterAnalysisAlgorithm(cfa, algorithm, this.config, this.logger, this.shutdownNotifier, specification);
            }
            if (this.unknownIfUnrestrictedProgram) {
                algorithm = new RestrictedProgramDomainAlgorithm(algorithm, cfa);
            }
            if (cpa instanceof ARGCPA && this.forceCexStore) {
                algorithm = new CounterexampleStoreAlgorithm(algorithm, cpa, this.config, this.logger, cfa.getMachineModel());
            }
            if (this.useMPV) {
                algorithm = new MPVAlgorithm(cpa, this.config, this.logger, this.shutdownNotifier, specification, cfa);
            }
            if (this.useConfigurableComponents) {
                algorithm = new DistributedSummaryAnalysis(this.config, this.logger, cfa, ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier), specification);
            }
            if (this.useFaultLocalizationWithCoverage) {
                algorithm = new FaultLocalizationWithCoverage(algorithm, this.shutdownNotifier, this.logger, this.config);
            }
            if (this.useFaultLocalizationWithTraceFormulas) {
                algorithm = new FaultLocalizationWithTraceFormula(algorithm, this.config, this.logger, cfa, this.shutdownNotifier);
            }
        }
        return algorithm;
    }

    public ReachedSet createReachedSet(ConfigurableProgramAnalysis cpa) {
        ReachedSet reached = this.reachedSetFactory.create(cpa);
        if (this.useCompositionAlgorithm || this.useRestartingAlgorithm || this.useHeuristicSelectionAlgorithm || this.useParallelAlgorithm || this.asConditionalVerifier || this.useFaultLocalizationWithDistanceMetrics || this.useArrayAbstraction) {
            reached = this.memorizeReachedAfterRestart ? new HistoryForwardingReachedSet(reached) : new ForwardingReachedSet(reached);
        }
        if (this.useMPV) {
            reached = new MPVReachedSet(reached);
        }
        return reached;
    }

    public ConfigurableProgramAnalysis createCPA(CFA cfa, Specification pSpecification) throws InvalidConfigurationException, CPAException, InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"Creating CPAs"});
        if (this.useCompositionAlgorithm || this.useRestartingAlgorithm || this.useHeuristicSelectionAlgorithm || this.useParallelAlgorithm || this.useProofCheckAlgorithmWithStoredConfig || this.useProofCheckWithARGCMCStrategy || this.asConditionalVerifier || this.useNonTerminationWitnessValidation || this.useUndefinedFunctionCollector || this.constructProgramSlice || this.useFaultLocalizationWithDistanceMetrics || this.useArrayAbstraction || this.useRandomTestCaseGeneratorAlgorithm) {
            return LocationCPA.factory().set(cfa, CFA.class).setConfiguration(this.config).createInstance();
        }
        return this.cpaFactory.buildCPAs(cfa, pSpecification, this.aggregatedReachedSets);
    }
}

