/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.management.JMException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Concurrency;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.export.DOTBuilder;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.LocationMappedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.coverage.CoverageCollector;
import org.sosy_lab.cpachecker.util.coverage.CoverageData;
import org.sosy_lab.cpachecker.util.coverage.CoverageReportGcov;
import org.sosy_lab.cpachecker.util.coverage.CoverageReportStdoutSummary;
import org.sosy_lab.cpachecker.util.cwriter.CExpressionInvariantExporter;
import org.sosy_lab.cpachecker.util.resources.MemoryStatistics;
import org.sosy_lab.cpachecker.util.resources.ProcessCpuTime;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.SolverException;

@Options
class MainCPAStatistics
implements Statistics {
    private static final int MAX_SIZE_FOR_REACHED_STATISTICS = 1000000;
    @Option(secure=true, name="reachedSet.export", description="print reached set to text file")
    private boolean exportReachedSet = false;
    @Option(secure=true, name="reachedSet.file", description="print reached set to text file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path reachedSetFile = Path.of("reached.txt", new String[0]);
    @Option(secure=true, name="reachedSet.dot", description="print reached set to graph file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path reachedSetGraphDumpPath = Path.of("reached.dot", new String[0]);
    @Option(secure=true, name="statistics.memory", description="track memory usage of JVM during runtime")
    private boolean monitorMemoryUsage = true;
    @Option(secure=true, name="cinvariants.export", description="Output an input file, with invariants embedded as assume constraints.")
    private boolean cInvariantsExport = false;
    @Option(secure=true, name="cinvariants.prefix", description="Prefix to add to an output file, which would contain assumed invariants.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private @Nullable PathTemplate cInvariantsPrefix = PathTemplate.ofFormatString((String)"inv-%s");
    @Option(secure=true, name="coverage.enabled", description="Compute and export information about the verification coverage?")
    private boolean exportCoverage = true;
    @Option(secure=true, name="coverage.file", description="print coverage info to file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path outputCoverageFile = Path.of("coverage.info", new String[0]);
    private final LogManager logger;
    private final Collection<Statistics> subStats;
    private final @Nullable MemoryStatistics memStats;
    private final @Nullable CExpressionInvariantExporter cExpressionInvariantExporter;
    private Thread memStatsThread;
    private final Timer programTime = new Timer();
    final Timer creationTime = new Timer();
    final Timer cpaCreationTime = new Timer();
    private final Timer analysisTime = new Timer();
    final Timer resultAnalysisTime = new Timer();
    private long programCpuTime;
    private long analysisCpuTime = 0L;
    private @Nullable Statistics cfaCreatorStatistics;
    private @Nullable CFA cfa;
    private @Nullable ConfigurableProgramAnalysis cpa;

    public MainCPAStatistics(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        this.logger = pLogger;
        pConfig.inject((Object)this);
        this.subStats = new ArrayList<Statistics>();
        if (this.monitorMemoryUsage) {
            this.memStats = new MemoryStatistics(pLogger);
            this.memStatsThread = Concurrency.newDaemonThread((String)"CPAchecker memory statistics collector", (Runnable)this.memStats);
            this.memStatsThread.start();
        } else {
            this.memStats = null;
        }
        this.programTime.start();
        try {
            this.programCpuTime = ProcessCpuTime.read();
        }
        catch (JMException e) {
            this.logger.logDebugException((Throwable)e, "Querying cpu time failed");
            this.logger.log(Level.WARNING, new Object[]{"Your Java VM does not support measuring the cpu time, some statistics will be missing."});
            this.programCpuTime = -1L;
        }
        catch (NoClassDefFoundError e) {
            this.logger.logDebugException((Throwable)e, "Querying cpu time failed");
            this.logger.log(Level.WARNING, new Object[]{"Google App Engine does not support measuring the cpu time."});
            this.programCpuTime = -1L;
        }
        this.cExpressionInvariantExporter = this.cInvariantsExport && this.cInvariantsPrefix != null ? new CExpressionInvariantExporter(pConfig, pLogger, pShutdownNotifier, this.cInvariantsPrefix) : null;
    }

    public Collection<Statistics> getSubStatistics() {
        return this.subStats;
    }

    @Override
    public String getName() {
        return "CPAchecker";
    }

    void startAnalysisTimer() {
        this.analysisTime.start();
        try {
            this.analysisCpuTime = ProcessCpuTime.read();
        }
        catch (JMException e) {
            this.logger.logDebugException((Throwable)e, "Querying cpu time failed");
            this.analysisCpuTime = -1L;
        }
        catch (NoClassDefFoundError e) {
            this.logger.logDebugException((Throwable)e, "Querying cpu time failed");
            this.logger.log(Level.WARNING, new Object[]{"Google App Engine does not support measuring the cpu time."});
            this.analysisCpuTime = -1L;
        }
    }

    void stopAnalysisTimer() {
        this.analysisTime.stop();
        this.programTime.stop();
        try {
            long stopCpuTime = ProcessCpuTime.read();
            if (this.programCpuTime >= 0L) {
                this.programCpuTime = stopCpuTime - this.programCpuTime;
            }
            if (this.analysisCpuTime >= 0L) {
                this.analysisCpuTime = stopCpuTime - this.analysisCpuTime;
            }
        }
        catch (JMException e) {
            this.logger.logDebugException((Throwable)e, "Querying cpu time failed");
        }
        catch (NoClassDefFoundError e) {
            this.logger.logDebugException((Throwable)e, "Querying cpu time failed");
            this.logger.log(Level.WARNING, new Object[]{"Google App Engine does not support measuring the cpu time."});
        }
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        Preconditions.checkNotNull((Object)out);
        Preconditions.checkNotNull((Object)((Object)result));
        Preconditions.checkArgument((result == CPAcheckerResult.Result.NOT_YET_STARTED || reached != null ? 1 : 0) != 0);
        if (this.analysisTime.isRunning()) {
            this.analysisTime.stop();
        }
        if (this.programTime.isRunning()) {
            this.programTime.stop();
        }
        if (this.memStats != null) {
            this.memStatsThread.interrupt();
        }
        Timer statisticsTime = new Timer();
        statisticsTime.start();
        if (result != CPAcheckerResult.Result.NOT_YET_STARTED) {
            this.dumpReachedSet(reached);
            this.printSubStatistics(out, result, reached);
            this.exportCoverage(out, reached);
        }
        out.println();
        out.println("CPAchecker general statistics");
        out.println("-----------------------------");
        this.printCfaStatistics(out);
        if (result != CPAcheckerResult.Result.NOT_YET_STARTED) {
            try {
                this.printReachedSetStatistics(reached, out);
            }
            catch (OutOfMemoryError e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Out of memory while generating statistics about final reached set");
            }
            if (this.cExpressionInvariantExporter != null && this.cfa != null) {
                try {
                    this.cExpressionInvariantExporter.exportInvariant(this.cfa, reached);
                }
                catch (IOException e) {
                    this.logger.logUserException(Level.WARNING, (Throwable)e, "Encountered IO error while generating the invariant as an output program.");
                }
                catch (InterruptedException pE) {
                    this.logger.logUserException(Level.WARNING, (Throwable)pE, "Interrupted while generating the invariant as an output program");
                }
                catch (SolverException e) {
                    this.logger.logUserException(Level.WARNING, (Throwable)e, "Encountered solver problem while generating the invariant as an output program");
                }
            }
        }
        out.println();
        this.printTimeStatistics(out, result, reached, statisticsTime);
        out.println();
        this.printMemoryStatistics(out);
    }

    private void exportCoverage(PrintStream out, UnmodifiableReachedSet reached) {
        if (this.exportCoverage && this.cfa != null && reached.size() > 1) {
            FluentIterable reachedStates = FluentIterable.from((Iterable)reached);
            if (this.cpa instanceof AbstractBAMCPA) {
                Collection<ReachedSet> otherReachedSets = ((AbstractBAMCPA)this.cpa).getData().getCache().getAllCachedReachedStates();
                reachedStates = reachedStates.append((Iterable)FluentIterable.concat(otherReachedSets));
            }
            CoverageData infosPerFile = CoverageCollector.fromReachedSet((Iterable<AbstractState>)reachedStates, this.cfa);
            out.println();
            out.println("Code Coverage");
            out.println("-----------------------------");
            CoverageReportStdoutSummary.write(infosPerFile, out);
            if (this.outputCoverageFile != null) {
                try (Writer gcovOut = IO.openOutputFile((Path)this.outputCoverageFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                    CoverageReportGcov.write(infosPerFile, gcovOut);
                }
                catch (IOException e) {
                    this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write coverage information to file");
                }
            }
        }
    }

    private void dumpReachedSet(UnmodifiableReachedSet reached) {
        this.dumpReachedSet(reached, this.reachedSetFile, false);
        this.dumpReachedSet(reached, this.reachedSetGraphDumpPath, true);
    }

    private void dumpReachedSet(UnmodifiableReachedSet reached, Path pOutputFile, boolean writeDotFormat) {
        assert (reached != null) : "ReachedSet may be null only if analysis not yet started";
        if (this.exportReachedSet && pOutputFile != null) {
            try (Writer w = IO.openOutputFile((Path)pOutputFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                if (writeDotFormat) {
                    this.dumpLocationMappedReachedSet(reached, w);
                } else {
                    Joiner.on((char)'\n').appendTo((Appendable)w, (Iterable)reached);
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write reached set to file");
            }
            catch (OutOfMemoryError e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write reached set to file due to memory problems");
            }
        }
    }

    private void dumpLocationMappedReachedSet(UnmodifiableReachedSet pReachedSet, Appendable sb) throws IOException {
        ImmutableListMultimap locationIndex = Multimaps.index((Iterable)pReachedSet, AbstractStates::extractLocation);
        DOTBuilder.generateDOT(sb, this.cfa, (Function<CFANode, String>)((Function)arg_0 -> MainCPAStatistics.lambda$dumpLocationMappedReachedSet$0((ListMultimap)locationIndex, arg_0)));
    }

    private static String formatCFANodeWithStateInformation(CFANode node, Multimap<CFANode, AbstractState> locationMapping) {
        StringBuilder buf = new StringBuilder();
        buf.append(node.getNodeNumber()).append("\n");
        for (AbstractState state : locationMapping.get((Object)node)) {
            if (!(state instanceof Graphable)) continue;
            buf.append(((Graphable)((Object)state)).toDOTLabel());
        }
        return buf.toString();
    }

    private void printSubStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        assert (reached != null) : "ReachedSet may be null only if analysis not yet started";
        for (Statistics s : this.subStats) {
            StatisticsUtils.printStatistics(s, out, this.logger, result, reached);
        }
    }

    @Override
    public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        assert (pReached != null) : "ReachedSet may be null only if analysis not yet started";
        for (Statistics s : this.subStats) {
            StatisticsUtils.writeOutputFiles(s, this.logger, pResult, pReached);
        }
    }

    private void printReachedSetStatistics(UnmodifiableReachedSet reached, PrintStream out) {
        assert (reached != null) : "ReachedSet may be null only if analysis not yet started";
        if (reached instanceof ForwardingReachedSet) {
            reached = ((ForwardingReachedSet)reached).getDelegate();
        }
        int reachedSize = reached.size();
        out.println("Size of reached set:             " + reachedSize);
        if (!reached.isEmpty()) {
            if (reachedSize < 1000000) {
                this.printReachedSetStatisticsDetails(reached, out);
            }
            if (reached.hasWaitingState()) {
                out.println("  Size of final wait list:       " + reached.getWaitlist().size());
            }
        }
    }

    private void printReachedSetStatisticsDetails(UnmodifiableReachedSet reached, PrintStream out) {
        Set locations;
        int reachedSize = reached.size();
        CFANode mostFrequentLocation = null;
        int mostFrequentLocationCount = 0;
        if (reached instanceof LocationMappedReachedSet) {
            LocationMappedReachedSet l = (LocationMappedReachedSet)reached;
            locations = l.getLocations();
            Map.Entry<Object, Collection<AbstractState>> maxPartition = l.getMaxPartition();
            mostFrequentLocation = (CFANode)maxPartition.getKey();
            mostFrequentLocationCount = maxPartition.getValue().size();
        } else {
            ImmutableMultiset allLocations = FluentIterable.from((Iterable)reached).transform(AbstractStates::extractLocation).filter(Predicates.notNull()).toMultiset();
            locations = allLocations.elementSet();
            for (Multiset.Entry location : allLocations.entrySet()) {
                int size = location.getCount();
                if (size > mostFrequentLocationCount) {
                    mostFrequentLocationCount = size;
                    mostFrequentLocation = (CFANode)location.getElement();
                    continue;
                }
                if (size != mostFrequentLocationCount) continue;
                mostFrequentLocation = (CFANode)Ordering.natural().min((Object)mostFrequentLocation, (Object)((CFANode)location.getElement()));
            }
        }
        if (!locations.isEmpty()) {
            int locs = locations.size();
            out.println("  Number of reached locations:   " + locs + " (" + StatisticsUtils.toPercent(locs, this.cfa.getAllNodes().size()) + ")");
            out.println("    Avg states per location:     " + reachedSize / locs);
            out.println("    Max states per location:     " + mostFrequentLocationCount + " (at node " + mostFrequentLocation + ")");
            long functions = locations.stream().map(CFANode::getFunctionName).distinct().count();
            out.println("  Number of reached functions:   " + functions + " (" + StatisticsUtils.toPercent(functions, this.cfa.getNumberOfFunctions()) + ")");
        }
        if (reached instanceof PartitionedReachedSet) {
            PartitionedReachedSet p = (PartitionedReachedSet)reached;
            int partitions = p.getNumberOfPartitions();
            out.println("  Number of partitions:          " + partitions);
            out.println("    Avg size of partitions:      " + reachedSize / partitions);
            Map.Entry<Object, Collection<AbstractState>> maxPartition = p.getMaxPartition();
            out.print("    Max size of partitions:      " + maxPartition.getValue().size());
            if (maxPartition.getValue().size() > 1) {
                out.println(" (with key " + maxPartition.getKey() + ")");
            } else {
                out.println();
            }
        }
        out.println("  Number of target states:       " + FluentIterable.from((Iterable)reached).filter(AbstractStates::isTargetState).size());
    }

    private void printCfaStatistics(PrintStream out) {
        if (this.cfa != null) {
            StatisticsWriter.writingStatisticsTo(out).put("Number of program locations", this.cfa.getAllNodes().size()).put(StatInt.forStream(StatKind.SUM, "Number of CFA edges (per node)", this.cfa.getAllNodes().stream().mapToInt(CFANode::getNumLeavingEdges))).putIfPresent(this.cfa.getVarClassification(), "Number of relevant variables", vc -> vc.getRelevantVariables().size()).put("Number of functions", this.cfa.getNumberOfFunctions()).putIfPresent(this.cfa.getLoopStructure(), loops -> StatInt.forStream(StatKind.COUNT, "Number of loops (and loop nodes)", loops.getAllLoops().stream().mapToInt(loop -> loop.getLoopNodes().size())));
        }
    }

    private void printTimeStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached, Timer statisticsTime) {
        out.println("Time for analysis setup:      " + this.creationTime);
        out.println("  Time for loading CPAs:      " + this.cpaCreationTime);
        if (this.cfaCreatorStatistics != null) {
            StatisticsUtils.printStatistics(this.cfaCreatorStatistics, out, this.logger, result, reached);
            StatisticsUtils.writeOutputFiles(this.cfaCreatorStatistics, this.logger, result, reached);
        }
        out.println("Time for Analysis:            " + this.analysisTime);
        out.println("CPU time for analysis:        " + TimeSpan.ofNanos((long)this.analysisCpuTime).formatAs(TimeUnit.SECONDS));
        if (this.resultAnalysisTime.getNumberOfIntervals() > 0) {
            out.println("Time for analyzing result:    " + this.resultAnalysisTime);
        }
        out.println("Total time for CPAchecker:    " + this.programTime);
        out.println("Total CPU time for CPAchecker:" + TimeSpan.ofNanos((long)this.programCpuTime).formatAs(TimeUnit.SECONDS));
        out.println("Time for statistics:          " + statisticsTime);
    }

    private void printMemoryStatistics(PrintStream out) {
        MemoryStatistics.printGcStatistics(out);
        if (this.monitorMemoryUsage && this.memStats != null) {
            try {
                this.memStatsThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!this.memStatsThread.isAlive()) {
                this.memStats.printStatistics(out);
            }
        }
    }

    public void setCFACreator(CFACreator pCfaCreator) {
        Preconditions.checkState((this.cfaCreatorStatistics == null ? 1 : 0) != 0);
        this.cfaCreatorStatistics = pCfaCreator.getStatistics();
    }

    public void setCFA(CFA pCfa) {
        Preconditions.checkState((this.cfa == null ? 1 : 0) != 0);
        this.cfa = pCfa;
    }

    public void setCPA(ConfigurableProgramAnalysis pCpa) {
        Preconditions.checkState((this.cpa == null ? 1 : 0) != 0);
        this.cpa = pCpa;
    }

    private static /* synthetic */ String lambda$dumpLocationMappedReachedSet$0(ListMultimap locationIndex, CFANode node) {
        return MainCPAStatistics.formatCFANodeWithStateInformation(node, (Multimap<CFANode, AbstractState>)locationIndex);
    }
}

