/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Objects;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public interface Algorithm {
    public AlgorithmStatus run(ReachedSet var1) throws CPAException, InterruptedException;

    public static interface AlgorithmFactory {
        public Algorithm newInstance();
    }

    public static final class AlgorithmStatus {
        private final boolean propertyChecked;
        private final boolean isSound;
        private final boolean isPrecise;
        public static final AlgorithmStatus NO_PROPERTY_CHECKED = new AlgorithmStatus(false, false, false);
        public static final AlgorithmStatus SOUND_AND_PRECISE = new AlgorithmStatus(true, true, true);
        public static final AlgorithmStatus UNSOUND_AND_PRECISE = new AlgorithmStatus(true, false, true);
        public static final AlgorithmStatus SOUND_AND_IMPRECISE = new AlgorithmStatus(true, true, false);
        public static final AlgorithmStatus UNSOUND_AND_IMPRECISE = new AlgorithmStatus(true, false, false);

        private AlgorithmStatus(boolean pPropertyChecked, boolean pIsSound, boolean pIsPrecise) {
            this.propertyChecked = pPropertyChecked;
            this.isSound = pIsSound && pPropertyChecked;
            this.isPrecise = pIsPrecise && pPropertyChecked;
        }

        @CheckReturnValue
        public AlgorithmStatus update(AlgorithmStatus other) {
            return new AlgorithmStatus(this.propertyChecked && other.propertyChecked, this.isSound && other.isSound, this.isPrecise && other.isPrecise);
        }

        @CheckReturnValue
        public AlgorithmStatus withSound(boolean pIsSound) {
            return new AlgorithmStatus(this.propertyChecked, pIsSound, this.isPrecise);
        }

        @CheckReturnValue
        public AlgorithmStatus withPrecise(boolean pIsPrecise) {
            return new AlgorithmStatus(this.propertyChecked, this.isSound, pIsPrecise);
        }

        public boolean wasPropertyChecked() {
            return this.propertyChecked;
        }

        public boolean isSound() {
            return this.isSound;
        }

        public boolean isPrecise() {
            return this.isPrecise;
        }

        public int hashCode() {
            return Objects.hash(this.propertyChecked, this.isSound, this.isPrecise);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AlgorithmStatus)) {
                return false;
            }
            AlgorithmStatus other = (AlgorithmStatus)obj;
            return this.propertyChecked == other.propertyChecked && this.isSound == other.isSound && this.isPrecise == other.isPrecise;
        }

        public String toString() {
            if (!this.propertyChecked) {
                return "AlgorithmStatus [no property checked]";
            }
            return "AlgorithmStatus [isSound=" + this.isSound + ", isPrecise=" + this.isPrecise + "]";
        }
    }
}

