/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.apron.ApronCPA;
import org.sosy_lab.cpachecker.cpa.apron.ApronState;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGMergeJoinCPAEnabledAnalysis;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeMergeAgreeCPAEnabledAnalysisOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPABackwards;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonCPA;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.CPAEnabledAnalysisPropertyViolationException;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="enabledanalysis")
public class AnalysisWithRefinableEnablerCPAAlgorithm
implements Algorithm,
StatisticsProvider {
    private final Algorithm algorithm;
    private final ConfigurableProgramAnalysis cpa;
    private final PredicateCPA predCPA;
    private final CFA cfa;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final List<CAssumeEdge> fakeEdgesFromLastRun = new ArrayList<CAssumeEdge>();
    private AbstractState initialWrappedState = null;
    private ARGPath pathToFailure = null;
    private boolean repeatedFailure = false;
    private Precision oldEnablerPrecision = null;
    private Constructor<? extends AbstractState> locConstructor = null;
    private final TransferRelation enablerTransfer;
    @Option(secure=true, description="Enable to use lazy refinement in current analysis instead of restarting from root after each refinement.")
    private boolean allowLazyRefinement = false;
    @Option(secure=true, description="Which CPA is used as enabler in the current analysis.")
    private Enabler enablerCPA = Enabler.PREDICATE;

    public AnalysisWithRefinableEnablerCPAAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis cpa, CFA pCfa, LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.algorithm = pAlgorithm;
        this.cpa = cpa;
        this.cfa = pCfa;
        this.logger = logger;
        this.shutdownNotifier = pShutdownNotifier;
        if (!(cpa instanceof ARGCPA) || CPAs.retrieveCPA(cpa, LocationCPA.class) == null && CPAs.retrieveCPA(cpa, LocationCPABackwards.class) == null || CPAs.retrieveCPA(cpa, this.enablerCPA.cpaClass) == null || CPAs.retrieveCPA(cpa, CompositeCPA.class) == null) {
            throw new InvalidConfigurationException("Analysis with enabler CPA requires ARG as top CPA and Composite CPA as child. Furthermore, it needs Location CPA and enabling CPA to work.");
        }
        this.predCPA = this.enablerCPA == Enabler.PREDICATE ? CPAs.retrieveCPA(cpa, PredicateCPA.class) : null;
        try {
            if (!(CPAs.retrieveCPA(cpa, CompositeCPA.class).getMergeOperator() instanceof MergeSepOperator)) {
                ((CompositeMergeAgreeCPAEnabledAnalysisOperator)CPAs.retrieveCPA(cpa, CompositeCPA.class).getMergeOperator()).setEnablerStateClass(this.enablerCPA.stateClass);
            }
        }
        catch (ClassCastException e) {
            throw new InvalidConfigurationException("Option cpa.composite.inCPAEnabledAnalysis must be enabled.");
        }
        this.enablerTransfer = CPAs.retrieveCPA(cpa, this.enablerCPA.cpaClass).getTransferRelation();
        if (CPAs.retrieveCPA(cpa, LocationCPABackwards.class) != null) {
            throw new InvalidConfigurationException("Currently only support forward analyses.");
        }
        if (!(cpa.getMergeOperator() instanceof MergeSepOperator) && !(cpa.getMergeOperator() instanceof ARGMergeJoinCPAEnabledAnalysis)) {
            throw new InvalidConfigurationException("ARG CPA must be informed about analysis with enabler CPA. Add cpa.arg.inCPAEnabledAnalysis=true to your configuration options.");
        }
    }

    @Override
    @SuppressForbidden(value="TODO: needs to be fixed")
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        Algorithm.AlgorithmStatus status;
        this.logger.log(Level.FINEST, new Object[]{"Clean up from previous run"});
        for (CAssumeEdge edge : this.fakeEdgesFromLastRun) {
            edge.getPredecessor().removeLeavingEdge(edge);
            edge.getSuccessor().removeEnteringEdge(edge);
        }
        this.fakeEdgesFromLastRun.clear();
        if (!this.allowLazyRefinement) {
            this.restartFromScratchAfterRefinement(pReachedSet);
        } else if (pReachedSet.wasTargetReached()) {
            throw new RefinementFailedException(RefinementFailedException.Reason.InterpolationFailed, null);
        }
        this.logger.log(Level.FINEST, new Object[]{"Start analysis."});
        try {
            status = this.algorithm.run(pReachedSet);
        }
        catch (CPAEnabledAnalysisPropertyViolationException e) {
            if (e.getFailureCause() == null) {
                throw new CPAException("Error state not known to analysis with enabler CPA. Cannot continue analysis.");
            }
            Precision precision = pReachedSet.getPrecision(((ARGState)e.getFailureCause()).getParents().iterator().next());
            if (e.getFailureCause() != null && !pReachedSet.contains(e.getFailureCause()) && !((ARGState)e.getFailureCause()).getParents().isEmpty()) {
                pReachedSet.add(e.getFailureCause(), precision);
                for (ARGState parent : ((ARGState)e.getFailureCause()).getParents()) {
                    pReachedSet.reAddToWaitlist(parent);
                }
            }
            if (e.isMergeViolationCause()) {
                pReachedSet.add(((ARGState)e.getFailureCause()).getMergedWith(), precision);
                ((ARGMergeJoinCPAEnabledAnalysis)this.cpa.getMergeOperator()).cleanUp(pReachedSet);
            }
            this.logger.log(Level.FINEST, new Object[]{"Analysis aborted because error state found"});
            ARGState predecessor = (ARGState)pReachedSet.getLastState();
            CFANode node = AbstractStates.extractLocation(predecessor);
            this.logger.log(Level.FINEST, new Object[]{"Prepare for refinement by CEGAR algorithm"});
            AbstractState errorEnablerState = this.getEnablerState(predecessor);
            CompositeState comp = AbstractStates.extractStateByType(predecessor, CompositeState.class);
            if (!e.isMergeViolationCause()) {
                predecessor = this.prepareForCEGARAfterPathExplorationError(predecessor, comp, errorEnablerState, pReachedSet);
                errorEnablerState = this.getEnablerState(predecessor);
                comp = AbstractStates.extractStateByType(predecessor, CompositeState.class);
            }
            if (!this.allowLazyRefinement) {
                ARGPath currentFailurePath = ARGUtils.getOnePathTo(predecessor);
                this.repeatedFailure = this.pathToFailure == null || this.isSamePathInCFA(this.pathToFailure, currentFailurePath);
                this.pathToFailure = currentFailurePath;
            }
            CFANode predNode = node;
            try {
                for (AutomatonState s : AbstractStates.asIterable(predecessor).filter(AutomatonState.class)) {
                    if (!s.isTarget()) continue;
                    for (CExpression assume : FluentIterable.from(s.getAssumptions()).filter(CExpression.class)) {
                        predNode = this.createFakeEdge(assume, predNode);
                    }
                }
            }
            catch (ClassCastException e2) {
                throw new CPAException("Analysis with enabler CPA requires that the error condition is specified as a CExpression (statement) in the specification (automata).");
            }
            if (this.fakeEdgesFromLastRun.isEmpty()) {
                predNode = this.createFakeEdge(CIntegerLiteralExpression.ONE, predNode);
            }
            if (this.locConstructor == null) {
                try {
                    this.locConstructor = LocationState.class.getDeclaredConstructor(CFANode.class, Boolean.TYPE);
                    this.locConstructor.setAccessible(true);
                }
                catch (NoSuchMethodException | SecurityException e1) {
                    throw new CPAException("Cannot prepare for refinement because cannot get constructor for location states.", e1);
                }
            }
            AbstractState fakeEnablerState = errorEnablerState;
            int i = 1;
            for (CAssumeEdge assumeEdge : this.fakeEdgesFromLastRun) {
                errorEnablerState = fakeEnablerState;
                fakeEnablerState = this.buildFakeEnablerState(fakeEnablerState, assumeEdge, i == this.fakeEdgesFromLastRun.size());
                ImmutableList.Builder wrappedStates = ImmutableList.builder();
                for (AbstractState state : comp.getWrappedStates()) {
                    if (state != errorEnablerState) {
                        if (state instanceof LocationState) {
                            try {
                                wrappedStates.add((Object)this.locConstructor.newInstance(assumeEdge.getSuccessor(), true));
                                continue;
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e1) {
                                throw new CPAException("Cannot prepare for refinement, cannot build necessary fake states.", e1);
                            }
                        }
                        wrappedStates.add((Object)state);
                        continue;
                    }
                    wrappedStates.add((Object)fakeEnablerState);
                }
                comp = new CompositeState((List<AbstractState>)wrappedStates.build());
                ARGState successor = new ARGState(comp, predecessor);
                pReachedSet.add(successor, pReachedSet.getPrecision(predecessor));
                predecessor = successor;
                ++i;
            }
            if (this.enablerCPA != Enabler.PREDICATE) {
                this.createFakeEdge(CIntegerLiteralExpression.ONE, predNode);
            }
            assert (ARGUtils.checkARG(pReachedSet));
            return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        }
        return status;
    }

    private AbstractState getEnablerState(ARGState pPredecessor) {
        return AbstractStates.extractStateByType(pPredecessor, this.enablerCPA.stateClass);
    }

    private ARGState prepareForCEGARAfterPathExplorationError(ARGState pPredecessor, CompositeState pComp, AbstractState pErrorEnablerState, ReachedSet pReachedSet) {
        PredicateAbstractState predError;
        if (this.enablerCPA == Enabler.PREDICATE && (predError = (PredicateAbstractState)pErrorEnablerState).isAbstractionState()) {
            PredicateAbstractState prevErrorState = AbstractStates.extractStateByType(pPredecessor.getParents().iterator().next(), PredicateAbstractState.class);
            PredicateAbstractState errorEnablerStateReplace = PredicateAbstractState.mkNonAbstractionStateWithNewPathFormula(predError.getAbstractionFormula().getBlockFormula(), prevErrorState);
            ImmutableList.Builder wrappedStates = ImmutableList.builder();
            for (AbstractState state : pComp.getWrappedStates()) {
                if (!(state instanceof PredicateAbstractState)) {
                    wrappedStates.add((Object)state);
                    continue;
                }
                wrappedStates.add((Object)errorEnablerStateReplace);
            }
            CompositeState newComp = new CompositeState((List<AbstractState>)wrappedStates.build());
            assert (pPredecessor.getChildren().isEmpty());
            assert (pPredecessor.getParents().size() == 1);
            assert (pPredecessor.getCoveredByThis().isEmpty());
            ARGState newPred = new ARGState(newComp, pPredecessor.getParents().iterator().next());
            pPredecessor.removeFromARG();
            pReachedSet.add(newPred, pReachedSet.getPrecision(pPredecessor));
            pReachedSet.remove(pPredecessor);
            return newPred;
        }
        return pPredecessor;
    }

    private AbstractState buildFakeEnablerState(AbstractState pFakeEnablerState, CAssumeEdge pAssumeEdge, boolean pLastEdge) throws CPATransferException, InterruptedException {
        switch (this.enablerCPA) {
            case PREDICATE: {
                PathFormulaManager pfm = this.predCPA.getPathFormulaManager();
                PredicateAbstractionManager pam = this.predCPA.getPredicateManager();
                PredicateAbstractState predFakeState = (PredicateAbstractState)pFakeEnablerState;
                PathFormula pf = predFakeState.getPathFormula();
                pf = pfm.makeAnd(pf, pAssumeEdge);
                if (pLastEdge) {
                    AbstractionFormula abf = pam.makeTrueAbstractionFormula(pf);
                    pf = pfm.makeEmptyPathFormulaWithContextFrom(pf);
                    PersistentMap abstractionLocations = predFakeState.getAbstractionLocationsOnPath();
                    Integer newLocInstance = (Integer)abstractionLocations.getOrDefault((Object)pAssumeEdge.getSuccessor(), (Object)0) + 1;
                    abstractionLocations = abstractionLocations.putAndCopy((Object)pAssumeEdge.getSuccessor(), (Object)newLocInstance);
                    predFakeState = PredicateAbstractState.mkAbstractionState(pf, abf, (PersistentMap<CFANode, Integer>)abstractionLocations);
                } else {
                    predFakeState = PredicateAbstractState.mkNonAbstractionStateWithNewPathFormula(pf, predFakeState);
                }
                return predFakeState;
            }
            case APRON: 
            case INTERVAL: 
            case OCTAGON: 
            case VALUE: {
                Collection<? extends AbstractState> nextFakeStateResult = this.enablerTransfer.getAbstractSuccessorsForEdge(pFakeEnablerState, SingletonPrecision.getInstance(), pAssumeEdge);
                if (nextFakeStateResult == null || nextFakeStateResult.isEmpty()) {
                    this.logger.log(Level.INFO, new Object[]{"Adding error explaining condition makes path infeasible, enabler knows of infeasibility of error, but still try to exclude path"});
                    return pFakeEnablerState;
                }
                return nextFakeStateResult.iterator().next();
            }
        }
        throw new AssertionError((Object)"case should never happen");
    }

    private CFANode createFakeEdge(CExpression pAssumeExpr, CFANode pPredecessor) {
        CFANode successor = new CFANode(pPredecessor.getFunction());
        CAssumeEdge assumeEdge = new CAssumeEdge(pAssumeExpr.toASTString(), FileLocation.DUMMY, pPredecessor, successor, pAssumeExpr, true);
        pPredecessor.addLeavingEdge(assumeEdge);
        successor.addEnteringEdge(assumeEdge);
        this.fakeEdgesFromLastRun.add(assumeEdge);
        return successor;
    }

    private void restartFromScratchAfterRefinement(ReachedSet pReachedSet) throws RefinementFailedException, InterruptedException {
        this.logger.log(Level.FINEST, new Object[]{"Construct precision for current run"});
        Precision precision = this.buildInitialPrecision(pReachedSet.getPrecisions(), this.cpa.getInitialPrecision(this.cfa.getMainFunction(), StateSpacePartition.getDefaultPartition()));
        this.oldEnablerPrecision = this.getCurrentEnablerPrecision(precision);
        pReachedSet.clear();
        if (this.initialWrappedState == null) {
            this.initialWrappedState = ((ARGState)this.cpa.getInitialState(this.cfa.getMainFunction(), StateSpacePartition.getDefaultPartition())).getWrappedState();
        }
        pReachedSet.add(new ARGState(this.initialWrappedState, null), precision);
    }

    private Precision buildInitialPrecision(Collection<Precision> precisions, Precision initialPrecision) throws InterruptedException, RefinementFailedException {
        if (precisions.isEmpty()) {
            return initialPrecision;
        }
        Precision newPrec = this.enablerCPA == Enabler.PREDICATE ? this.builtNewPredicatePrecision(initialPrecision, precisions) : this.builtNewVariableTrackingPrecision(initialPrecision, precisions);
        this.shutdownNotifier.shutdownIfNecessary();
        try {
            if (this.repeatedFailure && (this.enablerCPA == Enabler.PREDICATE && this.noNewPredicates((PredicatePrecision)this.oldEnablerPrecision, (PredicatePrecision)newPrec) || this.enablerCPA != Enabler.PREDICATE && this.noNewVariablesTracked((VariableTrackingPrecision)this.oldEnablerPrecision, (VariableTrackingPrecision)newPrec))) {
                throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, this.pathToFailure);
            }
        }
        catch (SolverException e) {
            throw new RefinementFailedException(RefinementFailedException.Reason.InterpolationFailed, this.pathToFailure, e);
        }
        return this.replaceEnablerPrecision(initialPrecision, newPrec);
    }

    private PredicatePrecision builtNewPredicatePrecision(Precision initialPrecision, Collection<Precision> pReachedSetPrecisions) {
        return PredicatePrecision.unionOf(Iterables.concat((Iterable)ImmutableList.of((Object)initialPrecision), pReachedSetPrecisions));
    }

    private Precision builtNewVariableTrackingPrecision(Precision pInitialPrecision, Collection<Precision> pPrecisions) {
        VariableTrackingPrecision vtPrec = (VariableTrackingPrecision)Precisions.asIterable(pInitialPrecision).filter(VariableTrackingPrecision.isMatchingCPAClass(this.enablerCPA.cpaClass)).get(0);
        HashSet<Precision> seen = new HashSet<Precision>();
        seen.add(pInitialPrecision);
        for (Precision joinPrec : pPrecisions) {
            if (!seen.add(joinPrec)) continue;
            vtPrec = vtPrec.join((VariableTrackingPrecision)Precisions.asIterable(joinPrec).filter(VariableTrackingPrecision.isMatchingCPAClass(this.enablerCPA.cpaClass)).get(0));
        }
        return vtPrec;
    }

    private Precision getCurrentEnablerPrecision(Precision pPrecision) {
        if (this.enablerCPA == Enabler.PREDICATE) {
            return Precisions.extractPrecisionByType(pPrecision, PredicatePrecision.class);
        }
        return (Precision)Precisions.asIterable(pPrecision).filter(VariableTrackingPrecision.isMatchingCPAClass(this.enablerCPA.cpaClass)).get(0);
    }

    private Precision replaceEnablerPrecision(Precision pInitialPrecision, Precision pNewPrec) {
        if (this.enablerCPA == Enabler.PREDICATE) {
            return Precisions.replaceByType(pInitialPrecision, pNewPrec, (Predicate<? super Precision>)Predicates.instanceOf(PredicatePrecision.class));
        }
        return Precisions.replaceByType(pInitialPrecision, pNewPrec, VariableTrackingPrecision.isMatchingCPAClass(this.enablerCPA.cpaClass));
    }

    private boolean noNewPredicates(PredicatePrecision oldPrecision, PredicatePrecision newPrecision) throws SolverException, InterruptedException {
        if (this.isMorePrecise((Set<AbstractionPredicate>)oldPrecision.getGlobalPredicates(), (Set<AbstractionPredicate>)newPrecision.getGlobalPredicates())) {
            return false;
        }
        HashSet<String> funNames = new HashSet<String>();
        HashSet<CFANode> nodesOnPath = new HashSet<CFANode>();
        for (CFAEdge edge : this.pathToFailure.getInnerEdges()) {
            CFANode current = edge.getSuccessor();
            funNames.add(current.getFunctionName());
            nodesOnPath.add(current);
        }
        for (String funName : funNames) {
            if (!this.isMorePrecise((Set<AbstractionPredicate>)oldPrecision.getFunctionPredicates().get((Object)funName), (Set<AbstractionPredicate>)newPrecision.getFunctionPredicates().get((Object)funName))) continue;
            return false;
        }
        for (CFANode node : nodesOnPath) {
            if (!this.isMorePrecise((Set<AbstractionPredicate>)oldPrecision.getLocalPredicates().get((Object)node), (Set<AbstractionPredicate>)newPrecision.getLocalPredicates().get((Object)node))) continue;
            return false;
        }
        return true;
    }

    private boolean noNewVariablesTracked(VariableTrackingPrecision pOldEnablerPrecision, VariableTrackingPrecision pNewPrec) {
        return pOldEnablerPrecision.tracksTheSameVariablesAs(pNewPrec);
    }

    private boolean isMorePrecise(Set<AbstractionPredicate> lessPrecise, Set<AbstractionPredicate> morePrecise) throws SolverException, InterruptedException {
        if (lessPrecise != null && morePrecise != null) {
            if (lessPrecise.size() == morePrecise.size() && lessPrecise.equals(morePrecise)) {
                return false;
            }
            ArrayList<BooleanFormula> list = new ArrayList<BooleanFormula>(Math.max(lessPrecise.size(), morePrecise.size()));
            for (AbstractionPredicate abs : lessPrecise) {
                list.add(abs.getSymbolicAtom());
            }
            Solver solver = this.predCPA.getSolver();
            BooleanFormulaManagerView bfmgr = solver.getFormulaManager().getBooleanFormulaManager();
            BooleanFormula fLess = bfmgr.and(list);
            list.clear();
            for (AbstractionPredicate abs : morePrecise) {
                list.add(abs.getSymbolicAtom());
            }
            BooleanFormula fMore = bfmgr.and(list);
            fMore = bfmgr.not(fMore);
            return !solver.isUnsat(fMore = bfmgr.and(fLess, fMore));
        }
        return lessPrecise == null && morePrecise != null;
    }

    private boolean isSamePathInCFA(ARGPath path1, ARGPath path2) {
        if (path1.size() != path2.size()) {
            return false;
        }
        List edges1 = Lists.transform((List)path1.asStatesList().reverse(), AbstractStates::extractLocation);
        List edges2 = Lists.transform((List)path2.asStatesList().reverse(), AbstractStates::extractLocation);
        return edges1.equals(edges2);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
    }

    static enum Enabler {
        APRON(ApronState.class, ApronCPA.class),
        INTERVAL(IntervalAnalysisState.class, IntervalAnalysisCPA.class),
        OCTAGON(OctagonState.class, OctagonCPA.class),
        PREDICATE(PredicateAbstractState.class, PredicateCPA.class),
        VALUE(ValueAnalysisState.class, ValueAnalysisCPA.class);

        private final Class<? extends AbstractState> stateClass;
        private final Class<? extends ConfigurableProgramAnalysis> cpaClass;

        private Enabler(Class<? extends AbstractState> pStateClassOfEnabler, Class<? extends ConfigurableProgramAnalysis> pCPAClassOfEnabler) {
            this.stateClass = pStateClassOfEnabler;
            this.cpaClass = pCPAClassOfEnabler;
        }
    }
}

