/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.export.DOTBuilder;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.NestingAlgorithm;
import org.sosy_lab.cpachecker.core.defaults.MultiStatistics;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAEnabledAnalysisPropertyViolationException;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.arrayabstraction.ArrayAbstraction;
import org.sosy_lab.cpachecker.util.arrayabstraction.ArrayAbstractionResult;
import org.sosy_lab.cpachecker.util.cwriter.CFAToCTranslator;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;

@Options(prefix="arrayAbstraction")
public final class ArrayAbstractionAlgorithm
extends NestingAlgorithm {
    @Option(secure=true, name="delegateAnalysis", description="Configuration file path of the delegate analysis running on the transformed program.")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path delegateAnalysisConfigurationFile;
    @Option(secure=true, name="allowImprecision", description="Whether to allow imprecise array abstraction that may lead to false alarms.")
    private boolean allowImprecision = false;
    @Option(secure=true, name="checkCounterexamples", description="Use a second delegate analysis run to check counterexamples on the original program that contains (non-abstracted) arrays for imprecise array abstractions.")
    private boolean checkCounterexamples = false;
    @Option(secure=true, name="cfa.dot.export", description="Whether to export the CFA with abstracted arrays as DOT file.")
    private boolean exportDotTransformedCfa = true;
    @Option(secure=true, name="cfa.dot.file", description="DOT file path for CFA with abstracted arrays.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportDotTransformedCfaFile = Path.of("cfa-abstracted-arrays.dot", new String[0]);
    @Option(secure=true, name="cfa.c.export", description="Whether to export the CFA with abstracted arrays as C source file.")
    private boolean exportCTransformedCfa = true;
    @Option(secure=true, name="cfa.c.file", description="C source file path for CFA with abstracted arrays.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportCTransformedCfaFile = Path.of("abstracted-arrays.c", new String[0]);
    private final ShutdownManager shutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier);
    private final ArrayAbstractionAlgorithmStatistics statistics;
    private final ArrayAbstractionResult arrayAbstractionResult;
    private final CFA originalCfa;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayAbstractionAlgorithm(Configuration pConfiguration, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Specification pSpecification, CFA pCfa) throws InvalidConfigurationException {
        super(pConfiguration, pLogger, pShutdownNotifier, pSpecification);
        this.statistics = new ArrayAbstractionAlgorithmStatistics(pLogger);
        this.originalCfa = pCfa;
        this.statistics.startTimer();
        try {
            this.arrayAbstractionResult = ArrayAbstraction.transformCfa(this.globalConfig, this.logger, this.originalCfa);
        }
        finally {
            this.statistics.stopTimer();
        }
        pConfiguration.inject((Object)this);
    }

    private boolean useTransformedCfa() {
        ArrayAbstractionResult.Status status = this.arrayAbstractionResult.getStatus();
        if (status == ArrayAbstractionResult.Status.PRECISE) {
            return true;
        }
        return this.allowImprecision && status == ArrayAbstractionResult.Status.IMPRECISE;
    }

    private Algorithm.AlgorithmStatus runDelegateAnalysis(CFA pCfa, ForwardingReachedSet pForwardingReachedSet, AggregatedReachedSets pAggregatedReached) throws InterruptedException, CPAEnabledAnalysisPropertyViolationException, CPAException {
        Triple<Algorithm, ConfigurableProgramAnalysis, ReachedSet> delegate;
        ImmutableSet ignoreOptions = ImmutableSet.of((Object)"analysis.useArrayAbstraction", (Object)"arrayAbstraction.delegateAnalysis");
        try {
            delegate = this.createAlgorithm(this.delegateAnalysisConfigurationFile, pCfa.getMainFunction(), pCfa, this.shutdownManager, pAggregatedReached, (Collection<String>)ignoreOptions, this.statistics.getSubStatistics());
        }
        catch (IOException | InvalidConfigurationException ex) {
            this.logger.logUserException(Level.SEVERE, ex, "Could not create delegate algorithm");
            return Algorithm.AlgorithmStatus.NO_PROPERTY_CHECKED;
        }
        Algorithm algorithm = delegate.getFirst();
        ReachedSet reached = delegate.getThird();
        Algorithm.AlgorithmStatus status = algorithm.run(reached);
        while (reached.hasWaitingState()) {
            status = algorithm.run(reached);
        }
        pForwardingReachedSet.setDelegate(reached);
        return status;
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException, CPAEnabledAnalysisPropertyViolationException {
        ForwardingReachedSet forwardingReachedSet = (ForwardingReachedSet)pReachedSet;
        AggregatedReachedSets aggregatedReached = AggregatedReachedSets.singleton(pReachedSet);
        CFA cfa = this.useTransformedCfa() ? this.arrayAbstractionResult.getTransformedCfa() : this.originalCfa;
        Algorithm.AlgorithmStatus status = this.runDelegateAnalysis(cfa, forwardingReachedSet, aggregatedReached);
        if (this.checkCounterexamples && this.arrayAbstractionResult.getStatus() == ArrayAbstractionResult.Status.IMPRECISE && forwardingReachedSet.wasTargetReached()) {
            status = this.runDelegateAnalysis(this.originalCfa, forwardingReachedSet, aggregatedReached);
        }
        return status;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.statistics);
    }

    private final class ArrayAbstractionAlgorithmStatistics
    extends MultiStatistics {
        private final StatTimer timer;

        private ArrayAbstractionAlgorithmStatistics(LogManager pLogger) {
            super(pLogger);
            this.timer = new StatTimer("Time for array abstraction");
        }

        private void startTimer() {
            this.timer.start();
        }

        private void stopTimer() {
            this.timer.stop();
        }

        @Override
        public String getName() {
            return "Array Abstraction Algorithm";
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            int indentation = 1;
            this.put(pOut, indentation, "Array abstraction status", (Object)ArrayAbstractionAlgorithm.this.arrayAbstractionResult.getStatus());
            this.put(pOut, indentation, this.timer);
            this.put(pOut, indentation, "Number of transformed arrays", ArrayAbstractionAlgorithm.this.arrayAbstractionResult.getTransformedArrays().size());
            this.put(pOut, indentation, "Number of transformed loops", ArrayAbstractionAlgorithm.this.arrayAbstractionResult.getTransformedLoops().size());
            super.printStatistics(pOut, pResult, pReached);
        }

        @Override
        public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            if (ArrayAbstractionAlgorithm.this.arrayAbstractionResult.getStatus() != ArrayAbstractionResult.Status.UNCHANGED) {
                Writer writer;
                CFA transformedCfa = ArrayAbstractionAlgorithm.this.arrayAbstractionResult.getTransformedCfa();
                if (ArrayAbstractionAlgorithm.this.exportDotTransformedCfa && ArrayAbstractionAlgorithm.this.exportDotTransformedCfaFile != null) {
                    try {
                        writer = IO.openOutputFile((Path)ArrayAbstractionAlgorithm.this.exportDotTransformedCfaFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
                        try {
                            DOTBuilder.generateDOT(writer, transformedCfa);
                        }
                        finally {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                    }
                    catch (IOException ex) {
                        this.logger.logUserException(Level.WARNING, (Throwable)ex, "Could not write CFA to dot file");
                    }
                }
                if (ArrayAbstractionAlgorithm.this.exportCTransformedCfa && ArrayAbstractionAlgorithm.this.exportCTransformedCfaFile != null) {
                    try {
                        writer = IO.openOutputFile((Path)ArrayAbstractionAlgorithm.this.exportCTransformedCfaFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
                        try {
                            String sourceCode = new CFAToCTranslator(ArrayAbstractionAlgorithm.this.globalConfig).translateCfa(transformedCfa);
                            writer.write(sourceCode);
                        }
                        finally {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                    }
                    catch (IOException | InvalidConfigurationException | CPAException ex) {
                        this.logger.logUserException(Level.WARNING, ex, "Could not export CFA as C source file");
                    }
                }
            }
            super.writeOutputFiles(pResult, pReached);
        }
    }
}

