/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.DummyScope;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageCPA;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonParser;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.assumptions.AssumptionWithLocation;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;

@Options(prefix="assumptions")
public class AssumptionCollectorAlgorithm
implements Algorithm,
StatisticsProvider {
    @Option(secure=true, name="export", description="write collected assumptions to file")
    private boolean exportAssumptions = true;
    @Option(secure=true, name="export.location", description="export assumptions collected per location")
    private boolean exportLocationAssumptions = true;
    @Option(secure=true, name="file", description="write collected assumptions to file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path assumptionsFile = Path.of("assumptions.txt", new String[0]);
    @Option(secure=true, name="automatonFile", description="write collected assumptions as automaton to file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path assumptionAutomatonFile = Path.of("AssumptionAutomaton.txt", new String[0]);
    @Option(secure=true, name="dotExport", description="export assumptions as automaton to dot file")
    private boolean dotExport = false;
    @Option(secure=true, name="dotFile", description="write collected assumptions as automaton to dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path assumptionAutomatonDotFile = Path.of("AssumptionAutomaton.dot", new String[0]);
    @Option(secure=true, description="compress the produced assumption automaton using GZIP compression.")
    private boolean compressAutomaton = false;
    @Option(secure=true, description="Add a threshold to the automaton, after so many branches on a path the automaton will be ignored (0 to disable)")
    @IntegerOption(min=0L)
    private int automatonBranchingThreshold = 0;
    @Option(secure=true, description="If it is enabled, automaton does not add assumption which is considered to continue path with corresponding this edge.")
    private boolean automatonIgnoreAssumptions = false;
    @Option(secure=true, description="If it is enabled, automaton adds transitions to later ARG states first")
    private boolean automatonOrderedTransitions = false;
    @Option(secure=true, description="If it is enabled, check if a state that should lead to false state indeed has successors.")
    private boolean removeNonExploredWithoutSuccessors = false;
    private final LogManager logger;
    private final Algorithm innerAlgorithm;
    private final FormulaManagerView formulaManager;
    private final AssumptionWithLocation exceptionAssumptions;
    private final BooleanFormulaManager bfmgr;
    private final CFA cfa;
    private final Configuration config;
    private final Set<Integer> exceptionStates = new HashSet<Integer>();
    private int automatonStates = 0;
    private final ConfigurableProgramAnalysis cpa;
    private final ShutdownNotifier shutdownNotifier;

    public AssumptionCollectorAlgorithm(Algorithm algo, ConfigurableProgramAnalysis pCpa, Configuration config, LogManager logger, CFA cfa, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = logger;
        this.innerAlgorithm = algo;
        this.shutdownNotifier = pShutdownNotifier;
        AssumptionStorageCPA asCpa = CPAs.retrieveCPAOrFail(pCpa, AssumptionStorageCPA.class, AssumptionStorageCPA.class);
        if (this.exportAssumptions && this.assumptionAutomatonFile != null && !(pCpa instanceof ARGCPA)) {
            throw new InvalidConfigurationException("ARGCPA needed for for export of assumption automaton in AssumptionCollectionAlgorithm");
        }
        this.formulaManager = asCpa.getFormulaManager();
        this.bfmgr = this.formulaManager.getBooleanFormulaManager();
        this.exceptionAssumptions = new AssumptionWithLocation(this.formulaManager);
        this.cpa = pCpa;
        this.cfa = cfa;
        this.config = config;
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reached) throws CPAException, InterruptedException {
        boolean restartCPA;
        Algorithm.AlgorithmStatus status = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        do {
            restartCPA = false;
            try {
                status = status.update(this.innerAlgorithm.run(reached));
            }
            catch (RefinementFailedException failedRefinement) {
                this.logger.logUserException(Level.INFO, (Throwable)failedRefinement, "Will generate assumption for incomplete analysis");
                ARGPath path = failedRefinement.getErrorPath();
                ARGState errorState = path.getLastState();
                assert (errorState == reached.getLastState());
                ARGState parent = (ARGState)Iterables.getOnlyElement(errorState.getParents());
                reached.removeOnlyFromWaitlist(parent);
                this.exceptionStates.add(parent.getStateId());
                this.addAvoidingAssumptions(this.exceptionAssumptions, parent);
                reached.remove(errorState);
                errorState.removeFromARG();
                restartCPA = true;
                status = status.withSound(false);
            }
        } while (restartCPA);
        return status;
    }

    private AssumptionWithLocation collectLocationAssumptions(UnmodifiableReachedSet reached, AssumptionWithLocation pExceptionAssumptions) {
        AssumptionWithLocation result = AssumptionWithLocation.copyOf(pExceptionAssumptions);
        this.logger.log(Level.FINER, new Object[]{"Dumping assumptions resulting from tool assumptions"});
        for (AbstractState state : reached) {
            if (AbstractStates.isTargetState(state)) {
                this.addAvoidingAssumptions(result, state);
                continue;
            }
            AssumptionStorageState e = AbstractStates.extractStateByType(state, AssumptionStorageState.class);
            BooleanFormula assumption = this.bfmgr.and(e.getAssumption(), e.getStopFormula());
            if (this.bfmgr.isTrue(assumption)) continue;
            this.addAssumption(result, assumption, state);
        }
        this.logger.log(Level.FINER, new Object[]{"Dumping assumptions resulting from waitlist states"});
        for (AbstractState state : reached.getWaitlist()) {
            this.addAvoidingAssumptions(result, state);
        }
        return result;
    }

    private void addAssumption(AssumptionWithLocation invariant, BooleanFormula assumption, AbstractState state) {
        BooleanFormula dataRegion = AbstractStates.extractReportedFormulas(this.formulaManager, state);
        CFANode loc = AbstractStates.extractLocation(state);
        assert (loc != null);
        invariant.add(loc, this.bfmgr.or(assumption, this.bfmgr.not(dataRegion)));
    }

    private void addAvoidingAssumptions(AssumptionWithLocation invariant, AbstractState state) {
        this.addAssumption(invariant, this.bfmgr.makeFalse(), state);
    }

    private void produceAssumptionAutomaton(Appendable output, UnmodifiableReachedSet reached) throws IOException {
        AbstractState firstState = reached.getFirstState();
        if (!(firstState instanceof ARGState)) {
            output.append("Cannot dump assumption as automaton if ARGCPA is not used.");
        }
        Set<AbstractState> falseAssumptionStates = this.getFalseAssumptionStates(reached);
        TreeSet<ARGState> relevantStates = new TreeSet<ARGState>();
        for (AbstractState state : reached) {
            boolean isRelevant;
            ARGState e = (ARGState)state;
            AssumptionStorageState asmptState = AbstractStates.extractStateByType(e, AssumptionStorageState.class);
            boolean hasFalseAssumption = e.isTarget() || asmptState.isStop() || this.exceptionStates.contains(e.getStateId());
            boolean bl = isRelevant = !asmptState.isAssumptionTrue();
            if (e.isCovered()) {
                e = e.getCoveringState();
                assert (!e.isCovered());
                asmptState = null;
            }
            if (hasFalseAssumption) {
                falseAssumptionStates.add(e);
            }
            if (relevantStates.contains(e) || !isRelevant && !falseAssumptionStates.contains(e)) continue;
            AssumptionCollectorAlgorithm.findAllParents(e, relevantStates);
        }
        this.automatonStates += AssumptionCollectorAlgorithm.writeAutomaton(output, (ARGState)firstState, relevantStates, falseAssumptionStates, this.automatonBranchingThreshold, this.automatonIgnoreAssumptions, this.automatonOrderedTransitions);
    }

    private Automaton constructAutomatonFromFile() throws InvalidConfigurationException {
        Scope scope = this.cfa.getLanguage() == Language.C ? new CProgramScope(this.cfa, this.logger) : DummyScope.getInstance();
        List<Automaton> lst = AutomatonParser.parseAutomatonFile(this.assumptionAutomatonFile, this.config, this.logger, this.cfa.getMachineModel(), scope, this.cfa.getLanguage(), this.shutdownNotifier);
        if (lst.isEmpty()) {
            throw new InvalidConfigurationException("Could not find automata in the file " + this.assumptionAutomatonFile.toAbsolutePath());
        }
        if (lst.size() > 1) {
            throw new InvalidConfigurationException("Found " + lst.size() + " automata in the File " + this.assumptionAutomatonFile.toAbsolutePath() + " The CPA can only handle ONE Automaton!");
        }
        return lst.get(0);
    }

    private void writeAutomatonToDot(Automaton automaton) {
        try (Writer w = IO.openOutputFile((Path)this.assumptionAutomatonDotFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            automaton.writeDotFile(w);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write the automaton to DOT file");
        }
    }

    private Set<AbstractState> getFalseAssumptionStates(UnmodifiableReachedSet pReached) {
        if (this.removeNonExploredWithoutSuccessors) {
            HashSet falseAssumptionStates = Sets.newHashSetWithExpectedSize((int)pReached.getWaitlist().size());
            for (AbstractState state : pReached.getWaitlist()) {
                try {
                    if (this.cpa.getTransferRelation().getAbstractSuccessors(state, pReached.getPrecision(state)).isEmpty()) continue;
                    falseAssumptionStates.add(state);
                    if (!(state instanceof ARGState)) continue;
                    ARGState argState = (ARGState)state;
                    while (!argState.getChildren().isEmpty()) {
                        argState.getChildren().iterator().next().removeFromARG();
                    }
                }
                catch (InterruptedException | UnsupportedOperationException | CPATransferException e) {
                    falseAssumptionStates.add(state);
                }
            }
            return falseAssumptionStates;
        }
        HashSet<AbstractState> falseAssumptionStates = new HashSet<AbstractState>(pReached.getWaitlist());
        return falseAssumptionStates;
    }

    public static int writeAutomaton(Appendable sb, ARGState pInitialState, Set<ARGState> relevantStates, Set<AbstractState> falseAssumptionStates, int branchingThreshold, boolean ignoreAssumptions, boolean automatonOrderedTransitions) throws IOException {
        int numProducedStates = 0;
        sb.append("OBSERVER AUTOMATON AssumptionAutomaton\n\n");
        String actionOnFinalEdges = "";
        if (branchingThreshold > 0) {
            sb.append("LOCAL int branchingThreshold = " + branchingThreshold + ";\n");
            sb.append("LOCAL int branchingCount = 0;\n\n");
            actionOnFinalEdges = "DO branchingCount = 0 ";
        }
        Object initialStateName = relevantStates.isEmpty() ? "__TRUE" : "ARG" + pInitialState.getStateId();
        sb.append("INITIAL STATE ").append((CharSequence)initialStateName).append(";\n\n");
        sb.append("STATE __TRUE :\n");
        sb.append("    TRUE -> GOTO __TRUE;\n\n");
        if (!falseAssumptionStates.isEmpty()) {
            sb.append("STATE __FALSE :\n");
            if (ignoreAssumptions) {
                sb.append("    TRUE -> GOTO __FALSE;\n\n");
            } else {
                sb.append("    TRUE -> ASSUME {false} GOTO __FALSE;\n\n");
            }
        }
        for (ARGState s : relevantStates) {
            assert (!s.isCovered());
            if (falseAssumptionStates.contains(s)) continue;
            sb.append("STATE USEFIRST ARG" + s.getStateId() + " :\n");
            ++numProducedStates;
            boolean branching = false;
            if (branchingThreshold > 0 && s.getChildren().size() > 1) {
                branching = true;
                sb.append("    branchingCount == branchingThreshold -> " + actionOnFinalEdges + "GOTO __FALSE;\n");
            }
            StringBuilder descriptionForInnerMultiEdges = new StringBuilder();
            int multiEdgeID = 0;
            ImmutableList children = ARGUtils.getUncoveredChildrenView(s);
            if (automatonOrderedTransitions && children.size() > 1) {
                children = FluentIterable.from(children).toSortedList(Comparator.comparingInt(child -> child.getStateId()).reversed());
            }
            for (ARGState child2 : children) {
                assert (!child2.isCovered());
                List<CFAEdge> edges = s.getEdgesToChild(child2);
                if (edges.size() > 1) {
                    sb.append("    MATCH \"");
                    AssumptionCollectorAlgorithm.escape(edges.get(0).getRawStatement(), sb);
                    sb.append("\" -> ");
                    sb.append("GOTO ARG" + s.getStateId() + "M" + multiEdgeID);
                    boolean first = true;
                    for (CFAEdge innerEdge : FluentIterable.from(edges).skip(1)) {
                        if (!first) {
                            descriptionForInnerMultiEdges.append("GOTO ARG" + s.getStateId() + "M" + ++multiEdgeID + ";\n");
                            descriptionForInnerMultiEdges.append("    TRUE -> " + actionOnFinalEdges + "GOTO __TRUE;\n\n");
                        } else {
                            first = false;
                        }
                        descriptionForInnerMultiEdges.append("STATE USEFIRST ARG" + s.getStateId() + "M" + multiEdgeID + " :\n");
                        ++numProducedStates;
                        descriptionForInnerMultiEdges.append("    MATCH \"");
                        AssumptionCollectorAlgorithm.escape(innerEdge.getRawStatement(), descriptionForInnerMultiEdges);
                        descriptionForInnerMultiEdges.append("\" -> ");
                    }
                    AssumptionStorageState assumptionChild = AbstractStates.extractStateByType(child2, AssumptionStorageState.class);
                    AssumptionCollectorAlgorithm.addAssumption(descriptionForInnerMultiEdges, assumptionChild, ignoreAssumptions, AbstractStates.extractLocation(child2));
                    AssumptionCollectorAlgorithm.finishTransition(descriptionForInnerMultiEdges, child2, relevantStates, falseAssumptionStates, actionOnFinalEdges, branching);
                    descriptionForInnerMultiEdges.append(";\n");
                    descriptionForInnerMultiEdges.append("    TRUE -> " + actionOnFinalEdges + "GOTO __TRUE;\n\n");
                } else {
                    sb.append("    MATCH \"");
                    AssumptionCollectorAlgorithm.escape(((CFAEdge)Iterables.getOnlyElement(edges)).getRawStatement(), sb);
                    sb.append("\" -> ");
                    AssumptionStorageState assumptionChild = AbstractStates.extractStateByType(child2, AssumptionStorageState.class);
                    AssumptionCollectorAlgorithm.addAssumption(sb, assumptionChild, ignoreAssumptions, AbstractStates.extractLocation(child2));
                    AssumptionCollectorAlgorithm.finishTransition(sb, child2, relevantStates, falseAssumptionStates, actionOnFinalEdges, branching);
                }
                sb.append(";\n");
            }
            sb.append("    TRUE -> " + actionOnFinalEdges + "GOTO __TRUE;\n\n");
            sb.append(descriptionForInnerMultiEdges);
        }
        sb.append("END AUTOMATON\n");
        return numProducedStates;
    }

    private static void addAssumption(Appendable writer, AssumptionStorageState assumptionState, boolean ignoreAssumptions, CFANode pCFANode) throws IOException {
        if (!ignoreAssumptions) {
            BooleanFormula assumption;
            FormulaManagerView fmgr = assumptionState.getFormulaManager();
            BooleanFormulaManagerView bmgr = assumptionState.getFormulaManager().getBooleanFormulaManager();
            if (!bmgr.isTrue(assumption = bmgr.and(assumptionState.getAssumption(), assumptionState.getStopFormula()))) {
                try {
                    ExpressionTree<Object> assumptionTree = ExpressionTrees.fromFormula(assumption, fmgr, pCFANode);
                    writer.append("ASSUME {");
                    AssumptionCollectorAlgorithm.escape(assumptionTree.toString(), writer);
                    writer.append("} ");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static void finishTransition(Appendable writer, ARGState child, Set<ARGState> relevantStates, Set<AbstractState> falseAssumptionStates, String actionOnFinalEdges, boolean branching) throws IOException {
        if (falseAssumptionStates.contains(child)) {
            writer.append(actionOnFinalEdges + "GOTO __FALSE");
        } else if (relevantStates.contains(child)) {
            if (branching) {
                writer.append("DO branchingCount = branchingCount+1 ");
            }
            writer.append("GOTO ARG" + child.getStateId());
        } else {
            writer.append(actionOnFinalEdges + "GOTO __TRUE");
        }
    }

    private static void findAllParents(ARGState s, Set<ARGState> parentSet) {
        ArrayDeque<ARGState> toAdd = new ArrayDeque<ARGState>();
        toAdd.add(s);
        while (!toAdd.isEmpty()) {
            ARGState current = (ARGState)toAdd.pop();
            assert (!current.isCovered());
            if (!parentSet.add(current)) continue;
            toAdd.addAll(current.getParents());
            for (ARGState coveredByCurrent : current.getCoveredByThis()) {
                toAdd.addAll(coveredByCurrent.getParents());
            }
        }
    }

    private static void escape(String s, Appendable appendTo) throws IOException {
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    appendTo.append("\\r");
                    continue block7;
                }
                case '\n': {
                    appendTo.append("\\n");
                    continue block7;
                }
                case '\"': {
                    appendTo.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    appendTo.append("\\\\");
                    continue block7;
                }
                case '`': {
                    continue block7;
                }
                default: {
                    appendTo.append(c);
                }
            }
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.innerAlgorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.innerAlgorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(new AssumptionCollectionStatistics());
    }

    private class AssumptionCollectionStatistics
    implements Statistics {
        private AssumptionCollectionStatistics() {
        }

        @Override
        public String getName() {
            return "Assumption Collection algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            AssumptionWithLocation resultAssumption = null;
            if (AssumptionCollectorAlgorithm.this.exportLocationAssumptions) {
                resultAssumption = AssumptionCollectorAlgorithm.this.collectLocationAssumptions(pReached, AssumptionCollectorAlgorithm.this.exceptionAssumptions);
                this.put(out, "Number of locations with assumptions", resultAssumption.getNumberOfLocations());
            }
            if (AssumptionCollectorAlgorithm.this.exportAssumptions) {
                if (AssumptionCollectorAlgorithm.this.exportLocationAssumptions && AssumptionCollectorAlgorithm.this.assumptionsFile != null) {
                    try {
                        IO.writeFile((Path)AssumptionCollectorAlgorithm.this.assumptionsFile, (Charset)Charset.defaultCharset(), (Object)resultAssumption);
                    }
                    catch (IOException e) {
                        AssumptionCollectorAlgorithm.this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write assumptions to file");
                    }
                }
                if (AssumptionCollectorAlgorithm.this.assumptionAutomatonFile != null) {
                    if (!AssumptionCollectorAlgorithm.this.compressAutomaton) {
                        try (Writer w = IO.openOutputFile((Path)AssumptionCollectorAlgorithm.this.assumptionAutomatonFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                            AssumptionCollectorAlgorithm.this.produceAssumptionAutomaton(w, pReached);
                        }
                        catch (IOException e) {
                            AssumptionCollectorAlgorithm.this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write assumptions to file");
                        }
                    } else {
                        AssumptionCollectorAlgorithm.this.assumptionAutomatonFile = AssumptionCollectorAlgorithm.this.assumptionAutomatonFile.resolveSibling(AssumptionCollectorAlgorithm.this.assumptionAutomatonFile.getFileName() + ".gz");
                        try {
                            IO.writeGZIPFile((Path)AssumptionCollectorAlgorithm.this.assumptionAutomatonFile, (Charset)Charset.defaultCharset(), appendable -> AssumptionCollectorAlgorithm.this.produceAssumptionAutomaton(appendable, pReached));
                        }
                        catch (IOException e) {
                            AssumptionCollectorAlgorithm.this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write assumptions to file");
                        }
                    }
                    this.put(out, "Number of states in automaton", AssumptionCollectorAlgorithm.this.automatonStates);
                    if (AssumptionCollectorAlgorithm.this.dotExport) {
                        try {
                            AssumptionCollectorAlgorithm.this.writeAutomatonToDot(AssumptionCollectorAlgorithm.this.constructAutomatonFromFile());
                        }
                        catch (InvalidConfigurationException e) {
                            AssumptionCollectorAlgorithm.this.logger.logfUserException(Level.WARNING, (Throwable)e, "Could not write to DOT File", new Object[0]);
                        }
                    }
                }
            }
        }
    }
}

