/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.bdd.BDDCPA;
import org.sosy_lab.cpachecker.cpa.bdd.BDDState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.regions.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;

@Options(prefix="counterexample.export", deprecatedPrefix="counterexample")
public class BDDCPARestrictionAlgorithm
implements Algorithm,
StatisticsProvider {
    @Option(secure=true, name="presenceCondition", deprecatedName="presenceConditionFile", description="The files where the BDDCPARestrictionAlgorithm should write the presence conditions for the counterexamples to.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate presenceConditionFile = PathTemplate.ofFormatString((String)"Counterexample.%d.presenceCondition.txt");
    private final Algorithm algorithm;
    private final LogManager logger;
    private final NamedRegionManager manager;
    private Region errorSummary;

    public BDDCPARestrictionAlgorithm(Algorithm algorithm, ConfigurableProgramAnalysis pCpa, Configuration config, LogManager logger) throws InvalidConfigurationException {
        this.algorithm = algorithm;
        this.logger = logger;
        config.inject((Object)this);
        BDDCPA bddCpa = CPAs.retrieveCPAOrFail(pCpa, BDDCPA.class, BDDCPARestrictionAlgorithm.class);
        logger.log(Level.INFO, new Object[]{"using the BDDCPA Restriction Algorithm"});
        this.manager = bddCpa.getManager();
        this.errorSummary = this.manager.makeFalse();
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reached) throws CPAException, InterruptedException {
        Algorithm.AlgorithmStatus status = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        while (reached.hasWaitingState()) {
            CounterexampleInfo counterEx;
            status = status.update(this.algorithm.run(reached));
            assert (ARGUtils.checkARG(reached));
            AbstractState lastState = reached.getLastState();
            if (!(lastState instanceof Targetable) || !((Targetable)((Object)lastState)).isTarget()) break;
            BDDState bddErrorState = AbstractStates.extractStateByType(lastState, BDDState.class);
            Region errorBdd = bddErrorState.getRegion();
            this.logger.log(Level.INFO, new Object[]{"ErrorBDD:", this.manager.dumpRegion(errorBdd)});
            this.errorSummary = this.manager.makeOr(errorBdd, this.errorSummary);
            if (this.presenceConditionFile != null && lastState instanceof ARGState && (counterEx = (CounterexampleInfo)((ARGState)lastState).getCounterexampleInformation().orElse(null)) != null) {
                counterEx.addFurtherInformation(this.manager.dumpRegion(errorBdd), this.presenceConditionFile);
            }
            this.logger.log(Level.INFO, new Object[]{"ErrorSummary:", this.manager.dumpRegion(this.errorSummary)});
            Region negatedErrorBdd = this.manager.makeNot(errorBdd);
            for (AbstractState s : ImmutableList.copyOf(reached.getWaitlist())) {
                BDDState bddState = AbstractStates.extractStateByType(s, BDDState.class);
                if (bddState == null) continue;
                bddState.addConstraintToState(negatedErrorBdd);
                if (!bddState.getRegion().isFalse()) continue;
                reached.removeOnlyFromWaitlist(s);
            }
        }
        return status;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
    }
}

