/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.sosy_lab.common.AbstractMBean;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.ParallelAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.value.refiner.UnsoundRefiner;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

public class CEGARAlgorithm
implements Algorithm,
StatisticsProvider,
ParallelAlgorithm.ReachedSetUpdater,
AutoCloseable {
    private final CEGARStatistics stats = new CEGARStatistics();
    private final List<ParallelAlgorithm.ReachedSetUpdateListener> reachedSetUpdateListeners = new CopyOnWriteArrayList<ParallelAlgorithm.ReachedSetUpdateListener>();
    private volatile int sizeOfReachedSetBeforeRefinement = 0;
    private boolean globalRefinement = false;
    private int maxRefinementNum = -1;
    private final LogManager logger;
    private final Algorithm algorithm;
    private final Refiner mRefiner;

    private CEGARAlgorithm(Algorithm pAlgorithm, Refiner pRefiner, LogManager pLogger, boolean pGlobalRefinement, int pMaxRefinementNum) {
        this.algorithm = pAlgorithm;
        this.mRefiner = (Refiner)Preconditions.checkNotNull((Object)pRefiner);
        this.logger = pLogger;
        this.globalRefinement = pGlobalRefinement;
        this.maxRefinementNum = pMaxRefinementNum;
        new CEGARMBean().register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reached) throws CPAException, InterruptedException {
        Algorithm.AlgorithmStatus status = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        boolean refinedInPreviousIteration = false;
        this.stats.totalTimer.start();
        try {
            boolean refinementSuccessful;
            do {
                refinementSuccessful = false;
                AbstractState previousLastState = reached.getLastState();
                status = status.update(this.algorithm.run(reached));
                this.notifyReachedSetUpdateListeners(reached);
                if (this.stats.countRefinements == this.maxRefinementNum) {
                    this.logger.log(Level.WARNING, new Object[]{"Aborting analysis because maximum number of refinements " + this.maxRefinementNum + " used"});
                    status = status.withPrecise(false);
                    break;
                }
                if (this.refinementNecessary(reached, previousLastState)) {
                    refinementSuccessful = this.refine(reached);
                    refinedInPreviousIteration = true;
                    continue;
                }
                if (!(this.mRefiner instanceof UnsoundRefiner)) continue;
                if (!refinedInPreviousIteration) {
                    break;
                }
                ((UnsoundRefiner)this.mRefiner).forceRestart(reached);
                refinementSuccessful = true;
                refinedInPreviousIteration = false;
            } while (refinementSuccessful);
        }
        finally {
            this.stats.totalTimer.stop();
        }
        return status;
    }

    private boolean refinementNecessary(ReachedSet reached, AbstractState previousLastState) {
        if (this.globalRefinement) {
            return reached.wasTargetReached();
        }
        return !Objects.equals(reached.getLastState(), previousLastState) && AbstractStates.isTargetState(reached.getLastState());
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="only one thread writes countRefinements, others read")
    private boolean refine(ReachedSet reached) throws CPAException, InterruptedException {
        boolean refinementResult;
        this.logger.log(Level.FINE, new Object[]{"Error found, performing CEGAR"});
        ++this.stats.countRefinements;
        this.stats.totalReachedSizeBeforeRefinement += (long)reached.size();
        this.stats.maxReachedSizeBeforeRefinement = Math.max(this.stats.maxReachedSizeBeforeRefinement, reached.size());
        this.sizeOfReachedSetBeforeRefinement = reached.size();
        this.stats.refinementTimer.start();
        try {
            refinementResult = this.mRefiner.performRefinement(reached);
        }
        catch (RefinementFailedException e) {
            ++this.stats.countFailedRefinements;
            throw e;
        }
        finally {
            this.stats.refinementTimer.stop();
        }
        this.logger.log(Level.FINE, new Object[]{"Refinement successful:", refinementResult});
        if (refinementResult) {
            ++this.stats.countSuccessfulRefinements;
            this.stats.totalReachedSizeAfterRefinement += (long)reached.size();
            this.stats.maxReachedSizeAfterRefinement = Math.max(this.stats.maxReachedSizeAfterRefinement, reached.size());
        }
        return refinementResult;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
        if (this.mRefiner instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.mRefiner)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    @Override
    public void register(ParallelAlgorithm.ReachedSetUpdateListener pReachedSetUpdateListener) {
        if (this.algorithm instanceof ParallelAlgorithm.ReachedSetUpdater) {
            ((ParallelAlgorithm.ReachedSetUpdater)((Object)this.algorithm)).register(pReachedSetUpdateListener);
        }
        this.reachedSetUpdateListeners.add(pReachedSetUpdateListener);
    }

    @Override
    public void unregister(ParallelAlgorithm.ReachedSetUpdateListener pReachedSetUpdateListener) {
        if (this.algorithm instanceof ParallelAlgorithm.ReachedSetUpdater) {
            ((ParallelAlgorithm.ReachedSetUpdater)((Object)this.algorithm)).unregister(pReachedSetUpdateListener);
        }
        this.reachedSetUpdateListeners.remove(pReachedSetUpdateListener);
    }

    private void notifyReachedSetUpdateListeners(ReachedSet pReachedSet) {
        for (ParallelAlgorithm.ReachedSetUpdateListener rsul : this.reachedSetUpdateListeners) {
            rsul.updated(pReachedSet);
        }
    }

    @Override
    public void close() {
        CPAs.closeIfPossible(this.mRefiner, this.logger);
    }

    @Options(prefix="cegar")
    public static class CEGARAlgorithmFactory
    implements Algorithm.AlgorithmFactory {
        @Option(secure=true, name="refiner", required=true, description="Which refinement algorithm to use? (give class name, required for CEGAR) If the package name starts with 'org.sosy_lab.cpachecker.', this prefix can be omitted.")
        @ClassOption(packagePrefix={"org.sosy_lab.cpachecker"})
        private Refiner.Factory refinerFactory;
        @Option(secure=true, name="globalRefinement", description="Whether to do refinement immediately after finding an error state, or globally after the ARG has been unrolled completely.")
        private boolean globalRefinement = false;
        @Option(name="maxIterations", description="Max number of refinement iterations, -1 for no limit")
        private int maxRefinementNum = -1;
        private final Algorithm.AlgorithmFactory algorithmFactory;
        private final LogManager logger;
        private final Refiner refiner;

        public CEGARAlgorithmFactory(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCpa, LogManager pLogger, Configuration pConfig, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
            this(() -> pAlgorithm, pCpa, pLogger, pConfig, pShutdownNotifier);
        }

        public CEGARAlgorithmFactory(Algorithm.AlgorithmFactory pAlgorithmFactory, ConfigurableProgramAnalysis pCpa, LogManager pLogger, Configuration pConfig, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
            pConfig.inject((Object)this);
            this.algorithmFactory = pAlgorithmFactory;
            this.logger = pLogger;
            Verify.verifyNotNull((Object)this.refinerFactory);
            this.refiner = this.refinerFactory.create(pCpa, pLogger, pShutdownNotifier);
        }

        @Override
        public CEGARAlgorithm newInstance() {
            return new CEGARAlgorithm(this.algorithmFactory.newInstance(), this.refiner, this.logger, this.globalRefinement, this.maxRefinementNum);
        }
    }

    private class CEGARMBean
    extends AbstractMBean
    implements CEGARMXBean {
        public CEGARMBean() {
            super("org.sosy_lab.cpachecker:type=CEGAR", CEGARAlgorithm.this.logger);
        }

        @Override
        public int getNumberOfRefinements() {
            return CEGARAlgorithm.this.stats.countRefinements;
        }

        @Override
        public int getSizeOfReachedSetBeforeLastRefinement() {
            return CEGARAlgorithm.this.sizeOfReachedSetBeforeRefinement;
        }

        @Override
        public boolean isRefinementActive() {
            return CEGARAlgorithm.this.stats.refinementTimer.isRunning();
        }
    }

    public static interface CEGARMXBean {
        public int getNumberOfRefinements();

        public int getSizeOfReachedSetBeforeLastRefinement();

        public boolean isRefinementActive();
    }

    private static class CEGARStatistics
    implements Statistics {
        private final Timer totalTimer = new Timer();
        private final Timer refinementTimer = new Timer();
        @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="only one thread writes, others read")
        private volatile int countRefinements = 0;
        private int countSuccessfulRefinements = 0;
        private int countFailedRefinements = 0;
        private int maxReachedSizeBeforeRefinement = 0;
        private int maxReachedSizeAfterRefinement = 0;
        private long totalReachedSizeBeforeRefinement = 0L;
        private long totalReachedSizeAfterRefinement = 0L;

        private CEGARStatistics() {
        }

        @Override
        public String getName() {
            return "CEGAR algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            out.println("Number of CEGAR refinements:          " + this.countRefinements);
            if (this.countRefinements > 0) {
                out.println("Number of successful refinements:     " + this.countSuccessfulRefinements);
                out.println("Number of failed refinements:         " + this.countFailedRefinements);
                out.println("Max. size of reached set before ref.: " + this.maxReachedSizeBeforeRefinement);
                out.println("Max. size of reached set after ref.:  " + this.maxReachedSizeAfterRefinement);
                out.println("Avg. size of reached set before ref.: " + StatisticsUtils.div(this.totalReachedSizeBeforeRefinement, this.countRefinements));
                out.println("Avg. size of reached set after ref.:  " + StatisticsUtils.div(this.totalReachedSizeAfterRefinement, this.countSuccessfulRefinements));
                out.println("");
                out.println("Total time for CEGAR algorithm:   " + this.totalTimer);
                out.println("Time for refinements:             " + this.refinementTimer);
                out.println("Average time for refinement:      " + this.refinementTimer.getAvgTime().formatAs(TimeUnit.SECONDS));
                out.println("Max time for refinement:          " + this.refinementTimer.getMaxTime().formatAs(TimeUnit.SECONDS));
            }
        }
    }
}

