/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ForcedCovering;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGMergeJoinCPAEnabledAnalysis;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatValue;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatHist;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public class CPAAlgorithm
implements Algorithm,
StatisticsProvider {
    private final ForcedCovering forcedCovering;
    private final CPAStatistics stats = new CPAStatistics();
    private final TransferRelation transferRelation;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final PrecisionAdjustment precisionAdjustment;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Algorithm.AlgorithmStatus status;

    public static CPAAlgorithm create(ConfigurableProgramAnalysis cpa, LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        return new CPAAlgorithmFactory(cpa, logger, config, pShutdownNotifier).newInstance();
    }

    private CPAAlgorithm(ConfigurableProgramAnalysis cpa, LogManager logger, ShutdownNotifier pShutdownNotifier, ForcedCovering pForcedCovering, boolean pIsImprecise) {
        this.transferRelation = cpa.getTransferRelation();
        this.mergeOperator = cpa.getMergeOperator();
        this.stopOperator = cpa.getStopOperator();
        this.precisionAdjustment = cpa.getPrecisionAdjustment();
        this.logger = logger;
        this.shutdownNotifier = pShutdownNotifier;
        this.forcedCovering = pForcedCovering;
        this.status = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE.withPrecise(!pIsImprecise);
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reachedSet) throws CPAException, InterruptedException {
        this.stats.totalTimer.start();
        try {
            Algorithm.AlgorithmStatus algorithmStatus = this.run0(reachedSet);
            return algorithmStatus;
        }
        finally {
            this.stats.stopAllTimers();
            this.stats.updateReachedSetStatistics((Map<String, AbstractStatValue>)reachedSet.getStatistics());
        }
    }

    private Algorithm.AlgorithmStatus run0(ReachedSet reachedSet) throws CPAException, InterruptedException {
        while (reachedSet.hasWaitingState()) {
            this.shutdownNotifier.shutdownIfNecessary();
            ++this.stats.countIterations;
            int size = reachedSet.getWaitlist().size();
            if (size >= this.stats.maxWaitlistSize) {
                this.stats.maxWaitlistSize = size;
            }
            this.stats.countWaitlistSize += (long)size;
            this.stats.chooseTimer.start();
            AbstractState state = reachedSet.popFromWaitlist();
            Precision precision = reachedSet.getPrecision(state);
            this.stats.chooseTimer.stop();
            this.logger.log(Level.FINER, new Object[]{"Retrieved state from waitlist"});
            try {
                if (!this.handleState(state, precision, reachedSet)) continue;
                return this.status;
            }
            catch (InterruptedException | CPAException e) {
                reachedSet.reAddToWaitlist(state);
                throw e;
            }
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleState(AbstractState state, Precision precision, ReachedSet reachedSet) throws CPAException, InterruptedException {
        Collection<? extends AbstractState> successors;
        this.logger.log(Level.ALL, new Object[]{"Current state is", state, "with precision", precision});
        if (this.forcedCovering != null) {
            this.stats.forcedCoveringTimer.start();
            try {
                boolean stop = this.forcedCovering.tryForcedCovering(state, precision, reachedSet);
                if (stop) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.stats.forcedCoveringTimer.stop();
            }
        }
        this.stats.transferTimer.start();
        try {
            successors = this.transferRelation.getAbstractSuccessors(state, precision);
        }
        finally {
            this.stats.transferTimer.stop();
        }
        int numSuccessors = successors.size();
        this.logger.log(Level.FINER, new Object[]{"Current state has", numSuccessors, "successors"});
        this.stats.countSuccessors += numSuccessors;
        this.stats.maxSuccessors = Math.max(numSuccessors, this.stats.maxSuccessors);
        Iterator<? extends AbstractState> it = successors.iterator();
        while (it.hasNext()) {
            boolean stop;
            PrecisionAdjustmentResult precAdjustmentResult;
            AbstractState successor = it.next();
            this.shutdownNotifier.shutdownIfNecessary();
            this.logger.log(Level.FINER, new Object[]{"Considering successor of current state"});
            this.logger.log(Level.ALL, new Object[]{"Successor of", state, "\nis", successor});
            this.stats.precisionTimer.start();
            try {
                Optional<PrecisionAdjustmentResult> precAdjustmentOptional = this.precisionAdjustment.prec(successor, precision, reachedSet, (Function<AbstractState, AbstractState>)Functions.identity(), successor);
                if (!precAdjustmentOptional.isPresent()) continue;
                precAdjustmentResult = precAdjustmentOptional.orElseThrow();
            }
            finally {
                this.stats.precisionTimer.stop();
                continue;
            }
            successor = precAdjustmentResult.abstractState();
            Precision successorPrecision = precAdjustmentResult.precision();
            PrecisionAdjustmentResult.Action action = precAdjustmentResult.action();
            if (action == PrecisionAdjustmentResult.Action.BREAK) {
                boolean stop2;
                this.stats.stopTimer.start();
                try {
                    stop2 = this.stopOperator.stop(successor, reachedSet.getReached(successor), successorPrecision);
                }
                finally {
                    this.stats.stopTimer.stop();
                }
                if (AbstractStates.isTargetState(successor) && stop2) {
                    ++this.stats.countStop;
                    this.logger.log(Level.FINER, new Object[]{"Break was signalled but ignored because the state is covered."});
                    continue;
                }
                ++this.stats.countBreak;
                this.logger.log(Level.FINER, new Object[]{"Break signalled, CPAAlgorithm will stop."});
                reachedSet.add(successor, successorPrecision);
                if (it.hasNext()) {
                    reachedSet.reAddToWaitlist(state);
                }
                return true;
            }
            assert (action == PrecisionAdjustmentResult.Action.CONTINUE) : "Enum Action has unhandled values!";
            Collection<AbstractState> reached = reachedSet.getReached(successor);
            if (this.mergeOperator != MergeSepOperator.getInstance() && !reached.isEmpty()) {
                this.stats.mergeTimer.start();
                try {
                    ArrayList<AbstractState> toRemove = new ArrayList<AbstractState>();
                    ArrayList<Pair<AbstractState, Precision>> toAdd = new ArrayList<Pair<AbstractState, Precision>>();
                    try {
                        this.logger.log(Level.FINER, new Object[]{"Considering", reached.size(), "states from reached set for merge"});
                        for (AbstractState reachedState : reached) {
                            this.shutdownNotifier.shutdownIfNecessary();
                            AbstractState mergedState = this.mergeOperator.merge(successor, reachedState, successorPrecision);
                            if (mergedState.equals(reachedState)) continue;
                            this.logger.log(Level.FINER, new Object[]{"Successor was merged with state from reached set"});
                            this.logger.log(Level.ALL, new Object[]{"Merged", successor, "\nand", reachedState, "\n-->", mergedState});
                            ++this.stats.countMerge;
                            toRemove.add(reachedState);
                            toAdd.add(Pair.of(mergedState, successorPrecision));
                        }
                    }
                    finally {
                        reachedSet.removeAll(toRemove);
                        reachedSet.addAll(toAdd);
                    }
                    if (this.mergeOperator instanceof ARGMergeJoinCPAEnabledAnalysis) {
                        ((ARGMergeJoinCPAEnabledAnalysis)this.mergeOperator).cleanUp(reachedSet);
                    }
                }
                finally {
                    this.stats.mergeTimer.stop();
                }
            }
            this.stats.stopTimer.start();
            try {
                stop = this.stopOperator.stop(successor, reached, successorPrecision);
            }
            finally {
                this.stats.stopTimer.stop();
            }
            if (stop) {
                this.logger.log(Level.FINER, new Object[]{"Successor is covered or unreachable, not adding to waitlist"});
                ++this.stats.countStop;
                continue;
            }
            this.logger.log(Level.FINER, new Object[]{"No need to stop, adding successor to waitlist"});
            this.stats.addTimer.start();
            reachedSet.add(successor, successorPrecision);
            this.stats.addTimer.stop();
        }
        return false;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.forcedCovering instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.forcedCovering)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    @Options(prefix="cpa")
    public static class CPAAlgorithmFactory
    implements Algorithm.AlgorithmFactory {
        @Option(secure=true, description="Which strategy to use for forced coverings (empty for none)", name="forcedCovering")
        @ClassOption(packagePrefix={"org.sosy_lab.cpachecker"})
        private @Nullable ForcedCovering.Factory forcedCoveringClass = null;
        @Option(secure=true, description="Do not report 'False' result, return UNKNOWN instead.  Useful for incomplete analysis with no counterexample checking.")
        private boolean reportFalseAsUnknown = false;
        private final ForcedCovering forcedCovering;
        private final ConfigurableProgramAnalysis cpa;
        private final LogManager logger;
        private final ShutdownNotifier shutdownNotifier;

        public CPAAlgorithmFactory(ConfigurableProgramAnalysis cpa, LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
            config.inject((Object)this);
            this.cpa = cpa;
            this.logger = logger;
            this.shutdownNotifier = pShutdownNotifier;
            this.forcedCovering = this.forcedCoveringClass != null ? this.forcedCoveringClass.create(config, logger, cpa) : null;
        }

        @Override
        public CPAAlgorithm newInstance() {
            return new CPAAlgorithm(this.cpa, this.logger, this.shutdownNotifier, this.forcedCovering, this.reportFalseAsUnknown);
        }
    }

    private static class CPAStatistics
    implements Statistics {
        private Timer totalTimer = new Timer();
        private Timer chooseTimer = new Timer();
        private Timer precisionTimer = new Timer();
        private Timer transferTimer = new Timer();
        private Timer mergeTimer = new Timer();
        private Timer stopTimer = new Timer();
        private Timer addTimer = new Timer();
        private Timer forcedCoveringTimer = new Timer();
        private int countIterations = 0;
        private int maxWaitlistSize = 0;
        private long countWaitlistSize = 0L;
        private int countSuccessors = 0;
        private int maxSuccessors = 0;
        private int countMerge = 0;
        private int countStop = 0;
        private int countBreak = 0;
        private Map<String, AbstractStatValue> reachedSetStatistics = new HashMap<String, AbstractStatValue>();

        private CPAStatistics() {
        }

        private void stopAllTimers() {
            this.totalTimer.stopIfRunning();
            this.chooseTimer.stopIfRunning();
            this.precisionTimer.stopIfRunning();
            this.transferTimer.stopIfRunning();
            this.mergeTimer.stopIfRunning();
            this.stopTimer.stopIfRunning();
            this.addTimer.stopIfRunning();
            this.forcedCoveringTimer.stopIfRunning();
        }

        private void updateReachedSetStatistics(Map<String, AbstractStatValue> newStatistics) {
            for (Map.Entry<String, AbstractStatValue> e : newStatistics.entrySet()) {
                String key = e.getKey();
                AbstractStatValue val = e.getValue();
                if (!this.reachedSetStatistics.containsKey(key)) {
                    this.reachedSetStatistics.put(key, val);
                    continue;
                }
                AbstractStatValue newVal = this.reachedSetStatistics.get(key);
                if (val == newVal) continue;
                if (newVal instanceof StatCounter) {
                    assert (val instanceof StatCounter);
                    ((StatCounter)newVal).mergeWith((StatCounter)val);
                    continue;
                }
                if (newVal instanceof StatInt) {
                    assert (val instanceof StatInt);
                    ((StatInt)newVal).add((StatInt)val);
                    continue;
                }
                if (newVal instanceof StatHist) {
                    assert (val instanceof StatHist);
                    ((StatHist)newVal).mergeWith((StatHist)val);
                    continue;
                }
                throw new AssertionError((Object)("Can't handle " + val.getClass().getSimpleName()));
            }
        }

        @Override
        public String getName() {
            return "CPA algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            out.println("Number of iterations:            " + this.countIterations);
            if (this.countIterations == 0) {
                return;
            }
            out.println("Max size of waitlist:            " + this.maxWaitlistSize);
            out.println("Average size of waitlist:        " + this.countWaitlistSize / (long)this.countIterations);
            StatisticsWriter w = StatisticsWriter.writingStatisticsTo(out);
            for (AbstractStatValue c : this.reachedSetStatistics.values()) {
                w.put(c);
            }
            out.println("Number of computed successors:   " + this.countSuccessors);
            out.println("Max successors for one state:    " + this.maxSuccessors);
            out.println("Number of times merged:          " + this.countMerge);
            out.println("Number of times stopped:         " + this.countStop);
            out.println("Number of times breaked:         " + this.countBreak);
            out.println();
            out.println("Total time for CPA algorithm:     " + this.totalTimer + " (Max: " + this.totalTimer.getMaxTime().formatAs(TimeUnit.SECONDS) + ")");
            out.println("  Time for choose from waitlist:  " + this.chooseTimer);
            if (this.forcedCoveringTimer.getNumberOfIntervals() > 0) {
                out.println("  Time for forced covering:       " + this.forcedCoveringTimer);
            }
            out.println("  Time for precision adjustment:  " + this.precisionTimer);
            out.println("  Time for transfer relation:     " + this.transferTimer);
            if (this.mergeTimer.getNumberOfIntervals() > 0) {
                out.println("  Time for merge operator:        " + this.mergeTimer);
            }
            out.println("  Time for stop operator:         " + this.stopTimer);
            out.println("  Time for adding to reached set: " + this.addTimer);
        }
    }
}

