/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;

public final class CounterexampleStoreAlgorithm
implements Algorithm,
StatisticsProvider {
    private final Algorithm algorithm;
    private final ARGCPA argCpa;
    private final AssumptionToEdgeAllocator allocator;

    public CounterexampleStoreAlgorithm(Algorithm pCpaAlgorithm, ConfigurableProgramAnalysis pCpa, Configuration pConfig, LogManager pLogger, MachineModel pMachineModel) throws InvalidConfigurationException {
        this.algorithm = pCpaAlgorithm;
        this.argCpa = CPAs.retrieveCPAOrFail(pCpa, ARGCPA.class, CounterexampleStoreAlgorithm.class);
        this.allocator = AssumptionToEdgeAllocator.create(pConfig, pLogger, pMachineModel);
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        Algorithm.AlgorithmStatus status = this.algorithm.run(pReachedSet);
        if (pReachedSet.wasTargetReached()) {
            Map<ARGState, CounterexampleInfo> cexs = this.getAllCounterexamples(pReachedSet);
            for (Map.Entry<ARGState, CounterexampleInfo> e : cexs.entrySet()) {
                ARGState targetState = e.getKey();
                if (targetState.getCounterexampleInformation().isPresent()) continue;
                targetState.addCounterexampleInformation(e.getValue());
            }
        }
        return status;
    }

    private Map<ARGState, CounterexampleInfo> getAllCounterexamples(UnmodifiableReachedSet pReached) {
        ImmutableMap.Builder counterexamples = ImmutableMap.builder();
        for (AbstractState targetState : FluentIterable.from((Iterable)pReached).filter(AbstractStates::isTargetState)) {
            ARGState s = (ARGState)targetState;
            CounterexampleInfo cex2 = ARGUtils.tryGetOrCreateCounterexampleInformation(s, this.argCpa, this.allocator).orElse(null);
            if (cex2 == null) continue;
            counterexamples.put((Object)s, (Object)cex2);
        }
        ImmutableMap allCounterexamples = counterexamples.buildOrThrow();
        Map preciseCounterexamples = Maps.filterValues((Map)allCounterexamples, cex -> cex.isPreciseCounterExample());
        return preciseCounterexamples.isEmpty() ? allCounterexamples : preciseCounterexamples;
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(statsCollection);
        }
    }
}

