/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.ci.CustomInstructionApplications;
import org.sosy_lab.cpachecker.util.ci.CustomInstructionRequirementsExtractor;

@Options(prefix="custominstructions")
public class CustomInstructionRequirementsExtractingAlgorithm
implements Algorithm,
StatisticsProvider {
    private final Algorithm analysis;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final ConfigurableProgramAnalysis cpa;
    private final CustomInstructionApplications.CustomInstructionApplicationBuilder ciasBuilder;
    private final CustomInstructionRequirementsExtractor ciExtractor;
    @Option(secure=true, description="Specifies the mode how custom instruction applications in program are identified.")
    private CustomInstructionApplications.CustomInstructionApplicationBuilder.CIDescriptionType mode = CustomInstructionApplications.CustomInstructionApplicationBuilder.CIDescriptionType.OPERATOR;

    public CustomInstructionRequirementsExtractingAlgorithm(Algorithm analysisAlgorithm, ConfigurableProgramAnalysis cpa, Configuration config, LogManager logger, ShutdownNotifier sdNotifier, CFA cfa) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.analysis = analysisAlgorithm;
        this.logger = logger;
        this.shutdownNotifier = sdNotifier;
        this.cpa = cpa;
        if (!(cpa instanceof ARGCPA)) {
            throw new InvalidConfigurationException("The given cpa " + cpa + "is not an instance of ARGCPA");
        }
        this.ciasBuilder = CustomInstructionApplications.CustomInstructionApplicationBuilder.getBuilder(this.mode, config, logger, sdNotifier, cfa);
        this.ciExtractor = new CustomInstructionRequirementsExtractor(config, logger, sdNotifier, cpa);
        Class<? extends AbstractState> requirementsStateClass = this.ciExtractor.getRequirementsStateClass();
        try {
            if (AbstractStates.extractStateByType(cpa.getInitialState(cfa.getMainFunction(), StateSpacePartition.getDefaultPartition()), requirementsStateClass) == null) {
                throw new InvalidConfigurationException(requirementsStateClass + "is not an abstract state.");
            }
        }
        catch (InterruptedException e) {
            throw new InvalidConfigurationException(requirementsStateClass + "initial state computation did not finish in time");
        }
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        this.logger.log(Level.INFO, new Object[]{"Get custom instruction applications in program."});
        CustomInstructionApplications cia = null;
        try {
            cia = this.ciasBuilder.identifyCIApplications();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, new Object[]{"Detecting the custom instruction applications in program failed.", e});
            return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
        }
        if (cia.getNumApplications() < 1) {
            this.logger.log(Level.WARNING, new Object[]{"No applications of custon instruction in program."});
        }
        if (this.ciExtractor.getRequirementsStateClass().equals(PredicateAbstractState.class)) {
            PredicateCPA predCPA = CPAs.retrieveCPA(this.cpa, PredicateCPA.class);
            if (predCPA == null) {
                this.logger.log(Level.SEVERE, new Object[]{"Cannot find PredicateCPA in CPA configuration but it is required to set abstraction nodes"});
                return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
            }
            predCPA.changeExplicitAbstractionNodes(cia.getStartAndEndLocationsOfCIApplications());
        }
        this.shutdownNotifier.shutdownIfNecessary();
        this.logger.log(Level.INFO, new Object[]{"Start analysing to compute requirements."});
        Algorithm.AlgorithmStatus status = this.analysis.run(pReachedSet);
        if (!status.isSound() || pReachedSet.hasWaitingState() || status.wasPropertyChecked() && !pReachedSet.getTargetInformation().isEmpty()) {
            this.logger.log(Level.SEVERE, new Object[]{"Do not extract requirements since analysis failed."});
            return status;
        }
        this.shutdownNotifier.shutdownIfNecessary();
        this.logger.log(Level.INFO, new Object[]{"Start extracting requirements for applied custom instructions"});
        this.ciExtractor.extractRequirements((ARGState)pReachedSet.getFirstState(), cia);
        return status;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.analysis instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.analysis)).collectStatistics(pStatsCollection);
        }
    }
}

