/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.ParallelAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.InfeasibleCounterexampleException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;

public class ExceptionHandlingAlgorithm
implements Algorithm,
StatisticsProvider,
ParallelAlgorithm.ReachedSetUpdater {
    private final Algorithm algorithm;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final ExceptionHandlingOptions options;

    private ExceptionHandlingAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCpa, ExceptionHandlingOptions pOptions, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        this.options = pOptions;
        this.algorithm = pAlgorithm;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        if (!(pCpa instanceof ARGCPA) && !(pCpa instanceof BAMCPA)) {
            throw new InvalidConfigurationException("ARG CPA needed for counterexample check");
        }
    }

    public static Algorithm create(Configuration pConfig, Algorithm pAlgorithm, ConfigurableProgramAnalysis pCpa, LogManager pLogger, ShutdownNotifier pShutdownNotifier, boolean pCheckCounterexamples, boolean pUseCEGAR) throws InvalidConfigurationException {
        ExceptionHandlingOptions options = new ExceptionHandlingOptions(pConfig);
        if (options.continueAfterInfeasibleError && pCheckCounterexamples || options.continueAfterFailedRefinement && pUseCEGAR || options.continueAfterUnsupportedCode) {
            return new ExceptionHandlingAlgorithm(pAlgorithm, pCpa, options, pLogger, pShutdownNotifier);
        }
        return pAlgorithm;
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reached) throws CPAException, InterruptedException {
        Algorithm.AlgorithmStatus status = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        while (reached.hasWaitingState() && !this.shutdownNotifier.shouldShutdown()) {
            try {
                status = status.update(this.algorithm.run(reached));
                break;
            }
            catch (InfeasibleCounterexampleException e) {
                if (!this.options.continueAfterInfeasibleError) {
                    throw e;
                }
                for (ARGPath errorPath : e.getErrorPaths()) {
                    status = this.handleExceptionWithErrorPath(reached, status, errorPath.getLastState(), true);
                }
            }
            catch (RefinementFailedException e) {
                if (!this.options.continueAfterFailedRefinement) {
                    throw e;
                }
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Removing path that could not be refined from reached set and continue analysis with rest of the waitlist");
                ARGState lastState = e.getErrorPath() != null ? e.getErrorPath().getLastState() : (ARGState)reached.getLastState();
                status = this.handleExceptionWithErrorPath(reached, status, lastState, true);
            }
            catch (UnsupportedCodeException e) {
                if (!this.options.continueAfterUnsupportedCode || e.getParentState() == null) {
                    throw e;
                }
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Removing path that cannot be analyzed from reached set, and continue analysis with other states");
                status = this.handleExceptionWithErrorPath(reached, status, e.getParentState(), false);
            }
        }
        return status;
    }

    private Algorithm.AlgorithmStatus handleExceptionWithErrorPath(ReachedSet reached, Algorithm.AlgorithmStatus status, ARGState lastState, boolean isErrorState) {
        assert (lastState != null);
        boolean sound = status.isSound();
        if (this.options.removeInfeasibleErrors) {
            sound &= this.handleInfeasibleCounterexample(reached, (Set<ARGState>)ARGUtils.getAllStatesOnPathsTo(lastState));
        } else if (sound) {
            this.logger.log(Level.WARNING, new Object[]{"Infeasible counterexample found, but could not remove it from the ARG. Therefore, we cannot prove safety."});
            sound = false;
        } else {
            this.logger.log(Level.INFO, new Object[]{"Another infeasible counterexample found which could not be removed from the ARG."});
        }
        if (this.options.removeInfeasibleErrorState) {
            sound &= this.removeLastState(reached, lastState, isErrorState);
        }
        assert (ARGUtils.checkARG(reached));
        status = status.withSound(sound);
        return status;
    }

    private boolean handleInfeasibleCounterexample(ReachedSet reached, Set<ARGState> statesOnErrorPath) {
        boolean sound = true;
        ArrayList<ARGState> coveredByErrorPath = new ArrayList<ARGState>();
        for (ARGState errorPathState : statesOnErrorPath) {
            coveredByErrorPath.addAll(errorPathState.getCoveredByThis());
            errorPathState.setNotCovering();
        }
        for (ARGState coveredState : coveredByErrorPath) {
            if (this.isTransitiveChildOf(coveredState, coveredState.getCoveringState())) {
                this.logger.log(Level.WARNING, new Object[]{"Infeasible counterexample found, but could not remove it from the ARG due to loops in the counterexample path. Therefore, we cannot prove safety."});
                sound = false;
                continue;
            }
            for (ARGState parentOfCovered : coveredState.getParents()) {
                if (statesOnErrorPath.contains(parentOfCovered)) {
                    this.logger.log(Level.WARNING, new Object[]{"Infeasible counterexample found, but could not remove it from the ARG. Therefore, we cannot prove safety."});
                    sound = false;
                    continue;
                }
                reached.reAddToWaitlist(parentOfCovered);
            }
            assert (!reached.contains(coveredState)) : "covered state in reached set";
            coveredState.removeFromARG();
        }
        return sound;
    }

    private boolean isTransitiveChildOf(ARGState potentialChild, ARGState potentialParent) {
        HashSet<ARGState> seen = new HashSet<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>(potentialChild.getParents());
        while (!waitlist.isEmpty()) {
            ARGState current = (ARGState)waitlist.pollFirst();
            for (ARGState currentParent : current.getParents()) {
                if (currentParent.equals(potentialParent)) {
                    return true;
                }
                if (seen.add(currentParent)) continue;
                waitlist.addLast(currentParent);
            }
        }
        return false;
    }

    private boolean removeLastState(ReachedSet reached, ARGState lastState, boolean isErrorState) {
        ARGState parent;
        boolean sound = true;
        assert (lastState.getChildren().isEmpty());
        assert (lastState.getCoveredByThis().isEmpty());
        Collection<ARGState> parents = lastState.getParents();
        assert (parents.size() == 1) : "error state that was merged";
        ARGState aRGState = parent = isErrorState ? (ARGState)Iterables.getOnlyElement(parents) : lastState;
        if (parent.getChildren().size() > 1 || parent.getCoveredByThis().isEmpty() || !isErrorState) {
            sound = false;
        }
        ImmutableList siblings = ImmutableList.copyOf(parent.getChildren());
        for (ARGState toRemove : siblings) {
            assert (toRemove.getChildren().isEmpty());
            assert (siblings.containsAll(toRemove.getCoveredByThis()));
            reached.remove(toRemove);
            toRemove.removeFromARG();
        }
        ImmutableList coveredByParent = ImmutableList.copyOf(parent.getCoveredByThis());
        for (ARGState covered : coveredByParent) {
            assert (covered.getChildren().isEmpty());
            assert (covered.getCoveredByThis().isEmpty());
            covered.removeFromARG();
        }
        reached.remove(parent);
        parent.removeFromARG();
        assert (lastState.isDestroyed()) : "errorState is not the child of its parent";
        assert (!reached.contains(lastState)) : "reached.remove() didn't work";
        return sound;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
    }

    @Override
    public void register(ParallelAlgorithm.ReachedSetUpdateListener pReachedSetUpdateListener) {
        if (this.algorithm instanceof ParallelAlgorithm.ReachedSetUpdater) {
            ((ParallelAlgorithm.ReachedSetUpdater)((Object)this.algorithm)).register(pReachedSetUpdateListener);
        }
    }

    @Override
    public void unregister(ParallelAlgorithm.ReachedSetUpdateListener pReachedSetUpdateListener) {
        if (this.algorithm instanceof ParallelAlgorithm.ReachedSetUpdater) {
            ((ParallelAlgorithm.ReachedSetUpdater)((Object)this.algorithm)).unregister(pReachedSetUpdateListener);
        }
    }

    @Options
    private static class ExceptionHandlingOptions {
        @Option(name="counterexample.removeInfeasibleErrors", description="If continueAfterInfeasibleError is true, attempt to remove the whole path of the infeasible counterexample before continuing. Setting this to false may prevent a lot of similar infeasible counterexamples to get discovered, but is unsound", secure=true)
        private boolean removeInfeasibleErrors = false;
        @Option(name="counterexample.removeInfeasibleErrorState", description="If continueAfterInfeasibleError is true, remove the error state that is proven to be unreachable before continuing. Set this to false if analyis.collectAssumptions=true is also set.", secure=true)
        private boolean removeInfeasibleErrorState = true;
        @Option(secure=true, name="counterexample.continueAfterInfeasibleError", description="continue analysis after an counterexample was found that was denied by the second check")
        private boolean continueAfterInfeasibleError = true;
        @Option(secure=true, name="cegar.continueAfterFailedRefinement", description="continue analysis after a failed refinement (e.g. due to interpolation) other paths may still contain errors that could be found")
        private boolean continueAfterFailedRefinement = false;
        @Option(secure=true, name="analysis.continueAfterUnsupportedCode", description="continue analysis after a unsupported code was found on one path")
        private boolean continueAfterUnsupportedCode = false;

        private ExceptionHandlingOptions(Configuration pConfig) throws InvalidConfigurationException {
            pConfig.inject((Object)this);
        }
    }
}

