/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.sosy_lab.common.Optionals;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_coverage.DStar;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_coverage.Ochiai;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_coverage.SuspiciousnessMeasure;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_coverage.Tarantula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_coverage.utils.CoverageInformationBuilder;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_coverage.utils.FailedCase;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_coverage.utils.SafeCase;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultLocalizationInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="faultLocalization.by_coverage")
public class FaultLocalizationWithCoverage
implements Algorithm,
StatisticsProvider,
Statistics {
    @Option(secure=true, name="type", description="Ranking algorithm to use for fault localization")
    private AlgorithmType rankingMeasure = AlgorithmType.TARANTULA;
    private final StatTimer totalTime = new StatTimer("Total time of fault localization");
    private final Algorithm algorithm;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;

    public FaultLocalizationWithCoverage(Algorithm pAlgorithm, ShutdownNotifier pShutdownNotifier, LogManager pLogger, Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.algorithm = pAlgorithm;
        this.shutdownNotifier = pShutdownNotifier;
        this.logger = pLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reachedSet) throws CPAException, InterruptedException {
        Algorithm.AlgorithmStatus status = this.algorithm.run(reachedSet);
        this.totalTime.start();
        try {
            ImmutableList counterExamples = this.getCounterexampleInfos(reachedSet).toList();
            if (counterExamples.isEmpty()) {
                this.logger.log(Level.INFO, new Object[]{"No counterexamples found in computed reached set - stopping fault localization early. If CPAchecker found a property violation, consider analysis.alwaysStoreCounterexamples=true"});
                Algorithm.AlgorithmStatus algorithmStatus = status;
                return algorithmStatus;
            }
            SafeCase safeCase = new SafeCase(reachedSet);
            FailedCase failedCase = new FailedCase(reachedSet);
            ImmutableSet<ARGPath> safePaths = safeCase.getSafePaths();
            Set<ARGPath> errorPaths = failedCase.getErrorPaths();
            CoverageInformationBuilder coverageInformation = new CoverageInformationBuilder(this.shutdownNotifier, (Set<ARGPath>)safePaths, errorPaths);
            SuspiciousnessMeasure suspiciousnessMeasure = this.createSuspiciousnessMeasure(this.rankingMeasure);
            List<Fault> faults = this.getFaultsSortedByRank(suspiciousnessMeasure.getAllFaults((Set<ARGPath>)safePaths, errorPaths, coverageInformation));
            for (CounterexampleInfo counterexample : counterExamples) {
                List<Fault> faultsForCex = this.getFaultsForCex(faults, counterexample);
                FaultLocalizationInfo info = new FaultLocalizationInfo(faultsForCex, counterexample);
                info.getHtmlWriter().hideTypes(FaultInfo.InfoType.RANK_INFO);
                info.apply();
            }
        }
        finally {
            this.totalTime.stop();
        }
        return status;
    }

    private FluentIterable<CounterexampleInfo> getCounterexampleInfos(ReachedSet reachedSet) {
        return Optionals.presentInstances((Iterable)FluentIterable.from((Iterable)reachedSet).filter(AbstractStates::isTargetState).filter(ARGState.class).transform(ARGState::getCounterexampleInformation));
    }

    public List<Fault> getFaultsSortedByRank(List<Fault> pFaults) {
        return this.sortingByScoreReversed(pFaults);
    }

    public List<Fault> getFaultsForCex(List<Fault> pFaults, CounterexampleInfo counterexample) {
        ImmutableSet fullPath = ImmutableSet.copyOf(counterexample.getTargetPath().getFullPath());
        return pFaults.stream().filter(f -> f.stream().anyMatch(e -> fullPath.contains((Object)e.correspondingEdge()))).collect(Collectors.toCollection(ArrayList::new));
    }

    private List<Fault> sortingByScoreReversed(List<Fault> faults) {
        return (List)faults.stream().filter(f -> f.getScore() != 0.0).sorted(Comparator.comparing(f -> f.getScore()).reversed()).collect(ImmutableList.toImmutableList());
    }

    private SuspiciousnessMeasure createSuspiciousnessMeasure(AlgorithmType pAlgorithmType) {
        this.logger.log(Level.INFO, new Object[]{"Ranking-algorithm type: " + pAlgorithmType + " starts"});
        switch (pAlgorithmType) {
            case TARANTULA: {
                return new Tarantula();
            }
            case DSTAR: {
                return new DStar();
            }
            case OCHIAI: {
                return new Ochiai();
            }
        }
        throw new AssertionError((Object)("Unexpected ranking-algorithm type: " + pAlgorithmType));
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this);
        if (this.algorithm instanceof Statistics) {
            statsCollection.add((Statistics)((Object)this.algorithm));
        }
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        StatisticsWriter w0 = StatisticsWriter.writingStatisticsTo(out);
        w0.put(this.totalTime);
    }

    @Override
    public String getName() {
        return this.getClass().getCanonicalName() + "(" + this.rankingMeasure + ")";
    }

    private static enum AlgorithmType {
        TARANTULA,
        DSTAR,
        OCHIAI;

    }
}

