/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.VerifyException;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Optionals;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CounterexampleStoreAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.FaultLocalizationInfoWithTraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.FaultLocalizerWithTraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.error_invariants.ErrorInvariantsAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.error_invariants.IntervalReportWriter;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.rankings.CallHierarchyScoring;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.rankings.EdgeTypeScoring;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.FormulaContext;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.TraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.postcondition.FinalAssumeClusterPostConditionComposer;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.postcondition.FinalAssumeEdgePostConditionComposer;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.postcondition.FinalAssumeEdgesOnSameLinePostConditionComposer;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.postcondition.PostConditionComposer;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.precondition.PreConditionComposer;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.precondition.TruePreConditionComposer;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.precondition.VariableAssignmentPreConditionComposer;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.trace.Trace;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.unsat.ModifiedMaxSatAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.unsat.OriginalMaxSatAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.unsat.SingleUnsatCoreAlgorithm;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultRankingUtils;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultScoring;
import org.sosy_lab.cpachecker.util.faultlocalization.InformationProvider;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.ranking.MinimalLineDistanceScoring;
import org.sosy_lab.cpachecker.util.faultlocalization.ranking.OverallOccurrenceScoring;
import org.sosy_lab.cpachecker.util.faultlocalization.ranking.SetSizeScoring;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="faultLocalization.by_traceformula")
public class FaultLocalizationWithTraceFormula
implements Algorithm,
StatisticsProvider,
Statistics {
    private final Algorithm algorithm;
    private final LogManager logger;
    private final FormulaContext context;
    private final TraceFormula.TraceFormulaOptions options;
    private final FaultLocalizerWithTraceFormula faultAlgorithm;
    private final StatTimer totalTime = new StatTimer("Total time for fault localization");
    @Option(secure=true, name="type", description="which algorithm to use")
    private AlgorithmType algorithmType = AlgorithmType.UNSAT;
    @Option(secure=true, name="maxsat.ban", description="Do not show faults that contain a certain variable. Use, e.g., 'main::x' to ban variable 'x' in the main function. Use, e.g., '::x' to ban all variables named 'x'. This is especially useful to filter specific faults if the first run results in many candidates. Provide a comma separated string to add variables, e.g., main::x,doStuff::y,::z")
    private List<String> ban = ImmutableList.of();
    @Option(description="By default, the precondition only contains the failing variable assignment of all nondet variables. Choose INITIAL_ASSIGNMENT to assignments like '<datatype> <variable-name> = <value>' to the precondition.")
    private PreConditionType preconditionType = PreConditionType.NONDETERMINISTIC_VARIABLES_ONLY;
    @Option(description="which post-condition type to use")
    private PostConditionType postConditionType = PostConditionType.LAST_ASSUME_EDGES_ON_SAME_LINE;

    public FaultLocalizationWithTraceFormula(Algorithm pStoreAlgorithm, Configuration pConfig, LogManager pLogger, CFA pCfa, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        if (!(pStoreAlgorithm instanceof CounterexampleStoreAlgorithm)) {
            throw new InvalidConfigurationException("option CounterexampleStoreAlgorithm required");
        }
        this.logger = pLogger;
        pConfig.inject((Object)this);
        this.options = new TraceFormula.TraceFormulaOptions(pConfig);
        this.checkOptions();
        this.algorithm = pStoreAlgorithm;
        Solver solver = Solver.create(pConfig, pLogger, pShutdownNotifier);
        PathFormulaManagerImpl manager = new PathFormulaManagerImpl(solver.getFormulaManager(), pConfig, pLogger, pShutdownNotifier, pCfa, AnalysisDirection.FORWARD);
        this.context = new FormulaContext(solver, manager, pCfa, this.logger, pConfig, pShutdownNotifier);
        switch (this.algorithmType) {
            case MAXORG: {
                this.faultAlgorithm = new OriginalMaxSatAlgorithm();
                break;
            }
            case MAXSAT: {
                this.faultAlgorithm = new ModifiedMaxSatAlgorithm();
                break;
            }
            case ERRINV: {
                this.faultAlgorithm = new ErrorInvariantsAlgorithm(pShutdownNotifier, pConfig, this.logger);
                break;
            }
            case UNSAT: {
                this.faultAlgorithm = new SingleUnsatCoreAlgorithm();
                break;
            }
            default: {
                throw new AssertionError((Object)"The specified algorithm type does not exist");
            }
        }
    }

    public void checkOptions() throws InvalidConfigurationException {
        if (!this.algorithmType.equals((Object)AlgorithmType.ERRINV) && this.options.makeFlowSensitive()) {
            throw new InvalidConfigurationException("The option 'makeFlowSensitive' (flow-sensitive trace formula) requires the error invariants algorithm");
        }
        if (this.algorithmType.equals((Object)AlgorithmType.ERRINV) && !this.ban.isEmpty()) {
            throw new InvalidConfigurationException("The option 'ban' cannot be used together with the error invariants algorithm. Use MAX-SAT instead.");
        }
        if (!this.algorithmType.equals((Object)AlgorithmType.MAXSAT) && this.options.isReduceSelectors()) {
            throw new InvalidConfigurationException("The option 'reduceselectors' requires the MAX-SAT algorithm");
        }
        if (!this.options.getDisable().isEmpty() && this.algorithmType.equals((Object)AlgorithmType.ERRINV)) {
            throw new InvalidConfigurationException("The option 'ban' is not applicable for the error invariants algorithm");
        }
        if (!this.options.getDisable().isEmpty() && this.options.getDisable().stream().anyMatch(variable -> !Pattern.matches(".+::.+", variable))) {
            throw new InvalidConfigurationException("The option 'traceformula.disable' needs scoped variables. Make sure to input the variables with their scope as prefix, e.g. main::x i.e., function::variable.");
        }
        if (!this.options.getExcludeFromPrecondition().isEmpty() && this.options.getExcludeFromPrecondition().stream().anyMatch(variable -> !Pattern.matches(".+::.+", variable))) {
            throw new InvalidConfigurationException("The option 'traceformula.ignore' needs scoped variables. Make sure to input the variables with their scope as prefix, e.g. main::x, i.e., function::variable.");
        }
        if (!this.ban.isEmpty() && this.ban.stream().anyMatch(variable -> !Pattern.matches(".+::.+", variable))) {
            throw new InvalidConfigurationException("The option 'faultlocalization.by_traceformula.ban' needs scoped variables. Make sure to input the variables with their scope as prefix, e.g. main::x, i.e., function::variable.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reachedSet) throws CPAException, InterruptedException {
        Algorithm.AlgorithmStatus status = this.algorithm.run(reachedSet);
        this.totalTime.start();
        try {
            FluentIterable counterExamples = Optionals.presentInstances((Iterable)FluentIterable.from((Iterable)reachedSet).filter(AbstractStates::isTargetState).filter(ARGState.class).transform(ARGState::getCounterexampleInformation));
            this.logger.log(Level.INFO, new Object[]{"Starting fault localization..."});
            for (CounterexampleInfo info : counterExamples) {
                this.logger.log(Level.INFO, new Object[]{"Find explanations for fault #" + info.getUniqueId()});
                if (!info.isPreciseCounterExample() || info.isSpurious()) {
                    this.logger.logf(Level.INFO, "Algorithm found a spurious or imprecise counterexample. Cannot continue fault localization on counterexample %s...", new Object[]{info.getUniqueId()});
                    continue;
                }
                this.runAlgorithm(info, this.faultAlgorithm);
            }
            this.logger.log(Level.INFO, new Object[]{"Stopping fault localization..."});
        }
        finally {
            this.totalTime.stop();
        }
        return status;
    }

    private FaultScoring getScoring(TraceFormula pTraceFormula) {
        switch (this.algorithmType) {
            case MAXORG: 
            case MAXSAT: {
                return FaultRankingUtils.concatHeuristics(new EdgeTypeScoring(), new SetSizeScoring(), new OverallOccurrenceScoring(), new MinimalLineDistanceScoring((CFAEdge)pTraceFormula.getPostCondition().getEdgesForPostCondition().get(0)), new CallHierarchyScoring(pTraceFormula.getTrace().toEdgeList()));
            }
            case ERRINV: 
            case UNSAT: {
                return FaultRankingUtils.concatHeuristics(new EdgeTypeScoring(), new CallHierarchyScoring(pTraceFormula.getTrace().toEdgeList()));
            }
        }
        throw new AssertionError((Object)"The specified algorithm type does not exist");
    }

    private void runAlgorithm(CounterexampleInfo pInfo, FaultLocalizerWithTraceFormula pAlgorithm) throws CPAException, InterruptedException {
        CFAPathWithAssumptions assumptions = pInfo.getCFAPathWithAssignments();
        if (assumptions.isEmpty()) {
            this.logger.log(Level.INFO, new Object[]{"The analysis returned no assumptions. Fault localization not possible."});
            return;
        }
        try {
            ImmutableList edgeList = Collections3.transformedImmutableListCopy((Collection)((Object)assumptions), assumption -> assumption.getCFAEdge());
            if (edgeList.isEmpty()) {
                this.logger.log(Level.INFO, new Object[]{"Can't find relevant edges in the error trace."});
                return;
            }
            TraceFormula tf = TraceFormula.fromCounterexample(this.getPreConditionExtractor(), this.getPostConditionExtractor(), (List<CFAEdge>)edgeList, this.context, this.options);
            if (!tf.isCalculationPossible()) {
                this.logger.log(Level.INFO, new Object[]{"Pre- and post-condition are unsatisfiable. No further analysis required. Most likely the variables in your post-condition never change their value."});
                return;
            }
            ImmutableSet faults = pAlgorithm.run(this.context, tf);
            ImmutableSet.Builder remainingFaults = ImmutableSet.builder();
            if (!this.algorithmType.equals((Object)AlgorithmType.ERRINV)) {
                for (Fault fault : faults) {
                    if (!fault.stream().noneMatch(fc -> this.ban.stream().anyMatch(b -> ((Trace.TraceAtom)fc).getFormula().toString().contains((CharSequence)b)))) continue;
                    remainingFaults.add((Object)fault);
                }
                faults = remainingFaults.build();
            }
            InformationProvider.searchForAdditionalInformation(faults, (List<CFAEdge>)edgeList);
            InformationProvider.addDefaultPotentialFixesToFaults(faults, 3);
            FaultLocalizationInfoWithTraceFormula info = new FaultLocalizationInfoWithTraceFormula((Set<Fault>)faults, this.getScoring(tf), tf, pInfo, this.algorithmType == AlgorithmType.ERRINV);
            if (this.algorithmType == AlgorithmType.ERRINV) {
                info.replaceHtmlWriter(new IntervalReportWriter(this.context.getSolver().getFormulaManager()));
            }
            info.getHtmlWriter().hideTypes(FaultInfo.InfoType.RANK_INFO);
            info.apply();
            this.logger.log(Level.INFO, new Object[]{"Running " + pAlgorithm.getClass().getSimpleName() + ":\n" + info});
        }
        catch (SolverException sE) {
            throw new CPAException("The solver was not able to find the UNSAT-core of the path formula.", sE);
        }
        catch (VerifyException vE) {
            throw new CPAException("No bugs found because the trace formula is satisfiable or the counterexample is spurious.", vE);
        }
        catch (InvalidConfigurationException iE) {
            throw new CPAException("Incomplete analysis because of invalid configuration.", iE);
        }
        catch (IllegalStateException iE) {
            throw new CPAException("The counterexample is spurious. Calculating interpolants is not possible.", iE);
        }
    }

    private PostConditionComposer getPostConditionExtractor() {
        switch (this.postConditionType) {
            case LAST_ASSUME_EDGE: {
                return new FinalAssumeEdgePostConditionComposer(this.context);
            }
            case LAST_ASSUME_EDGES_ON_SAME_LINE: {
                return new FinalAssumeEdgesOnSameLinePostConditionComposer(this.context);
            }
            case LAST_ASSUME_EDGE_CLUSTER: {
                return new FinalAssumeClusterPostConditionComposer(this.context);
            }
        }
        throw new AssertionError((Object)"Unknown post-condition type");
    }

    private PreConditionComposer getPreConditionExtractor() {
        switch (this.preconditionType) {
            case NONDETERMINISTIC_VARIABLES_ONLY: {
                return new VariableAssignmentPreConditionComposer(this.context, this.options, false);
            }
            case INITIAL_ASSIGNMENT: {
                return new VariableAssignmentPreConditionComposer(this.context, this.options, true);
            }
            case ALWAYS_TRUE: {
                return new TruePreConditionComposer(this.context);
            }
        }
        throw new AssertionError((Object)("Unknown precondition type: " + this.preconditionType));
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this);
        if (this.algorithm instanceof Statistics) {
            statsCollection.add((Statistics)((Object)this.algorithm));
        }
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(statsCollection);
        }
        if (this.faultAlgorithm instanceof Statistics) {
            statsCollection.add((Statistics)((Object)this.faultAlgorithm));
        }
        if (this.faultAlgorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.faultAlgorithm)).collectStatistics(statsCollection);
        }
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        StatisticsWriter.writingStatisticsTo(out).put(this.totalTime);
    }

    @Override
    public @Nullable String getName() {
        return this.getClass().getSimpleName();
    }

    static enum PreConditionType {
        NONDETERMINISTIC_VARIABLES_ONLY,
        INITIAL_ASSIGNMENT,
        ALWAYS_TRUE;

    }

    static enum PostConditionType {
        LAST_ASSUME_EDGE,
        LAST_ASSUME_EDGES_ON_SAME_LINE,
        LAST_ASSUME_EDGE_CLUSTER;

    }

    public static enum AlgorithmType {
        UNSAT,
        MAXSAT,
        MAXORG,
        ERRINV;

    }
}

