/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.invariants.AbstractInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.DoNothingInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.ExpressionTreeSupplier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantSupplier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.KInductionInvariantGenerator;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAEnabledAnalysisPropertyViolationException;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProvider;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.invariantwitness.InvariantWitness;
import org.sosy_lab.cpachecker.util.invariantwitness.InvariantWitnessFactory;
import org.sosy_lab.cpachecker.util.invariantwitness.InvariantWitnessGenerator;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.InvariantWitnessWriter;
import org.sosy_lab.cpachecker.util.predicates.invariants.ExpressionTreeInvariantSupplier;
import org.sosy_lab.cpachecker.util.predicates.invariants.FormulaInvariantsSupplier;

@Options(prefix="invariantStore")
public class InvariantExportAlgorithm
implements Algorithm {
    private final Configuration config;
    private final LogManager logger;
    private final CFA cfa;
    private final ShutdownNotifier shutdownNotifier;
    private final InvariantGenerator generator;
    private final InvariantWitnessFactory invariantWitnessFactory;
    private final InvariantWitnessWriter invariantWitnessWriter;
    private final Set<InvariantWitness> alreadyExported;
    @Option(secure=true, description="Strategy for generating invariants")
    private InvariantGeneratorFactory invariantGenerationStrategy = InvariantGeneratorFactory.REACHED_SET;

    public InvariantExportAlgorithm(Configuration pConfig, LogManager pLogger, ShutdownManager pShutdownManager, CFA pCFA, Specification pSpecification, ReachedSetFactory pReachedSetFactory, TargetLocationProvider pTargetLocationProvider, AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException, InterruptedException, CPAException {
        this.config = pConfig;
        this.config.inject((Object)this);
        this.logger = pLogger;
        this.cfa = pCFA;
        this.shutdownNotifier = pShutdownManager.getNotifier();
        this.invariantWitnessFactory = InvariantWitnessFactory.getFactory(pLogger, pCFA);
        try {
            this.invariantWitnessWriter = InvariantWitnessWriter.getWriter(pConfig, pCFA, pSpecification, pLogger);
        }
        catch (IOException e) {
            throw new CPAException("could not instantiate invariant witness writer", e);
        }
        this.alreadyExported = new HashSet<InvariantWitness>();
        this.generator = this.invariantGenerationStrategy.createInvariantGenerator(pConfig, pLogger, pReachedSetFactory, pShutdownManager, pCFA, pSpecification, pAggregatedReachedSets, pTargetLocationProvider);
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException, CPAEnabledAnalysisPropertyViolationException {
        this.generator.start(this.cfa.getMainFunction());
        try {
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                this.handleNewInvariants();
                Thread.sleep(2000L);
            }
            this.handleNewInvariants();
        }
        catch (IOException e) {
            this.logger.logException(Level.SEVERE, (Throwable)e, "Cannot write inavariant witnesses");
            this.generator.cancel();
        }
        return Algorithm.AlgorithmStatus.NO_PROPERTY_CHECKED;
    }

    private void handleNewInvariants() throws IOException, InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        if (!this.generator.isStarted()) {
            return;
        }
        this.logger.log(Level.INFO, new Object[]{"Checking for invariants to export ..."});
        ExpressionTreeSupplier supplier = this.getCurrentSupplier();
        ImmutableSet.Builder witnesses = ImmutableSet.builder();
        for (CFANode node : this.cfa.getAllNodes()) {
            ExpressionTree<Object> invariant = supplier.getInvariantFor(node);
            if (invariant.equals(ExpressionTrees.getTrue())) continue;
            witnesses.addAll(this.invariantWitnessFactory.fromNodeAndInvariant(node, invariant));
        }
        this.exportWitnesses((Set<InvariantWitness>)Sets.difference((Set)witnesses.build(), this.alreadyExported));
    }

    private ExpressionTreeSupplier getCurrentSupplier() {
        try {
            return this.generator.getExpressionTreeSupplier();
        }
        catch (CPAException e) {
            this.logger.logUserException(Level.FINE, (Throwable)e, "Invariant generation failed.");
        }
        catch (InterruptedException e) {
            this.logger.log(Level.FINE, new Object[]{"Invariant generation was cancelled."});
            this.logger.logDebugException((Throwable)e);
        }
        return ExpressionTreeSupplier.TrivialInvariantSupplier.INSTANCE;
    }

    private void exportWitnesses(Set<InvariantWitness> witnesses) throws IOException {
        if (witnesses.isEmpty()) {
            return;
        }
        this.logger.log(Level.INFO, new Object[]{"Found " + witnesses.size() + " new invariants and will export them."});
        for (InvariantWitness witness : witnesses) {
            this.alreadyExported.add(witness);
            this.logger.log(Level.INFO, new Object[]{"Exporting invariant " + witness});
            this.invariantWitnessWriter.exportInvariantWitness(witness);
        }
    }

    public static enum InvariantGeneratorFactory {
        INDUCTION{

            @Override
            InvariantGenerator createInvariantGenerator(Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownManager pShutdownManager, CFA pCFA, Specification pSpecification, AggregatedReachedSets pAggregatedReachedSets, TargetLocationProvider pTargetLocationProvider) throws InvalidConfigurationException, CPAException, InterruptedException {
                return KInductionInvariantGenerator.create(pConfig, pLogger, pShutdownManager, pCFA, pSpecification, pReachedSetFactory, pTargetLocationProvider, pAggregatedReachedSets);
            }
        }
        ,
        REACHED_SET{

            @Override
            InvariantGenerator createInvariantGenerator(Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownManager pShutdownManager, final CFA pCFA, Specification pSpecification, final AggregatedReachedSets pAggregatedReachedSets, TargetLocationProvider pTargetLocationProvider) {
                return new AbstractInvariantGenerator(){

                    @Override
                    protected void startImpl(CFANode pInitialLocation) {
                    }

                    @Override
                    public boolean isProgramSafe() {
                        return false;
                    }

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public InvariantSupplier getSupplier() throws CPAException, InterruptedException {
                        return new FormulaInvariantsSupplier(pAggregatedReachedSets);
                    }

                    @Override
                    public ExpressionTreeSupplier getExpressionTreeSupplier() throws CPAException, InterruptedException {
                        return new ExpressionTreeInvariantSupplier(pAggregatedReachedSets, pCFA);
                    }
                };
            }
        }
        ,
        DO_NOTHING{

            @Override
            InvariantGenerator createInvariantGenerator(Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownManager pShutdownManager, CFA pCFA, Specification pSpecification, AggregatedReachedSets pAggregatedReachedSets, TargetLocationProvider pTargetLocationProvider) {
                return new DoNothingInvariantGenerator();
            }
        }
        ,
        INVARIANT_STORE{

            @Override
            InvariantGenerator createInvariantGenerator(Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownManager pShutdownManager, CFA pCFA, Specification pSpecification, AggregatedReachedSets pAggregatedReachedSets, TargetLocationProvider pTargetLocationProvider) throws InvalidConfigurationException, CPAException, InterruptedException {
                try {
                    return InvariantWitnessGenerator.getNewFromDiskInvariantGenerator(pConfig, pCFA, pLogger, pShutdownManager.getNotifier());
                }
                catch (IOException e) {
                    throw new CPAException("Could not instantiate from disk invariant generator", e);
                }
            }
        };


        abstract InvariantGenerator createInvariantGenerator(Configuration var1, LogManager var2, ReachedSetFactory var3, ShutdownManager var4, CFA var5, Specification var6, AggregatedReachedSets var7, TargetLocationProvider var8) throws InvalidConfigurationException, CPAException, InterruptedException;
    }
}

