/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.JSON;
import org.sosy_lab.common.ProcessExecutor;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.defaults.DummyTargetState;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="mpiAlgorithm")
public class MPIPortfolioAlgorithm
implements Algorithm,
StatisticsProvider {
    private static final String MPI_BIN = "mpiexec";
    private static final String PYTHON3_BIN = "python3";
    private static final Path MPI_PYTHON_MAIN_PATH = Classes.getCodeLocation(MPIPortfolioAlgorithm.class).resolveSibling(Path.of("scripts", "mpi_portfolio.py"));
    @Option(secure=true, required=true, description="List of property-files to be run by the subprocesses.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private List<Path> configFiles;
    @Option(secure=true, description="Max. amount of processes to be used by MPI.")
    private int numberProcesses;
    @Option(secure=true, description="File containing the ip addresses to be used by MPI.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path hostfile;
    @Option(secure=true, description="The MCA parameter ('Modular Component Architecture') is available only on Open MPI frameworks. It might thus need to be disabled if unavailable on the working machine.")
    private boolean disableMCAOptions;
    private final Configuration globalConfig;
    private final LogManager logger;
    private final ShutdownManager shutdownManager;
    private final Specification specification;
    private final MPIPortfolioAlgorithmStatistics stats;
    private final Map<String, Path> binaries;
    private final ImmutableList<SubanalysisConfig> subanalyses;
    private final int availableProcessors;
    private final String mpiArgs;

    public MPIPortfolioAlgorithm(Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Specification pSpecification) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.globalConfig = config;
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.shutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)((ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier)));
        this.specification = (Specification)Preconditions.checkNotNull((Object)pSpecification);
        this.stats = new MPIPortfolioAlgorithmStatistics();
        this.binaries = new HashMap<String, Path>();
        this.binaries.put(PYTHON3_BIN, MPIPortfolioAlgorithm.getPathOrThrowError(PYTHON3_BIN));
        this.binaries.put(MPI_BIN, MPIPortfolioAlgorithm.getPathOrThrowError(MPI_BIN));
        String subanalysesTimelimit = MPIPortfolioAlgorithm.computeTimelimitForSubanalyses(config);
        ImmutableList.Builder subanalysesBuilder = new ImmutableList.Builder();
        for (int i = 0; i < this.configFiles.size(); ++i) {
            subanalysesBuilder.add((Object)new SubanalysisConfig(i, subanalysesTimelimit));
        }
        this.subanalyses = subanalysesBuilder.build();
        this.stats.subanalysesTimelimit = subanalysesTimelimit;
        this.availableProcessors = Runtime.getRuntime().availableProcessors();
        Verify.verify((this.availableProcessors > 0 ? 1 : 0) != 0);
        this.logger.logf(Level.INFO, "Found %d logical processors on main node", new Object[]{this.availableProcessors});
        if (this.numberProcesses < 1) {
            this.numberProcesses = 1;
            this.numberProcesses *= this.availableProcessors;
            String numNodesEnv = System.getenv("AWS_BATCH_JOB_NUM_NODES");
            if (!Strings.isNullOrEmpty((String)numNodesEnv)) {
                this.logger.logf(Level.INFO, "Env variable 'AWS_BATCH_JOB_NUM_NODES' found with value '%s'. Continuing using this value.", new Object[]{numNodesEnv});
                try {
                    this.numberProcesses *= Integer.parseInt(numNodesEnv);
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("Env variable 'AWS_BATCH_JOB_NUM_NODES' does not contain a valid integer value", (Throwable)e);
                }
            }
        } else {
            this.logger.logf(Level.INFO, "Number of available processes specified (%d). Not using a heuristic.", new Object[]{this.numberProcesses});
        }
        if (this.configFiles.size() < this.numberProcesses) {
            this.numberProcesses = this.configFiles.size();
        }
        this.stats.noOfAlgorithmsExecuted = this.numberProcesses;
        this.stats.usedSubanalyses = FluentIterable.from(this.subanalyses).filter(x -> x.getIndex() < this.numberProcesses).transform(x -> x.getConfigName().toString()).join(Joiner.on((String)", "));
        if (this.hostfile == null) {
            String envVariable = System.getenv("HOST_FILE_PATH");
            if (!Strings.isNullOrEmpty((String)envVariable)) {
                this.hostfile = Path.of(envVariable, new String[0]);
                this.logger.logf(Level.INFO, "Found env variable 'HOST_FILE_PATH' ('%s'). Continuing using this value.", new Object[]{this.hostfile});
            } else {
                this.logger.log(Level.INFO, new Object[]{"Neither was a hostfile specified nor is one found in path. Running analysis on the local machine only."});
            }
        }
        if (this.hostfile != null) {
            Verify.verify((boolean)this.hostfile.normalize().toFile().exists(), (String)"Hostfile specified, but cannot find it at the given location '%s'", (Object)this.hostfile);
            this.stats.hostfilePath = this.hostfile.toString();
        }
        try (StringWriter stringWriter = new StringWriter();){
            LinkedHashMap<String, Object> analysisMap = new LinkedHashMap<String, Object>();
            for (int i = 0; i < this.configFiles.size(); ++i) {
                SubanalysisConfig subanalysis = (SubanalysisConfig)this.subanalyses.get(i);
                analysisMap.putAll((Map<String, Object>)subanalysis.buildCommandLine());
            }
            if (this.hostfile != null) {
                HashMap<String, String> networkSettings = new HashMap<String, String>();
                String mainNodeIPAddress = null;
                try {
                    mainNodeIPAddress = InetAddress.getByName(System.getProperty("user.name")).getHostAddress();
                }
                catch (IOException e) {
                    this.logger.log(Level.WARNING, new Object[]{"Could not retrieve the ip address from the main node. Proceeding without it."});
                    this.logger.logDebugException((Throwable)e, "Failed to retrieve the ip address of the main node from PATH.");
                }
                if (mainNodeIPAddress != null) {
                    networkSettings.put("main_node_ipv4_address", mainNodeIPAddress);
                }
                networkSettings.put("user_name_main_node", System.getProperty("user.name"));
                networkSettings.put("project_location_main_node", System.getProperty("user.dir"));
                analysisMap.put("network_settings", networkSettings);
            }
            JSON.writeJSONString(analysisMap, (Appendable)stringWriter);
            this.mpiArgs = stringWriter.toString();
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Failed to create a valid CPAchecker-cmdline from the config", (Throwable)e);
        }
    }

    private static String computeTimelimitForSubanalyses(Configuration pConfig) throws InvalidConfigurationException {
        int limitMain;
        if (!pConfig.hasProperty("limits.time.cpu")) {
            return "750s";
        }
        @Nullable String property = pConfig.getProperty("limits.time.cpu");
        Verify.verify((!Strings.isNullOrEmpty((String)property) ? 1 : 0) != 0);
        String rawValue = ((String)Iterables.get((Iterable)Splitter.on((char)'s').split((CharSequence)property), (int)0)).strip();
        try {
            limitMain = Integer.parseInt(rawValue);
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigurationException(String.format("Unable to turn the value '%s' into an int value", rawValue), (Throwable)e);
        }
        int limitSubanalyses = limitMain < 60 ? (int)((double)limitMain * 0.8) : (limitMain < 150 ? limitMain - 15 : Math.max((int)((double)limitMain * 0.8), limitMain - 90));
        Verify.verify((limitSubanalyses > 0 ? 1 : 0) != 0);
        return limitSubanalyses + "s";
    }

    private static Path getPathOrThrowError(String pRequiredBin) throws InvalidConfigurationException {
        Optional<Path> pathOpt = Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator))).map(x$0 -> Path.of(x$0, new String[0])).filter(path -> Files.exists(path.resolve(pRequiredBin), new LinkOption[0])).findFirst();
        if (pathOpt.isEmpty()) {
            throw new InvalidConfigurationException(pRequiredBin + " is required for performing the portfolio-analysis, but could not find it in PATH");
        }
        return pathOpt.orElseThrow().resolve(pRequiredBin);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        ArrayList<Object> cmdList = new ArrayList<Object>();
        cmdList.add(this.binaries.get(MPI_BIN).toString());
        if (this.hostfile != null) {
            if (!this.disableMCAOptions) {
                cmdList.add("--mca");
                cmdList.add("btl_tcp_if_include");
                cmdList.add("eth0");
            }
            cmdList.add("-hostfile");
            cmdList.add(this.hostfile.normalize().toString());
        } else {
            cmdList.add("--host");
            cmdList.add("localhost:" + this.numberProcesses);
        }
        cmdList.add("-np");
        cmdList.add(String.valueOf(this.numberProcesses));
        cmdList.add("--map-by");
        cmdList.add("ppr:" + this.availableProcessors + ":core");
        cmdList.add(this.binaries.get(PYTHON3_BIN).toString());
        cmdList.add(MPI_PYTHON_MAIN_PATH.normalize().toString());
        this.logger.log(Level.INFO, new Object[]{"Executing command (arguments trimmed): " + cmdList});
        cmdList.add("--input");
        cmdList.add(this.mpiArgs);
        this.logger.log(Level.FINEST, new Object[]{"MPI arguments: " + this.mpiArgs});
        ProcessExecutor<IOException> executor = null;
        try {
            this.shutdownManager.getNotifier().shutdownIfNecessary();
            this.logger.log(Level.INFO, new Object[]{"Running subprocesses orchestrated by MPI"});
            this.stats.mpiBinaryTotalTimer.start();
            try {
                executor = new ProcessExecutor<IOException>(this.logger, IOException.class, (String[])Iterables.toArray(cmdList, String.class)){

                    protected void handleOutput(String line) {
                        Preconditions.checkNotNull((Object)line);
                        this.logger.logf(Level.INFO, "%s - %s", new Object[]{"scripts/" + MPI_PYTHON_MAIN_PATH.getFileName(), line});
                    }
                };
                int exitCode = executor.join();
                this.logger.log(Level.INFO, new Object[]{"MPI has finished its job. Continuing in main node."});
                if (exitCode != 0) {
                    if (executor.getErrorOutput().stream().anyMatch(x -> x.contains("unrecognized argument mca"))) {
                        this.logger.log(Level.SEVERE, new Object[]{"The error log of the MPI binary indicates that the 'mca' optionis not available. You can try executing this analysis again with this option disabled (mpiAlgorithm.disableMCAOptions=true)"});
                    }
                    throw new CPAException("MPI script has failed with exit code " + exitCode);
                }
            }
            finally {
                this.stats.mpiBinaryTotalTimer.stop();
            }
            Optional<Object> successfulAnalysisOpt = Optional.empty();
            for (SubanalysisConfig subconf : this.subanalyses) {
                Path logfilePath = subconf.getOutputPath().resolve(subconf.getLogfileName());
                if (!logfilePath.toFile().exists()) continue;
                ImmutableList subanalysisLog = null;
                try (Stream<String> lines = Files.lines(logfilePath);){
                    subanalysisLog = (ImmutableList)lines.filter(Predicate.not(String::isBlank)).collect(ImmutableList.toImmutableList());
                }
                subconf.addResultLog((ImmutableList<String>)subanalysisLog);
                Optional subanalysisResultOpt = (Optional)subanalysisLog.stream().filter(x -> x.startsWith("Verification result:")).collect(MoreCollectors.toOptional());
                if (subanalysisResultOpt.isEmpty()) continue;
                Optional<CPAcheckerResult> resultOpt = CPAcheckerResult.parseResultString((String)subanalysisResultOpt.orElseThrow());
                CPAcheckerResult subanalyisResult = resultOpt.orElseThrow();
                subconf.addResult(subanalyisResult);
                if (subanalyisResult.getResult() == CPAcheckerResult.Result.UNKNOWN) continue;
                CPAcheckerResult.Result result = subanalyisResult.getResult();
                Verify.verify((result == CPAcheckerResult.Result.TRUE || result == CPAcheckerResult.Result.FALSE ? 1 : 0) != 0);
                this.logger.logf(Level.INFO, "Received the results for analysis '%s': %s", new Object[]{subconf.getConfigName(), result});
                successfulAnalysisOpt = Optional.of(subconf);
                break;
            }
            if (!successfulAnalysisOpt.isEmpty()) {
                SubanalysisConfig successfulAnalysis = (SubanalysisConfig)successfulAnalysisOpt.orElseThrow();
                CPAcheckerResult result = successfulAnalysis.getResult();
                if (result.getResult() == CPAcheckerResult.Result.TRUE) {
                    this.logger.logf(Level.FINE, "Returning result: TRUE", new Object[0]);
                    pReachedSet.clear();
                } else if (result.getResult() == CPAcheckerResult.Result.FALSE) {
                    this.logger.logf(Level.FINE, "Returning result: FALSE", new Object[0]);
                    pReachedSet.clear();
                    pReachedSet.add(DummyTargetState.withSimpleTargetInformation(result.getTargetDescription()), SingletonPrecision.getInstance());
                }
                this.logger.log(Level.INFO, new Object[]{"Executed the following command for the successful subanalysis:"});
                String formattedCmdline = FluentIterable.from(successfulAnalysis.getCmdLine()).transform(arg_0 -> ((CharMatcher)CharMatcher.whitespace()).removeFrom(arg_0)).join(Joiner.on((String)" "));
                this.logger.log(Level.INFO, new Object[]{formattedCmdline});
                this.logger.log(Level.WARNING, new Object[]{"Subsequently the log of the successful subanalysis is printed"});
                this.logger.log(Level.WARNING, new Object[]{"------------------- START SUBANALYSIS LOG -------------------"});
                ImmutableList<String> resultLog = successfulAnalysis.getResultLog();
                Verify.verifyNotNull(resultLog);
                Verify.verify((!resultLog.isEmpty() ? 1 : 0) != 0, (String)"Result log may not be empty", (Object[])new Object[0]);
                this.logger.log(Level.INFO, new Object[]{Joiner.on((String)"\n\n").join(resultLog)});
                this.logger.log(Level.WARNING, new Object[]{"-------------------- END SUBANALYSIS LOG --------------------"});
                return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
            }
            this.logger.logf(Level.WARNING, "None of the subanalyses produced a result.", new Object[0]);
        }
        catch (IOException e) {
            throw new CPAException("Execution of MPI failed", e);
        }
        return Algorithm.AlgorithmStatus.UNSOUND_AND_IMPRECISE;
    }

    private static class MPIPortfolioAlgorithmStatistics
    implements Statistics {
        private int noOfAlgorithmsExecuted;
        private String usedSubanalyses;
        private String hostfilePath;
        private final Timer mpiBinaryTotalTimer = new Timer();
        private String subanalysesTimelimit;

        private MPIPortfolioAlgorithmStatistics() {
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            pOut.println("Number of algorithms used:                  " + this.noOfAlgorithmsExecuted);
            pOut.println("Subanalyses executed by MPI:                " + this.usedSubanalyses);
            if (this.hostfilePath != null) {
                pOut.println("Hostfile path:                              " + this.hostfilePath);
            }
            pOut.println("MPI binary total execution time:         " + this.mpiBinaryTotalTimer);
            pOut.println("Timelimit for the CPAchecker sub-instances: " + this.subanalysesTimelimit);
        }

        @Override
        public @Nullable String getName() {
            return "MPI Portfolio Algorithm";
        }
    }

    private class SubanalysisConfig {
        private static final String SUBPROCESS_DEFAULT_TIMELIMIT = "750s";
        private static final String OUTPUT_DIR = "output";
        private static final String SUBANALYSIS_DIR = "output_portfolio-analysis_";
        private static final String ANALYSIS_KEY = "analysis";
        private static final String CMD_KEY = "cmd";
        private static final String OUPUT_KEY = "output";
        private static final String LOGFILE_KEY = "logfile";
        private final int subanalysis_index;
        private final Path configPath;
        private final Path outputPath;
        private final Path logfileName;
        private final Configuration config;
        private final ImmutableList<String> cmdLine;
        private ImmutableList<String> resultLog = null;
        private CPAcheckerResult result = null;

        SubanalysisConfig(int index, String pSubanalysesTimelimit) throws InvalidConfigurationException {
            this.subanalysis_index = index;
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pSubanalysesTimelimit) ? 1 : 0) != 0);
            this.configPath = MPIPortfolioAlgorithm.this.configFiles.get(this.subanalysis_index);
            this.outputPath = Path.of("output", SUBANALYSIS_DIR + this.subanalysis_index);
            this.logfileName = Path.of(SUBANALYSIS_DIR + this.subanalysis_index + ".log", new String[0]);
            String specPath = Joiner.on((String)", ").join(MPIPortfolioAlgorithm.this.specification.getFiles());
            this.config = Configuration.builder().copyFrom(MPIPortfolioAlgorithm.this.globalConfig).clearOption("mpiAlgorithm.hostfile").clearOption("analysis.algorithm.MPI").clearOption("mpiAlgorithm.configFiles").clearOption("analysis.name").clearOption("mpiAlgorithm.numberProcesses").clearOption("mpiAlgorithm.disableMCAOptions").setOption("limits.time.cpu", pSubanalysesTimelimit).setOption("output.path", (String)Preconditions.checkNotNull((Object)this.outputPath.toString())).setOption("specification", specPath).build();
            ImmutableList.Builder cmdLineBuilder = ImmutableList.builder();
            cmdLineBuilder.add((Object)"scripts/cpa.sh").add((Object)"-config").add((Object)this.configPath.toString());
            for (String opt : Splitter.on((char)'\n').omitEmptyStrings().split((CharSequence)this.config.asPropertiesString())) {
                cmdLineBuilder.add((Object)"-setprop").add((Object)opt);
            }
            this.cmdLine = cmdLineBuilder.build();
        }

        ImmutableMap<String, ImmutableMap<String, Object>> buildCommandLine() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            builder.put((Object)ANALYSIS_KEY, (Object)this.configPath.getFileName().toString());
            builder.put((Object)CMD_KEY, this.cmdLine);
            builder.put((Object)"output", (Object)this.outputPath.toString());
            builder.put((Object)LOGFILE_KEY, (Object)this.outputPath.resolve(this.logfileName).toString());
            return ImmutableMap.of((Object)("Analysis_" + this.subanalysis_index), (Object)builder.buildOrThrow());
        }

        int getIndex() {
            return this.subanalysis_index;
        }

        Path getConfigName() {
            return this.configPath.getFileName();
        }

        Path getOutputPath() {
            return this.outputPath;
        }

        Path getLogfileName() {
            return this.logfileName;
        }

        ImmutableList<String> getCmdLine() {
            return this.cmdLine;
        }

        @Nullable ImmutableList<String> getResultLog() {
            return this.resultLog;
        }

        void addResultLog(ImmutableList<String> pResultLog) {
            if (this.resultLog != null) {
                throw new RuntimeException("ResultLog is expected to be null");
            }
            this.resultLog = pResultLog;
        }

        @Nullable CPAcheckerResult getResult() {
            return this.result;
        }

        void addResult(CPAcheckerResult pResult) {
            if (this.result != null) {
                throw new RuntimeException("Result is expected to be null");
            }
            this.result = pResult;
        }

        public String toString() {
            return String.format("Subanalysis_%d-%s", this.subanalysis_index, this.getConfigName());
        }
    }
}

