/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;

public abstract class NestingAlgorithm
implements Algorithm,
StatisticsProvider {
    protected final LogManager logger;
    protected final ShutdownNotifier shutdownNotifier;
    protected final Configuration globalConfig;
    protected final Specification specification;

    protected NestingAlgorithm(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Specification pSpecification) {
        this.shutdownNotifier = Objects.requireNonNull(pShutdownNotifier);
        this.globalConfig = Objects.requireNonNull(pConfig);
        this.specification = Objects.requireNonNull(pSpecification);
        this.logger = Objects.requireNonNull(pLogger);
    }

    protected Triple<Algorithm, ConfigurableProgramAnalysis, ReachedSet> createAlgorithm(Path singleConfigFileName, CFANode initialNode, CFA pCfa, ShutdownManager singleShutdownManager, AggregatedReachedSets aggregateReached, Collection<String> ignoreOptions, Collection<Statistics> stats) throws InvalidConfigurationException, CPAException, IOException, InterruptedException {
        Configuration singleConfig = this.buildSubConfig(singleConfigFileName, ignoreOptions);
        LogManager singleLogger = this.logger.withComponentName("Analysis " + singleConfigFileName);
        ResourceLimitChecker singleLimits = ResourceLimitChecker.fromConfiguration(singleConfig, singleLogger, singleShutdownManager);
        singleLimits.start();
        CoreComponentsFactory coreComponents = new CoreComponentsFactory(singleConfig, singleLogger, singleShutdownManager.getNotifier(), aggregateReached);
        ConfigurableProgramAnalysis cpa = coreComponents.createCPA(pCfa, this.specification);
        GlobalInfo.getInstance().setUpInfoFromCPA(cpa);
        Algorithm algorithm = coreComponents.createAlgorithm(cpa, pCfa, this.specification);
        ReachedSet reached = NestingAlgorithm.createInitialReachedSet(cpa, initialNode, coreComponents, singleLogger);
        if (cpa instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)cpa)).collectStatistics(stats);
        }
        if (algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)algorithm)).collectStatistics(stats);
        }
        return Triple.of(algorithm, cpa, reached);
    }

    private Configuration buildSubConfig(Path singleConfigFileName, Collection<String> ignoreOptions) throws IOException, InvalidConfigurationException {
        ConfigurationBuilder singleConfigBuilder = Configuration.builder();
        singleConfigBuilder.copyFrom(this.globalConfig);
        for (String ignore : ignoreOptions) {
            singleConfigBuilder.clearOption(ignore);
        }
        singleConfigBuilder.loadFromFile(singleConfigFileName);
        Configuration singleConfig = singleConfigBuilder.build();
        NestingAlgorithm.checkConfigs(this.globalConfig, singleConfig, singleConfigFileName, this.logger);
        return singleConfig;
    }

    private static ReachedSet createInitialReachedSet(ConfigurableProgramAnalysis cpa, CFANode mainFunction, CoreComponentsFactory pFactory, LogManager singleLogger) throws InterruptedException {
        singleLogger.log(Level.FINE, new Object[]{"Creating initial reached set"});
        AbstractState initialState = cpa.getInitialState(mainFunction, StateSpacePartition.getDefaultPartition());
        Precision initialPrecision = cpa.getInitialPrecision(mainFunction, StateSpacePartition.getDefaultPartition());
        ReachedSet reached = pFactory.createReachedSet(cpa);
        reached.add(initialState, initialPrecision);
        return reached;
    }

    static void checkConfigs(Configuration pGlobalConfig, Configuration pSingleConfig, Path pSingleConfigFileName, LogManager pLogger) throws InvalidConfigurationException {
        String value;
        String key;
        Map<String, String> global = NestingAlgorithm.configToMap(pGlobalConfig);
        Map<String, String> single = NestingAlgorithm.configToMap(pSingleConfig);
        for (Map.Entry<String, String> entry : global.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!single.containsKey(key) || value.equals(single.get(key))) continue;
            pLogger.logf(Level.INFO, "Mismatch of configuration options when loading from '%s': '%s' has two values '%s' and '%s'. Using '%s'.", new Object[]{pSingleConfigFileName, key, value, single.get(key), single.get(key)});
        }
        for (Map.Entry<String, String> entry : single.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!key.startsWith("cfa.") || global.containsKey(key) && value.equals(global.get(key))) continue;
            throw new InvalidConfigurationException("CFA option of a nested sub-configuration must also be present in the outer configuration!\n" + String.format("inner config: \"%s = %s\" ; outer config: \"%s = %s\" ", key, value, key, global.get(key)));
        }
    }

    private static Map<String, String> configToMap(Configuration config) {
        LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
        for (String option : Splitter.on((String)"\n").omitEmptyStrings().split((CharSequence)config.asPropertiesString())) {
            List split = Splitter.on((String)" = ").splitToList((CharSequence)option);
            Preconditions.checkArgument((split.size() == 2 ? 1 : 0) != 0, (String)"unexpected option format: %s", (Object)option);
            mp.put((String)split.get(0), (String)split.get(1));
        }
        return mp;
    }
}

