/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.AnnotatedValue;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.NestingAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.conditions.ReachedSetAdjustingCPA;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CompoundException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;
import org.sosy_lab.cpachecker.util.resources.ThreadCpuTimeLimit;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options(prefix="parallelAlgorithm")
public class ParallelAlgorithm
implements Algorithm,
StatisticsProvider {
    @Option(secure=true, required=true, description="List of files with configurations to use. Files can be suffixed with ::supply-reached this signalizes that the (finished) reached set of an analysis can be used in other analyses (e.g. for invariants computation). If you use the suffix ::supply-reached-refinable instead this means that the reached set supplier is additionally continously refined (so one of the analysis has to be instanceof ReachedSetAdjustingCPA) to make this work properly.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private List<AnnotatedValue<Path>> configFiles;
    private static final String SUCCESS_MESSAGE = "One of the parallel analyses has finished successfully, cancelling all other runs.";
    private final Configuration globalConfig;
    private final LogManager logger;
    private final ShutdownManager shutdownManager;
    private final CFA cfa;
    private final Specification specification;
    private final ParallelAlgorithmStatistics stats;
    private ParallelAnalysisResult finalResult = null;
    private CFANode mainEntryNode = null;
    private final AggregatedReachedSets.AggregatedReachedSetManager aggregatedReachedSetManager;
    private final List<ConditionAdjustmentEventSubscriber> conditionAdjustmentEventSubscribers = new CopyOnWriteArrayList<ConditionAdjustmentEventSubscriber>();
    private final ImmutableList<Callable<ParallelAnalysisResult>> analyses;

    public ParallelAlgorithm(Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Specification pSpecification, CFA pCfa, AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException, CPAException, InterruptedException {
        config.inject((Object)this);
        this.stats = new ParallelAlgorithmStatistics(pLogger);
        this.globalConfig = config;
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.shutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)((ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier)));
        this.specification = (Specification)Preconditions.checkNotNull((Object)pSpecification);
        this.cfa = (CFA)Preconditions.checkNotNull((Object)pCfa);
        this.aggregatedReachedSetManager = new AggregatedReachedSets.AggregatedReachedSetManager();
        this.aggregatedReachedSetManager.addAggregated(pAggregatedReachedSets);
        ImmutableList.Builder analysesBuilder = ImmutableList.builder();
        for (AnnotatedValue<Path> p : this.configFiles) {
            analysesBuilder.add(this.createParallelAnalysis(p, ++this.stats.noOfAlgorithmsUsed));
        }
        this.analyses = analysesBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        this.mainEntryNode = AbstractStates.extractLocation(pReachedSet.getFirstState());
        ForwardingReachedSet forwardingReachedSet = (ForwardingReachedSet)pReachedSet;
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.analyses.size()));
        ArrayList<ListenableFuture<ParallelAnalysisResult>> futures = new ArrayList<ListenableFuture<ParallelAnalysisResult>>(this.analyses.size());
        for (Callable call : this.analyses) {
            futures.add((ListenableFuture<ParallelAnalysisResult>)exec.submit(call));
        }
        exec.shutdown();
        try {
            this.handleFutureResults(futures);
        }
        catch (Throwable throwable) {
            if (!ParallelAlgorithm.awaitTermination(exec, 10L, TimeUnit.SECONDS)) {
                this.logger.log(Level.WARNING, new Object[]{"Not all threads are terminated although we have a result."});
            }
            exec.shutdownNow();
            throw throwable;
        }
        if (!ParallelAlgorithm.awaitTermination(exec, 10L, TimeUnit.SECONDS)) {
            this.logger.log(Level.WARNING, new Object[]{"Not all threads are terminated although we have a result."});
        }
        exec.shutdownNow();
        if (this.finalResult != null) {
            forwardingReachedSet.setDelegate(this.finalResult.getReached());
            return this.finalResult.getStatus();
        }
        return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
    }

    private static boolean awaitTermination(ListeningExecutorService exec, long timeout, TimeUnit unit) {
        long timeoutNanos = unit.toNanos(timeout);
        long endNanos = System.nanoTime() + timeoutNanos;
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                boolean bl = exec.awaitTermination(timeoutNanos, TimeUnit.NANOSECONDS);
                return bl;
            }
            catch (InterruptedException e) {
                interrupted = false;
                timeoutNanos = Math.max(0L, endNanos - System.nanoTime());
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void handleFutureResults(List<ListenableFuture<ParallelAnalysisResult>> futures) throws InterruptedException, Error, CPAException {
        ArrayList<CPAException> exceptions = new ArrayList<CPAException>();
        for (ListenableFuture f : Futures.inCompletionOrder(futures)) {
            try {
                ParallelAnalysisResult result = (ParallelAnalysisResult)f.get();
                if (result.hasValidReachedSet() && this.finalResult == null) {
                    this.finalResult = result;
                    this.stats.successfulAnalysisName = result.getAnalysisName();
                    futures.forEach(future -> future.cancel(true));
                    this.logger.log(Level.INFO, new Object[]{result.getAnalysisName() + " finished successfully."});
                    this.shutdownManager.requestShutdown(SUCCESS_MESSAGE);
                    continue;
                }
                if (result.hasValidReachedSet()) continue;
                this.logger.log(Level.INFO, new Object[]{result.getAnalysisName() + " finished without usable result."});
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CPAException) {
                    if (cause.getMessage().contains("recursion")) {
                        this.logger.logUserException(Level.WARNING, cause, "Analysis not completed due to recursion");
                    }
                    if (cause.getMessage().contains("pthread_create")) {
                        this.logger.logUserException(Level.WARNING, cause, "Analysis not completed due to concurrency");
                    }
                    exceptions.add((CPAException)cause);
                    continue;
                }
                futures.forEach(future -> future.cancel(true));
                this.shutdownManager.requestShutdown("cancelling all remaining analyses");
                Throwables.throwIfUnchecked((Throwable)cause);
                throw new Classes.UnexpectedCheckedException("analysis", cause);
            }
            catch (CancellationException cancellationException) {
            }
        }
        if (this.finalResult == null && !exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw (CPAException)Iterables.getOnlyElement(exceptions);
            }
            throw new CompoundException(exceptions);
        }
    }

    private Callable<ParallelAnalysisResult> createParallelAnalysis(AnnotatedValue<Path> pSingleConfigFileName, int analysisNumber) throws InvalidConfigurationException, CPAException, InterruptedException {
        boolean supplyRefinableReached;
        boolean supplyReached;
        Path singleConfigFileName = (Path)pSingleConfigFileName.value();
        Configuration singleConfig = this.createSingleConfig(singleConfigFileName, this.logger);
        if (singleConfig == null) {
            return () -> ParallelAnalysisResult.absent(singleConfigFileName.toString());
        }
        ShutdownManager singleShutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownManager.getNotifier());
        LogManager singleLogger = this.logger.withComponentName("Parallel analysis " + analysisNumber);
        if (pSingleConfigFileName.annotation().isPresent()) {
            switch ((String)pSingleConfigFileName.annotation().orElseThrow()) {
                case "supply-reached": {
                    supplyReached = true;
                    supplyRefinableReached = false;
                    break;
                }
                case "supply-reached-refinable": {
                    supplyReached = false;
                    supplyRefinableReached = true;
                    break;
                }
                default: {
                    throw new InvalidConfigurationException(String.format("Annotation %s is not valid for config %s in option parallelAlgorithm.configFiles", pSingleConfigFileName.annotation(), pSingleConfigFileName.value()));
                }
            }
        } else {
            supplyReached = false;
            supplyRefinableReached = false;
        }
        ResourceLimitChecker singleAnalysisOverallLimit = ResourceLimitChecker.fromConfiguration(singleConfig, singleLogger, singleShutdownManager);
        CoreComponentsFactory coreComponents = new CoreComponentsFactory(singleConfig, singleLogger, singleShutdownManager.getNotifier(), this.aggregatedReachedSetManager.asView());
        ConfigurableProgramAnalysis cpa = coreComponents.createCPA(this.cfa, this.specification);
        Algorithm algorithm = coreComponents.createAlgorithm(cpa, this.cfa, this.specification);
        ReachedSet reached = coreComponents.createReachedSet(cpa);
        AtomicBoolean terminated = new AtomicBoolean(false);
        StatisticsEntry statisticsEntry = this.stats.getNewSubStatistics(reached, singleConfigFileName.toString(), (ThreadCpuTimeLimit)Iterables.getOnlyElement((Iterable)FluentIterable.from(singleAnalysisOverallLimit.getResourceLimits()).filter(ThreadCpuTimeLimit.class), null), terminated);
        return () -> {
            GlobalInfo.getInstance().setUpInfoFromCPA(cpa);
            if (algorithm instanceof ConditionAdjustmentEventSubscriber) {
                this.conditionAdjustmentEventSubscribers.add((ConditionAdjustmentEventSubscriber)((Object)algorithm));
            }
            singleAnalysisOverallLimit.start();
            if (cpa instanceof StatisticsProvider) {
                ((StatisticsProvider)((Object)cpa)).collectStatistics(statisticsEntry.subStatistics);
            }
            if (algorithm instanceof StatisticsProvider) {
                ((StatisticsProvider)((Object)algorithm)).collectStatistics(statisticsEntry.subStatistics);
            }
            try {
                this.initializeReachedSet(cpa, this.mainEntryNode, reached);
            }
            catch (InterruptedException e) {
                singleLogger.logUserException(Level.INFO, (Throwable)e, "Initializing reached set took too long, analysis cannot be started");
                terminated.set(true);
                return ParallelAnalysisResult.absent(singleConfigFileName.toString());
            }
            ParallelAnalysisResult r = this.runParallelAnalysis(singleConfigFileName.toString(), algorithm, reached, singleLogger, cpa, supplyReached, supplyRefinableReached, coreComponents, statisticsEntry);
            terminated.set(true);
            return r;
        };
    }

    private ParallelAnalysisResult runParallelAnalysis(String analysisName, Algorithm algorithm, ReachedSet reached, final LogManager singleLogger, ConfigurableProgramAnalysis cpa, boolean supplyReached, boolean supplyRefinableReached, final CoreComponentsFactory coreComponents, StatisticsEntry pStatisticsEntry) throws CPAException {
        try {
            Algorithm.AlgorithmStatus status = null;
            ReachedSet currentReached = reached;
            final AtomicReference<ReachedSet> oldReached = new AtomicReference<ReachedSet>();
            if (algorithm instanceof ReachedSetUpdater) {
                ReachedSetUpdater reachedSetUpdater = (ReachedSetUpdater)((Object)algorithm);
                reachedSetUpdater.register(new ReachedSetUpdateListener(){

                    @Override
                    public void updated(ReachedSet pReachedSet) {
                        singleLogger.log(Level.INFO, new Object[]{"Updating reached set provided to other analyses"});
                        ReachedSet newReached = coreComponents.createReachedSet(pReachedSet.getCPA());
                        for (AbstractState as : pReachedSet) {
                            newReached.addNoWaitlist(as, pReachedSet.getPrecision(as));
                        }
                        ReachedSet oldReachedSet = (ReachedSet)oldReached.get();
                        if (oldReachedSet != null) {
                            ParallelAlgorithm.this.aggregatedReachedSetManager.updateReachedSet(oldReachedSet, newReached);
                        } else {
                            ParallelAlgorithm.this.aggregatedReachedSetManager.addReachedSet(newReached);
                        }
                        oldReached.set(newReached);
                    }
                });
            }
            if (!supplyRefinableReached) {
                status = algorithm.run(currentReached);
            } else {
                boolean stopAnalysis = true;
                while (true) {
                    Object oldReachedSet;
                    if (currentReached.hasWaitingState() && (status = algorithm.run(currentReached)).isSound()) {
                        continue;
                    }
                    Preconditions.checkState((status != null ? 1 : 0) != 0, (Object)"algorithm should run at least once.");
                    if (status.isSound() && !FluentIterable.from((Iterable)currentReached).anyMatch(Predicates.or(AbstractStates::isTargetState, AbstractStates::hasAssumptions))) {
                        oldReachedSet = (ReachedSet)oldReached.get();
                        if (oldReachedSet != null) {
                            this.aggregatedReachedSetManager.updateReachedSet((UnmodifiableReachedSet)oldReachedSet, currentReached);
                        } else {
                            this.aggregatedReachedSetManager.addReachedSet(currentReached);
                        }
                        return ParallelAnalysisResult.of(currentReached, status, analysisName);
                    }
                    stopAnalysis = true;
                    for (ReachedSetAdjustingCPA innerCpa : CPAs.asIterable(cpa).filter(ReachedSetAdjustingCPA.class)) {
                        if (!innerCpa.adjustPrecision()) continue;
                        singleLogger.log(Level.INFO, new Object[]{"Adjusting precision for CPA", innerCpa});
                        stopAnalysis = false;
                    }
                    for (ConditionAdjustmentEventSubscriber conditionAdjustmentEventSubscriber : this.conditionAdjustmentEventSubscribers) {
                        if (stopAnalysis) {
                            conditionAdjustmentEventSubscriber.adjustmentRefused(cpa);
                            continue;
                        }
                        conditionAdjustmentEventSubscriber.adjustmentSuccessful(cpa);
                    }
                    if (status.isSound()) {
                        singleLogger.log(Level.INFO, new Object[]{"Updating reached set provided to other analyses"});
                        oldReachedSet = (ReachedSet)oldReached.get();
                        if (oldReachedSet != null) {
                            this.aggregatedReachedSetManager.updateReachedSet((UnmodifiableReachedSet)oldReachedSet, currentReached);
                        } else {
                            this.aggregatedReachedSetManager.addReachedSet(currentReached);
                        }
                        oldReached.set(currentReached);
                    }
                    if (!stopAnalysis) {
                        currentReached = coreComponents.createReachedSet(cpa);
                        pStatisticsEntry.reachedSet.set(currentReached);
                        this.initializeReachedSet(cpa, this.mainEntryNode, currentReached);
                    }
                    if (stopAnalysis) break;
                }
            }
            if (!currentReached.hasWaitingState() && supplyReached && !supplyRefinableReached && status.isPrecise() && status.isSound()) {
                this.aggregatedReachedSetManager.addReachedSet(currentReached);
            }
            return ParallelAnalysisResult.of(currentReached, status, analysisName);
        }
        catch (InterruptedException e) {
            singleLogger.log(Level.INFO, new Object[]{"Analysis was terminated"});
            return ParallelAnalysisResult.absent(analysisName);
        }
    }

    private @Nullable Configuration createSingleConfig(Path singleConfigFileName, LogManager pLogger) {
        try {
            ConfigurationBuilder singleConfigBuilder = Configuration.builder();
            singleConfigBuilder.copyFrom(this.globalConfig);
            singleConfigBuilder.clearOption("parallelAlgorithm.configFiles");
            singleConfigBuilder.clearOption("analysis.useParallelAnalyses");
            singleConfigBuilder.loadFromFile(singleConfigFileName);
            Configuration singleConfig = singleConfigBuilder.build();
            NestingAlgorithm.checkConfigs(this.globalConfig, singleConfig, singleConfigFileName, this.logger);
            return singleConfig;
        }
        catch (IOException | InvalidConfigurationException e) {
            pLogger.logUserException(Level.WARNING, e, "Skipping one analysis because the configuration file " + singleConfigFileName + " could not be read");
            return null;
        }
    }

    private void initializeReachedSet(ConfigurableProgramAnalysis cpa, CFANode mainFunction, ReachedSet reached) throws InterruptedException {
        AbstractState initialState = cpa.getInitialState(mainFunction, StateSpacePartition.getDefaultPartition());
        Precision initialPrecision = cpa.getInitialPrecision(mainFunction, StateSpacePartition.getDefaultPartition());
        reached.add(initialState, initialPrecision);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    public static interface ConditionAdjustmentEventSubscriber {
        public void adjustmentSuccessful(ConfigurableProgramAnalysis var1);

        public void adjustmentRefused(ConfigurableProgramAnalysis var1);
    }

    public static interface ReachedSetUpdater {
        public void register(ReachedSetUpdateListener var1);

        public void unregister(ReachedSetUpdateListener var1);
    }

    public static interface ReachedSetUpdateListener {
        public void updated(ReachedSet var1);
    }

    private static class StatisticsEntry {
        private final Collection<Statistics> subStatistics;
        private final AtomicReference<ReachedSet> reachedSet;
        private final String name;
        private final @Nullable ThreadCpuTimeLimit rLimit;
        private final AtomicBoolean terminated;

        public StatisticsEntry(Collection<Statistics> pSubStatistics, ReachedSet pReachedSet, String pName, @Nullable ThreadCpuTimeLimit pRLimit, AtomicBoolean pTerminated) {
            this.subStatistics = Objects.requireNonNull(pSubStatistics);
            this.reachedSet = new AtomicReference<ReachedSet>(Objects.requireNonNull(pReachedSet));
            this.name = Objects.requireNonNull(pName);
            this.rLimit = pRLimit;
            this.terminated = Objects.requireNonNull(pTerminated);
        }
    }

    private static class ParallelAlgorithmStatistics
    implements Statistics {
        private final LogManager logger;
        private final List<StatisticsEntry> allAnalysesStats = new CopyOnWriteArrayList<StatisticsEntry>();
        private int noOfAlgorithmsUsed = 0;
        private String successfulAnalysisName = null;

        ParallelAlgorithmStatistics(LogManager pLogger) {
            this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        }

        public synchronized StatisticsEntry getNewSubStatistics(ReachedSet pReached, String pName, @Nullable ThreadCpuTimeLimit pRLimit, AtomicBoolean pTerminated) {
            CopyOnWriteArrayList<Statistics> subStats = new CopyOnWriteArrayList<Statistics>();
            StatisticsEntry entry = new StatisticsEntry(subStats, pReached, pName, pRLimit, pTerminated);
            this.allAnalysesStats.add(entry);
            return entry;
        }

        @Override
        public String getName() {
            return "Parallel Algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            out.println("Number of algorithms used:        " + this.noOfAlgorithmsUsed);
            if (this.successfulAnalysisName != null) {
                out.println("Successful analysis: " + this.successfulAnalysisName);
            }
            this.printSubStatistics(out, result);
        }

        private void printSubStatistics(PrintStream pOut, CPAcheckerResult.Result pResult) {
            for (StatisticsEntry subStats : this.allAnalysesStats) {
                boolean terminated;
                pOut.println();
                pOut.println();
                String title = "Statistics for: " + subStats.name;
                pOut.println(title);
                pOut.println("=".repeat(title.length()));
                if (subStats.rLimit != null) {
                    pOut.println("Time spent in analysis thread " + subStats.name + ": " + subStats.rLimit.getOverallUsedTime().formatAs(TimeUnit.SECONDS));
                }
                if (terminated = subStats.terminated.get()) {
                    CPAcheckerResult.Result result = this.determineAnalysisResult(pResult, subStats.name);
                    for (Statistics s : subStats.subStatistics) {
                        StatisticsUtils.printStatistics(s, pOut, this.logger, result, subStats.reachedSet.get());
                    }
                    continue;
                }
                this.logger.log(Level.INFO, new Object[]{"Cannot print statistics for", subStats.name, "because it is still running."});
            }
            pOut.println("\n");
            pOut.println("Other statistics");
            pOut.println("================");
        }

        @Override
        public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            StatisticsEntry successfullAnalysisStats = null;
            for (StatisticsEntry subStats : this.allAnalysesStats) {
                if (this.isSuccessfulAnalysis(subStats)) {
                    successfullAnalysisStats = subStats;
                    continue;
                }
                this.writeSubOutputFiles(pResult, subStats);
            }
            if (successfullAnalysisStats != null) {
                this.writeSubOutputFiles(pResult, successfullAnalysisStats);
            }
        }

        private void writeSubOutputFiles(CPAcheckerResult.Result pResult, StatisticsEntry pSubStats) {
            if (pSubStats.terminated.get()) {
                CPAcheckerResult.Result result = this.determineAnalysisResult(pResult, pSubStats.name);
                for (Statistics s : pSubStats.subStatistics) {
                    StatisticsUtils.writeOutputFiles(s, this.logger, result, pSubStats.reachedSet.get());
                }
            }
        }

        private boolean isSuccessfulAnalysis(StatisticsEntry pStatEntry) {
            return this.successfulAnalysisName != null && this.successfulAnalysisName.equals(pStatEntry.name);
        }

        private CPAcheckerResult.Result determineAnalysisResult(CPAcheckerResult.Result pResult, String pActualAnalysisName) {
            if (this.successfulAnalysisName != null && !this.successfulAnalysisName.equals(pActualAnalysisName)) {
                if (pResult == CPAcheckerResult.Result.TRUE) {
                    return CPAcheckerResult.Result.UNKNOWN;
                }
                return CPAcheckerResult.Result.DONE;
            }
            return pResult;
        }
    }

    private static class ParallelAnalysisResult {
        private final @Nullable ReachedSet reached;
        private final @Nullable Algorithm.AlgorithmStatus status;
        private final String analysisName;

        private ParallelAnalysisResult(@Nullable ReachedSet pReached, @Nullable Algorithm.AlgorithmStatus pStatus, String pAnalysisName) {
            this.reached = pReached;
            this.status = pStatus;
            this.analysisName = pAnalysisName;
        }

        public static ParallelAnalysisResult of(ReachedSet pReached, Algorithm.AlgorithmStatus pStatus, String pAnalysisName) {
            return new ParallelAnalysisResult(pReached, pStatus, pAnalysisName);
        }

        public static ParallelAnalysisResult absent(String pAnalysisName) {
            return new ParallelAnalysisResult(null, null, pAnalysisName);
        }

        public boolean hasValidReachedSet() {
            if (this.reached == null || this.status == null) {
                return false;
            }
            return this.status.isPrecise() && FluentIterable.from((Iterable)this.reached).anyMatch(AbstractStates::isTargetState) || (this.status.isSound() || !this.status.wasPropertyChecked()) && !this.reached.hasWaitingState() && !FluentIterable.from((Iterable)this.reached).anyMatch(Predicates.or(AbstractStates::hasAssumptions, AbstractStates::isTargetState));
        }

        public @Nullable ReachedSet getReached() {
            return this.reached;
        }

        public @Nullable Algorithm.AlgorithmStatus getStatus() {
            return this.status;
        }

        public String getAnalysisName() {
            return this.analysisName;
        }
    }
}

