/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.AssumptionCollectorAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.splitter.SplitInfoState;
import org.sosy_lab.cpachecker.cpa.splitter.SplitterCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="program.splitter")
public class ProgramSplitAlgorithm
implements Algorithm,
StatisticsProvider,
Statistics {
    @Option(secure=true, name="exportAsCondition", description="export program splitting as conditions (assumption automata)")
    private boolean exportCondition = true;
    @Option(secure=true, name="conditionFile", description="where to export conditions")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate conditionPathFile = PathTemplate.ofFormatString((String)"Condition.%d.txt");
    private final LogManager logger;
    private final Algorithm innerAlgorithm;
    private final int numSplits;
    private final ShutdownNotifier shutdownNotifier;
    private final Timer determineSplitTime = new Timer();
    private final Timer extractSplitTime = new Timer();
    private final List<Set<ARGState>> splitConditions;
    private boolean extractionComplete = false;

    public ProgramSplitAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCpa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.innerAlgorithm = pAlgorithm;
        this.shutdownNotifier = pShutdownNotifier;
        SplitterCPA splitterCPA = CPAs.retrieveCPAOrFail(pCpa, SplitterCPA.class, this.getClass());
        this.numSplits = splitterCPA.getMaximalSplitNumber();
        this.splitConditions = new ArrayList<Set<ARGState>>(this.numSplits);
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        Preconditions.checkArgument((boolean)(pReachedSet.getFirstState() instanceof ARGState), (Object)"ProgramSplitAlgorithm requires ARG state as top level state.");
        this.logger.log(Level.INFO, new Object[]{"Determining program splitting."});
        this.determineSplitTime.start();
        try {
            this.innerAlgorithm.run(pReachedSet);
        }
        finally {
            this.determineSplitTime.stop();
        }
        if (pReachedSet.hasWaitingState()) {
            this.logger.log(Level.WARNING, new Object[]{"The computation of the program splitting is not complete. The result remains a proper splitting, but may not be the expected one."});
        }
        this.shutdownNotifier.shutdownIfNecessary();
        this.logger.log(Level.INFO, new Object[]{"Extract description of each part of the program split."});
        this.extractSplitTime.start();
        try {
            this.extractSplitConditions(pReachedSet);
        }
        finally {
            this.extractSplitTime.stop();
        }
        return Algorithm.AlgorithmStatus.SOUND_AND_IMPRECISE;
    }

    private void extractSplitConditions(ReachedSet pReached) throws InterruptedException {
        this.extractionComplete = false;
        int i = 0;
        while (i < this.numSplits) {
            int index = i++;
            this.shutdownNotifier.shutdownIfNecessary();
            this.splitConditions.add(new HashSet(FluentIterable.from((Iterable)pReached).filter(state -> AbstractStates.extractStateByType(state, SplitInfoState.class).isInSplit(index)).filter(ARGState.class).toSet()));
        }
        this.extractionComplete = true;
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        StatisticsWriter statsWriter = StatisticsWriter.writingStatisticsTo(pOut);
        statsWriter.put("Number of splits", this.numSplits);
        statsWriter.put("Time to determine split", this.determineSplitTime);
        statsWriter.put("Time to extract split", this.extractSplitTime);
    }

    @Override
    public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        if (this.extractionComplete) {
            if (this.exportCondition) {
                this.exportSplitConditionsToFiles((ARGState)pReached.getFirstState());
            }
        } else {
            this.logger.log(Level.INFO, new Object[]{"Extraction of program splitting incomplete. Do not extract the splitting."});
        }
    }

    private void exportSplitConditionsToFiles(ARGState pInitialState) {
        try {
            int i = 0;
            for (Set<ARGState> splitConditionStates : this.splitConditions) {
                Path condFile = this.conditionPathFile.getPath(new Object[]{++i});
                condFile = condFile.resolveSibling(condFile.getFileName() + ".gz");
                HashSet falseAssumptionStates = new HashSet(FluentIterable.from(splitConditionStates).filter(state -> state.getChildren().isEmpty()).toSet());
                IO.writeGZIPFile((Path)condFile, (Charset)Charset.defaultCharset(), appendable -> AssumptionCollectorAlgorithm.writeAutomaton(appendable, pInitialState, splitConditionStates, falseAssumptionStates, 0, true, false));
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, new Object[]{"Failed to write a condition reflecting a part of program split. Abort writting conditions describing program splitting.", e});
        }
    }

    @Override
    public @Nullable String getName() {
        return "Program Splitter";
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this);
        if (this.innerAlgorithm instanceof Statistics) {
            pStatsCollection.add((Statistics)((Object)this.innerAlgorithm));
        }
    }
}

