/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Property;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.cpachecker.util.testcase.TestCaseExporter;

@Options(prefix="testcase")
public class RandomTestGeneratorAlgorithm
implements Algorithm,
StatisticsProvider,
Statistics {
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Configuration config;
    private final CFA cfa;
    private final Property specProp;
    private int numExportedTestCases = 0;
    private StatInt testCaseLengths = new StatInt(StatKind.AVG, "Average test case length");
    @Option(secure=true, description="Random seed for random test-case generation")
    private long randomInputSeed = 0L;
    @Option(secure=true, description="Number of random test cases that should be generated")
    private int numRandomTests = 1;
    @Option(secure=true, name="random.maxLength", description="Number of random test cases that should be generated")
    private int maxLength = 20;
    @Option(secure=true, name="random.min", description="Minimum value randomly generated")
    private int minVal = 0;
    @Option(secure=true, name="random.max", description="Maximum value randomly generated")
    private int maxVal = 20;

    public RandomTestGeneratorAlgorithm(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa, Specification pSpec) throws InvalidConfigurationException {
        this.config = pConfig;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCfa;
        this.config.inject((Object)this);
        this.numRandomTests = Math.max(this.numRandomTests, 0);
        this.maxVal = Math.max(this.minVal + 1, this.maxVal);
        if (pSpec.getProperties().size() == 1) {
            this.specProp = pSpec.getProperties().iterator().next();
            Preconditions.checkArgument((boolean)this.specProp.isCoverage(), (String)"Property %s not supported for test generation", (Object)this.specProp);
        } else {
            this.specProp = null;
        }
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        this.logger.log(Level.INFO, new Object[]{"Start generating", this.numRandomTests, "random tests"});
        try {
            TestCaseExporter exporter = new TestCaseExporter(this.cfa, this.logger, this.config);
            Random randomGenerator = new Random(this.randomInputSeed);
            PrimitiveIterator.OfInt randomInt = randomGenerator.ints(this.minVal, this.maxVal).iterator();
            ArrayList<String> inputs = new ArrayList<String>();
            block2: for (int i = 0; i < this.numRandomTests; ++i) {
                this.shutdownNotifier.shutdownIfNecessary();
                int testLength = randomGenerator.nextInt(this.maxLength + 1);
                this.testCaseLengths.setNextValue(testLength);
                inputs.clear();
                for (int j = 0; j < testLength; ++j) {
                    this.shutdownNotifier.shutdownIfNecessary();
                    if (!randomInt.hasNext()) break block2;
                    inputs.add(String.valueOf(randomInt.nextInt()));
                }
                this.shutdownNotifier.shutdownIfNecessary();
                this.logger.log(Level.FINE, new Object[]{"Export test case of length ", testLength});
                exporter.writeTestCaseFiles(inputs, Optional.ofNullable(this.specProp));
                ++this.numExportedTestCases;
            }
            this.logger.log(Level.INFO, new Object[]{"Finished random test generation"});
        }
        catch (InvalidConfigurationException e) {
            this.logger.logException(Level.INFO, (Throwable)e, "Abort test generation due to wrong configuration");
        }
        return Algorithm.AlgorithmStatus.NO_PROPERTY_CHECKED;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this);
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        StatisticsWriter statWriter = StatisticsWriter.writingStatisticsTo(pOut);
        statWriter.put(this.testCaseLengths).put("Generated random tests", this.numExportedTestCases);
    }

    @Override
    public @Nullable String getName() {
        return "RandomTestGeneratorAlgorithm";
    }
}

