/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.common.configuration.AnnotatedValue;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.NestingAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.ParallelAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.pcc.PartialARGsCombiner;
import org.sosy_lab.cpachecker.core.defaults.MultiStatistics;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Triple;

@Options(prefix="restartAlgorithm")
public class RestartAlgorithm
extends NestingAlgorithm
implements ParallelAlgorithm.ReachedSetUpdater {
    @Option(secure=true, required=true, description="List of files with configurations to use. A filename can be suffixed with :if-interrupted, :if-failed, and :if-terminated which means that this configuration will only be used if the previous configuration ended with a matching condition. What also can be added is :use-reached then the reached set of the preceding analysis is taken and provided to the next analysis.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private List<AnnotatedValue<Path>> configFiles;
    @Option(secure=true, name="combineARGsAfterRestart", description="combine (partial) ARGs obtained by restarts of the analysis after an unknown result with a different configuration")
    private boolean useARGCombiningAlgorithm = false;
    @Option(secure=true, description="print the statistics of each component of the restart algorithm directly after the components computation is finished")
    private boolean printIntermediateStatistics = true;
    @Option(secure=true, description="let each component of the restart algorithm write output files and not only the last one that is excuted")
    private boolean writeIntermediateOutputFiles = false;
    @Option(secure=true, description="wether to start next algorithm independently from the previous result")
    private boolean alwaysRestart = false;
    private final ShutdownNotifier.ShutdownRequestListener logShutdownListener;
    private final RestartAlgorithmStatistics stats;
    private final CFA cfa;
    private Algorithm currentAlgorithm;
    private final List<ParallelAlgorithm.ReachedSetUpdateListener> reachedSetUpdateListeners = new CopyOnWriteArrayList<ParallelAlgorithm.ReachedSetUpdateListener>();
    private final Collection<ParallelAlgorithm.ReachedSetUpdateListener> reachedSetUpdateListenersAdded = new ArrayList<ParallelAlgorithm.ReachedSetUpdateListener>();

    private RestartAlgorithm(Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Specification pSpecification, CFA pCfa) throws InvalidConfigurationException {
        super(config, pLogger, pShutdownNotifier, pSpecification);
        config.inject((Object)this);
        this.cfa = pCfa;
        if (this.configFiles.isEmpty()) {
            throw new InvalidConfigurationException("Need at least one configuration for restart algorithm!");
        }
        this.stats = new RestartAlgorithmStatistics(this.configFiles.size(), pLogger);
        this.logShutdownListener = reason -> this.logger.logf(Level.WARNING, "Shutdown of analysis %d requested (%s).", new Object[]{this.stats.noOfAlgorithmsUsed, reason});
    }

    public static Algorithm create(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Specification pSpecification, CFA pCfa) throws InvalidConfigurationException {
        RestartAlgorithm algorithm = new RestartAlgorithm(pConfig, pLogger, pShutdownNotifier, pSpecification, pCfa);
        if (algorithm.useARGCombiningAlgorithm) {
            return new PartialARGsCombiner(algorithm, pConfig, pLogger, pShutdownNotifier);
        }
        return algorithm;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReached) throws CPAException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Encoding is irrelevant for null output stream")
    @SuppressForbidden(value="System.out is correct for statistics")
    private void printIntermediateStatistics(ReachedSet currentReached) {
        if (this.printIntermediateStatistics) {
            this.stats.printIntermediateStatistics(System.out, CPAcheckerResult.Result.UNKNOWN, currentReached);
        } else {
            PrintStream dummyStream = new PrintStream(ByteStreams.nullOutputStream());
            this.stats.printIntermediateStatistics(dummyStream, CPAcheckerResult.Result.UNKNOWN, currentReached);
        }
        if (this.writeIntermediateOutputFiles) {
            this.stats.writeOutputFiles(CPAcheckerResult.Result.UNKNOWN, currentReached);
        }
    }

    private Triple<Algorithm, ConfigurableProgramAnalysis, ReachedSet> createNextAlgorithm(Path singleConfigFileName, CFANode pInitialNode, CFA pCfa, ShutdownManager singleShutdownManager, boolean pProvideReachedForNextAlgorithm, ReachedSet pCurrentReached) throws InvalidConfigurationException, CPAException, IOException, InterruptedException {
        AggregatedReachedSets aggregateReached = pProvideReachedForNextAlgorithm && pCurrentReached != null ? AggregatedReachedSets.singleton(pCurrentReached) : AggregatedReachedSets.empty();
        return super.createAlgorithm(singleConfigFileName, pInitialNode, pCfa, singleShutdownManager, aggregateReached, Sets.newHashSet((Object[])new String[]{"restartAlgorithm.configFiles", "analysis.restartAfterUnknown"}), this.stats.getSubStatistics());
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.currentAlgorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.currentAlgorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    @Override
    public void register(ParallelAlgorithm.ReachedSetUpdateListener pReachedSetUpdateListener) {
        this.reachedSetUpdateListeners.add(pReachedSetUpdateListener);
    }

    @Override
    public void unregister(ParallelAlgorithm.ReachedSetUpdateListener pReachedSetUpdateListener) {
        this.reachedSetUpdateListeners.remove(pReachedSetUpdateListener);
    }

    private void registerReachedSetUpdateListeners() {
        Preconditions.checkState((boolean)this.reachedSetUpdateListenersAdded.isEmpty());
        if (this.currentAlgorithm instanceof ParallelAlgorithm.ReachedSetUpdater) {
            ParallelAlgorithm.ReachedSetUpdater algorithm = (ParallelAlgorithm.ReachedSetUpdater)((Object)this.currentAlgorithm);
            for (ParallelAlgorithm.ReachedSetUpdateListener listener : this.reachedSetUpdateListeners) {
                algorithm.register(listener);
                this.reachedSetUpdateListenersAdded.add(listener);
            }
        }
    }

    private void unregisterReachedSetUpdateListeners() {
        if (this.currentAlgorithm instanceof ParallelAlgorithm.ReachedSetUpdater) {
            ParallelAlgorithm.ReachedSetUpdater algorithm = (ParallelAlgorithm.ReachedSetUpdater)((Object)this.currentAlgorithm);
            for (ParallelAlgorithm.ReachedSetUpdateListener listener : this.reachedSetUpdateListenersAdded) {
                algorithm.unregister(listener);
            }
            this.reachedSetUpdateListenersAdded.clear();
        } else {
            Preconditions.checkState((boolean)this.reachedSetUpdateListenersAdded.isEmpty());
        }
        assert (this.reachedSetUpdateListenersAdded.isEmpty());
    }

    private static class RestartAlgorithmStatistics
    extends MultiStatistics {
        private final int noOfAlgorithms;
        private int noOfAlgorithmsUsed = 0;
        private Timer totalTime = new Timer();

        public RestartAlgorithmStatistics(int pNoOfAlgorithms, LogManager pLogger) {
            super(pLogger);
            this.noOfAlgorithms = pNoOfAlgorithms;
        }

        @Override
        public void resetSubStatistics() {
            super.resetSubStatistics();
            this.totalTime = new Timer();
        }

        @Override
        public String getName() {
            return "Restart Algorithm";
        }

        private void printIntermediateStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
            String text = "Statistics for algorithm " + this.noOfAlgorithmsUsed + " of " + this.noOfAlgorithms;
            out.println(text);
            out.println("=".repeat(text.length()));
            this.printSubStatistics(out, result, reached);
            out.println();
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            out.println("Number of algorithms provided:    " + this.noOfAlgorithms);
            out.println("Number of algorithms used:        " + this.noOfAlgorithmsUsed);
            this.printSubStatistics(out, result, reached);
        }

        private void printSubStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            out.println("Total time for algorithm " + this.noOfAlgorithmsUsed + ": " + this.totalTime);
            super.printStatistics(out, result, reached);
        }
    }
}

