/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AdjustableConditionCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageCPA;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;

@Options(prefix="adjustableconditions")
public class RestartWithConditionsAlgorithm
implements Algorithm {
    private final Algorithm innerAlgorithm;
    private final LogManager logger;
    private final ARGCPA cpa;
    private final List<? extends AdjustableConditionCPA> conditionCPAs;
    @Option(secure=true, description="maximum number of condition adjustments (-1 for infinite)")
    @IntegerOption(min=-1L)
    private int adjustmentLimit = -1;

    public RestartWithConditionsAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCpa, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.innerAlgorithm = pAlgorithm;
        if (!(pCpa instanceof ARGCPA)) {
            throw new InvalidConfigurationException("ARGCPA needed for RestartWithConditionsAlgorithm");
        }
        this.cpa = (ARGCPA)pCpa;
        if (this.cpa.retrieveWrappedCpa(AssumptionStorageCPA.class) == null) {
            throw new InvalidConfigurationException("AssumptionStorageCPA needed for RestartWithConditionsAlgorithm");
        }
        this.conditionCPAs = CPAs.asIterable(this.cpa).filter(AdjustableConditionCPA.class).toList();
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReached) throws CPAException, InterruptedException {
        Algorithm.AlgorithmStatus status = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        int count = 0;
        do {
            status = status.update(this.innerAlgorithm.run(pReached));
            if (pReached.wasTargetReached() && status.isPrecise()) {
                return status;
            }
            if (this.adjustmentLimit >= 0 && ++count > this.adjustmentLimit) {
                this.logger.log(Level.INFO, new Object[]{"Terminating because adjustment limit has been reached."});
                return status;
            }
            List<AbstractState> statesWithAssumptions = this.getStatesWithAssumptions(pReached);
            if (!statesWithAssumptions.isEmpty()) {
                this.logger.log(Level.INFO, new Object[]{"Adjusting heuristics thresholds."});
                this.adjustThresholds(statesWithAssumptions, pReached);
            }
            for (AdjustableConditionCPA adjustableConditionCPA : this.conditionCPAs) {
                if (adjustableConditionCPA.adjustPrecision()) continue;
                this.logger.log(Level.INFO, new Object[]{"Terminating because of", adjustableConditionCPA.getClass().getSimpleName()});
                return status;
            }
        } while (pReached.hasWaitingState());
        return status;
    }

    private List<AbstractState> getStatesWithAssumptions(ReachedSet reached) {
        ArrayList<AbstractState> retList = new ArrayList<AbstractState>();
        for (AbstractState state : reached) {
            AssumptionStorageState s = AbstractStates.extractStateByType(state, AssumptionStorageState.class);
            if (s.isAssumptionTrue() && s.isStopFormulaTrue()) continue;
            retList.add(state);
        }
        return retList;
    }

    private void adjustThresholds(List<AbstractState> pStatesWithAssumptions, ReachedSet pReached) throws InterruptedException {
        ARGReachedSet reached = new ARGReachedSet(pReached, this.cpa);
        for (AbstractState s : pStatesWithAssumptions) {
            ARGState argState = (ARGState)s;
            for (ARGState parent : ImmutableSet.copyOf(argState.getParents())) {
                reached.removeSubtree(parent);
            }
        }
    }
}

