/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.NestingAlgorithm;
import org.sosy_lab.cpachecker.core.defaults.MultiStatistics;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

@Options(prefix="heuristicSelection")
public class SelectionAlgorithm
extends NestingAlgorithm {
    private Algorithm preAnalysisAlgorithm;
    private ReachedSet preAnalysisReachedSet;
    private final SelectionAlgorithmStatistics stats;
    @Option(secure=true, description="Configuration for preliminary algorithm.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path preAnalysisAlgorithmConfig = null;
    @Option(secure=true, description="Configuration for programs containing recursion.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path recursionConfig;
    @Option(secure=true, description="Configuration for loop-free programs.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path loopFreeConfig;
    @Option(secure=true, description="Configuration for programs with a single loop.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path singleLoopConfig;
    @Option(secure=true, required=true, description="Configuration for programs with loops.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path loopConfig;
    @Option(secure=true, description="Configuration for programs with loops and complex datastructures.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path complexLoopConfig;
    @Option(secure=true, description="Configuration for programs containing only relevant bool vars.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path onlyBoolConfig;
    @Option(secure=true, description="Configuration for programs containing more than @Option adressedRatio addressed vars.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path addressedConfig;
    @Option(secure=true, description="Configuration for programs containing composite types.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path compositeTypeConfig;
    @Option(secure=true, description="Configuration for programs containing arrays.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path arrayConfig;
    @Option(secure=true, description="Ratio of addressed vars. Values bigger than the passed value lead to @option addressedConfig.")
    private double addressedRatio = 0.0;
    private final CFA cfa;

    public SelectionAlgorithm(CFA pCfa, ShutdownNotifier pShutdownNotifier, Configuration pConfig, Specification pSpecification, LogManager pLogger) throws InvalidConfigurationException {
        super(pConfig, pLogger, pShutdownNotifier, pSpecification);
        pConfig.inject((Object)this);
        this.cfa = pCfa;
        this.stats = new SelectionAlgorithmStatistics(pLogger);
    }

    private Algorithm.AlgorithmStatus performPreAnalysisAlgorithm() throws CPAException, InterruptedException {
        Triple<Algorithm, ConfigurableProgramAnalysis, ReachedSet> preAnaAlg;
        String info = "Performing preliminary analysis algorithm ...";
        this.logger.log(Level.INFO, new Object[]{info});
        Path preAnalysisConfig = this.preAnalysisAlgorithmConfig;
        ShutdownManager shutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier);
        try {
            preAnaAlg = this.createAlgorithm(preAnalysisConfig, this.cfa.getMainFunction(), this.cfa, shutdownManager);
        }
        catch (InvalidConfigurationException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Skipping preAnalysisAlgorithm because the configuration file " + preAnalysisConfig + " is invalid");
            return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
        }
        catch (IOException e) {
            String message = "Skipping preAnalysisAlgorithm because the configuration file " + preAnalysisConfig + " could not be read";
            if (this.shutdownNotifier.shouldShutdown() && e instanceof ClosedByInterruptException) {
                this.logger.log(Level.WARNING, new Object[]{message});
            } else {
                this.logger.logUserException(Level.WARNING, (Throwable)e, message);
            }
            return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
        }
        this.preAnalysisAlgorithm = preAnaAlg.getFirst();
        this.preAnalysisReachedSet = preAnaAlg.getThird();
        return this.preAnalysisAlgorithm.run(this.preAnalysisReachedSet);
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        Preconditions.checkArgument((boolean)(pReachedSet instanceof ForwardingReachedSet), (Object)"SelectionAlgorithm needs ForwardingReachedSet");
        Preconditions.checkArgument((pReachedSet.size() <= 1 ? 1 : 0) != 0, (Object)"SelectionAlgorithm does not support being called several times with the same reached set");
        Preconditions.checkArgument((!pReachedSet.isEmpty() ? 1 : 0) != 0, (Object)"SelectionAlgorithm needs non-empty reached set");
        Preconditions.checkArgument((boolean)this.cfa.getVarClassification().isPresent(), (Object)"SelectionAlgorithm requires variable classification");
        this.extractStatisticsFromCfa();
        Path chosenConfig = this.chooseConfig();
        return this.run0(pReachedSet, chosenConfig);
    }

    private void extractStatisticsFromCfa() throws CPAException {
        SelectionAlgorithmCFAVisitor visitor = new SelectionAlgorithmCFAVisitor();
        FunctionEntryNode startingNode = this.cfa.getMainFunction();
        CFATraversal.dfs().traverseOnce(startingNode, visitor);
        for (String name : visitor.functionNames) {
            if (this.cfa.getAllFunctionNames().contains(name)) continue;
            this.stats.containsExternalFunctionCalls = true;
        }
        this.stats.numberOfAllRightFunctions = visitor.functionNames.size();
        if (this.preAnalysisAlgorithmConfig != null) {
            try {
                this.performPreAnalysisAlgorithm();
            }
            catch (UnsupportedCodeException e) {
                if (e.getMessage().contains("recursion")) {
                    this.stats.requiresRecursionHandling = true;
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.stats.sizeOfPreAnaReachedSet = this.preAnalysisReachedSet.size();
        }
        Optional<LoopStructure> loopStructure = this.cfa.getLoopStructure();
        VariableClassification variableClassification = this.cfa.getVarClassification().orElseThrow();
        if (!variableClassification.getRelevantVariables().isEmpty()) {
            this.stats.relevantBoolRatio = (double)Sets.intersection(variableClassification.getIntBoolVars(), variableClassification.getRelevantVariables()).size() / (double)variableClassification.getRelevantVariables().size();
            this.stats.relevantAddressedRatio = (double)Sets.intersection(variableClassification.getAddressedVariables(), variableClassification.getRelevantVariables()).size() / (double)variableClassification.getRelevantVariables().size();
        }
        this.stats.requiresOnlyRelevantBoolsHandling = variableClassification.getIntBoolVars().containsAll(variableClassification.getRelevantVariables());
        this.stats.requiresAliasHandling = !variableClassification.getAddressedVariables().isEmpty() || !variableClassification.getAddressedFields().isEmpty();
        this.stats.requiresLoopHandling = !loopStructure.isPresent() || !loopStructure.orElseThrow().getAllLoops().isEmpty();
        this.stats.requiresCompositeTypeHandling = !variableClassification.getRelevantFields().isEmpty();
        this.stats.requiresArrayHandling = !Collections.disjoint(variableClassification.getRelevantVariables(), visitor.arrayVariables) || !Collections.disjoint(variableClassification.getAddressedFields().values(), visitor.arrayVariables);
        this.stats.requiresFloatHandling = !Collections.disjoint(variableClassification.getRelevantVariables(), visitor.floatVariables) || !Collections.disjoint(variableClassification.getAddressedFields().values(), visitor.floatVariables);
        this.stats.hasSingleLoop = loopStructure.isPresent() && loopStructure.orElseThrow().getAllLoops().size() == 1;
    }

    private Path chooseConfig() {
        String info = "Performing heuristic ...";
        this.logger.log(Level.INFO, new Object[]{info});
        Path chosenConfig = this.stats.requiresRecursionHandling && this.recursionConfig != null ? this.recursionConfig : (!this.stats.requiresLoopHandling && this.loopFreeConfig != null ? this.loopFreeConfig : (this.stats.requiresOnlyRelevantBoolsHandling && this.onlyBoolConfig != null ? this.onlyBoolConfig : (this.stats.relevantAddressedRatio > this.addressedRatio && this.addressedConfig != null ? this.addressedConfig : (this.stats.requiresCompositeTypeHandling && this.compositeTypeConfig != null ? this.compositeTypeConfig : (this.stats.requiresArrayHandling && this.arrayConfig != null ? this.arrayConfig : ((this.stats.requiresFloatHandling || this.stats.requiresArrayHandling || this.stats.requiresCompositeTypeHandling) && this.complexLoopConfig != null ? this.complexLoopConfig : (this.stats.hasSingleLoop && this.singleLoopConfig != null ? this.singleLoopConfig : this.loopConfig)))))));
        this.stats.chosenConfig = chosenConfig.toString();
        return chosenConfig;
    }

    private Algorithm.AlgorithmStatus run0(ReachedSet pReachedSet, Path chosenConfig) throws CPAException, InterruptedException {
        Triple<Algorithm, ConfigurableProgramAnalysis, ReachedSet> currentAlg;
        ShutdownManager shutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier);
        try {
            currentAlg = this.createAlgorithm(chosenConfig, this.cfa.getMainFunction(), this.cfa, shutdownManager);
        }
        catch (InvalidConfigurationException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Skipping SelectionAlgorithm because the configuration file " + chosenConfig + " is invalid");
            return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
        }
        catch (IOException e) {
            String message = "Skipping SelectionAlgorithm because the configuration file " + chosenConfig + " could not be read";
            if (this.shutdownNotifier.shouldShutdown() && e instanceof ClosedByInterruptException) {
                this.logger.log(Level.WARNING, new Object[]{message});
            } else {
                this.logger.logUserException(Level.WARNING, (Throwable)e, message);
            }
            return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
        }
        Algorithm chosenAlgorithm = currentAlg.getFirst();
        ReachedSet reachedSetForChosenAnalysis = currentAlg.getThird();
        ForwardingReachedSet reached = (ForwardingReachedSet)pReachedSet;
        reached.setDelegate(reachedSetForChosenAnalysis);
        return chosenAlgorithm.run(reachedSetForChosenAnalysis);
    }

    private Triple<Algorithm, ConfigurableProgramAnalysis, ReachedSet> createAlgorithm(Path singleConfigFileName, CFANode pInitialNode, CFA pCfa, ShutdownManager singleShutdownManager) throws InvalidConfigurationException, CPAException, IOException, InterruptedException {
        AggregatedReachedSets aggregateReached = AggregatedReachedSets.empty();
        return super.createAlgorithm(singleConfigFileName, pInitialNode, pCfa, singleShutdownManager, aggregateReached, (Collection<String>)ImmutableSet.of((Object)"analysis.selectAnalysisHeuristically"), this.stats.getSubStatistics());
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private static class SelectionAlgorithmStatistics
    extends MultiStatistics {
        private int sizeOfPreAnaReachedSet = 0;
        private String chosenConfig = "";
        private double relevantBoolRatio = 0.0;
        private double relevantAddressedRatio = 0.0;
        private boolean containsExternalFunctionCalls = false;
        private int numberOfAllRightFunctions = 0;
        private boolean requiresOnlyRelevantBoolsHandling = false;
        private boolean requiresAliasHandling = false;
        private boolean requiresLoopHandling = false;
        private boolean requiresCompositeTypeHandling = false;
        private boolean requiresArrayHandling = false;
        private boolean requiresFloatHandling = false;
        private boolean requiresRecursionHandling = false;
        private boolean hasSingleLoop = false;

        SelectionAlgorithmStatistics(LogManager pLogger) {
            super(pLogger);
        }

        @Override
        public String getName() {
            return "Selection Algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            out.println("Size of preliminary analysis reached set:      " + this.sizeOfPreAnaReachedSet);
            out.println("Used algorithm property:                       " + this.chosenConfig);
            out.println("Program containing only relevant bools:        " + (this.requiresOnlyRelevantBoolsHandling ? 1 : 0));
            out.println(String.format("Relevant boolean vars / relevant vars ratio:   %.4f", this.relevantBoolRatio));
            out.println("Requires alias handling:                       " + (this.requiresAliasHandling ? 1 : 0));
            out.println("Requires loop handling:                        " + (this.requiresLoopHandling ? 1 : 0));
            out.println("Has a single loop:                             " + (this.hasSingleLoop ? 1 : 0));
            out.println("Requires composite-type handling:              " + (this.requiresCompositeTypeHandling ? 1 : 0));
            out.println("Requires array handling:                       " + (this.requiresArrayHandling ? 1 : 0));
            out.println("Requires float handling:                       " + (this.requiresFloatHandling ? 1 : 0));
            out.println("Requires recursion handling:                   " + (this.requiresRecursionHandling ? 1 : 0));
            out.println(String.format("Relevant addressed vars / relevant vars ratio: %.4f", this.relevantAddressedRatio));
            out.println("Program containing external functions:         " + this.containsExternalFunctionCalls);
            out.println("Number of all righthand side functions:        " + this.numberOfAllRightFunctions);
            out.println();
            super.printStatistics(out, result, reached);
        }
    }

    private static class SelectionAlgorithmCFAVisitor
    implements CFATraversal.CFAVisitor {
        private final Set<String> functionNames = new HashSet<String>();
        private final Set<String> arrayVariables = new HashSet<String>();
        private final Set<String> floatVariables = new HashSet<String>();

        private SelectionAlgorithmCFAVisitor() {
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
            switch (pEdge.getEdgeType()) {
                case StatementEdge: {
                    AFunctionCall call;
                    AExpression exp;
                    AStatementEdge edge = (AStatementEdge)pEdge;
                    if (!(edge.getStatement() instanceof AFunctionCall) || !((exp = (call = (AFunctionCall)edge.getStatement()).getFunctionCallExpression().getFunctionNameExpression()) instanceof AIdExpression)) break;
                    AIdExpression id = (AIdExpression)exp;
                    this.functionNames.add(id.getName());
                    break;
                }
                case DeclarationEdge: {
                    ADeclarationEdge declarationEdge = (ADeclarationEdge)pEdge;
                    ADeclaration declaration = declarationEdge.getDeclaration();
                    Type declType = declaration.getType();
                    ArrayDeque<Type> types = new ArrayDeque<Type>();
                    HashSet<Type> visitedTypes = new HashSet<Type>();
                    types.add(declType);
                    while (!types.isEmpty()) {
                        Type simpleType;
                        Type type = (Type)types.poll();
                        if (type instanceof CType) {
                            type = ((CType)type).getCanonicalType();
                        }
                        if (!visitedTypes.add(type)) continue;
                        if (type instanceof CCompositeType) {
                            CCompositeType compositeType = (CCompositeType)type;
                            for (CCompositeType.CCompositeTypeMemberDeclaration member : compositeType.getMembers()) {
                                types.offer(member.getType());
                            }
                        }
                        if (type instanceof CArrayType || type instanceof JArrayType) {
                            this.arrayVariables.add(declaration.getQualifiedName());
                            continue;
                        }
                        if (type instanceof CSimpleType) {
                            simpleType = (CSimpleType)type;
                            if (!((CSimpleType)simpleType).getType().isFloatingPointType()) continue;
                            this.floatVariables.add(declaration.getQualifiedName());
                            continue;
                        }
                        if (!(type instanceof JSimpleType) || !((JSimpleType)(simpleType = (JSimpleType)type)).getType().isFloatingPointType()) continue;
                        this.floatVariables.add(declaration.getQualifiedName());
                    }
                    break;
                }
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
            return CFATraversal.TraversalProcess.CONTINUE;
        }
    }
}

