/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.ProgressReportingAlgorithm;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.defaults.PropertyTargetInformation;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Property;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetCPA;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetProvider;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.error.DummyErrorState;
import org.sosy_lab.cpachecker.util.testcase.TestCaseExporter;

@Options(prefix="testcase")
public class TestCaseGeneratorAlgorithm
implements ProgressReportingAlgorithm,
StatisticsProvider {
    @Option(secure=true, name="inStats", description="display all test targets and non-covered test targets in statistics")
    private boolean printTestTargetInfoInStats = false;
    @Option(secure=true, description="when generating tests covering error call stop as soon as generated one test case and report false (only possible in combination with error call property specification")
    private boolean reportCoveredErrorCallAsError = false;
    @Option(secure=true, name="progress", description="defines how progress is computed")
    private ProgressComputation progressType = ProgressComputation.RELATIVE_TOTAL;
    @Option(secure=true, name="mutants", description="how many mutated test cases should be additionally generated (disabled if <= 0)")
    private int numMutations = 0;
    private final Algorithm algorithm;
    private final AssumptionToEdgeAllocator assumptionToEdgeAllocator;
    private final ConfigurableProgramAnalysis cpa;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private Set<CFAEdge> testTargets;
    private final Property specProp;
    private final TestCaseExporter exporter;
    private double progress = 0.0;

    public TestCaseGeneratorAlgorithm(Algorithm pAlgorithm, CFA pCfa, Configuration pConfig, ConfigurableProgramAnalysis pCpa, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Specification pSpec) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        CPAs.retrieveCPAOrFail(pCpa, ARGCPA.class, TestCaseGeneratorAlgorithm.class);
        this.algorithm = pAlgorithm;
        this.cpa = pCpa;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.assumptionToEdgeAllocator = AssumptionToEdgeAllocator.create(pConfig, this.logger, pCfa.getMachineModel());
        TestTargetCPA testTargetCpa = CPAs.retrieveCPAOrFail(pCpa, TestTargetCPA.class, TestCaseGeneratorAlgorithm.class);
        this.testTargets = ((TestTargetTransferRelation)testTargetCpa.getTransferRelation()).getTestTargets();
        this.exporter = new TestCaseExporter(pCfa, this.logger, pConfig);
        this.numMutations = Math.max(this.numMutations, 0);
        if (pSpec.getProperties().size() == 1) {
            this.specProp = pSpec.getProperties().iterator().next();
            Preconditions.checkArgument((boolean)this.specProp.isCoverage(), (String)"Property %s not supported for test generation", (Object)this.specProp);
        } else {
            this.specProp = null;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReached) throws CPAException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void cleanUpIfNoTestTargetsRemain(ReachedSet pReached) {
        if (this.testTargets.isEmpty()) {
            pReached.clearWaitlist();
        }
    }

    private void addErrorStateWithTargetInformation(ReachedSet pReached) {
        Preconditions.checkState((boolean)this.shouldReportCoveredErrorCallAsError());
        pReached.add(new DummyErrorState(pReached.getLastState()){
            private static final long serialVersionUID = 5522643115974481914L;

            @Override
            public Set<Targetable.TargetInformation> getTargetInformation() {
                return PropertyTargetInformation.singleton(TestCaseGeneratorAlgorithm.this.specProp);
            }
        }, SingletonPrecision.getInstance());
    }

    private boolean shouldReportCoveredErrorCallAsError() {
        return this.reportCoveredErrorCallAsError && Property.CommonCoverageProperty.COVERAGE_ERROR.equals(this.specProp);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(TestTargetProvider.getTestTargetStatisitics(this.printTestTargetInfoInStats));
    }

    @Override
    public double getProgress() {
        switch (this.progressType) {
            case ABSOLUTE: {
                return this.progress;
            }
            case RELATIVE_TOTAL: {
                return this.progress / (double)Math.max(1, TestTargetProvider.getTotalNumberOfTestTargets());
            }
        }
        throw new AssertionError((Object)("Unhandled progress computation type: " + this.progressType));
    }

    private static /* synthetic */ void lambda$run$1(ReachedSet pReached, AbstractState state) {
        ARGState argState = (ARGState)state;
        ArrayList<ARGState> removedChildren = new ArrayList<ARGState>(2);
        for (ARGState child : argState.getChildren()) {
            if (pReached.contains(child)) continue;
            removedChildren.add(child);
        }
        for (ARGState child : removedChildren) {
            child.removeFromARG();
        }
    }

    private static /* synthetic */ boolean lambda$run$0(AbstractState state) {
        return !((ARGState)state).getChildren().isEmpty();
    }

    public static enum ProgressComputation {
        ABSOLUTE,
        RELATIVE_TOTAL;

    }
}

