/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.IAFunctionType;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.StandardFunctions;

@Options(prefix="undefinedFunctionsCollector")
public class UndefinedFunctionCollectorAlgorithm
implements Algorithm,
StatisticsProvider,
Statistics {
    private static final String ASSUME_FUNCTION_NAME = "__VERIFIER_assume";
    private static final String NONDET_FUNCTION_PREFIX = "__VERIFIER_nondet_";
    private static final String ASSUME_FUNCTION_DECL = "void __VERIFIER_assume(int);\n";
    @Option(secure=true, description="export undefined functions as C file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path stubsFile = Path.of("stubs.c", new String[0]);
    @Option(secure=true, description="Set of functions that should be ignored")
    private Set<String> allowedFunctions = ImmutableSet.of((Object)"__assert_fail", (Object)"__finite", (Object)"__fpclassify", (Object)"__fpclassifyf", (Object)"__fpclassifyl", (Object)"__isinf", (Object[])new String[]{"__isinff", "__isnan", "__isnanf", "__signbit", "__signbitf"});
    @Option(secure=true, description="Ignore functions that are defined by C11")
    private boolean allowC11Functions = true;
    @Option(secure=true, description="Ignore functions that are defined by GNU C and not by C11/POSIX")
    private boolean allowGnuCFunctions = true;
    @Option(secure=true, description="Ignore functions that are defined by POSIX")
    private boolean allowPosixFunctions = true;
    @Option(secure=true, description="Memory-allocation function that will be used in stubs")
    private String externAllocFunction = "external_alloc";
    @Option(secure=true, description="Regexp matching function names that are allowed to be undefined")
    private Pattern allowedFunctionsRegexp = Pattern.compile("^(__VERIFIER|pthread)_[a-zA-Z0-9_]*");
    @Option(secure=true, description="Regexp matching function names that need not be declared")
    private Pattern allowedUndeclaredFunctionsRegexp = Pattern.compile("^__builtin_[a-zA-Z0-9_]*");
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final CFA cfa;
    private final Map<String, AFunctionDeclaration> undefinedfFunctions = new HashMap<String, AFunctionDeclaration>();
    private final Set<String> undeclaredFunctions = new HashSet<String>();
    private final String odmFunctionDecl = "void *" + this.externAllocFunction + "(void);\n";

    public UndefinedFunctionCollectorAlgorithm(Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCfa;
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws InterruptedException {
        this.collectUndefinedFunctions();
        return Algorithm.AlgorithmStatus.NO_PROPERTY_CHECKED;
    }

    private void collectUndefinedFunctions() throws InterruptedException {
        for (CFANode node : this.cfa.getAllNodes()) {
            this.shutdownNotifier.shutdownIfNecessary();
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                AStatementEdge stmtEdge;
                if (edge.getEdgeType() != CFAEdgeType.StatementEdge || !((stmtEdge = (AStatementEdge)edge).getStatement() instanceof AFunctionCall)) continue;
                this.collectUndefinedFunction((AFunctionCall)stmtEdge.getStatement());
            }
        }
    }

    private void collectUndefinedFunction(AFunctionCall call) {
        AFunctionDeclaration functionDecl = call.getFunctionCallExpression().getDeclaration();
        if (functionDecl == null) {
            AExpression functionName = call.getFunctionCallExpression().getFunctionNameExpression();
            if (functionName instanceof AIdExpression) {
                String name = ((AIdExpression)functionName).getName();
                this.logger.log(Level.FINE, new Object[]{"Call to undeclared function", name, "found."});
                this.undeclaredFunctions.add(name);
            }
        } else if (!this.cfa.getAllFunctionNames().contains(functionDecl.getName())) {
            this.undefinedfFunctions.put(functionDecl.getName(), functionDecl);
        }
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        pOut.println("Total undefined functions called:         " + this.undefinedfFunctions.size());
        pOut.println("Non-standard undefined functions called:  " + ((long)this.undefinedfFunctions.size() - this.undefinedfFunctions.keySet().stream().filter(this::skipFunction).count()));
        pOut.println("Total undeclared functions called:        " + this.undeclaredFunctions.size());
        pOut.println("Non-standard undeclared functions called: " + this.undeclaredFunctions.stream().filter(name -> !this.allowedUndeclaredFunctionsRegexp.matcher((CharSequence)name).matches()).count());
    }

    @Override
    public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        if (this.stubsFile != null) {
            try (Writer w = IO.openOutputFile((Path)this.stubsFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                for (Map.Entry<String, AFunctionDeclaration> k : new TreeMap<String, AFunctionDeclaration>(this.undefinedfFunctions).entrySet()) {
                    this.printFunction(k.getKey(), k.getValue(), w);
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write stubs to the file");
            }
        }
    }

    private boolean skipFunction(String name) {
        return this.allowedFunctions.contains(name) || this.allowC11Functions && StandardFunctions.C11_ALL_FUNCTIONS.contains((Object)name) || this.allowGnuCFunctions && StandardFunctions.GNUC_ALL_FUNCTIONS.contains((Object)name) || this.allowPosixFunctions && StandardFunctions.POSIX_ALL_FUNCTIONS.contains((Object)name) || this.allowedFunctionsRegexp.matcher(name).matches() || this.allowedUndeclaredFunctionsRegexp.matcher(name).matches();
    }

    private void printFunction(String name, AFunctionDeclaration f, Writer w) throws IOException {
        if (this.skipFunction(name)) {
            this.logger.log(Level.FINE, new Object[]{" Skip function: " + name});
            w.write("// Skip function: " + name + "\n\n");
        } else {
            w.write("// Function: " + name + "\n");
            w.write("// with type: " + f.getType() + "\n");
            Type rt = f.getType().getReturnType();
            w.write("// with return type: " + rt + "\n");
            StringBuilder buf = new StringBuilder();
            StringBuilder prepend = new StringBuilder();
            boolean couldBeHandled = this.printType("  ", prepend, buf, (CType)rt);
            if (couldBeHandled) {
                w.write(prepend.toString());
                w.write(this.getSignature(name, f.getType()) + " {\n");
                w.write(buf.toString());
                w.write("}\n\n");
            } else {
                w.write("// ignored because stub could not be generated\n\n");
            }
        }
    }

    private String getSignature(String name, IAFunctionType type) {
        StringBuilder res = new StringBuilder().append(name).append("(");
        int i = 0;
        for (Type type2 : type.getParameters()) {
            if (i == 0) {
                res.append(type2.toASTString("arg" + i));
            } else {
                res.append(", ").append(type2.toASTString("arg" + i));
            }
            ++i;
        }
        if (type.takesVarArgs()) {
            if (i != 0) {
                res.append(", ");
            }
            res.append("...");
        }
        res.append(")");
        return type.getReturnType().toASTString(res.toString());
    }

    private boolean printType(String indent, StringBuilder prepend, StringBuilder buf, CType rt) {
        boolean couldBeHandled = true;
        if (rt instanceof CVoidType) {
            buf.append(indent + "// Void type\n");
            buf.append(indent + "return;\n");
        } else if (rt instanceof CPointerType) {
            buf.append(indent + "// Pointer type\n");
            prepend.append(this.odmFunctionDecl);
            buf.append(indent + "return (" + rt.toASTString("") + ")" + this.externAllocFunction + "();\n");
        } else if (rt instanceof CSimpleType) {
            CSimpleType ct = (CSimpleType)rt;
            Pair<String, String> pair = this.convertType(ct);
            String nondetFunc = NONDET_FUNCTION_PREFIX + pair.getSecond();
            prepend.append(pair.getFirst() + " " + nondetFunc + "(void);\n");
            buf.append(indent + "// Simple type\n");
            buf.append(indent + "return " + nondetFunc + "();\n");
        } else if (rt instanceof CEnumType) {
            buf.append(indent + "// Enum type\n");
            String nondetFunc = "__VERIFIER_nondet_int";
            prepend.append("int " + nondetFunc + "(void);\n");
            buf.append(indent + "return " + nondetFunc + "();\n");
        } else if (rt instanceof CCompositeType) {
            buf.append(indent + "// Composite type\n");
            prepend.append(this.odmFunctionDecl);
            buf.append(indent + rt + " *tmp = (" + rt + "*)" + this.externAllocFunction + "();\n");
            prepend.append(ASSUME_FUNCTION_DECL);
            buf.append(indent + "__VERIFIER_assume(tmp != 0);\n");
            buf.append(indent + "return *tmp;\n");
        } else if (rt instanceof CElaboratedType) {
            CComplexType real = ((CElaboratedType)rt).getRealType();
            couldBeHandled = real == null ? false : this.printType(indent, prepend, buf, real);
        } else if (rt instanceof CTypedefType) {
            buf.append(indent + "// Typedef type\n");
            CTypedefType tt = (CTypedefType)rt;
            CType real = tt.getRealType();
            buf.append(indent + "// Real type: " + real + "\n");
            couldBeHandled = this.printType(indent, prepend, buf, real);
        } else {
            throw new AssertionError((Object)("Unexpected type '" + rt + "' of class " + rt.getClass().getSimpleName()));
        }
        return couldBeHandled;
    }

    private Pair<String, String> convertType(CSimpleType ct) {
        CBasicType bt = ct.getType();
        if (bt == CBasicType.BOOL) {
            return Pair.of("bool", "bool");
        }
        if (bt == CBasicType.CHAR) {
            if (ct.isUnsigned()) {
                return Pair.of("unsigned char", "uchar");
            }
            return Pair.of("char", "char");
        }
        if (bt == CBasicType.DOUBLE) {
            return Pair.of("double", "double");
        }
        if (bt == CBasicType.FLOAT) {
            return Pair.of("float", "float");
        }
        if (bt == CBasicType.INT || bt == CBasicType.UNSPECIFIED) {
            if (ct.isShort()) {
                if (ct.isUnsigned()) {
                    return Pair.of("unsigned short", "ushort");
                }
                return Pair.of("short", "short");
            }
            if (ct.isLong() || ct.isLongLong()) {
                if (ct.isUnsigned()) {
                    return Pair.of("unsigned long", "ulong");
                }
                return Pair.of("long", "long");
            }
            if (ct.isUnsigned()) {
                return Pair.of("unsigned int", "uint");
            }
            return Pair.of("int", "int");
        }
        throw new RuntimeException("Unknown type " + ct);
    }

    @Override
    public @Nullable String getName() {
        return "UndefinedFunctionCollectorAlgorithm";
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this);
    }
}

