/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.ExpressionTreeLocationInvariant;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAEnabledAnalysisPropertyViolationException;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.WitnessInvariantsExtractor;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;

@Options(prefix="wacsl")
public class WitnessToACSLAlgorithm
implements Algorithm {
    @Option(secure=true, required=true, description="The witness from which ACSL annotations should be generated.")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path witness;
    @Option(secure=true, description="The directory where generated, ACSL annotated programs are stored.")
    @FileOption(value=FileOption.Type.OUTPUT_DIRECTORY)
    private Path outDir = Path.of("annotated", new String[0]);
    @Option(secure=true, description="Instead of comments, output the assertions into the original program as violations to unreach_call.prp")
    private boolean makeDirectAssertions = false;
    @Option(secure=true, description="Makes the annotated file's name identical to the original source file's name.")
    private boolean useSameFileName = false;
    private final Configuration config;
    private final LogManager logger;
    private final CFA cfa;
    private final ShutdownNotifier shutdownNotifier;

    public WitnessToACSLAlgorithm(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        this.config = pConfig;
        this.config.inject((Object)this);
        this.logger = pLogger;
        this.cfa = pCfa;
        this.shutdownNotifier = pShutdownNotifier;
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException, CPAEnabledAnalysisPropertyViolationException {
        Set<ExpressionTreeLocationInvariant> invariants;
        HashSet<Path> files = new HashSet<Path>();
        try {
            WitnessInvariantsExtractor invariantsExtractor = new WitnessInvariantsExtractor(this.config, this.logger, this.cfa, this.shutdownNotifier, this.witness);
            invariants = invariantsExtractor.extractInvariantsFromReachedSet();
        }
        catch (InvalidConfigurationException pE) {
            throw new CPAException("Invalid Configuration while analyzing witness:\n" + pE.getMessage(), pE);
        }
        for (ExpressionTreeLocationInvariant c : invariants) {
            Path file = c.getLocation().getFunction().getFileLocation().getFileName();
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            files.add(file);
        }
        for (Path file : files) {
            String fileContent;
            LinkedHashMultimap locationsToInvariants = LinkedHashMultimap.create();
            for (ExpressionTreeLocationInvariant inv : invariants) {
                CFANode node = inv.getLocation();
                if (!node.getFunction().getFileLocation().getFileName().equals(file)) continue;
                Set<Integer> effectiveLocations = this.getEffectiveLocations(inv);
                if (!effectiveLocations.isEmpty()) {
                    for (Integer location : effectiveLocations) {
                        locationsToInvariants.put((Object)location, (Object)inv);
                    }
                    continue;
                }
                this.logger.logf(Level.INFO, "Could not determine a location for invariant %s, skipping.", new Object[]{inv.asExpressionTree()});
            }
            try {
                fileContent = Files.readString(file);
            }
            catch (IOException pE) {
                this.logger.logfUserException(Level.WARNING, (Throwable)pE, "Could not read file %s", new Object[]{file});
                continue;
            }
            PriorityQueue<Integer> sortedLocations = new PriorityQueue<Integer>(locationsToInvariants.keySet());
            Integer currentLocation = (Integer)sortedLocations.poll();
            ArrayList<String> output = new ArrayList<String>();
            List splitContent = Splitter.onPattern((String)"\\r?\\n").splitToList((CharSequence)fileContent);
            for (int i = 0; i < splitContent.size(); ++i) {
                assert (currentLocation == null || currentLocation >= i);
                ArrayList collectedLoopInvariants = new ArrayList();
                while (currentLocation != null && currentLocation == i) {
                    String lineBefore = ((String)splitContent.get(i - 1)).strip();
                    String lineAfter = ((String)splitContent.get(i)).strip();
                    if ((lineBefore.endsWith(")") || lineBefore.endsWith("else")) && lineAfter.startsWith("{")) {
                        sortedLocations.offer(currentLocation + 1);
                        for (ExpressionTreeLocationInvariant inv : locationsToInvariants.get((Object)currentLocation)) {
                            locationsToInvariants.put((Object)(currentLocation + 1), (Object)inv);
                        }
                        locationsToInvariants.removeAll((Object)currentLocation);
                    } else {
                        for (ExpressionTreeLocationInvariant inv : locationsToInvariants.get((Object)currentLocation)) {
                            if (this.isAtLoopStart(inv)) {
                                collectedLoopInvariants.add(inv.asExpressionTree());
                                continue;
                            }
                            String annotation = this.makeACSLAnnotation(inv.asExpressionTree(), this.isAtLoopStart(inv));
                            String indentation = i > 0 ? this.getIndentation((String)splitContent.get(i - 1)) : "";
                            output.add(indentation + annotation);
                        }
                    }
                    currentLocation = (Integer)sortedLocations.poll();
                }
                if (!collectedLoopInvariants.isEmpty() && !((String)splitContent.get(i)).isBlank()) {
                    ExpressionTree<Object> conjunctedInvariants = And.of(collectedLoopInvariants);
                    String annotation = this.makeACSLAnnotation(conjunctedInvariants, true);
                    String indentation = i > 0 ? this.getIndentation((String)splitContent.get(i - 1)) : "";
                    output.add(indentation + annotation);
                    collectedLoopInvariants.clear();
                }
                output.add((String)splitContent.get(i));
            }
            long count = 0L;
            while (!sortedLocations.isEmpty()) {
                currentLocation = (Integer)sortedLocations.poll();
                ++count;
            }
            if (count != 0L) {
                this.logger.logf(Level.WARNING, "Not all invariants where used for annotations, we still have %d invariants left!", new Object[]{count});
            }
            try {
                this.writeToFile(file, output);
            }
            catch (IOException pE) {
                this.logger.logfUserException(Level.WARNING, (Throwable)pE, "Could not write annotations for file %s", new Object[]{file});
            }
        }
        return Algorithm.AlgorithmStatus.NO_PROPERTY_CHECKED;
    }

    private void writeToFile(Path pathToOriginalFile, List<String> newContent) throws IOException {
        String newFileName = this.makeNameForAnnotatedFile(pathToOriginalFile.getFileName().toString());
        Path outFile = this.outDir.resolve(newFileName);
        try (Writer writer = IO.openOutputFile((Path)outFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            writer.write(String.join((CharSequence)"\n", newContent) + "\n");
        }
    }

    private String makeNameForAnnotatedFile(String oldFileName) {
        if (this.useSameFileName) {
            return oldFileName;
        }
        int indexOfFirstPeriod = oldFileName.indexOf(46);
        String nameWithoutExtension = oldFileName;
        String extension = "";
        if (indexOfFirstPeriod != -1) {
            nameWithoutExtension = oldFileName.substring(0, indexOfFirstPeriod);
            extension = oldFileName.substring(indexOfFirstPeriod);
        }
        String timestamp = LocalDateTime.now(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH:mm:ss"));
        return "annotated_" + nameWithoutExtension + timestamp + extension;
    }

    private String getIndentation(String correctlyIndented) {
        String indentation = null;
        for (int i = 0; i < correctlyIndented.length(); ++i) {
            if (Character.isSpaceChar(correctlyIndented.charAt(i))) continue;
            indentation = correctlyIndented.substring(0, i);
            break;
        }
        return indentation == null ? correctlyIndented : indentation;
    }

    private String makeACSLAnnotation(ExpressionTree<Object> inv, boolean asLoopInvariant) {
        if (!this.makeDirectAssertions) {
            if (asLoopInvariant) {
                return "/*@ loop invariant " + inv + "; */";
            }
            return "/*@ assert " + inv + "; */";
        }
        return "if (!(" + inv + ")) reach_error();";
    }

    private boolean isAtLoopStart(ExpressionTreeLocationInvariant inv) {
        Optional<LoopStructure> loopStructure = this.cfa.getLoopStructure();
        if (loopStructure.isPresent()) {
            CFANode node = inv.getLocation();
            for (LoopStructure.Loop loop : loopStructure.orElseThrow().getLoopsForFunction(node.getFunctionName())) {
                for (CFAEdge edge : loop.getIncomingEdges()) {
                    String description;
                    if (!edge.getPredecessor().equals(node) || !(description = edge.getDescription()).equals("while") && !description.equals("for") && !description.equals("do") && (edge.getPredecessor().getNumEnteringEdges() != 1 || !edge.getPredecessor().getEnteringEdge(0).getDescription().equals("for"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Set<Integer> getEffectiveLocations(ExpressionTreeLocationInvariant inv) {
        CFANode node = inv.getLocation();
        ImmutableSet.Builder locations = ImmutableSet.builder();
        if (node instanceof FunctionEntryNode || node instanceof FunctionExitNode) {
            return locations.build();
        }
        for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
            if (edge.getFileLocation().equals(FileLocation.DUMMY) || edge.getDescription().contains("CPAchecker_TMP") || edge instanceof AssumeEdge) continue;
            locations.add((Object)(edge.getFileLocation().getStartingLineNumber() - 1));
        }
        for (CFAEdge edge : CFAUtils.enteringEdges(node)) {
            if (edge.getFileLocation().equals(FileLocation.DUMMY) || edge.getDescription().contains("CPAchecker_TMP") || edge instanceof AssumeEdge) continue;
            locations.add((Object)edge.getFileLocation().getEndingLineNumber());
        }
        return locations.build();
    }
}

