/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.ExpressionTreeLocationInvariant;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAEnabledAnalysisPropertyViolationException;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.WitnessInvariantsExtractor;
import org.sosy_lab.cpachecker.util.invariantwitness.InvariantWitness;
import org.sosy_lab.cpachecker.util.invariantwitness.InvariantWitnessFactory;
import org.sosy_lab.cpachecker.util.invariantwitness.exchange.InvariantWitnessWriter;

@Options(prefix="invariantStore")
public class WitnessToInvariantWitnessAlgorithm
implements Algorithm {
    @Option(secure=true, description="The witness from which invariants should be generated.")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path witness = Path.of("invariantwitness.yaml", new String[0]);
    private final Configuration config;
    private final LogManager logger;
    private final CFA cfa;
    private final ShutdownNotifier shutdownNotifier;
    private final InvariantWitnessWriter invariantExporter;

    public WitnessToInvariantWitnessAlgorithm(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCFA, Specification pSpecification) throws InvalidConfigurationException, IOException {
        this.config = pConfig;
        this.config.inject((Object)this);
        this.logger = pLogger;
        this.cfa = pCFA;
        this.shutdownNotifier = pShutdownNotifier;
        this.invariantExporter = InvariantWitnessWriter.getWriter(pConfig, pCFA, pSpecification, pLogger);
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException, CPAEnabledAnalysisPropertyViolationException {
        Set<ExpressionTreeLocationInvariant> invariants;
        try {
            WitnessInvariantsExtractor invariantsExtractor = new WitnessInvariantsExtractor(this.config, this.logger, this.cfa, this.shutdownNotifier, this.witness);
            invariants = invariantsExtractor.extractInvariantsFromReachedSet();
        }
        catch (InvalidConfigurationException pE) {
            throw new CPAException("Invalid Configuration while analyzing witness:\n" + pE.getMessage(), pE);
        }
        HashSet<InvariantWitness> invariantWitnesses = new HashSet<InvariantWitness>();
        for (ExpressionTreeLocationInvariant invariant : invariants) {
            invariantWitnesses.addAll(InvariantWitnessFactory.getFactory(this.logger, this.cfa).fromNodeAndInvariant(invariant.getLocation(), invariant.asExpressionTree()));
        }
        for (InvariantWitness invariantWitness : invariantWitnesses) {
            try {
                this.invariantExporter.exportInvariantWitness(invariantWitness);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, new Object[]{"Could not write witness to file"});
            }
        }
        return Algorithm.AlgorithmStatus.NO_PROPERTY_CHECKED;
    }
}

