/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.ParallelAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.AbstractionBasedLifting;
import org.sosy_lab.cpachecker.core.algorithm.bmc.AbstractionStrategy;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCHelper;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCStatistics;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CandidateGenerator;
import org.sosy_lab.cpachecker.core.algorithm.bmc.InductionResult;
import org.sosy_lab.cpachecker.core.algorithm.bmc.InvariantStrengthenings;
import org.sosy_lab.cpachecker.core.algorithm.bmc.KInductionProver;
import org.sosy_lab.cpachecker.core.algorithm.bmc.Lifting;
import org.sosy_lab.cpachecker.core.algorithm.bmc.PredicateAbstractionStrategy;
import org.sosy_lab.cpachecker.core.algorithm.bmc.StandardLiftings;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariantCombination;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SingleLocationFormulaInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SymbolicCandiateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.TargetLocationCandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.invariants.AbstractInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.DoNothingInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.ExpressionTreeSupplier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantSupplier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.KInductionInvariantGenerator;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.LoopIterationBounding;
import org.sosy_lab.cpachecker.core.interfaces.LoopIterationReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AdjustableConditionCPA;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.targetreachability.ReachabilityState;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetCPA;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.automaton.CachingTargetLocationProvider;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProvider;
import org.sosy_lab.cpachecker.util.automaton.TestTargetLocationProvider;
import org.sosy_lab.cpachecker.util.invariantwitness.InvariantWitnessGenerator;
import org.sosy_lab.cpachecker.util.predicates.AssignmentToPathAllocator;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.invariants.ExpressionTreeInvariantSupplier;
import org.sosy_lab.cpachecker.util.predicates.invariants.FormulaInvariantsSupplier;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="bmc")
abstract class AbstractBMCAlgorithm
implements StatisticsProvider,
ParallelAlgorithm.ConditionAdjustmentEventSubscriber {
    @Option(secure=true, description="If BMC did not find a bug, check whether the bounding did actually remove parts of the state space (this is similar to CBMC's unwinding assertions).")
    private boolean boundingAssertions = true;
    @Option(secure=true, description="If BMC did not find a bug, check which parts of the boundary actually reachableand prevent them from being unrolled any further.")
    private boolean boundingAssertionsSlicing = false;
    @Option(secure=true, description="try using induction to verify programs with loops")
    private boolean induction = false;
    @Option(secure=true, description="Strategy for generating auxiliary invariants")
    private InvariantGeneratorFactory invariantGenerationStrategy = InvariantGeneratorFactory.REACHED_SET;
    @Option(secure=true, description="Controls how long the invariant generator is allowed to run before the k-induction procedure starts.")
    private InvariantGeneratorHeadStartFactories invariantGeneratorHeadStartStrategy = InvariantGeneratorHeadStartFactories.NONE;
    @Option(secure=true, description="k-induction configuration to be used as an invariant generator for k-induction (ki-ki(-ai)).")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private @Nullable Path invariantGeneratorConfig = null;
    @Option(secure=true, description="Propagates the interrupts of the invariant generator.")
    private boolean propagateInvGenInterrupts = false;
    @Option(secure=true, description="Use generalized counterexamples to induction as candidate invariants.")
    private boolean usePropertyDirection = false;
    @Option(secure=true, description="Try to simplify the structure of formulas for the sat check of BMC. The improvement depends on the underlying SMT solver.")
    private boolean simplifyBooleanFormula = false;
    protected final BMCStatistics stats;
    private final Algorithm algorithm;
    private final ConfigurableProgramAnalysis cpa;
    private final @Nullable ConfigurableProgramAnalysis stepCaseCPA;
    private final @Nullable Algorithm stepCaseAlgorithm;
    protected final InvariantGenerator invariantGenerator;
    private final InvariantGeneratorHeadStart invariantGeneratorHeadStart;
    private final FormulaManagerView fmgr;
    private final PathFormulaManager pmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final Solver solver;
    protected final LogManager logger;
    private final ReachedSetFactory reachedSetFactory;
    private final Configuration config;
    private final CFA cfa;
    private final AssignmentToPathAllocator assignmentToPathAllocator;
    private final Specification specification;
    protected final ShutdownNotifier shutdownNotifier;
    private final TargetLocationProvider targetLocationProvider;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ShutdownNotifier.ShutdownRequestListener propagateSafetyInterrupt;
    private final AbstractionStrategy abstractionStrategy;
    private final Set<CandidateInvariant> confirmedCandidates = new CopyOnWriteArraySet<CandidateInvariant>();
    private final List<ParallelAlgorithm.ConditionAdjustmentEventSubscriber> conditionAdjustmentEventSubscribers = new CopyOnWriteArrayList<ParallelAlgorithm.ConditionAdjustmentEventSubscriber>();

    protected static boolean isStopState(AbstractState state) {
        AssumptionStorageState assumptionState = AbstractStates.extractStateByType(state, AssumptionStorageState.class);
        return assumptionState != null && assumptionState.isStop();
    }

    protected static boolean isRelevantForReachability(AbstractState state) {
        return AbstractStates.extractStateByType(state, ReachabilityState.class) != ReachabilityState.IRRELEVANT_TO_TARGET;
    }

    protected AbstractBMCAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCPA, Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory, final ShutdownManager pShutdownManager, CFA pCFA, Specification pSpecification, BMCStatistics pBMCStatistics, boolean pIsInvariantGenerator, AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException, CPAException, InterruptedException {
        boolean addInvariantsByInduction;
        pConfig.inject((Object)this, AbstractBMCAlgorithm.class);
        this.stats = pBMCStatistics;
        this.algorithm = pAlgorithm;
        this.cpa = pCPA;
        this.logger = pLogger;
        this.reachedSetFactory = pReachedSetFactory;
        this.cfa = pCFA;
        this.config = pConfig;
        this.specification = (Specification)Preconditions.checkNotNull((Object)pSpecification);
        this.shutdownNotifier = pShutdownManager.getNotifier();
        TestTargetCPA testCPA = CPAs.retrieveCPA(pCPA, TestTargetCPA.class);
        this.targetLocationProvider = testCPA != null ? new TestTargetLocationProvider(((TestTargetTransferRelation)testCPA.getTransferRelation()).getTestTargets()) : new CachingTargetLocationProvider(this.shutdownNotifier, this.logger, this.cfa);
        if (this.induction) {
            this.induction = AbstractBMCAlgorithm.checkIfInductionIsPossible(pCFA, pLogger);
            boolean bl = this.induction = this.induction && this.cfa.getLoopStructure().orElseThrow().getCount() > 0 && !this.getLoopHeads().isEmpty();
        }
        if (this.induction) {
            LogManager stepCaseLogger = this.logger.withComponentName("InductionStepCase");
            CPABuilder builder = new CPABuilder(pConfig, stepCaseLogger, pShutdownManager.getNotifier(), pReachedSetFactory);
            this.stepCaseCPA = builder.buildCPAs(this.cfa, pSpecification, AggregatedReachedSets.empty());
            this.stepCaseAlgorithm = CPAAlgorithm.create(this.stepCaseCPA, stepCaseLogger, pConfig, pShutdownManager.getNotifier());
        } else {
            this.stepCaseCPA = null;
            this.stepCaseAlgorithm = null;
            this.invariantGenerationStrategy = InvariantGeneratorFactory.DO_NOTHING;
            this.invariantGeneratorHeadStartStrategy = InvariantGeneratorHeadStartFactories.NONE;
        }
        ShutdownManager invariantGeneratorShutdownManager = pShutdownManager;
        boolean bl = addInvariantsByInduction = this.invariantGenerationStrategy == InvariantGeneratorFactory.INDUCTION;
        if (addInvariantsByInduction) {
            invariantGeneratorShutdownManager = this.propagateInvGenInterrupts ? pShutdownManager : ShutdownManager.createWithParent((ShutdownNotifier)pShutdownManager.getNotifier());
            this.propagateSafetyInterrupt = new ShutdownNotifier.ShutdownRequestListener(){

                public void shutdownRequested(String pReason) {
                    if (AbstractBMCAlgorithm.this.invariantGenerator != null && AbstractBMCAlgorithm.this.invariantGenerator.isProgramSafe()) {
                        pShutdownManager.requestShutdown(pReason);
                    }
                }
            };
            invariantGeneratorShutdownManager.getNotifier().register(this.propagateSafetyInterrupt);
        } else {
            this.propagateSafetyInterrupt = null;
        }
        if (pIsInvariantGenerator && addInvariantsByInduction) {
            this.invariantGenerationStrategy = InvariantGeneratorFactory.REACHED_SET;
        }
        Configuration invGenConfig = pConfig;
        if (this.invariantGeneratorConfig != null) {
            try {
                invGenConfig = Configuration.builder().copyFrom(invGenConfig).loadFromFile(this.invariantGeneratorConfig).build();
            }
            catch (IOException e) {
                throw new InvalidConfigurationException(String.format("Cannot load configuration from file %s", this.invariantGeneratorConfig), (Throwable)e);
            }
        }
        this.invariantGenerator = this.invariantGenerationStrategy.createInvariantGenerator(invGenConfig, pLogger, pReachedSetFactory, invariantGeneratorShutdownManager, pCFA, pSpecification, pAggregatedReachedSets, this.targetLocationProvider);
        if (this.invariantGenerator instanceof ParallelAlgorithm.ConditionAdjustmentEventSubscriber) {
            this.conditionAdjustmentEventSubscribers.add((ParallelAlgorithm.ConditionAdjustmentEventSubscriber)((Object)this.invariantGenerator));
        }
        this.invariantGeneratorHeadStart = this.invariantGeneratorHeadStartStrategy.createFor(this);
        PredicateCPA predCpa = CPAs.retrieveCPAOrFail(this.cpa, PredicateCPA.class, BMCAlgorithm.class);
        this.solver = predCpa.getSolver();
        this.fmgr = this.solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.pmgr = predCpa.getPathFormulaManager();
        this.abstractionStrategy = new PredicateAbstractionStrategy(this.cfa.getVarClassification());
        this.assignmentToPathAllocator = new AssignmentToPathAllocator(this.config, this.shutdownNotifier, pLogger, pCFA.getMachineModel());
    }

    static boolean checkIfInductionIsPossible(CFA cfa, LogManager logger) {
        if (!cfa.getLoopStructure().isPresent()) {
            logger.log(Level.WARNING, new Object[]{"Could not use induction for proving program safety, loop structure of program could not be determined."});
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Algorithm.AlgorithmStatus run(ReachedSet reachedSet) throws CPAException, SolverException, InterruptedException {
        CFANode initialLocation = AbstractStates.extractLocation(reachedSet.getFirstState());
        this.invariantGenerator.start(initialLocation);
        CandidateGenerator candidateGenerator = this.getCandidateInvariants();
        TreeSet<Obligation> ctiBlockingClauses = new TreeSet<Obligation>();
        HashMap<SymbolicCandiateInvariant, BmcResult> checkedClauses = new HashMap<SymbolicCandiateInvariant, BmcResult>();
        if (!candidateGenerator.produceMoreCandidates()) {
            reachedSet.clearWaitlist();
            return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        }
        try (ProverEnvironment prover = this.solver.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            Algorithm.AlgorithmStatus status;
            this.invariantGeneratorHeadStart.waitForInvariantGenerator();
            do {
                Algorithm.AlgorithmStatus algorithmStatus;
                this.shutdownNotifier.shutdownIfNecessary();
                this.logger.log(Level.INFO, new Object[]{"Creating formula for program"});
                this.stats.bmcPreparation.start();
                try {
                    status = BMCHelper.unroll(this.logger, reachedSet, this.algorithm, this.cpa);
                }
                finally {
                    this.stats.bmcPreparation.stop();
                }
                if (FluentIterable.from((Iterable)reachedSet).skip(1).filter(Predicates.not(AbstractStates::isTargetState)).anyMatch(PredicateAbstractState::containsAbstractionState)) {
                    this.logger.log(Level.WARNING, new Object[]{"BMC algorithm does not work with abstractions. Could not check for satisfiability!"});
                    algorithmStatus = status;
                    return algorithmStatus;
                }
                this.shutdownNotifier.shutdownIfNecessary();
                if (this.invariantGenerator.isProgramSafe()) {
                    TargetLocationCandidateInvariant.INSTANCE.assumeTruth(reachedSet);
                    algorithmStatus = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
                    return algorithmStatus;
                }
                Iterator<CandidateInvariant> candidateInvariantIterator = candidateGenerator.iterator();
                while (candidateInvariantIterator.hasNext()) {
                    this.shutdownNotifier.shutdownIfNecessary();
                    CandidateInvariant candidateInvariant = candidateInvariantIterator.next();
                    boolean safe = this.boundedModelCheck(reachedSet, (BasicProverEnvironment<?>)prover, candidateInvariant);
                    if (!safe) {
                        if (candidateInvariant == TargetLocationCandidateInvariant.INSTANCE) {
                            Algorithm.AlgorithmStatus algorithmStatus2 = Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
                            return algorithmStatus2;
                        }
                        candidateInvariantIterator.remove();
                    }
                    if (!this.invariantGenerator.isProgramSafe()) continue;
                    TargetLocationCandidateInvariant.INSTANCE.assumeTruth(reachedSet);
                    Algorithm.AlgorithmStatus algorithmStatus3 = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
                    return algorithmStatus3;
                }
                if (status.isSound()) {
                    boolean sound;
                    boolean bl = sound = candidateGenerator.hasCandidatesAvailable() ? this.checkBoundingAssertions(reachedSet, (BasicProverEnvironment<?>)prover) : true;
                    if (this.invariantGenerator.isProgramSafe()) {
                        Algorithm.AlgorithmStatus safe = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
                        return safe;
                    }
                    if (this.induction && !sound) {
                        if (this.usePropertyDirection) {
                            this.usePropertyDirection = this.refineCtiBlockingClauses(reachedSet, (BasicProverEnvironment<?>)prover, (Set<Obligation>)ctiBlockingClauses, (Map<SymbolicCandiateInvariant, BmcResult>)checkedClauses);
                            if (!this.usePropertyDirection) {
                                ctiBlockingClauses.clear();
                            }
                        }
                        try (KInductionProver kInductionProver = this.createInductionProver();){
                            sound = this.checkStepCase(reachedSet, candidateGenerator, kInductionProver, ctiBlockingClauses);
                        }
                    }
                    if (this.invariantGenerator.isProgramSafe() || sound && !candidateGenerator.produceMoreCandidates()) {
                        Algorithm.AlgorithmStatus algorithmStatus4 = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
                        return algorithmStatus4;
                    }
                }
                if (candidateGenerator.hasCandidatesAvailable()) continue;
                Algorithm.AlgorithmStatus algorithmStatus5 = status;
                return algorithmStatus5;
            } while (status.isSound() && this.adjustConditions());
        }
        return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
    }

    private boolean checkStepCase(ReachedSet reachedSet, CandidateGenerator candidateGenerator, KInductionProver kInductionProver, Set<Obligation> pCtiBlockingClauses) throws InterruptedException, CPAException, SolverException {
        int k = CPAs.retrieveCPA(this.cpa, LoopIterationBounding.class).getMaxLoopIterations();
        Set<Object> checkedKeys = this.getCheckedKeys(reachedSet);
        Predicate<CandidateInvariant> isApplicable = this.getCandidateApplicabilityPredicate(reachedSet, checkedKeys);
        ImmutableSet candidates = FluentIterable.concat(pCtiBlockingClauses, (Iterable)candidateGenerator).filter(isApplicable).toSet();
        HashSet<SymbolicCandiateInvariant> checked = new HashSet<SymbolicCandiateInvariant>();
        this.shutdownNotifier.shutdownIfNecessary();
        boolean sound = true;
        ImmutableSet candidatesToCheck = candidates;
        for (CandidateInvariant candidate : candidatesToCheck) {
            InductionResult inductionResult;
            boolean extractCtiBlockingClauses;
            Lifting lifting;
            if (candidate instanceof Obligation) {
                if (!checked.add(((Obligation)candidate).getBlockingClause())) continue;
                pCtiBlockingClauses.remove(candidate);
            }
            Lifting lifting2 = lifting = (extractCtiBlockingClauses = this.usePropertyDirection) ? new AbstractionBasedLifting(this.abstractionStrategy, AbstractionBasedLifting.RefinementLAFStrategies.EAGER) : StandardLiftings.NO_LIFTING;
            if (!extractCtiBlockingClauses && candidate instanceof SingleLocationFormulaInvariant) {
                checkedKeys = this.getCheckedKeysAtLocation(reachedSet, ((SingleLocationFormulaInvariant)candidate).getLocation());
            }
            if ((inductionResult = kInductionProver.check(Iterables.concat(this.confirmedCandidates, Collections.singleton(candidate)), k, candidate, checkedKeys, InvariantStrengthenings.noStrengthening(), lifting)).isSuccessful()) {
                Iterables.addAll(this.confirmedCandidates, CandidateInvariantCombination.getConjunctiveParts(candidate));
                candidateGenerator.confirmCandidates(CandidateInvariantCombination.getConjunctiveParts(candidate));
                if (candidate != TargetLocationCandidateInvariant.INSTANCE) continue;
                sound = true;
                break;
            }
            sound = false;
            if (candidate instanceof Obligation) {
                Obligation obligation = (Obligation)candidate;
                List<SymbolicCandiateInvariant> weakenings = obligation.getWeakenings();
                for (SymbolicCandiateInvariant weakening : weakenings) {
                    inductionResult = kInductionProver.check(Iterables.concat(this.confirmedCandidates, Collections.singleton(weakening)), k, weakening, checkedKeys, InvariantStrengthenings.noStrengthening(), lifting);
                    if (!inductionResult.isSuccessful()) continue;
                    Iterables.addAll(this.confirmedCandidates, CandidateInvariantCombination.getConjunctiveParts(weakening));
                    candidateGenerator.confirmCandidates(CandidateInvariantCombination.getConjunctiveParts(weakening));
                    break;
                }
            }
            if (inductionResult.isSuccessful() || !extractCtiBlockingClauses) continue;
            FluentIterable causes = FluentIterable.from(CandidateInvariantCombination.getConjunctiveParts(candidate));
            if (causes.anyMatch(Obligation.class::isInstance)) {
                causes = causes.filter(Obligation.class);
            }
            if (causes.isEmpty()) continue;
            for (SymbolicCandiateInvariant badStateBlockingClause : inductionResult.getBadStateBlockingClauses()) {
                pCtiBlockingClauses.add(new Obligation((CandidateInvariant)causes.iterator().next(), badStateBlockingClause));
            }
        }
        return sound;
    }

    private Set<Object> getCheckedKeys(ReachedSet pReachedSet) {
        return AbstractStates.filterLocations(pReachedSet, this.getLoopHeads()).transform(s -> AbstractStates.extractStateByType(s, LoopIterationReportingState.class)).transform(Partitionable::getPartitionKey).toSet();
    }

    private Set<Object> getCheckedKeysAtLocation(ReachedSet pReachedSet, CFANode pLoc) {
        return FluentIterable.from(AbstractStates.filterLocation(pReachedSet, pLoc)).transform(s -> AbstractStates.extractStateByType(s, LoopIterationReportingState.class)).transform(Partitionable::getPartitionKey).toSet();
    }

    protected abstract CandidateGenerator getCandidateInvariants();

    protected boolean adjustConditions() {
        FluentIterable conditionCPAs = CPAs.asIterable(this.cpa).filter(AdjustableConditionCPA.class);
        boolean adjusted = conditionCPAs.anyMatch(AdjustableConditionCPA::adjustPrecision);
        if (!adjusted) {
            this.logger.log(Level.INFO, new Object[]{"Terminating because none of the following CPAs' precision can be adjusted any further ", conditionCPAs.transform(conditionCpa -> conditionCpa.getClass().getSimpleName()).join(Joiner.on((String)", "))});
        }
        return adjusted;
    }

    protected boolean boundedModelCheck(ReachedSet pReachedSet, BasicProverEnvironment<?> pProver, CandidateInvariant pCandidateInvariant) throws CPATransferException, InterruptedException, SolverException {
        return this.boundedModelCheck((Iterable<AbstractState>)pReachedSet, pProver, pCandidateInvariant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean boundedModelCheck(Iterable<AbstractState> pReachedSet, BasicProverEnvironment<?> pProver, CandidateInvariant pCandidateInvariant) throws CPATransferException, InterruptedException, SolverException {
        boolean safe;
        BooleanFormula program = this.bfmgr.not(pCandidateInvariant.getAssertion(pReachedSet, this.fmgr, this.pmgr));
        if (this.simplifyBooleanFormula) {
            BigInteger sizeBeforeSimplification = this.fmgr.countBooleanOperations(program);
            program = this.fmgr.simplifyBooleanFormula(program);
            BigInteger sizeAfterSimplification = this.fmgr.countBooleanOperations(program);
            this.logger.logf(Level.FINER, "Formula was simplified from %s to %s boolean operations.", new Object[]{sizeBeforeSimplification, sizeAfterSimplification});
        }
        this.logger.log(Level.INFO, new Object[]{"Starting satisfiability check..."});
        this.stats.satCheck.start();
        try {
            pProver.push(program);
            safe = pProver.isUnsat();
        }
        finally {
            this.stats.satCheck.stop();
        }
        if (pReachedSet instanceof ReachedSet) {
            ReachedSet reachedSet = (ReachedSet)pReachedSet;
            if (safe) {
                pCandidateInvariant.assumeTruth(reachedSet);
            } else if (pCandidateInvariant == TargetLocationCandidateInvariant.INSTANCE) {
                this.analyzeCounterexample(program, reachedSet, pProver);
            }
        }
        pProver.pop();
        return safe;
    }

    private boolean refineCtiBlockingClauses(ReachedSet pReachedSet, BasicProverEnvironment<?> pProver, Set<Obligation> pCtiBlockingClauses, Map<SymbolicCandiateInvariant, BmcResult> pCheckedClauses) throws CPATransferException, InterruptedException, SolverException {
        HashMap<SymbolicCandiateInvariant, SymbolicCandiateInvariant> refinedBlockingClauses = new HashMap<SymbolicCandiateInvariant, SymbolicCandiateInvariant>();
        for (SymbolicCandiateInvariant blockingClause : Iterables.transform(pCtiBlockingClauses, Obligation::getBlockingClause)) {
            if (refinedBlockingClauses.containsKey(blockingClause)) continue;
            BooleanFormula liftedCti = this.bfmgr.not(blockingClause.getPlainFormula(this.fmgr));
            ToIntFunction<BooleanFormula> variableNameCount = f -> this.fmgr.extractVariableNames((Formula)f).size();
            PriorityQueue<BooleanFormula> literals = new PriorityQueue<BooleanFormula>(Comparator.comparingInt(variableNameCount).reversed());
            Iterables.addAll(literals, SymbolicCandiateInvariant.getConjunctionOperands(this.fmgr, liftedCti, true));
            Iterator literalIterator = literals.iterator();
            ArrayList<BooleanFormula> requiredLiterals = new ArrayList<BooleanFormula>();
            boolean isUnsat = false;
            SymbolicCandiateInvariant newBlockingClause = blockingClause;
            while (!isUnsat && literalIterator.hasNext()) {
                BooleanFormula literal = (BooleanFormula)literalIterator.next();
                requiredLiterals.add(literal);
                if (literalIterator.hasNext() && this.fmgr.extractVariableNames((Formula)literal).size() > 1) continue;
                BooleanFormula furtherReducedCti = this.bfmgr.and(requiredLiterals);
                BooleanFormula newBlockingClauseFormula = this.bfmgr.not(furtherReducedCti);
                newBlockingClause = SymbolicCandiateInvariant.makeSymbolicInvariant(blockingClause.getApplicableLocations(), blockingClause.getStateFilter(), newBlockingClauseFormula, this.fmgr);
                BmcResult clauseResult = pCheckedClauses.get(newBlockingClause);
                if (clauseResult == null) {
                    clauseResult = new BmcResult();
                    pCheckedClauses.put(newBlockingClause, clauseResult);
                }
                if (!clauseResult.isSafe()) continue;
                Iterable<AbstractState> applicableStates = newBlockingClause.filterApplicable(pReachedSet);
                isUnsat = this.boundedModelCheck(applicableStates = clauseResult.filterUnchecked(applicableStates), pProver, (CandidateInvariant)newBlockingClause);
                if (isUnsat) {
                    clauseResult.addSafeStates(applicableStates);
                    continue;
                }
                clauseResult.declareUnsafe();
            }
            if (!isUnsat) continue;
            if (requiredLiterals.size() == literals.size()) {
                refinedBlockingClauses.put(blockingClause, blockingClause);
                continue;
            }
            refinedBlockingClauses.put(blockingClause, newBlockingClause);
        }
        Iterator<Obligation> obligationIterator = pCtiBlockingClauses.iterator();
        ArrayList<Obligation> newObligations = new ArrayList<Obligation>();
        while (obligationIterator.hasNext()) {
            Obligation obligation = obligationIterator.next();
            SymbolicCandiateInvariant refinedClause = (SymbolicCandiateInvariant)refinedBlockingClauses.get(obligation.getBlockingClause());
            if (refinedClause == obligation.getBlockingClause()) continue;
            obligationIterator.remove();
            if (refinedClause != null) {
                newObligations.add(obligation.refineWith(this.fmgr, refinedClause));
                continue;
            }
            if (obligation.getDepth() != 0 || !(obligation.getRootCause() instanceof TargetLocationCandidateInvariant)) continue;
            return false;
        }
        pCtiBlockingClauses.addAll(newObligations);
        return true;
    }

    protected void analyzeCounterexample(BooleanFormula pCounterexample, ReachedSet pReachedSet, BasicProverEnvironment<?> pProver) throws CPATransferException, InterruptedException {
        this.analyzeCounterexample0(pCounterexample, pReachedSet, pProver).ifPresent(cex -> cex.getTargetState().addCounterexampleInformation((CounterexampleInfo)((Object)cex)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Optional<CounterexampleInfo> analyzeCounterexample0(BooleanFormula pCounterexampleFormula, ReachedSet pReachedSet, BasicProverEnvironment<?> pProver) throws CPATransferException, InterruptedException {
        ARGPath targetPath;
        if (!(this.cpa instanceof ARGCPA)) {
            this.logger.log(Level.INFO, new Object[]{"Error found, but error path cannot be created without ARGCPA"});
            return Optional.empty();
        }
        this.logger.log(Level.INFO, new Object[]{"Error found, creating error path"});
        this.stats.errorPathCreation.start();
        try {
            Object root222222;
            ImmutableSet targetStates = FluentIterable.from((Iterable)pReachedSet).filter(AbstractStates::isTargetState).filter(ARGState.class).toSet();
            Set<ARGState> redundantStates = BMCHelper.filterAncestors((Iterable<ARGState>)targetStates, AbstractStates::isTargetState);
            redundantStates.forEach(state -> state.removeFromARG());
            pReachedSet.removeAll(redundantStates);
            try {
                Model model;
                block25: {
                    model = pProver.getModel();
                    root222222 = (ARGState)pReachedSet.getFirstState();
                    try {
                        targetPath = this.pmgr.getARGPathFromModel(model, (ARGState)root222222);
                    }
                    catch (IllegalArgumentException e222222) {
                        this.logger.logUserException(Level.WARNING, (Throwable)e222222, "Could not create error path");
                        Optional<CounterexampleInfo> optional = Optional.empty();
                        if (model != null) {
                            model.close();
                        }
                        this.stats.errorPathCreation.stop();
                        return optional;
                    }
                    if (targetPath.getLastState().isTarget()) break block25;
                    this.logger.log(Level.WARNING, new Object[]{"Could not create error path: path ends without target state!"});
                    Optional<CounterexampleInfo> e222222 = Optional.empty();
                    if (model == null) return e222222;
                    {
                        catch (Throwable root222222) {
                            if (model == null) throw root222222;
                            try {
                                model.close();
                                throw root222222;
                            }
                            catch (Throwable e222222) {
                                root222222.addSuppressed(e222222);
                            }
                            throw root222222;
                        }
                    }
                    model.close();
                    return e222222;
                }
                if (model != null) {
                    model.close();
                }
            }
            catch (SolverException e) {
                this.logger.log(Level.WARNING, new Object[]{"Solver could not produce model, cannot create error path."});
                this.logger.logDebugException((Throwable)e);
                root222222 = Optional.empty();
                return root222222;
            }
        }
        finally {
            this.stats.errorPathCreation.stop();
        }
        this.stats.errorPathProcessing.start();
        try {
            Optional<CounterexampleInfo> optional;
            PathChecker pathChecker;
            BooleanFormula cexFormula = pCounterexampleFormula;
            try {
                Solver solverForPathChecker = this.solver;
                PathFormulaManager pmgrForPathChecker = this.pmgr;
                if (solverForPathChecker.getVersion().toLowerCase().contains("smtinterpol")) {
                    solverForPathChecker = Solver.create(this.config, this.logger, this.shutdownNotifier);
                    FormulaManagerView formulaManager = solverForPathChecker.getFormulaManager();
                    pmgrForPathChecker = new PathFormulaManagerImpl(formulaManager, this.config, this.logger, this.shutdownNotifier, this.cfa, AnalysisDirection.FORWARD);
                    cexFormula = solverForPathChecker.getFormulaManager().getBooleanFormulaManager().makeTrue();
                }
                pathChecker = new PathChecker(this.config, this.logger, pmgrForPathChecker, solverForPathChecker, this.assignmentToPathAllocator);
            }
            catch (InvalidConfigurationException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not replay error path to get a more precise model");
                optional = Optional.empty();
                this.stats.errorPathProcessing.stop();
                return optional;
            }
            CounterexampleTraceInfo cexInfo = CounterexampleTraceInfo.feasible((List<BooleanFormula>)ImmutableList.of((Object)cexFormula), targetPath);
            optional = Optional.of(pathChecker.handleFeasibleCounterexample(cexInfo, targetPath));
            return optional;
        }
        finally {
            this.stats.errorPathProcessing.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkBoundingAssertions(ReachedSet pReachedSet, BasicProverEnvironment<?> prover) throws SolverException, InterruptedException {
        FluentIterable stopStates = FluentIterable.from((Iterable)pReachedSet).filter(AbstractBMCAlgorithm::isStopState).filter(AbstractBMCAlgorithm::isRelevantForReachability);
        if (this.boundingAssertions) {
            this.logger.log(Level.INFO, new Object[]{"Starting assertions check..."});
            boolean sound = true;
            if (!this.boundingAssertionsSlicing) {
                BooleanFormula assertions = BMCHelper.createFormulaFor((Iterable<AbstractState>)stopStates, this.bfmgr);
                this.stats.assertionsCheck.start();
                try {
                    prover.push(assertions);
                    sound = prover.isUnsat();
                    prover.pop();
                }
                finally {
                    this.stats.assertionsCheck.stop();
                }
            }
            ArrayList<AbstractState> toRemove = new ArrayList<AbstractState>();
            for (AbstractState s : stopStates) {
                boolean result;
                BooleanFormula assertions = BMCHelper.createFormulaFor((Iterable<AbstractState>)ImmutableList.of((Object)s), this.bfmgr);
                this.stats.assertionsCheck.start();
                try {
                    prover.push(assertions);
                    result = prover.isUnsat();
                    prover.pop();
                }
                finally {
                    this.stats.assertionsCheck.stop();
                }
                sound &= result;
                if (!result) continue;
                toRemove.add(s);
            }
            for (AbstractState s : toRemove) {
                pReachedSet.remove(s);
                if (!(s instanceof ARGState)) continue;
                ((ARGState)s).removeFromARG();
            }
            this.logger.log(Level.FINER, new Object[]{"Soundness after assertion checks:", sound});
            return sound;
        }
        return stopStates.isEmpty();
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
        if (this.invariantGenerator instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.invariantGenerator)).collectStatistics(pStatsCollection);
        }
    }

    protected KInductionProver createInductionProver() {
        assert (this.induction);
        return new KInductionProver(this.cfa, this.logger, this.stepCaseAlgorithm, this.stepCaseCPA, this.invariantGenerator, this.stats, this.reachedSetFactory, this.shutdownNotifier, this.getLoopHeads(), this.usePropertyDirection);
    }

    protected Collection<CFANode> getTargetLocations() {
        return this.targetLocationProvider.tryGetAutomatonTargetLocations(this.cfa.getMainFunction(), this.specification);
    }

    protected Set<CFANode> getLoopHeads() {
        return BMCHelper.getLoopHeads(this.cfa, this.targetLocationProvider);
    }

    protected FluentIterable<CandidateInvariant> getConfirmedCandidates(CFANode pLocation) {
        return FluentIterable.from(this.confirmedCandidates).filter(pConfirmedCandidate -> pConfirmedCandidate.appliesTo(pLocation));
    }

    private Predicate<CandidateInvariant> getCandidateApplicabilityPredicate(ReachedSet pReached, Set<Object> pCheckedKeys) {
        Object reachedK;
        int maxK = 0;
        if (this.cfa.getLoopStructure().isPresent()) {
            reachedK = new HashMap();
            for (AbstractState checkedState : BMCHelper.filterBmcChecked(AbstractStates.filterLocations(pReached, this.getLoopHeads()), pCheckedKeys)) {
                for (CFANode location : AbstractStates.extractLocations(checkedState)) {
                    LoopIterationReportingState lirs = AbstractStates.extractStateByType(checkedState, LoopIterationReportingState.class);
                    if (lirs == null) continue;
                    for (LoopStructure.Loop loop : this.cfa.getLoopStructure().orElseThrow().getLoopsForLoopHead(location)) {
                        Integer previous = (Integer)reachedK.get(loop);
                        int iteration = lirs.getIteration(loop);
                        if (previous != null && previous >= iteration) continue;
                        reachedK.put(loop, iteration);
                        maxK = Math.max(maxK, iteration);
                    }
                }
            }
        } else {
            reachedK = ImmutableMap.of();
        }
        int finalMaxK = maxK;
        return arg_0 -> this.lambda$getCandidateApplicabilityPredicate$7(pReached, (Map)reachedK, finalMaxK, arg_0);
    }

    @Override
    public void adjustmentSuccessful(ConfigurableProgramAnalysis pCpa) {
        for (ParallelAlgorithm.ConditionAdjustmentEventSubscriber caes : this.conditionAdjustmentEventSubscribers) {
            caes.adjustmentSuccessful(pCpa);
        }
    }

    @Override
    public void adjustmentRefused(ConfigurableProgramAnalysis pCpa) {
        for (ParallelAlgorithm.ConditionAdjustmentEventSubscriber caes : this.conditionAdjustmentEventSubscribers) {
            caes.adjustmentRefused(pCpa);
        }
    }

    private /* synthetic */ boolean lambda$getCandidateApplicabilityPredicate$7(ReachedSet pReached, Map reachedK, int finalMaxK, CandidateInvariant candidate) {
        if (candidate == TargetLocationCandidateInvariant.INSTANCE) {
            return true;
        }
        if (!this.cfa.getLoopStructure().isPresent()) {
            return this.getLoopHeads().isEmpty();
        }
        ImmutableSet locations = AbstractStates.extractLocations(candidate.filterApplicable(pReached)).toSet();
        if (locations.isEmpty()) {
            return false;
        }
        for (LoopStructure.Loop loop : this.cfa.getLoopStructure().orElseThrow().getAllLoops()) {
            for (CFANode location : locations) {
                if (!loop.getLoopNodes().contains((Object)location) || (Integer)reachedK.get(loop) >= finalMaxK) continue;
                return false;
            }
        }
        return true;
    }

    private static enum InvariantGeneratorHeadStartFactories {
        NONE{

            @Override
            public InvariantGeneratorHeadStart createFor(AbstractBMCAlgorithm pBmcAlgorithm) {
                return new InvariantGeneratorHeadStart(){

                    @Override
                    public void waitForInvariantGenerator() throws InterruptedException {
                    }
                };
            }
        }
        ,
        AWAIT_TERMINATION{

            @Override
            public InvariantGeneratorHeadStart createFor(AbstractBMCAlgorithm pBmcAlgorithm) {
                final CountDownLatch latch = new CountDownLatch(1);
                pBmcAlgorithm.conditionAdjustmentEventSubscribers.add(new ParallelAlgorithm.ConditionAdjustmentEventSubscriber(){

                    @Override
                    public void adjustmentSuccessful(ConfigurableProgramAnalysis pCpa) {
                    }

                    @Override
                    public void adjustmentRefused(ConfigurableProgramAnalysis pCpa) {
                        latch.countDown();
                    }
                });
                return new HeadStartWithLatch(pBmcAlgorithm, latch);
            }
        }
        ,
        WAIT_UNTIL_EXPENSIVE_ADJUSTMENT{

            @Override
            InvariantGeneratorHeadStart createFor(AbstractBMCAlgorithm pBmcAlgorithm) {
                final CountDownLatch latch = new CountDownLatch(1);
                pBmcAlgorithm.conditionAdjustmentEventSubscribers.add(new ParallelAlgorithm.ConditionAdjustmentEventSubscriber(){

                    @Override
                    public void adjustmentSuccessful(ConfigurableProgramAnalysis pCpa) {
                        FluentIterable cpas = CPAs.asIterable(pCpa).filter(InvariantsCPA.class);
                        if (cpas.isEmpty()) {
                            latch.countDown();
                        } else {
                            for (InvariantsCPA invariantCpa : cpas) {
                                if (!invariantCpa.isLikelyLongRunning()) continue;
                                latch.countDown();
                                break;
                            }
                        }
                    }

                    @Override
                    public void adjustmentRefused(ConfigurableProgramAnalysis pCpa) {
                        latch.countDown();
                    }
                });
                return new HeadStartWithLatch(pBmcAlgorithm, latch);
            }
        };


        abstract InvariantGeneratorHeadStart createFor(AbstractBMCAlgorithm var1);

        private static final class HeadStartWithLatch
        implements InvariantGeneratorHeadStart {
            private final CountDownLatch latch;
            private final ShutdownNotifier.ShutdownRequestListener shutdownListener = new ShutdownNotifier.ShutdownRequestListener(){

                public void shutdownRequested(String pReason) {
                    latch.countDown();
                }
            };

            public HeadStartWithLatch(AbstractBMCAlgorithm pBmcAlgorithm, CountDownLatch pLatch) {
                this.latch = Objects.requireNonNull(pLatch);
                pBmcAlgorithm.shutdownNotifier.registerAndCheckImmediately(this.shutdownListener);
            }

            @Override
            public void waitForInvariantGenerator() throws InterruptedException {
                this.latch.await();
            }
        }
    }

    private static interface InvariantGeneratorHeadStart {
        public void waitForInvariantGenerator() throws InterruptedException;
    }

    private static class BmcResult {
        private final Set<AbstractState> checkedStates = new HashSet<AbstractState>();
        private boolean safe = true;

        private BmcResult() {
        }

        public void addSafeStates(Iterable<AbstractState> pSafeStates) {
            Iterables.addAll(this.checkedStates, pSafeStates);
        }

        public void declareUnsafe() {
            this.safe = false;
            this.checkedStates.clear();
        }

        public boolean isSafe() {
            return this.safe;
        }

        public Iterable<AbstractState> filterUnchecked(Iterable<AbstractState> pStates) {
            Preconditions.checkState((boolean)this.isSafe(), (Object)"A counterexample was found already.");
            return Iterables.filter(pStates, (Predicate)Predicates.not((Predicate)Predicates.in(this.checkedStates)));
        }
    }

    private static class Obligation
    implements CandidateInvariant,
    Comparable<Obligation> {
        private final CandidateInvariant causingCandidateInvariant;
        private final @Nullable Obligation causingObligation;
        private final SymbolicCandiateInvariant blockingClause;
        private final List<SymbolicCandiateInvariant> weakenings;
        private int hashCode = 0;

        private Obligation(CandidateInvariant pCause, SymbolicCandiateInvariant pBlockingClause, List<SymbolicCandiateInvariant> pStrengthening) {
            if (pCause instanceof Obligation) {
                this.causingObligation = (Obligation)pCause;
                this.causingCandidateInvariant = this.causingObligation.causingCandidateInvariant;
            } else {
                this.causingCandidateInvariant = Objects.requireNonNull(pCause);
                this.causingObligation = null;
            }
            this.blockingClause = Objects.requireNonNull(pBlockingClause);
            this.weakenings = ImmutableList.copyOf(pStrengthening);
        }

        public Obligation(CandidateInvariant pCause, SymbolicCandiateInvariant pBlockingClause) {
            this(pCause, pBlockingClause, (List<SymbolicCandiateInvariant>)ImmutableList.of());
        }

        public int getDepth() {
            int depth = 0;
            Obligation current = this;
            while (current.causingObligation != null) {
                current = current.causingObligation;
                ++depth;
            }
            assert (depth == 0 && this.causingObligation == null || depth > 0 && this.causingObligation != null);
            return depth;
        }

        public String toString() {
            return this.blockingClause.toString();
        }

        public CandidateInvariant getRootCause() {
            return this.causingCandidateInvariant;
        }

        public SymbolicCandiateInvariant getBlockingClause() {
            return this.blockingClause;
        }

        public List<SymbolicCandiateInvariant> getWeakenings() {
            return this.weakenings;
        }

        public Obligation refineWith(FormulaManagerView pFmgr, SymbolicCandiateInvariant pRefinedBlockingClause) throws InterruptedException {
            if (pRefinedBlockingClause == this.blockingClause) {
                return this;
            }
            BooleanFormulaManagerView bfmgr = pFmgr.getBooleanFormulaManager();
            ImmutableSet reducedLiftedCti = ImmutableSet.copyOf(SymbolicCandiateInvariant.getConjunctionOperands(pFmgr, bfmgr.not(pRefinedBlockingClause.getPlainFormula(pFmgr)), true));
            ImmutableList remainingLiterals = FluentIterable.from(SymbolicCandiateInvariant.getConjunctionOperands(pFmgr, bfmgr.not(this.blockingClause.getPlainFormula(pFmgr)), true)).filter(Predicates.not((Predicate)Predicates.in((Collection)reducedLiftedCti))).toList();
            BooleanFormula strengthened = bfmgr.and((Collection)reducedLiftedCti);
            ArrayList<SymbolicCandiateInvariant> weakenedInvariants = new ArrayList<SymbolicCandiateInvariant>(remainingLiterals.size());
            for (BooleanFormula remainingLiteral : remainingLiterals) {
                strengthened = bfmgr.and(strengthened, remainingLiteral);
                weakenedInvariants.add(SymbolicCandiateInvariant.makeSymbolicInvariant(this.blockingClause.getApplicableLocations(), this.blockingClause.getStateFilter(), bfmgr.not(strengthened), pFmgr));
            }
            if (this.causingObligation == null) {
                return new Obligation(this.causingCandidateInvariant, pRefinedBlockingClause, weakenedInvariants);
            }
            return new Obligation(this.causingObligation, pRefinedBlockingClause, weakenedInvariants);
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            if (this.causingObligation != null) {
                this.hashCode = Objects.hash(this.causingObligation, this.blockingClause, this.weakenings);
                return this.hashCode;
            }
            this.hashCode = Objects.hash(this.causingCandidateInvariant, this.blockingClause, this.weakenings);
            return this.hashCode;
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther instanceof Obligation) {
                Obligation other = (Obligation)pOther;
                if (this.causingObligation == null) {
                    return other.causingObligation == null && this.causingCandidateInvariant.equals(other.causingCandidateInvariant) && this.blockingClause.equals(other.blockingClause) && this.weakenings.equals(other.weakenings);
                }
                return this.causingObligation.equals(other.causingObligation) && this.blockingClause.equals(other.blockingClause) && this.weakenings.equals(other.weakenings);
            }
            return false;
        }

        @Override
        public BooleanFormula getFormula(FormulaManagerView pFmgr, PathFormulaManager pPfmgr, @Nullable PathFormula pContext) throws CPATransferException, InterruptedException {
            return this.blockingClause.getFormula(pFmgr, pPfmgr, pContext);
        }

        @Override
        public BooleanFormula getAssertion(Iterable<AbstractState> pReachedSet, FormulaManagerView pFMGR, PathFormulaManager pPFMGR) throws CPATransferException, InterruptedException {
            return this.blockingClause.getAssertion(pReachedSet, pFMGR, pPFMGR);
        }

        @Override
        public void assumeTruth(ReachedSet pReachedSet) {
            this.blockingClause.assumeTruth(pReachedSet);
        }

        @Override
        public boolean appliesTo(CFANode pLocation) {
            return this.blockingClause.appliesTo(pLocation);
        }

        @Override
        public int compareTo(Obligation pObligation) {
            if (this == pObligation) {
                return 0;
            }
            return Integer.compare(this.getDepth(), pObligation.getDepth());
        }
    }

    public static enum InvariantGeneratorFactory {
        INDUCTION{

            @Override
            InvariantGenerator createInvariantGenerator(Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownManager pShutdownManager, CFA pCFA, Specification pSpecification, AggregatedReachedSets pAggregatedReachedSets, TargetLocationProvider pTargetLocationProvider) throws InvalidConfigurationException, CPAException, InterruptedException {
                return KInductionInvariantGenerator.create(pConfig, pLogger, pShutdownManager, pCFA, pSpecification, pReachedSetFactory, pTargetLocationProvider, pAggregatedReachedSets);
            }
        }
        ,
        REACHED_SET{

            @Override
            InvariantGenerator createInvariantGenerator(Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownManager pShutdownManager, final CFA pCFA, Specification pSpecification, final AggregatedReachedSets pAggregatedReachedSets, TargetLocationProvider pTargetLocationProvider) {
                return new AbstractInvariantGenerator(){

                    @Override
                    protected void startImpl(CFANode pInitialLocation) {
                    }

                    @Override
                    public boolean isProgramSafe() {
                        return false;
                    }

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public InvariantSupplier getSupplier() throws CPAException, InterruptedException {
                        return new FormulaInvariantsSupplier(pAggregatedReachedSets);
                    }

                    @Override
                    public ExpressionTreeSupplier getExpressionTreeSupplier() throws CPAException, InterruptedException {
                        return new ExpressionTreeInvariantSupplier(pAggregatedReachedSets, pCFA);
                    }
                };
            }
        }
        ,
        DO_NOTHING{

            @Override
            InvariantGenerator createInvariantGenerator(Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownManager pShutdownManager, CFA pCFA, Specification pSpecification, AggregatedReachedSets pAggregatedReachedSets, TargetLocationProvider pTargetLocationProvider) {
                return new DoNothingInvariantGenerator();
            }
        }
        ,
        INVARIANT_STORE{

            @Override
            InvariantGenerator createInvariantGenerator(Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownManager pShutdownManager, CFA pCFA, Specification pSpecification, AggregatedReachedSets pAggregatedReachedSets, TargetLocationProvider pTargetLocationProvider) throws InvalidConfigurationException, CPAException, InterruptedException {
                try {
                    return InvariantWitnessGenerator.getNewFromDiskInvariantGenerator(pConfig, pCFA, pLogger, pShutdownManager.getNotifier());
                }
                catch (IOException e) {
                    throw new CPAException("Could not create from disk generator", e);
                }
            }
        };


        abstract InvariantGenerator createInvariantGenerator(Configuration var1, LogManager var2, ReachedSetFactory var3, ShutdownManager var4, CFA var5, Specification var6, AggregatedReachedSets var7, TargetLocationProvider var8) throws InvalidConfigurationException, CPAException, InterruptedException;
    }
}

