/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.bmc.AbstractionStrategy;
import org.sosy_lab.cpachecker.core.algorithm.bmc.AssertCandidate;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CounterexampleToInductivity;
import org.sosy_lab.cpachecker.core.algorithm.bmc.Lifting;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ProverEnvironmentWithFallback;
import org.sosy_lab.cpachecker.core.algorithm.bmc.StandardLiftings;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SymbolicCandiateInvariant;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public class AbstractionBasedLifting
implements Lifting {
    private final AbstractionStrategy abstractionStrategy;
    private final LiftingAbstractionFailureStrategy lafStrategy;

    public AbstractionBasedLifting(AbstractionStrategy pAbstractionStrategy, LiftingAbstractionFailureStrategy pLAFStrategy) {
        this.abstractionStrategy = Objects.requireNonNull(pAbstractionStrategy);
        this.lafStrategy = Objects.requireNonNull(pLAFStrategy);
    }

    @Override
    public boolean canLift() {
        return true;
    }

    @Override
    public SymbolicCandiateInvariant lift(FormulaManagerView pFMGR, PredicateAbstractionManager pPam, ProverEnvironmentWithFallback pProver, SymbolicCandiateInvariant.BlockedCounterexampleToInductivity pBlockedConcreteCti, AssertCandidate pAssertPredecessor, Iterable<Object> pAssertionIds) throws CPATransferException, InterruptedException, SolverException {
        CounterexampleToInductivity cti = pBlockedConcreteCti.getCti();
        BooleanFormula concreteCTIFormula = cti.getFormula(pFMGR);
        BooleanFormula abstractCtiFormula = this.abstractionStrategy.performAbstraction(pPam, cti.getLocation(), concreteCTIFormula);
        BooleanFormulaManagerView bfmgr = pFMGR.getBooleanFormulaManager();
        BooleanFormula blockedAbstractCtiFormula = bfmgr.not(abstractCtiFormula);
        SymbolicCandiateInvariant blockedAbstractCti = SymbolicCandiateInvariant.makeSymbolicInvariant(pBlockedConcreteCti.getApplicableLocations(), pBlockedConcreteCti.getStateFilter(), blockedAbstractCtiFormula, pFMGR);
        SuccessCheckingLiftingUnsatCallback abstractLiftingUnsatCallback = new SuccessCheckingLiftingUnsatCallback();
        SymbolicCandiateInvariant unsatLiftedAbstractBlockingClause = StandardLiftings.unsatBasedLifting(pFMGR, pProver, blockedAbstractCti, blockedAbstractCti.negate(pFMGR).splitLiterals(pFMGR, false), pAssertPredecessor, pAssertionIds, abstractLiftingUnsatCallback);
        if (abstractLiftingUnsatCallback.isSuccessful()) {
            return unsatLiftedAbstractBlockingClause;
        }
        return this.lafStrategy.handleLAF(pFMGR, pPam, pProver, pBlockedConcreteCti, blockedAbstractCti, pAssertPredecessor, pAssertionIds, this.abstractionStrategy);
    }

    private static void refinePrecision(AbstractionStrategy pAbstractionStrategy, PredicateAbstractionManager pPam, FormulaManagerView pFMGR, CFANode pLocation, BooleanFormula pInterpolant) {
        pAbstractionStrategy.refinePrecision(pPam, pLocation, (Iterable<BooleanFormula>)FluentIterable.from(SymbolicCandiateInvariant.getConjunctionOperands(pFMGR, pInterpolant, true)).filter(f -> !pFMGR.getBooleanFormulaManager().isTrue((BooleanFormula)f)));
    }

    public static enum RefinementLAFStrategies implements LiftingAbstractionFailureStrategy
    {
        IGNORE{

            @Override
            public SymbolicCandiateInvariant handleLAF(FormulaManagerView pFMGR, PredicateAbstractionManager pPam, ProverEnvironmentWithFallback pProver, SymbolicCandiateInvariant.BlockedCounterexampleToInductivity pBlockedConcreteCti, SymbolicCandiateInvariant pBlockedAbstractCti, AssertCandidate pAssertPredecessor, Iterable<Object> pAssertionIds, AbstractionStrategy pAbstractionStrategy) throws CPATransferException, InterruptedException, SolverException {
                return pBlockedAbstractCti;
            }
        }
        ,
        EAGER{

            @Override
            public SymbolicCandiateInvariant handleLAF(FormulaManagerView pFMGR, PredicateAbstractionManager pPam, ProverEnvironmentWithFallback pProver, SymbolicCandiateInvariant.BlockedCounterexampleToInductivity pBlockedConcreteCti, SymbolicCandiateInvariant pBlockedAbstractCti, AssertCandidate pAssertPredecessor, Iterable<Object> pAssertionIds, AbstractionStrategy pAbstractionStrategy) throws CPATransferException, InterruptedException, SolverException {
                InterpolatingLiftingUnsatCallback concreteLiftingUnsatCallback = new InterpolatingLiftingUnsatCallback(pFMGR, pProver);
                FluentIterable<CandidateInvariant> ctiLiterals = pBlockedConcreteCti.getCti().splitLiterals(pFMGR, false);
                SymbolicCandiateInvariant unsatLiftedConcreteCTI = StandardLiftings.unsatBasedLifting(pFMGR, pProver, pBlockedConcreteCti, ctiLiterals, pAssertPredecessor, pAssertionIds, concreteLiftingUnsatCallback);
                if (concreteLiftingUnsatCallback.isSuccessful()) {
                    BooleanFormulaManagerView bfmgr = pFMGR.getBooleanFormulaManager();
                    BooleanFormula interpolant = concreteLiftingUnsatCallback.getInterpolant();
                    if (interpolant == null) {
                        return unsatLiftedConcreteCTI;
                    }
                    interpolant = pFMGR.uninstantiate(interpolant);
                    AbstractionBasedLifting.refinePrecision(pAbstractionStrategy, pPam, pFMGR, pBlockedConcreteCti.getCti().getLocation(), interpolant);
                    SymbolicCandiateInvariant refinedBlockingClause = SymbolicCandiateInvariant.makeSymbolicInvariant(pBlockedConcreteCti.getApplicableLocations(), pBlockedConcreteCti.getStateFilter(), bfmgr.not(bfmgr.and(bfmgr.not(pBlockedAbstractCti.getPlainFormula(pFMGR)), interpolant)), pFMGR);
                    return refinedBlockingClause;
                }
                return pBlockedConcreteCti;
            }
        };

    }

    public static interface LiftingAbstractionFailureStrategy {
        public SymbolicCandiateInvariant handleLAF(FormulaManagerView var1, PredicateAbstractionManager var2, ProverEnvironmentWithFallback var3, SymbolicCandiateInvariant.BlockedCounterexampleToInductivity var4, SymbolicCandiateInvariant var5, AssertCandidate var6, Iterable<Object> var7, AbstractionStrategy var8) throws CPATransferException, InterruptedException, SolverException;
    }

    private static class InterpolatingLiftingUnsatCallback
    extends SuccessCheckingLiftingUnsatCallback {
        private final FormulaManagerView fmgr;
        private final ProverEnvironmentWithFallback prover;
        private @Nullable BooleanFormula interpolant = null;

        InterpolatingLiftingUnsatCallback(FormulaManagerView pFmgr, ProverEnvironmentWithFallback pProver) {
            this.fmgr = Objects.requireNonNull(pFmgr);
            this.prover = Objects.requireNonNull(pProver);
        }

        @Override
        public void unsat(SymbolicCandiateInvariant pLiftedCTI, Iterable<Object> pCtiLiteralAssertionIds, Iterable<Object> pOtherAssertionIds) throws SolverException, InterruptedException {
            super.unsat(pLiftedCTI, pCtiLiteralAssertionIds, pOtherAssertionIds);
            if (this.prover.supportsInterpolation()) {
                try {
                    this.interpolant = this.fmgr.getBooleanFormulaManager().not(this.prover.getInterpolant(pOtherAssertionIds));
                }
                catch (SolverException solverException) {
                    // empty catch block
                }
            }
        }

        public @Nullable BooleanFormula getInterpolant() {
            Preconditions.checkState((boolean)this.isSuccessful(), (Object)"Lifting not yet performed or unsuccessful.");
            return this.interpolant;
        }
    }

    private static class SuccessCheckingLiftingUnsatCallback
    implements StandardLiftings.UnsatCallback {
        private boolean successful = false;

        private SuccessCheckingLiftingUnsatCallback() {
        }

        @Override
        public void unsat(SymbolicCandiateInvariant pLiftedCTI, Iterable<Object> pCtiLiteralAssertionIds, Iterable<Object> pOtherAssertionIds) throws SolverException, InterruptedException {
            this.successful = true;
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

