/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.LoopIterationReportingState;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AdjustableConditionCPA;
import org.sosy_lab.cpachecker.core.interfaces.conditions.ReachedSetAdjustingCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.automaton.Automata;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProvider;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;

public final class BMCHelper {
    public static boolean isEndState(AbstractState s) {
        ARGState argState = AbstractStates.extractStateByType(s, ARGState.class);
        return argState != null && argState.getChildren().isEmpty();
    }

    private BMCHelper() {
    }

    public static BooleanFormula assertAt(Iterable<AbstractState> pStates, CandidateInvariant pInvariant, FormulaManagerView pFMGR, PathFormulaManager pPFMGR) throws CPATransferException, InterruptedException {
        return BMCHelper.assertAt(pStates, pInvariant, pFMGR, pPFMGR, false);
    }

    public static BooleanFormula assertAt(Iterable<AbstractState> pStates, CandidateInvariant pInvariant, FormulaManagerView pFMGR, PathFormulaManager pPFMGR, boolean pForce) throws CPATransferException, InterruptedException {
        return BMCHelper.assertAt(pStates, (PathFormula pContext) -> pInvariant.getFormula(pFMGR, pPFMGR, pContext), pFMGR, pForce);
    }

    public static BooleanFormula assertAt(Iterable<AbstractState> pStates, FormulaInContext pInvariant, FormulaManagerView pFMGR) throws CPATransferException, InterruptedException {
        return BMCHelper.assertAt(pStates, pInvariant, pFMGR, false);
    }

    public static BooleanFormula assertAt(Iterable<AbstractState> pStates, FormulaInContext pInvariant, FormulaManagerView pFMGR, boolean pForce) throws CPATransferException, InterruptedException {
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (AbstractState abstractState : pStates) {
            result.add(BMCHelper.assertAt(abstractState, pInvariant, pFMGR, pForce));
        }
        return pFMGR.getBooleanFormulaManager().and(result);
    }

    private static BooleanFormula assertAt(AbstractState pState, FormulaInContext pInvariant, FormulaManagerView pFMGR, boolean pForce) throws CPATransferException, InterruptedException {
        BooleanFormula stateFormula;
        PredicateAbstractState pas = AbstractStates.extractStateByType(pState, PredicateAbstractState.class);
        PathFormula pathFormula = pas.getPathFormula();
        BooleanFormulaManagerView bfmgr = pFMGR.getBooleanFormulaManager();
        if (bfmgr.isFalse(stateFormula = pathFormula.getFormula())) {
            return bfmgr.makeTrue();
        }
        SSAMap ssaMap = pathFormula.getSsa().withDefault(1);
        BooleanFormula uninstantiatedFormula = pInvariant.getFormulaInContext(pathFormula);
        BooleanFormula instantiatedFormula = pFMGR.instantiate(uninstantiatedFormula, ssaMap);
        if (pForce) {
            return instantiatedFormula;
        }
        return bfmgr.or(bfmgr.not(stateFormula), instantiatedFormula);
    }

    public static BooleanFormula createFormulaFor(Iterable<AbstractState> states, BooleanFormulaManager pBFMGR) throws InterruptedException {
        return BMCHelper.createFormulaFor(states, pBFMGR, Optional.empty());
    }

    public static BooleanFormula createFormulaFor(Iterable<AbstractState> states, BooleanFormulaManager pBFMGR, Optional<ShutdownNotifier> pShutdownNotifier) throws InterruptedException {
        ArrayList<BooleanFormula> pathFormulas = new ArrayList<BooleanFormula>();
        for (PredicateAbstractState e : AbstractStates.projectToType(states, PredicateAbstractState.class)) {
            if (pShutdownNotifier.isPresent()) {
                pShutdownNotifier.orElseThrow().shutdownIfNecessary();
            }
            BooleanFormula pathFormula = pBFMGR.and(e.getAbstractionFormula().getBlockFormula().getFormula(), e.getPathFormula().getFormula());
            pathFormulas.add(pathFormula);
        }
        return pBFMGR.or(pathFormulas);
    }

    public static Algorithm.AlgorithmStatus unroll(LogManager pLogger, ReachedSet pReachedSet, Algorithm pAlgorithm, ConfigurableProgramAnalysis pCPA) throws CPAException, InterruptedException {
        BMCHelper.adjustReachedSet(pLogger, pReachedSet, pCPA);
        return pAlgorithm.run(pReachedSet);
    }

    public static void adjustReachedSet(LogManager pLogger, ReachedSet pReachedSet, ConfigurableProgramAnalysis pCPA) throws InterruptedException {
        Preconditions.checkArgument((!pReachedSet.isEmpty() ? 1 : 0) != 0);
        CFANode initialLocation = AbstractStates.extractLocation(pReachedSet.getFirstState());
        for (AdjustableConditionCPA conditionCPA : CPAs.asIterable(pCPA).filter(AdjustableConditionCPA.class)) {
            if (conditionCPA instanceof ReachedSetAdjustingCPA) {
                ((ReachedSetAdjustingCPA)conditionCPA).adjustReachedSet(pReachedSet);
                continue;
            }
            pReachedSet.clear();
            pLogger.log(Level.WARNING, new Object[]{"Completely clearing the reached set after condition adjustment due to " + conditionCPA.getClass() + ". This may drastically impede the efficiency of iterative deepening. Implement ReachedSetAdjustingCPA to avoid this problem."});
            break;
        }
        if (pReachedSet.isEmpty()) {
            pReachedSet.add(pCPA.getInitialState(initialLocation, StateSpacePartition.getDefaultPartition()), pCPA.getInitialPrecision(initialLocation, StateSpacePartition.getDefaultPartition()));
        }
    }

    public static Set<CFANode> getLoopHeads(CFA pCFA, TargetLocationProvider pTargetLocationProvider) {
        if (pCFA.getLoopStructure().isPresent() && pCFA.getLoopStructure().orElseThrow().getAllLoops().isEmpty()) {
            return ImmutableSet.of();
        }
        ImmutableSet<CFANode> loopHeads = pTargetLocationProvider.tryGetAutomatonTargetLocations(pCFA.getMainFunction(), Specification.fromAutomata((List<Automaton>)ImmutableList.of((Object)Automata.getLoopHeadTargetAutomaton())));
        if (!pCFA.getLoopStructure().isPresent()) {
            return loopHeads;
        }
        LoopStructure loopStructure = pCFA.getLoopStructure().orElseThrow();
        return FluentIterable.from(loopStructure.getAllLoops()).transformAndConcat(pLoop -> {
            if (Sets.intersection(pLoop.getLoopNodes(), (Set)loopHeads).isEmpty()) {
                return ImmutableSet.of();
            }
            return pLoop.getLoopHeads();
        }).toSet();
    }

    public static FluentIterable<AbstractState> filterIterationsBetween(Iterable<AbstractState> pStates, int pMinIt, int pMaxIt, Set<CFANode> pLoopHeads) {
        Objects.requireNonNull(pLoopHeads);
        if (pMinIt > pMaxIt) {
            throw new IllegalArgumentException(String.format("Minimum (%d) not lower than maximum (%d)", pMinIt, pMaxIt));
        }
        return FluentIterable.from(pStates).filter(state -> {
            if (state == null) {
                return false;
            }
            LoopIterationReportingState ls = AbstractStates.extractStateByType(state, LoopIterationReportingState.class);
            if (ls == null) {
                return false;
            }
            int minIt = BMCHelper.convertIteration(pMinIt, state, pLoopHeads);
            int maxIt = BMCHelper.convertIteration(pMaxIt, state, pLoopHeads);
            int actualIt = ls.getDeepestIteration();
            return minIt <= actualIt && actualIt <= maxIt;
        });
    }

    public static FluentIterable<AbstractState> filterIterationsUpTo(Iterable<AbstractState> pStates, int pIteration, Set<CFANode> pLoopHeads) {
        return BMCHelper.filterIterationsBetween(pStates, 0, pIteration, pLoopHeads);
    }

    public static FluentIterable<AbstractState> filterIteration(Iterable<AbstractState> pStates, int pIteration, Set<CFANode> pLoopHeads) {
        return BMCHelper.filterIterationsBetween(pStates, pIteration, pIteration, pLoopHeads);
    }

    private static int convertIteration(int pIteration, AbstractState state, Set<CFANode> pLoopHeads) {
        if (pIteration == Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("The highest supported value for an iteration count is %d, which is exceeded by %d", 0x7FFFFFFE, pIteration));
        }
        return !AbstractStates.isTargetState(state) && BMCHelper.hasMatchingLocation(state, pLoopHeads) ? pIteration + 1 : pIteration;
    }

    public static boolean hasMatchingLocation(AbstractState state, Set<CFANode> pLocations) {
        return FluentIterable.from(AbstractStates.extractLocations(state)).anyMatch(pLocations::contains);
    }

    public static Set<ARGState> filterAncestors(Iterable<ARGState> pStates, Predicate<? super AbstractState> pDescendant) {
        HashMultimap parentToTarget = HashMultimap.create();
        for (ARGState state : FluentIterable.from(pStates).filter(pDescendant::test)) {
            if (!state.getChildren().isEmpty()) continue;
            Collection<ARGState> parents = state.getParents();
            for (ARGState parent : parents) {
                parentToTarget.put((Object)parent, (Object)state);
            }
        }
        HashSet<ARGState> redundantStates = new HashSet<ARGState>();
        for (Map.Entry family : parentToTarget.asMap().entrySet()) {
            ARGState parent = (ARGState)family.getKey();
            Collection children = (Collection)family.getValue();
            ImmutableSet edges = FluentIterable.from((Iterable)children).transformAndConcat(parent::getEdgesToChild).toSet();
            if (edges.size() != 1 || edges.iterator().next() instanceof AssumeEdge) continue;
            Iterables.addAll(redundantStates, (Iterable)Iterables.skip((Iterable)children, (int)1));
        }
        return redundantStates;
    }

    public static boolean isTrivialSelfLoop(final LoopStructure.Loop pLoop) {
        ImmutableSet<CFANode> loopHeads = pLoop.getLoopHeads();
        if (loopHeads.size() != 1) {
            return false;
        }
        final CFANode loopHead = (CFANode)loopHeads.iterator().next();
        class TrivialSelfLoopVisitor
        implements CFATraversal.CFAVisitor {
            private boolean valid = true;

            TrivialSelfLoopVisitor() {
            }

            @Override
            public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
                if (!pEdge.getEdgeType().equals((Object)CFAEdgeType.BlankEdge) || !pLoop.getLoopNodes().contains((Object)pEdge.getSuccessor())) {
                    this.valid = false;
                    return CFATraversal.TraversalProcess.ABORT;
                }
                if (pEdge.getSuccessor().equals(loopHead)) {
                    return CFATraversal.TraversalProcess.SKIP;
                }
                return CFATraversal.TraversalProcess.CONTINUE;
            }

            @Override
            public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
                return CFATraversal.TraversalProcess.CONTINUE;
            }
        }
        TrivialSelfLoopVisitor visitor = new TrivialSelfLoopVisitor();
        CFATraversal.dfs().traverseOnce(loopHead, visitor);
        return visitor.valid;
    }

    public static BooleanFormula disjoinStateViolationAssertions(BooleanFormulaManager pBfmgr, Multimap<BooleanFormula, BooleanFormula> pSuccessorViolationAssertions) {
        ArrayList<BooleanFormula> assertions = new ArrayList<BooleanFormula>();
        for (Map.Entry stateWithViolations : pSuccessorViolationAssertions.asMap().entrySet()) {
            assertions.add(pBfmgr.and((BooleanFormula)stateWithViolations.getKey(), pBfmgr.and((Collection)stateWithViolations.getValue())));
        }
        return pBfmgr.or(assertions);
    }

    static FluentIterable<AbstractState> filterBmcChecked(Iterable<AbstractState> pStates, Set<Object> pCheckedKeys) {
        return FluentIterable.from(pStates).filter(pArg0 -> {
            if (pArg0 == null) {
                return false;
            }
            LoopIterationReportingState ls = AbstractStates.extractStateByType(pArg0, LoopIterationReportingState.class);
            return ls != null && pCheckedKeys.contains(ls.getPartitionKey());
        });
    }

    static FluentIterable<AbstractState> filterBmcCheckedWithin(Iterable<AbstractState> pStates, Set<Object> pCheckedKeys, Iterable<LoopStructure.Loop> pLoops) {
        return FluentIterable.from(pStates).filter(pState -> BMCHelper.isWithinBmcCheckedRange(pState, pCheckedKeys, pLoops));
    }

    private static boolean isWithinBmcCheckedRange(AbstractState pState, Set<Object> pCheckedKeys, Iterable<LoopStructure.Loop> pLoops) {
        LoopIterationReportingState loopState = AbstractStates.extractStateByType(pState, LoopIterationReportingState.class);
        if (loopState == null) {
            return false;
        }
        for (Object key : pCheckedKeys) {
            LoopIterationReportingState checkedState = (LoopIterationReportingState)key;
            boolean withinCheckedRange = true;
            for (LoopStructure.Loop loop : pLoops) {
                if (loopState.getIteration(loop) <= checkedState.getIteration(loop)) continue;
                withinCheckedRange = false;
                break;
            }
            if (!withinCheckedRange) continue;
            return true;
        }
        return false;
    }

    public static interface FormulaInContext {
        public BooleanFormula getFormulaInContext(PathFormula var1) throws CPATransferException, InterruptedException;
    }
}

