/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import java.io.PrintStream;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;

public class BMCStatistics
implements Statistics {
    final Timer bmcPreparation = new Timer();
    final Timer satCheck = new Timer();
    final Timer errorPathCreation = new Timer();
    final Timer errorPathProcessing = new Timer();
    final Timer assertionsCheck = new Timer();
    final Timer inductionPreparation = new Timer();
    final Timer inductionCheck = new Timer();
    final Timer interpolationPreparation = new Timer();
    final Timer fixedPointComputation = new Timer();
    int numOfIMCInnerIterations = -1;

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        if (this.bmcPreparation.getNumberOfIntervals() > 0) {
            out.println("Time for BMC formula creation:                   " + this.bmcPreparation);
        }
        if (this.satCheck.getNumberOfIntervals() > 0) {
            out.println("Time for final sat check:                        " + this.satCheck);
        }
        if (this.errorPathCreation.getNumberOfIntervals() > 0) {
            out.println("Time for error-path creation:                    " + this.errorPathCreation);
        }
        if (this.errorPathProcessing.getNumberOfIntervals() > 0) {
            out.println("Time for error-path post-processing:             " + this.errorPathProcessing);
        }
        if (this.assertionsCheck.getNumberOfIntervals() > 0) {
            out.println("Time for bounding assertions check:              " + this.assertionsCheck);
        }
        if (this.inductionCheck.getNumberOfIntervals() > 0) {
            out.println("Time for induction formula creation:             " + this.inductionPreparation);
            out.println("Time for induction check:                        " + this.inductionCheck);
        }
        if (this.fixedPointComputation.getNumberOfIntervals() > 0) {
            out.println("Time for collecting formulas for interpolation:  " + this.interpolationPreparation);
            out.println("Time for computing fixed point by interpolation: " + this.fixedPointComputation);
        }
        if (this.numOfIMCInnerIterations >= 0) {
            out.println("Number of IMC inner iterations:                  " + this.numOfIMCInnerIterations);
        }
    }

    @Override
    public String getName() {
        return "BMC algorithm";
    }
}

