/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.collect.FluentIterable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ModelValue;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SingleLocationFormulaInvariant;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class CounterexampleToInductivity {
    private final CFANode location;
    private final PersistentSortedMap<String, ModelValue> model;

    public CounterexampleToInductivity(CFANode pLocation, Map<String, ModelValue> pModel) {
        this.location = Objects.requireNonNull(pLocation);
        this.model = PathCopyingPersistentTreeMap.copyOf(pModel);
    }

    public BooleanFormula getFormula(FormulaManagerView pFMGR) {
        BooleanFormulaManagerView bfmgr = pFMGR.getBooleanFormulaManager();
        BooleanFormula modelFormula = bfmgr.makeTrue();
        for (Map.Entry valueAssignment : this.model.entrySet()) {
            String variableName = (String)valueAssignment.getKey();
            ModelValue v = (ModelValue)valueAssignment.getValue();
            assert (variableName.equals(v.getVariableName()));
            modelFormula = bfmgr.and(modelFormula, v.toAssignment(pFMGR));
        }
        return modelFormula;
    }

    public Map<String, ModelValue> getAssignments() {
        return this.model;
    }

    public CounterexampleToInductivity dropLiteral(String pVarName) {
        PersistentSortedMap reducedModel = this.model.removeAndCopy((Object)pVarName);
        if (reducedModel.size() == this.model.size()) {
            throw new IllegalArgumentException(pVarName + " is not part of this CTI");
        }
        return new CounterexampleToInductivity(this.getLocation(), (Map<String, ModelValue>)reducedModel);
    }

    public CFANode getLocation() {
        return this.location;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof CounterexampleToInductivity) {
            CounterexampleToInductivity other = (CounterexampleToInductivity)pOther;
            return this.model.equals(other.model) && this.getLocation().equals(other.getLocation());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.model, this.getLocation());
    }

    public String toString() {
        return this.model.values() + " at " + this.getLocation();
    }

    public FluentIterable<CandidateInvariant> splitLiterals(FormulaManagerView pFMGR, boolean pSplitEquals) {
        return FluentIterable.from((Iterable)this.model.values()).transformAndConcat(v -> {
            if (pSplitEquals) {
                return FluentIterable.from(pFMGR.splitNumeralEqualityIfPossible(v.toAssignment(pFMGR))).transform(f -> SingleLocationFormulaInvariant.makeLocationInvariant(this.getLocation(), f, pFMGR));
            }
            return Collections.singleton(SingleLocationFormulaInvariant.makeLocationInvariant(this.getLocation(), v.toAssignment(pFMGR), pFMGR));
        });
    }
}

