/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.collect.ImmutableList;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.AbstractBMCAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCHelper;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCStatistics;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CandidateGenerator;
import org.sosy_lab.cpachecker.core.algorithm.bmc.InterpolationHelper;
import org.sosy_lab.cpachecker.core.algorithm.bmc.PartitionedFormulas;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="imc")
public class IMCAlgorithm
extends AbstractBMCAlgorithm
implements Algorithm {
    @Option(secure=true, description="toggle checking forward conditions")
    private boolean checkForwardConditions = true;
    @Option(secure=true, description="toggle checking whether the safety property is inductive")
    private boolean checkPropertyInductiveness = false;
    @Option(secure=true, description="toggle which strategy is used for computing fixed points in order to verify programs with loops. ITP enables IMC algorithm, and ITPSEQ enables ISMC algorithm. ITPSEQ_AND_ITP runs ISMC first, and if a fixed point is not reached by ISMC, IMC is invoked.")
    private FixedPointComputeStrategy fixedPointComputeStrategy = FixedPointComputeStrategy.ITP;
    @Option(secure=true, description="toggle falling back if interpolation or forward-condition is disabled")
    private boolean fallBack = true;
    @Option(secure=true, description="toggle removing unreachable stop states in ARG")
    private boolean removeUnreachableStopStates = false;
    @Option(secure=true, description="toggle asserting targets at every iteration for IMC")
    private boolean assertTargetsAtEveryIteration = false;
    @Option(secure=true, description="toggle Impact-like covering for the ISMC fixed-point check")
    private boolean impactLikeCovering = false;
    private final ConfigurableProgramAnalysis cpa;
    private final Algorithm algorithm;
    private final PathFormulaManager pfmgr;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final Solver solver;
    private final PredicateAbstractionManager predAbsMgr;
    private final InterpolationManager itpMgr;
    private final CFA cfa;
    private BooleanFormula finalFixedPoint;
    private LoopBoundManager loopBoundMgr;

    public IMCAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCPA, Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownManager pShutdownManager, CFA pCFA, Specification specification, AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException, CPAException, InterruptedException {
        super(pAlgorithm, pCPA, pConfig, pLogger, pReachedSetFactory, pShutdownManager, pCFA, specification, new BMCStatistics(), false, pAggregatedReachedSets);
        pConfig.inject((Object)this);
        this.cpa = pCPA;
        this.cfa = pCFA;
        this.algorithm = pAlgorithm;
        PredicateCPA predCpa = CPAs.retrieveCPAOrFail(this.cpa, PredicateCPA.class, IMCAlgorithm.class);
        this.solver = predCpa.getSolver();
        this.pfmgr = predCpa.getPathFormulaManager();
        this.predAbsMgr = predCpa.getPredicateManager();
        this.fmgr = this.solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.itpMgr = new InterpolationManager(this.pfmgr, this.solver, Optional.empty(), Optional.empty(), pConfig, this.shutdownNotifier, this.logger);
        this.finalFixedPoint = this.bfmgr.makeFalse();
        this.loopBoundMgr = new LoopBoundManager(pConfig);
        if (this.assertTargetsAtEveryIteration && this.fixedPointComputeStrategy != FixedPointComputeStrategy.ITP) {
            this.logger.log(Level.WARNING, new Object[]{"Cannot assert targets at every iteration with current strategy for computing fixed point."});
            this.assertTargetsAtEveryIteration = false;
        }
        if (this.fixedPointComputeStrategy.isIMCEnabled()) {
            this.stats.numOfIMCInnerIterations = 0;
        }
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        try {
            Algorithm.AlgorithmStatus algorithmStatus = this.interpolationModelChecking(pReachedSet);
            return algorithmStatus;
        }
        catch (SolverException e) {
            throw new CPAException("Solver Failure " + e.getMessage(), e);
        }
        finally {
            this.invariantGenerator.cancel();
        }
    }

    private boolean isInterpolationEnabled() {
        return this.fixedPointComputeStrategy != FixedPointComputeStrategy.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Algorithm.AlgorithmStatus interpolationModelChecking(ReachedSet pReachedSet) throws CPAException, SolverException, InterruptedException {
        if (this.getTargetLocations().isEmpty()) {
            pReachedSet.clearWaitlist();
            return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        }
        if (!this.cfa.getAllLoopHeads().isPresent()) {
            if (this.isInterpolationEnabled()) {
                this.logger.log(Level.WARNING, new Object[]{"Disable interpolation as loop structure could not be determined"});
                this.fixedPointComputeStrategy = FixedPointComputeStrategy.NONE;
            }
            if (this.checkPropertyInductiveness) {
                this.logger.log(Level.WARNING, new Object[]{"Disable induction check as loop structure could not be determined"});
                this.checkPropertyInductiveness = false;
            }
        }
        if (this.cfa.getAllLoopHeads().orElseThrow().size() > 1) {
            if (this.isInterpolationEnabled()) {
                if (this.fallBack) {
                    this.fallBackToBMC("Interpolation is not supported for multi-loop programs yet");
                } else {
                    throw new CPAException("Multi-loop programs are not supported yet");
                }
            }
            if (this.checkPropertyInductiveness) {
                this.logger.log(Level.WARNING, new Object[]{"Disable induction check because the program contains multiple loops"});
                this.checkPropertyInductiveness = false;
            }
        }
        this.logger.log(Level.FINE, new Object[]{"Performing interpolation-based model checking"});
        ArrayList<BooleanFormula> reachVector = new ArrayList<BooleanFormula>();
        PartitionedFormulas partitionedFormulas = new PartitionedFormulas(this.bfmgr, this.logger, this.assertTargetsAtEveryIteration);
        do {
            this.shutdownNotifier.shutdownIfNecessary();
            this.stats.bmcPreparation.start();
            try {
                BMCHelper.unroll(this.logger, pReachedSet, this.algorithm, this.cpa);
            }
            finally {
                this.stats.bmcPreparation.stop();
            }
            this.shutdownNotifier.shutdownIfNecessary();
            if (this.loopBoundMgr.performBMCAtCurrentIteration()) {
                try (ProverEnvironment bmcProver = this.solver.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
                    boolean isTargetStateReachable;
                    BooleanFormula targetFormula = InterpolationHelper.buildReachTargetStateFormula(this.bfmgr, pReachedSet);
                    this.stats.satCheck.start();
                    try {
                        bmcProver.push(targetFormula);
                        isTargetStateReachable = !bmcProver.isUnsat();
                    }
                    finally {
                        this.stats.satCheck.stop();
                    }
                    if (isTargetStateReachable) {
                        this.logger.log(Level.FINE, new Object[]{"A target state is reached by BMC"});
                        this.analyzeCounterexample(targetFormula, pReachedSet, (BasicProverEnvironment<?>)bmcProver);
                        Algorithm.AlgorithmStatus algorithmStatus = Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
                        return algorithmStatus;
                    }
                }
            }
            if (this.isInterpolationEnabled() && !InterpolationHelper.checkAndAdjustARG(this.logger, this.cpa, this.bfmgr, this.solver, pReachedSet, this.removeUnreachableStopStates)) {
                if (this.fallBack) {
                    this.fallBackToBMC("The check of ARG failed");
                } else {
                    throw new CPAException("ARG does not meet the requirements");
                }
            }
            if (this.checkForwardConditions && InterpolationHelper.hasCoveredStates(pReachedSet)) {
                if (this.fallBack) {
                    this.fallBackToBMCWithoutForwardCondition("Covered states in ARG: forward-condition might be unsound!");
                } else {
                    throw new CPAException("ARG does not meet the requirements");
                }
            }
            if (this.checkForwardConditions) {
                boolean isStopStateUnreachable;
                this.stats.assertionsCheck.start();
                try {
                    isStopStateUnreachable = this.solver.isUnsat(InterpolationHelper.buildBoundingAssertionFormula(this.bfmgr, pReachedSet));
                }
                finally {
                    this.stats.assertionsCheck.stop();
                }
                if (isStopStateUnreachable) {
                    this.logger.log(Level.FINE, new Object[]{"The program cannot be further unrolled"});
                    InterpolationHelper.removeUnreachableTargetStates(pReachedSet);
                    return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
                }
            }
            if (this.loopBoundMgr.getCurrentMaxLoopIterations() > 1 && !AbstractStates.getTargetStates(pReachedSet).isEmpty()) {
                this.stats.interpolationPreparation.start();
                partitionedFormulas.collectFormulasFromARG(pReachedSet);
                this.stats.interpolationPreparation.stop();
                if (this.checkPropertyInductiveness && this.loopBoundMgr.performKIAtCurrentIteration() && this.isPropertyInductive(partitionedFormulas)) {
                    InterpolationHelper.removeUnreachableTargetStates(pReachedSet);
                    this.logger.log(Level.FINE, new Object[]{"The safety property is inductive"});
                    this.finalFixedPoint = this.bfmgr.makeTrue();
                    InterpolationHelper.storeFixedPointAsAbstractionAtLoopHeads(pReachedSet, this.finalFixedPoint, this.predAbsMgr, this.pfmgr);
                    return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
                }
                if (this.isInterpolationEnabled() && this.reachFixedPoint(partitionedFormulas, reachVector)) {
                    InterpolationHelper.removeUnreachableTargetStates(pReachedSet);
                    InterpolationHelper.storeFixedPointAsAbstractionAtLoopHeads(pReachedSet, this.finalFixedPoint, this.predAbsMgr, this.pfmgr);
                    return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
                }
            }
            InterpolationHelper.removeUnreachableTargetStates(pReachedSet);
            this.loopBoundMgr.incrementLoopBoundsToCheck();
        } while (this.adjustConditions());
        return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
    }

    private void fallBackToBMC(String pReason) {
        this.logger.log(Level.WARNING, new Object[]{"Interpolation disabled because of " + pReason + ", falling back to BMC"});
        this.fixedPointComputeStrategy = FixedPointComputeStrategy.NONE;
    }

    private void fallBackToBMCWithoutForwardCondition(String pReason) {
        this.logger.log(Level.WARNING, new Object[]{"Forward-condition disabled because of " + pReason + ", falling back to plain BMC"});
        this.fixedPointComputeStrategy = FixedPointComputeStrategy.NONE;
        this.checkForwardConditions = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPropertyInductive(PartitionedFormulas formulas) throws InterruptedException, SolverException {
        boolean isInductive;
        try (ProverEnvironment inductionProver = this.solver.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            this.stats.satCheck.start();
            BooleanFormula query = this.bfmgr.and(this.bfmgr.and(formulas.getLoopFormulas()), formulas.getAssertionFormula());
            try {
                inductionProver.push(query);
                isInductive = inductionProver.isUnsat();
            }
            finally {
                this.stats.satCheck.stop();
            }
        }
        return isInductive;
    }

    private boolean reachFixedPoint(PartitionedFormulas formulas, List<BooleanFormula> reachVector) throws CPAException, SolverException, InterruptedException {
        this.stats.fixedPointComputation.start();
        try {
            boolean hasReachedFixedPoint = false;
            switch (this.fixedPointComputeStrategy) {
                case ITP: {
                    hasReachedFixedPoint = this.reachFixedPointByInterpolation(formulas);
                    break;
                }
                case ITPSEQ: {
                    hasReachedFixedPoint = this.reachFixedPointByInterpolationSequence(formulas, reachVector);
                    break;
                }
                case ITPSEQ_AND_ITP: {
                    hasReachedFixedPoint = this.reachFixedPointByInterpolationSequence(formulas, reachVector);
                    if (hasReachedFixedPoint) break;
                    hasReachedFixedPoint = this.reachFixedPointByInterpolation(formulas);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown fixed-point strategy " + this.fixedPointComputeStrategy));
                }
            }
            if (hasReachedFixedPoint) {
                boolean bl = true;
                return bl;
            }
            this.logger.log(Level.FINE, new Object[]{"The overapproximation is unsafe, going back to BMC phase"});
            boolean bl = false;
            return bl;
        }
        catch (RefinementFailedException e) {
            if (this.fallBack) {
                this.logger.logDebugException((Throwable)e);
                this.fallBackToBMC(e.getMessage());
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            this.stats.fixedPointComputation.stop();
        }
    }

    private boolean reachFixedPointByInterpolation(PartitionedFormulas formulas) throws InterruptedException, CPAException, SolverException {
        if (!this.loopBoundMgr.performIMCAtCurrentIteration()) {
            return false;
        }
        this.logger.log(Level.FINE, new Object[]{"Computing fixed points by interpolation (IMC)"});
        this.logger.log(Level.ALL, new Object[]{"The SSA map is", formulas.getPrefixSsaMap()});
        BooleanFormula currentImage = formulas.getPrefixFormula();
        List<BooleanFormula> loops = formulas.getLoopFormulas();
        BooleanFormula suffixFormula = this.bfmgr.and(this.bfmgr.and(loops.subList(1, formulas.getNumLoops())), formulas.getAssertionFormula());
        Optional<ImmutableList<BooleanFormula>> interpolants = this.itpMgr.interpolate((List<BooleanFormula>)ImmutableList.of((Object)currentImage, (Object)loops.get(0), (Object)suffixFormula));
        assert (interpolants.isPresent());
        int initialIMCIter = this.stats.numOfIMCInnerIterations;
        while (interpolants.isPresent()) {
            ++this.stats.numOfIMCInnerIterations;
            this.logger.log(Level.ALL, new Object[]{"IMC inner loop iteration:", this.stats.numOfIMCInnerIterations - initialIMCIter, "[ accumulated:", this.stats.numOfIMCInnerIterations, "]"});
            this.logger.log(Level.ALL, new Object[]{"The current image is", currentImage});
            assert (interpolants.orElseThrow().size() == 2);
            BooleanFormula interpolant = (BooleanFormula)interpolants.orElseThrow().get(1);
            this.logger.log(Level.ALL, new Object[]{"The interpolant is", interpolant});
            interpolant = this.fmgr.instantiate(this.fmgr.uninstantiate(interpolant), formulas.getPrefixSsaMap());
            this.logger.log(Level.ALL, new Object[]{"After changing SSA", interpolant});
            if (this.solver.implies(interpolant, currentImage)) {
                this.logger.log(Level.INFO, new Object[]{"The current image reaches a fixed point"});
                this.finalFixedPoint = this.fmgr.uninstantiate(currentImage);
                return true;
            }
            currentImage = this.bfmgr.or(currentImage, interpolant);
            interpolants = this.itpMgr.interpolate((List<BooleanFormula>)ImmutableList.of((Object)interpolant, (Object)loops.get(0), (Object)suffixFormula));
        }
        this.logger.log(Level.FINE, new Object[]{"Attempted to compute fixed point with", this.stats.numOfIMCInnerIterations - initialIMCIter, "IMC inner iterations but did not succeed"});
        this.loopBoundMgr.adjustLoopBoundIncrementValues(this.stats.numOfIMCInnerIterations - initialIMCIter);
        return false;
    }

    private boolean reachFixedPointByInterpolationSequence(PartitionedFormulas pFormulas, List<BooleanFormula> reachVector) throws CPAException, InterruptedException, SolverException {
        if (!this.loopBoundMgr.performISMCAtCurrentIteration()) {
            return false;
        }
        this.logger.log(Level.FINE, new Object[]{"Computing fixed points by interpolation-sequence (ISMC)"});
        ImmutableList<BooleanFormula> itpSequence = this.getInterpolationSequence(pFormulas);
        this.updateReachabilityVector(reachVector, (List<BooleanFormula>)itpSequence);
        return this.checkFixedPointOfReachabilityVector(reachVector);
    }

    private ImmutableList<BooleanFormula> getInterpolationSequence(PartitionedFormulas pFormulas) throws InterruptedException, CPAException {
        this.logger.log(Level.FINE, new Object[]{"Extracting interpolation-sequence"});
        ImmutableList formulasToPush = new ImmutableList.Builder().add((Object)this.bfmgr.and(pFormulas.getPrefixFormula(), pFormulas.getLoopFormulas().get(0))).addAll(pFormulas.getLoopFormulas().subList(1, pFormulas.getNumLoops())).add((Object)pFormulas.getAssertionFormula()).build();
        ImmutableList<BooleanFormula> itpSequence = this.itpMgr.interpolate((List<BooleanFormula>)formulasToPush).orElseThrow();
        this.logger.log(Level.ALL, new Object[]{"Interpolation sequence:", itpSequence});
        return itpSequence;
    }

    private void updateReachabilityVector(List<BooleanFormula> reachVector, List<BooleanFormula> itpSequence) {
        this.logger.log(Level.FINE, new Object[]{"Updating reachability vector"});
        assert (reachVector.size() < itpSequence.size());
        while (reachVector.size() < itpSequence.size()) {
            reachVector.add(this.bfmgr.makeTrue());
        }
        assert (reachVector.size() == itpSequence.size());
        for (int i = 0; i < reachVector.size(); ++i) {
            BooleanFormula image = reachVector.get(i);
            BooleanFormula itp = this.fmgr.uninstantiate(itpSequence.get(i));
            reachVector.set(i, this.bfmgr.and(image, itp));
        }
        this.logger.log(Level.ALL, new Object[]{"Updated reachability vector:", reachVector});
    }

    private boolean checkFixedPointOfReachabilityVector(List<BooleanFormula> reachVector) throws InterruptedException, SolverException {
        this.logger.log(Level.FINE, new Object[]{"Checking fixed point of the reachability vector"});
        if (this.impactLikeCovering) {
            BooleanFormula lastImage = reachVector.get(reachVector.size() - 1);
            for (int i = 0; i < reachVector.size() - 1; ++i) {
                BooleanFormula imageAtI = reachVector.get(i);
                if (!this.solver.implies(lastImage, imageAtI)) continue;
                this.logger.log(Level.INFO, new Object[]{"Fixed point reached"});
                this.finalFixedPoint = this.bfmgr.or(reachVector);
                return true;
            }
        } else {
            BooleanFormula currentImage = reachVector.get(0);
            for (int i = 1; i < reachVector.size(); ++i) {
                BooleanFormula imageAtI = reachVector.get(i);
                if (this.solver.implies(imageAtI, currentImage)) {
                    this.finalFixedPoint = currentImage;
                    return true;
                }
                currentImage = this.bfmgr.or(currentImage, imageAtI);
            }
        }
        return false;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        super.collectStatistics(pStatsCollection);
        pStatsCollection.add(new Statistics(){

            @Override
            public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
                IMCAlgorithm.this.itpMgr.printStatistics(StatisticsWriter.writingStatisticsTo(out));
            }

            @Override
            public @Nullable String getName() {
                return "Interpolating SMT solver";
            }
        });
    }

    @Override
    protected CandidateGenerator getCandidateInvariants() {
        throw new AssertionError((Object)("Class " + this.getClass().getSimpleName() + " does not support this function. It should not be called."));
    }

    @Options(prefix="imc")
    private class LoopBoundManager {
        @Option(secure=true, description="toggle the strategy to determine the next loop iteration\nto execute BMC phase of IMC or ISMC\nCONST: increased by one (to guarantee a shortest counterexample)\nEAGER: skip all iterations where a bug cannot be found")
        private LoopBoundIncrementStrategy loopBoundIncrementStrategyForBMC = LoopBoundIncrementStrategy.CONST;
        @Option(secure=true, description="toggle the strategy to determine the next loop iteration\nto execute k-inductive check if \"checkPropertyInductiveness\" is enabled\nCONST: increased by by a constant (specified via loopBoundIncrementValueForKI)\nEAGER: skip all iterations where a bug cannot be found")
        private LoopBoundIncrementStrategy loopBoundIncrementStrategyForKI = LoopBoundIncrementStrategy.CONST;
        @Option(secure=true, description="toggle the strategy to determine the next loop iteration\nto execute interpolation phase of IMC\nCONST: increased by a constant (specified via loopBoundIncrementValueForIMC)\nEAGER: skip all iterations where a bug cannot be found")
        private LoopBoundIncrementStrategy loopBoundIncrementStrategyForIMC = LoopBoundIncrementStrategy.CONST;
        private final LoopBoundIncrementStrategy loopBoundIncrementStrategyForISMC = LoopBoundIncrementStrategy.CONST;
        private static final int loopBoundIncrementValueForBMC = 1;
        @Option(secure=true, description="toggle the value to increment the loop bound by at each step for KI")
        @IntegerOption(min=1L)
        private int loopBoundIncrementValueForKI = 1;
        @Option(secure=true, description="toggle the value to increment the loop bound by at each step for IMC")
        @IntegerOption(min=1L)
        private int loopBoundIncrementValueForIMC = 1;
        private static final int loopBoundIncrementValueForISMC = 1;
        private int nextLoopBoundForBMC = 1;
        private int nextLoopBoundForKI = 2;
        private int nextLoopBoundForIMC = 2;
        private int nextLoopBoundForISMC = 2;
        private final IndividualCheckInfoWrapper bmcInfo;
        private final IndividualCheckInfoWrapper kiInfo;
        private final IndividualCheckInfoWrapper imcInfo;
        private final IndividualCheckInfoWrapper ismcInfo;

        private LoopBoundManager(Configuration pConfig) throws InvalidConfigurationException {
            pConfig.inject((Object)this);
            if (!IMCAlgorithm.this.fixedPointComputeStrategy.isIMCEnabled()) {
                if (this.loopBoundIncrementStrategyForBMC == LoopBoundIncrementStrategy.EAGER) {
                    IMCAlgorithm.this.logger.log(Level.WARNING, new Object[]{"IMC is disabled, the loop bound is incremented by", 1, "each time for BMC."});
                    this.loopBoundIncrementStrategyForBMC = LoopBoundIncrementStrategy.CONST;
                }
                if (this.loopBoundIncrementStrategyForKI == LoopBoundIncrementStrategy.EAGER) {
                    IMCAlgorithm.this.logger.log(Level.WARNING, new Object[]{"IMC is disabled, the loop bound is incremented by", this.loopBoundIncrementValueForKI, "each time for KI."});
                    this.loopBoundIncrementStrategyForKI = LoopBoundIncrementStrategy.CONST;
                }
            }
            if (IMCAlgorithm.this.fixedPointComputeStrategy.isIMCEnabled() && this.loopBoundIncrementStrategyForIMC == LoopBoundIncrementStrategy.EAGER && this.loopBoundIncrementValueForIMC != 1) {
                IMCAlgorithm.this.logger.log(Level.WARNING, new Object[]{"The specified [ loopBoundIncrementValueOfIMC =", this.loopBoundIncrementValueForIMC, "] will be overwritten by the configuration [ loopBoundIncrementStrategyForIMC = EAGER]"});
            }
            this.bmcInfo = new IndividualCheckInfoWrapper("BMC", this.loopBoundIncrementStrategyForBMC, 1, this.nextLoopBoundForBMC);
            this.kiInfo = new IndividualCheckInfoWrapper("KI", this.loopBoundIncrementStrategyForKI, this.loopBoundIncrementValueForKI, this.nextLoopBoundForKI);
            this.imcInfo = new IndividualCheckInfoWrapper("IMC", this.loopBoundIncrementStrategyForIMC, this.loopBoundIncrementValueForIMC, this.nextLoopBoundForIMC);
            this.ismcInfo = new IndividualCheckInfoWrapper("ISMC", this.loopBoundIncrementStrategyForISMC, 1, this.nextLoopBoundForISMC);
            this.resetLoopBoundIncrementValues();
        }

        private int getCurrentMaxLoopIterations() {
            return CPAs.retrieveCPA(IMCAlgorithm.this.cpa, LoopBoundCPA.class).getMaxLoopIterations();
        }

        private void incrementLoopBoundToCheck(int currentLoopBound, IndividualCheckInfoWrapper checkInfo) {
            checkInfo.nextLoopIter = checkInfo.strategy.computeNextLoopBoundToCheck(currentLoopBound, checkInfo.incrementValue, checkInfo.nextLoopIter);
            IMCAlgorithm.this.logger.log(Level.FINEST, new Object[]{"Next loop iteration for", checkInfo.name, "is", checkInfo.nextLoopIter});
        }

        private void incrementLoopBoundsToCheck() {
            int currentLoopBound = this.getCurrentMaxLoopIterations();
            for (IndividualCheckInfoWrapper i : new IndividualCheckInfoWrapper[]{this.bmcInfo, this.kiInfo, this.imcInfo, this.ismcInfo}) {
                this.incrementLoopBoundToCheck(currentLoopBound, i);
            }
            this.resetLoopBoundIncrementValues();
        }

        private void adjustLoopBoundIncrementValue(int imcInnerLoopIter, IndividualCheckInfoWrapper checkInfo) {
            checkInfo.incrementValue = checkInfo.strategy.adjustLoopBoundIncrementValue(checkInfo.incrementValue, imcInnerLoopIter);
            assert (checkInfo.incrementValue > 0);
        }

        private void adjustLoopBoundIncrementValues(int imcInnerLoopIter) {
            for (IndividualCheckInfoWrapper i : new IndividualCheckInfoWrapper[]{this.bmcInfo, this.kiInfo, this.imcInfo, this.ismcInfo}) {
                this.adjustLoopBoundIncrementValue(imcInnerLoopIter, i);
            }
            assert (this.ismcInfo.incrementValue == 1);
        }

        private void resetLoopBoundIncrementValue(IndividualCheckInfoWrapper checkInfo) {
            checkInfo.incrementValue = checkInfo.strategy.resetLoopBoundIncrementValue(checkInfo.incrementValue);
            assert (checkInfo.incrementValue > 0);
        }

        private void resetLoopBoundIncrementValues() {
            for (IndividualCheckInfoWrapper i : new IndividualCheckInfoWrapper[]{this.bmcInfo, this.kiInfo, this.imcInfo, this.ismcInfo}) {
                this.resetLoopBoundIncrementValue(i);
            }
            assert (this.bmcInfo.incrementValue == 1);
            assert (this.ismcInfo.incrementValue == 1);
        }

        private boolean performCheckAtCurrentIteration(IndividualCheckInfoWrapper checkInfo) {
            int currentLoopIter = this.getCurrentMaxLoopIterations();
            assert (currentLoopIter <= checkInfo.nextLoopIter);
            if (currentLoopIter == checkInfo.nextLoopIter) {
                IMCAlgorithm.this.logger.log(Level.FINE, new Object[]{"Performing", checkInfo.name, "at loop iteration", currentLoopIter});
                return true;
            }
            IMCAlgorithm.this.logger.log(Level.FINE, new Object[]{"Skipping", checkInfo.name, "at loop iteration", currentLoopIter});
            return false;
        }

        private boolean performBMCAtCurrentIteration() {
            return this.performCheckAtCurrentIteration(this.bmcInfo);
        }

        private boolean performKIAtCurrentIteration() {
            return this.performCheckAtCurrentIteration(this.kiInfo);
        }

        private boolean performIMCAtCurrentIteration() {
            return this.performCheckAtCurrentIteration(this.imcInfo);
        }

        private boolean performISMCAtCurrentIteration() {
            return this.performCheckAtCurrentIteration(this.ismcInfo);
        }

        private class IndividualCheckInfoWrapper {
            private final String name;
            private final LoopBoundIncrementStrategy strategy;
            private int incrementValue;
            private int nextLoopIter;

            private IndividualCheckInfoWrapper(String pName, LoopBoundIncrementStrategy pStrategy, int pIncrementValue, int pNextLoopIter) {
                this.name = pName;
                this.strategy = pStrategy;
                this.incrementValue = pIncrementValue;
                this.nextLoopIter = pNextLoopIter;
            }
        }
    }

    private static enum LoopBoundIncrementStrategy {
        CONST{

            @Override
            int computeNextLoopBoundToCheck(int currentLoopBound, int loopBoundIncrementValue, int nextLoopBoundToCheck) {
                assert (currentLoopBound <= nextLoopBoundToCheck);
                if (currentLoopBound == nextLoopBoundToCheck) {
                    return currentLoopBound + loopBoundIncrementValue;
                }
                return nextLoopBoundToCheck;
            }

            @Override
            int resetLoopBoundIncrementValue(int loopBoundIncrementValue) {
                return loopBoundIncrementValue;
            }

            @Override
            int adjustLoopBoundIncrementValue(int loopBoundIncrementValue, int imcInnerLoopIter) {
                return loopBoundIncrementValue;
            }
        }
        ,
        EAGER{

            @Override
            int computeNextLoopBoundToCheck(int currentLoopBound, int loopBoundIncrementValue, int nextLoopBoundToCheck) {
                return Math.max(currentLoopBound + loopBoundIncrementValue, nextLoopBoundToCheck);
            }

            @Override
            int resetLoopBoundIncrementValue(int loopBoundIncrementValue) {
                return 1;
            }

            @Override
            int adjustLoopBoundIncrementValue(int loopBoundIncrementValue, int imcInnerLoopIter) {
                return imcInnerLoopIter;
            }
        };


        abstract int computeNextLoopBoundToCheck(int var1, int var2, int var3);

        abstract int resetLoopBoundIncrementValue(int var1);

        abstract int adjustLoopBoundIncrementValue(int var1, int var2);
    }

    private static enum FixedPointComputeStrategy {
        NONE{

            @Override
            boolean isIMCEnabled() {
                return false;
            }

            @Override
            boolean isISMCEnabled() {
                return false;
            }
        }
        ,
        ITP{

            @Override
            boolean isIMCEnabled() {
                return true;
            }

            @Override
            boolean isISMCEnabled() {
                return false;
            }
        }
        ,
        ITPSEQ{

            @Override
            boolean isIMCEnabled() {
                return false;
            }

            @Override
            boolean isISMCEnabled() {
                return true;
            }
        }
        ,
        ITPSEQ_AND_ITP{

            @Override
            boolean isIMCEnabled() {
                return true;
            }

            @Override
            boolean isISMCEnabled() {
                return true;
            }
        };


        abstract boolean isIMCEnabled();

        abstract boolean isISMCEnabled();
    }
}

