/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ProofResult;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SymbolicCandiateInvariant;

public class InductionResult<T extends CandidateInvariant>
extends ProofResult {
    private final @Nullable T invariantAbstraction;
    private final Set<SymbolicCandiateInvariant> badStateBlockingClauses;
    private final int k;

    private InductionResult(T pInvariantAbstraction) {
        super(true);
        this.invariantAbstraction = (CandidateInvariant)Objects.requireNonNull(pInvariantAbstraction);
        this.badStateBlockingClauses = ImmutableSet.of();
        this.k = -1;
    }

    private InductionResult(Iterable<? extends SymbolicCandiateInvariant> pBadStateBlockingClauses, int pK) {
        super(false);
        Preconditions.checkArgument((!Iterables.isEmpty(pBadStateBlockingClauses) ? 1 : 0) != 0, (Object)"Bad-state blocking invariants should be present if (and only if) induction failed.");
        Preconditions.checkArgument((pK >= 0 ? 1 : 0) != 0, (String)"k must not be negative for failed induction results, but is %s", (int)pK);
        this.invariantAbstraction = null;
        this.badStateBlockingClauses = ImmutableSet.copyOf(pBadStateBlockingClauses);
        this.k = pK;
    }

    @Override
    public boolean isSuccessful() {
        assert (super.isSuccessful() == (this.invariantAbstraction != null));
        return this.invariantAbstraction != null;
    }

    public T getInvariantRefinement() {
        Preconditions.checkArgument((boolean)this.isSuccessful(), (Object)"An invariant abstraction is only present if induction succeeded.");
        return this.invariantAbstraction;
    }

    public Set<SymbolicCandiateInvariant> getBadStateBlockingClauses() {
        Preconditions.checkState((!this.isSuccessful() ? 1 : 0) != 0, (Object)"Auxiliary-invariants for blocking bad states are only available if induction failed.");
        assert (!this.badStateBlockingClauses.isEmpty());
        return this.badStateBlockingClauses;
    }

    public int getK() {
        Preconditions.checkState((!this.isSuccessful() ? 1 : 0) != 0, (Object)"Input-assignment length is only present if induction failed.");
        return this.k;
    }

    public static <T extends CandidateInvariant> InductionResult<T> getSuccessful(T pInvariantAbstraction) {
        return new InductionResult<T>(pInvariantAbstraction);
    }

    public static <T extends CandidateInvariant> InductionResult<T> getFailed(Iterable<? extends SymbolicCandiateInvariant> pBadStateBlockingClauses, int pK) {
        return new InductionResult<T>(pBadStateBlockingClauses, pK);
    }
}

