/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.algorithm.bmc.AbstractBMCAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.TargetLocationCandidateInvariant;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public final class InterpolationHelper {
    static boolean checkAndAdjustARG(LogManager logger, ConfigurableProgramAnalysis cpa, BooleanFormulaManagerView bfmgr, Solver solver, ReachedSet pReachedSet, boolean removeUnreachableStopStates) throws SolverException, InterruptedException {
        if (InterpolationHelper.hasCoveredStates(pReachedSet)) {
            logger.log(Level.WARNING, new Object[]{"Covered states in ARG: interpolation might be unsound!"});
            return false;
        }
        FluentIterable<AbstractState> stopStates = InterpolationHelper.getStopStates(pReachedSet);
        if (stopStates.size() > 1) {
            boolean hasMultiReachableStopStates;
            if (!removeUnreachableStopStates) {
                logger.log(Level.WARNING, new Object[]{"Multiple stop states: interpolation might be unsound!"});
                return false;
            }
            List<AbstractState> unreachableStopStates = InterpolationHelper.getUnreachableStopStates(bfmgr, solver, stopStates);
            boolean bl = hasMultiReachableStopStates = stopStates.size() - unreachableStopStates.size() > 1;
            if (!unreachableStopStates.isEmpty()) {
                logger.log(Level.FINE, new Object[]{"Removing", unreachableStopStates.size(), "unreachable stop states"});
                ARGReachedSet reachedSetARG = new ARGReachedSet(pReachedSet, cpa);
                for (ARGState s : FluentIterable.from(unreachableStopStates).filter(ARGState.class)) {
                    reachedSetARG.removeInfeasiblePartofARG(s);
                }
            }
            if (hasMultiReachableStopStates) {
                logger.log(Level.WARNING, new Object[]{"Multi reachable stop states: interpolation might be unsound!"});
                return false;
            }
        }
        return true;
    }

    static boolean hasCoveredStates(ReachedSet pReachedSet) {
        return !FluentIterable.from((Iterable)pReachedSet).transformAndConcat(e -> ((ARGState)e).getCoveredByThis()).isEmpty();
    }

    private static FluentIterable<AbstractState> getStopStates(ReachedSet pReachedSet) {
        return FluentIterable.from((Iterable)pReachedSet).filter(AbstractBMCAlgorithm::isStopState).filter(AbstractBMCAlgorithm::isRelevantForReachability);
    }

    private static List<AbstractState> getUnreachableStopStates(BooleanFormulaManagerView bfmgr, Solver solver, FluentIterable<AbstractState> pStopStates) throws SolverException, InterruptedException {
        ArrayList<AbstractState> unreachableStopStates = new ArrayList<AbstractState>();
        for (AbstractState stopState : pStopStates) {
            BooleanFormula reachFormula = InterpolationHelper.buildReachFormulaForStates(bfmgr, (FluentIterable<AbstractState>)FluentIterable.of((Object)stopState, (Object[])new AbstractState[0]));
            if (!solver.isUnsat(reachFormula)) continue;
            unreachableStopStates.add(stopState);
        }
        return unreachableStopStates;
    }

    static void removeUnreachableTargetStates(ReachedSet pReachedSet) {
        if (pReachedSet.wasTargetReached()) {
            TargetLocationCandidateInvariant.INSTANCE.assumeTruth(pReachedSet);
        }
    }

    private static BooleanFormula buildReachFormulaForStates(BooleanFormulaManagerView bfmgr, FluentIterable<AbstractState> pGoalStates) {
        ArrayList<BooleanFormula> pathFormulas = new ArrayList<BooleanFormula>();
        for (AbstractState goalState : pGoalStates) {
            BooleanFormula pathFormula = InterpolationHelper.getAbstractionStatesToRoot(goalState).transform(e -> InterpolationHelper.getPredicateAbstractionBlockFormula(e).getFormula()).stream().collect(bfmgr.toConjunction());
            if (!PredicateAbstractState.containsAbstractionState(goalState)) {
                pathFormula = bfmgr.and(pathFormula, PredicateAbstractState.getPredicateState(goalState).getPathFormula().getFormula());
            }
            pathFormulas.add(pathFormula);
        }
        return bfmgr.or(pathFormulas);
    }

    static BooleanFormula buildReachTargetStateFormula(BooleanFormulaManagerView bfmgr, ReachedSet pReachedSet) {
        return InterpolationHelper.buildReachFormulaForStates(bfmgr, AbstractStates.getTargetStates(pReachedSet));
    }

    static BooleanFormula buildBoundingAssertionFormula(BooleanFormulaManagerView bfmgr, ReachedSet pReachedSet) {
        return InterpolationHelper.buildReachFormulaForStates(bfmgr, InterpolationHelper.getStopStates(pReachedSet));
    }

    static FluentIterable<ARGState> getAbstractionStatesToRoot(AbstractState pTargetState) {
        return FluentIterable.from(ARGUtils.getOnePathTo((ARGState)pTargetState).asStatesList()).filter(PredicateAbstractState::containsAbstractionState);
    }

    static PathFormula getPredicateAbstractionBlockFormula(AbstractState pState) {
        return PredicateAbstractState.getPredicateState(pState).getAbstractionFormula().getBlockFormula();
    }

    static FluentIterable<AbstractState> getTargetStatesAfterLoop(ReachedSet pReachedSet) {
        return AbstractStates.getTargetStates(pReachedSet).filter(InterpolationHelper::isTargetStateAfterLoopStart);
    }

    private static boolean isTargetStateAfterLoopStart(AbstractState pTargetState) {
        return InterpolationHelper.getAbstractionStatesToRoot(pTargetState).size() > 2;
    }

    static BooleanFormula createDisjunctionFromStates(BooleanFormulaManagerView bfmgr, FluentIterable<AbstractState> pStates) {
        return pStates.transform(e -> InterpolationHelper.getPredicateAbstractionBlockFormula(e).getFormula()).stream().collect(bfmgr.toDisjunction());
    }

    static PathFormula makeFalsePathFormula(PathFormulaManager pfmgr, BooleanFormulaManagerView bfmgr) {
        return pfmgr.makeEmptyPathFormula().withFormula(bfmgr.makeFalse());
    }

    static void storeFixedPointAsAbstractionAtLoopHeads(ReachedSet pReachedSet, BooleanFormula pFixedPoint, PredicateAbstractionManager pPredAbsMgr, PathFormulaManager pPfmgr) throws InterruptedException {
        ImmutableList abstractionStates = FluentIterable.from((Iterable)pReachedSet).skip(1).filter(Predicates.not(AbstractStates::isTargetState)).filter(PredicateAbstractState::containsAbstractionState).toList();
        for (AbstractState state : abstractionStates) {
            PredicateAbstractState predState = PredicateAbstractState.getPredicateState(state);
            predState.setAbstraction(pPredAbsMgr.asAbstraction(pFixedPoint, pPfmgr.makeEmptyPathFormula()));
        }
    }
}

