/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.sosy_lab.cpachecker.core.algorithm.bmc.AssertCandidate;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CounterexampleToInductivity;
import org.sosy_lab.cpachecker.core.algorithm.bmc.InvariantStrengthening;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ProverEnvironmentWithFallback;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SymbolicCandiateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.pdr.TotalTransitionRelation;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.SolverException;

public class InvariantStrengthenings {
    private InvariantStrengthenings() {
    }

    public static <S extends CandidateInvariant> InvariantStrengthening<S, S> noStrengthening() {
        return NoAbstraction.INSTANCE;
    }

    public static <T extends CandidateInvariant> InvariantStrengthening<T, T> unsatCoreBasedStrengthening() {
        return new InvariantStrengthening<T, T>(){

            @Override
            public T strengthenInvariant(ProverEnvironmentWithFallback pProver, FormulaManagerView pFmgr, PredicateAbstractionManager pPam, T pInvariant, AssertCandidate pAssertPredecessor, AssertCandidate pAssertSuccessorViolation, AssertCandidate pAssertCti, Multimap<BooleanFormula, BooleanFormula> pStateViolationAssertions, Optional<BooleanFormula> pAssertedInvariants, InvariantStrengthening.NextCti pNextCti) throws SolverException, InterruptedException, CPATransferException {
                if (pInvariant instanceof SymbolicCandiateInvariant) {
                    return UnsatCoreBasedRefinement.INSTANCE.strengthenInvariant(pProver, pFmgr, pPam, (SymbolicCandiateInvariant)pInvariant, pAssertPredecessor, pAssertSuccessorViolation, pAssertCti, pStateViolationAssertions, pAssertedInvariants, pNextCti);
                }
                return pInvariant;
            }
        };
    }

    private static enum UnsatCoreBasedRefinement implements InvariantStrengthening<SymbolicCandiateInvariant, SymbolicCandiateInvariant>
    {
        INSTANCE;


        @Override
        public SymbolicCandiateInvariant strengthenInvariant(ProverEnvironmentWithFallback pProver, FormulaManagerView pFmgr, PredicateAbstractionManager pPam, SymbolicCandiateInvariant pInvariant, AssertCandidate pAssertPredecessor, AssertCandidate pAssertSuccessorViolation, AssertCandidate pAssertCti, Multimap<BooleanFormula, BooleanFormula> pStateViolationAssertions, Optional<BooleanFormula> pAssertedInvariants, InvariantStrengthening.NextCti pNextCti) throws SolverException, InterruptedException, CPATransferException {
            if (pStateViolationAssertions.isEmpty()) {
                return pInvariant;
            }
            LinkedHashSet<BooleanFormula> relevantLiterals = new LinkedHashSet<BooleanFormula>();
            if (pAssertedInvariants.isPresent()) {
                pProver.pop();
            }
            pProver.pop();
            if (pAssertedInvariants.isPresent()) {
                pProver.push(pAssertedInvariants.orElseThrow());
            }
            for (Map.Entry entry : pStateViolationAssertions.asMap().entrySet()) {
                pProver.push((BooleanFormula)entry.getKey());
                Collection invariantAssertionComponents = (Collection)entry.getValue();
                if (!this.determineRelevantLiterals(pProver, pFmgr, invariantAssertionComponents, relevantLiterals)) {
                    return pInvariant;
                }
                pProver.pop();
            }
            return this.restoreConsecution(pProver, pFmgr, relevantLiterals, pInvariant, pAssertPredecessor, pAssertSuccessorViolation, pAssertCti, pAssertedInvariants, pNextCti);
        }

        private SymbolicCandiateInvariant restoreConsecution(ProverEnvironmentWithFallback pProver, FormulaManagerView pFmgr, Set<BooleanFormula> pChosenLiterals, SymbolicCandiateInvariant pInvariant, AssertCandidate pAssertPredecessor, AssertCandidate pAssertSuccessorViolation, AssertCandidate pAssertCti, Optional<BooleanFormula> pAssertedInvariants, InvariantStrengthening.NextCti pNextCti) throws InterruptedException, CPATransferException, SolverException {
            BooleanFormulaManagerView bfmgr = pFmgr.getBooleanFormulaManager();
            LinkedHashMap<BooleanFormula, SymbolicCandiateInvariant> remainingLiterals = new LinkedHashMap<BooleanFormula, SymbolicCandiateInvariant>();
            for (BooleanFormula literal : SymbolicCandiateInvariant.getConjunctionOperands(pFmgr, pInvariant.getPlainFormula(pFmgr), true)) {
                if (pChosenLiterals.contains(literal)) continue;
                SymbolicCandiateInvariant symbolicLiteral = SymbolicCandiateInvariant.makeSymbolicInvariant(pInvariant.getApplicableLocations(), pInvariant.getStateFilter(), literal, pFmgr);
                remainingLiterals.put(literal, symbolicLiteral);
            }
            boolean restored = remainingLiterals.isEmpty();
            SymbolicCandiateInvariant refinedInvariant = SymbolicCandiateInvariant.makeSymbolicInvariant(pInvariant.getApplicableLocations(), pInvariant.getStateFilter(), bfmgr.not(bfmgr.and(pChosenLiterals)), pFmgr);
            if (remainingLiterals.isEmpty()) {
                pProver.push(bfmgr.makeTrue());
                return refinedInvariant;
            }
            if (pAssertedInvariants.isPresent()) {
                pProver.pop();
            }
            pProver.pop();
            if (pAssertedInvariants.isPresent()) {
                pProver.push(pAssertedInvariants.orElseThrow());
            }
            while (!restored) {
                pProver.push(pAssertPredecessor.assertCandidate(refinedInvariant));
                pProver.push(pAssertSuccessorViolation.assertCandidate(refinedInvariant));
                if (pProver.isUnsat()) {
                    restored = true;
                    continue;
                }
                Optional<CounterexampleToInductivity> cti = pNextCti.getNextCti();
                if (!cti.isPresent()) {
                    return pInvariant;
                }
                SymbolicCandiateInvariant assertableCti = SymbolicCandiateInvariant.makeSymbolicInvariant(pInvariant.getApplicableLocations(), pInvariant.getStateFilter(), cti.orElseThrow().getFormula(pFmgr), pFmgr);
                pProver.push(pAssertCti.assertCandidate(assertableCti));
                Iterator remainingLiteralIterator = remainingLiterals.entrySet().iterator();
                boolean isUnsat = false;
                do {
                    Map.Entry remainingLiteral = remainingLiteralIterator.next();
                    pProver.push(pAssertPredecessor.assertCandidate((CandidateInvariant)remainingLiteral.getValue()));
                    isUnsat = pProver.isUnsat();
                    pProver.pop();
                    if (!isUnsat) continue;
                    remainingLiteralIterator.remove();
                    pChosenLiterals.add((BooleanFormula)remainingLiteral.getKey());
                } while (!isUnsat && remainingLiteralIterator.hasNext());
                pProver.pop();
                if (!isUnsat) {
                    return pInvariant;
                }
                refinedInvariant = SymbolicCandiateInvariant.makeSymbolicInvariant(pInvariant.getApplicableLocations(), pInvariant.getStateFilter(), bfmgr.not(bfmgr.and(pChosenLiterals)), pFmgr);
                if (remainingLiterals.isEmpty()) {
                    return refinedInvariant;
                }
                pProver.pop();
                pProver.pop();
                restored = false;
            }
            return refinedInvariant;
        }

        private boolean determineRelevantLiterals(ProverEnvironmentWithFallback pProver, FormulaManagerView pFmgr, Collection<BooleanFormula> pInvariantAssertionComponents, Set<BooleanFormula> pRelevantLiterals) throws SolverException, InterruptedException {
            Set literals = FluentIterable.from(pInvariantAssertionComponents).transformAndConcat(c -> SymbolicCandiateInvariant.getConjunctionOperands(pFmgr, c, true)).stream().collect(Collectors.toCollection(HashSet::new));
            Iterator literalIterator = literals.iterator();
            while (literalIterator.hasNext()) {
                BooleanFormula literal = (BooleanFormula)literalIterator.next();
                BooleanFormula uninstantiatedRemainingLiteral = pFmgr.uninstantiate(literal);
                if (!pFmgr.extractVariableNames((Formula)uninstantiatedRemainingLiteral).contains(TotalTransitionRelation.getLocationVariableName())) continue;
                pRelevantLiterals.add(uninstantiatedRemainingLiteral);
                literalIterator.remove();
            }
            boolean isUnsat = pProver.isUnsat();
            literalIterator = literals.iterator();
            ArrayList<BooleanFormula> pushedLiterals = new ArrayList<BooleanFormula>();
            while (!isUnsat && literalIterator.hasNext()) {
                BooleanFormula literal = (BooleanFormula)literalIterator.next();
                pProver.push(literal);
                pushedLiterals.add(literal);
                literalIterator.remove();
                isUnsat = pProver.isUnsat();
            }
            int nPushedLiterals = pushedLiterals.size();
            if (!pProver.isUnsat()) {
                IntStream.range(0, nPushedLiterals).forEach(i -> pProver.pop());
                return false;
            }
            if (pProver.supportsUnsatCoreGeneration()) {
                pushedLiterals.retainAll(pProver.getUnsatCore());
            }
            for (BooleanFormula pushedLiteral : pushedLiterals) {
                pRelevantLiterals.add(pFmgr.uninstantiate(pushedLiteral));
            }
            IntStream.range(0, nPushedLiterals).forEach(i -> pProver.pop());
            return true;
        }
    }

    private static class NoAbstraction<S extends CandidateInvariant>
    implements InvariantStrengthening<S, S> {
        private static final NoAbstraction<CandidateInvariant> INSTANCE = new NoAbstraction();

        private NoAbstraction() {
        }

        @Override
        public S strengthenInvariant(ProverEnvironmentWithFallback pProver, FormulaManagerView pFmgr, PredicateAbstractionManager pPam, S pInvariant, AssertCandidate pAssertPredecessor, AssertCandidate pAssertSuccessorViolation, AssertCandidate pAssertCti, Multimap<BooleanFormula, BooleanFormula> pStateViolationAssertions, Optional<BooleanFormula> pAssertedInvariants, InvariantStrengthening.NextCti pNextCti) {
            return pInvariant;
        }
    }
}

