/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.AssertCandidate;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCHelper;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCStatistics;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CounterexampleToInductivity;
import org.sosy_lab.cpachecker.core.algorithm.bmc.InductionResult;
import org.sosy_lab.cpachecker.core.algorithm.bmc.InvariantStrengthening;
import org.sosy_lab.cpachecker.core.algorithm.bmc.InvariantStrengthenings;
import org.sosy_lab.cpachecker.core.algorithm.bmc.Lifting;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ModelValue;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ProverEnvironmentWithFallback;
import org.sosy_lab.cpachecker.core.algorithm.bmc.StandardLiftings;
import org.sosy_lab.cpachecker.core.algorithm.bmc.UnrolledReachedSet;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariantCombination;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SingleLocationFormulaInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SymbolicCandiateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.TargetLocationCandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.invariants.ExpressionTreeSupplier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantSupplier;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.input.InputState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

class KInductionProver
implements AutoCloseable {
    private final CFA cfa;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Algorithm algorithm;
    private final ConfigurableProgramAnalysis cpa;
    private final UnrolledReachedSet reachedSet;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final PathFormulaManager pfmgr;
    private final PredicateAbstractionManager pam;
    private final BMCStatistics stats;
    private final ReachedSetFactory reachedSetFactory;
    private final InvariantGenerator invariantGenerator;
    private final ProverEnvironmentWithFallback prover;
    private ExpressionTreeSupplier expressionTreeSupplier;
    private BooleanFormula loopHeadInvariants;
    private final Map<CandidateInvariant, BooleanFormula> violationFormulas = new HashMap<CandidateInvariant, BooleanFormula>();
    private int previousK = -1;
    private final ImmutableSet<CFANode> loopHeads;
    private boolean invariantGenerationRunning = true;

    public KInductionProver(CFA pCFA, LogManager pLogger, Algorithm pAlgorithm, ConfigurableProgramAnalysis pCPA, InvariantGenerator pInvariantGenerator, BMCStatistics pStats, ReachedSetFactory pReachedSetFactory, ShutdownNotifier pShutdownNotifier, Set<CFANode> pLoopHeads, boolean pUnsatCoreGeneration) {
        this.cfa = (CFA)Preconditions.checkNotNull((Object)pCFA);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.algorithm = (Algorithm)Preconditions.checkNotNull((Object)pAlgorithm);
        this.cpa = (ConfigurableProgramAnalysis)Preconditions.checkNotNull((Object)pCPA);
        this.invariantGenerator = (InvariantGenerator)Preconditions.checkNotNull((Object)pInvariantGenerator);
        this.stats = (BMCStatistics)Preconditions.checkNotNull((Object)pStats);
        this.reachedSetFactory = (ReachedSetFactory)Preconditions.checkNotNull((Object)pReachedSetFactory);
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.reachedSet = new UnrolledReachedSet(this.algorithm, this.cpa, pLoopHeads, this.reachedSetFactory.create(this.cpa), this::ensureK);
        PredicateCPA stepCasePredicateCPA = CPAs.retrieveCPA(this.cpa, PredicateCPA.class);
        this.prover = pUnsatCoreGeneration ? new ProverEnvironmentWithFallback(stepCasePredicateCPA.getSolver(), SolverContext.ProverOptions.GENERATE_UNSAT_CORE, SolverContext.ProverOptions.GENERATE_MODELS) : new ProverEnvironmentWithFallback(stepCasePredicateCPA.getSolver(), SolverContext.ProverOptions.GENERATE_MODELS);
        this.fmgr = stepCasePredicateCPA.getSolver().getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.pfmgr = stepCasePredicateCPA.getPathFormulaManager();
        this.pam = stepCasePredicateCPA.getPredicateManager();
        this.loopHeadInvariants = this.bfmgr.makeTrue();
        this.expressionTreeSupplier = ExpressionTreeSupplier.TrivialInvariantSupplier.INSTANCE;
        this.loopHeads = ImmutableSet.copyOf(pLoopHeads);
    }

    private InvariantSupplier getCurrentInvariantSupplier() throws InterruptedException {
        if (this.invariantGenerationRunning) {
            try {
                return this.invariantGenerator.getSupplier();
            }
            catch (CPAException e) {
                this.logger.logUserException(Level.FINE, (Throwable)e, "Invariant generation failed.");
                this.invariantGenerationRunning = false;
            }
            catch (InterruptedException e) {
                this.shutdownNotifier.shutdownIfNecessary();
                this.logger.log(Level.FINE, new Object[]{"Invariant generation was cancelled."});
                this.logger.logDebugException((Throwable)e);
                this.invariantGenerationRunning = false;
            }
        }
        return InvariantSupplier.TrivialInvariantSupplier.INSTANCE;
    }

    private ExpressionTreeSupplier getCurrentExpressionTreeInvariantSupplier() throws InterruptedException {
        if (!this.invariantGenerationRunning) {
            return this.expressionTreeSupplier;
        }
        try {
            return this.invariantGenerator.getExpressionTreeSupplier();
        }
        catch (CPAException e) {
            this.logger.logUserException(Level.FINE, (Throwable)e, "Invariant generation failed.");
            this.invariantGenerationRunning = false;
            return this.expressionTreeSupplier;
        }
        catch (InterruptedException e) {
            this.shutdownNotifier.shutdownIfNecessary();
            this.logger.log(Level.FINE, new Object[]{"Invariant generation was cancelled."});
            this.logger.logDebugException((Throwable)e);
            this.invariantGenerationRunning = false;
            return this.expressionTreeSupplier;
        }
    }

    private BMCHelper.FormulaInContext getCurrentLoopHeadInvariants(Iterable<AbstractState> pAssertionStates) {
        ImmutableSet stopLoopHeads = AbstractStates.extractLocations(AbstractStates.filterLocations(pAssertionStates, this.loopHeads)).toSet();
        return arg_0 -> this.lambda$getCurrentLoopHeadInvariants$0((Set)stopLoopHeads, arg_0);
    }

    public BooleanFormula getCurrentLocationInvariants(CFANode pLocation, FormulaManagerView pFormulaManager, PathFormulaManager pPathFormulaManager, PathFormula pContext) throws InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        InvariantSupplier currentInvariantsSupplier = this.getCurrentInvariantSupplier();
        return currentInvariantsSupplier.getInvariantFor(pLocation, Optional.empty(), pFormulaManager, pPathFormulaManager, pContext);
    }

    public ExpressionTree<Object> getCurrentLocationInvariants(CFANode pLocation) throws InterruptedException {
        ExpressionTreeSupplier currentInvariantsSupplier = this.getCurrentExpressionTreeInvariantSupplier();
        return currentInvariantsSupplier.getInvariantFor(pLocation);
    }

    @Override
    public void close() {
        this.prover.close();
    }

    public final InductionResult<CandidateInvariant> check(Iterable<CandidateInvariant> pPredecessorAssumptions, int pK, CandidateInvariant pCandidateInvariant, Set<Object> pCheckedKeys) throws CPAException, InterruptedException, SolverException {
        return this.check(pPredecessorAssumptions, pK, pCandidateInvariant, pCheckedKeys, InvariantStrengthenings.noStrengthening(), StandardLiftings.NO_LIFTING);
    }

    public final <S extends CandidateInvariant, T extends CandidateInvariant> InductionResult<T> check(Iterable<CandidateInvariant> pPredecessorAssumptions, int pK, S pCandidateInvariant, Set<Object> pCheckedKeys, InvariantStrengthening<S, T> pInvariantAbstraction, Lifting pLifting) throws CPAException, InterruptedException, SolverException {
        this.stats.inductionPreparation.start();
        this.logger.log(Level.INFO, new Object[]{"Running algorithm to create induction hypothesis"});
        this.reachedSet.setDesiredK(pK + 1);
        this.reachedSet.ensureK();
        ReachedSet reached = this.reachedSet.getReachedSet();
        HashMap<CandidateInvariant, BooleanFormula> assertions = new HashMap<CandidateInvariant, BooleanFormula>();
        ImmutableSet.Builder inductionHypothesisBuilder = ImmutableSet.builder();
        for (CandidateInvariant candidateInvariant : CandidateInvariantCombination.getConjunctiveParts(pPredecessorAssumptions)) {
            BooleanFormula predecessorAssertion;
            this.shutdownNotifier.shutdownIfNecessary();
            if (candidateInvariant == TargetLocationCandidateInvariant.INSTANCE && pCandidateInvariant == TargetLocationCandidateInvariant.INSTANCE) {
                predecessorAssertion = this.bfmgr.makeBoolean(true);
            } else {
                BooleanFormula previousViolation = this.violationFormulas.get(candidateInvariant);
                if (previousViolation != null && this.previousK == pK) {
                    predecessorAssertion = this.bfmgr.not(previousViolation);
                } else if (!pLifting.canLift() && candidateInvariant instanceof SingleLocationFormulaInvariant) {
                    predecessorAssertion = candidateInvariant.getAssertion((Iterable<AbstractState>)BMCHelper.filterBmcCheckedWithin(reached, pCheckedKeys, this.cfa.getLoopStructure().orElseThrow().getAllLoops()), this.fmgr, this.pfmgr);
                    inductionHypothesisBuilder.addAll((Iterable)ImmutableSet.copyOf(candidateInvariant.filterApplicable((Iterable<AbstractState>)BMCHelper.filterBmcCheckedWithin(reached, pCheckedKeys, this.cfa.getLoopStructure().orElseThrow().getAllLoops()))));
                } else {
                    predecessorAssertion = candidateInvariant.getAssertion((Iterable<AbstractState>)BMCHelper.filterBmcChecked(BMCHelper.filterIterationsUpTo(reached, pK, this.loopHeads), pCheckedKeys), this.fmgr, this.pfmgr);
                }
            }
            BooleanFormula storedAssertion = (BooleanFormula)assertions.get(candidateInvariant);
            if (storedAssertion == null) {
                storedAssertion = this.bfmgr.makeBoolean(true);
            }
            assertions.put(candidateInvariant, this.bfmgr.and(storedAssertion, predecessorAssertion));
        }
        ImmutableSet inductionHypothesis = inductionHypothesisBuilder.build();
        FluentIterable<AbstractState> loopHeadStates = AbstractStates.filterLocations(reached, this.loopHeads);
        BooleanFormula loopHeadInv = this.inductiveLoopHeadInvariantAssertion((Iterable<AbstractState>)loopHeadStates);
        this.previousK = pK + 1;
        this.stats.inductionPreparation.stop();
        this.shutdownNotifier.shutdownIfNecessary();
        FluentIterable endStates = FluentIterable.from((Iterable)reached).filter(BMCHelper::isEndState);
        BooleanFormula successorExistsAssertion = BMCHelper.createFormulaFor((Iterable<AbstractState>)endStates, this.bfmgr, Optional.of(this.shutdownNotifier));
        BooleanFormula predecessorAssertion = this.bfmgr.and((Collection<BooleanFormula>)FluentIterable.from(CandidateInvariantCombination.getConjunctiveParts(CandidateInvariantCombination.conjunction(pPredecessorAssumptions))).transform(conjunctivePart -> (BooleanFormula)assertions.get(conjunctivePart)).toList());
        Multimap<BooleanFormula, BooleanFormula> successorViolationAssertions = this.getSuccessorViolationAssertions(pCandidateInvariant, pK + 1, (Set<AbstractState>)inductionHypothesis, pLifting.canLift());
        BooleanFormula successorViolation = BMCHelper.disjoinStateViolationAssertions(this.bfmgr, successorViolationAssertions);
        this.violationFormulas.put(pCandidateInvariant, successorViolation);
        this.logger.log(Level.INFO, new Object[]{"Starting induction check..."});
        this.stats.inductionCheck.start();
        Object successorExistsAssertionId = this.prover.push(successorExistsAssertion);
        Object predecessorAssertionId = this.prover.push(predecessorAssertion);
        this.prover.push(successorViolation);
        InductionResult<T> result = null;
        AssertCandidate assertPredecessor = p -> BMCHelper.assertAt(this.filterInductiveAssertionIteration((Iterable<AbstractState>)loopHeadStates), p, this.fmgr, this.pfmgr, true);
        while (result == null) {
            this.shutdownNotifier.shutdownIfNecessary();
            this.prover.push(loopHeadInv);
            boolean isInvariant = this.prover.isUnsat();
            if (!isInvariant) {
                boolean loopHeadInvChanged;
                BooleanFormula oldLoopHeadInv = loopHeadInv;
                loopHeadInv = this.inductiveLoopHeadInvariantAssertion((Iterable<AbstractState>)loopHeadStates);
                boolean bl = loopHeadInvChanged = !loopHeadInv.equals(oldLoopHeadInv);
                if (!loopHeadInvChanged || this.logger.wouldBeLogged(Level.ALL)) {
                    ImmutableList<Model.ValueAssignment> modelAssignments = this.prover.getModelAssignments();
                    if (this.logger.wouldBeLogged(Level.ALL)) {
                        this.logger.log(Level.ALL, new Object[]{"Model returned for induction check:", modelAssignments});
                    }
                    if (!loopHeadInvChanged) {
                        Object badStateBlockingClauses = ImmutableSet.of();
                        Map<CounterexampleToInductivity, BooleanFormula> detectedCtis = this.extractCTIs(reached, (Iterable<Model.ValueAssignment>)modelAssignments, pCheckedKeys, pCandidateInvariant, pK + 1, pLifting.canLift());
                        if (pLifting.canLift()) {
                            this.prover.pop();
                            this.prover.pop();
                            BooleanFormula candidateAssertion = this.assertCandidate(reached, pCandidateInvariant, pK + 1);
                            Object candidateSuccessorAssertionId = this.prover.push(candidateAssertion);
                            Object invariantsAssertionId = this.prover.push(loopHeadInv);
                            ImmutableSet.Builder badStateBlockingClauseBuilder = ImmutableSet.builder();
                            for (Map.Entry<CounterexampleToInductivity, BooleanFormula> ctiWithInput : detectedCtis.entrySet()) {
                                Object inputAssertionId = this.prover.push(ctiWithInput.getValue());
                                SymbolicCandiateInvariant blockedReducedCti = pLifting.lift(this.fmgr, this.pam, this.prover, SymbolicCandiateInvariant.blockCti(this.loopHeads, ctiWithInput.getKey(), this.fmgr), assertPredecessor, Arrays.asList(successorExistsAssertionId, predecessorAssertionId, candidateSuccessorAssertionId, invariantsAssertionId, inputAssertionId));
                                badStateBlockingClauseBuilder.add((Object)blockedReducedCti);
                                this.prover.pop();
                            }
                            badStateBlockingClauses = badStateBlockingClauseBuilder.build();
                        } else {
                            badStateBlockingClauses = Iterables.transform(detectedCtis.keySet(), cti -> SymbolicCandiateInvariant.blockCti(this.loopHeads, cti, this.fmgr));
                        }
                        result = InductionResult.getFailed((Iterable<? extends SymbolicCandiateInvariant>)badStateBlockingClauses, pK);
                    }
                }
            } else {
                AssertCandidate assertSuccessorViolation = candidate -> {
                    Multimap<BooleanFormula, BooleanFormula> succViolationAssertions = this.getSuccessorViolationAssertions(pCandidateInvariant, pK + 1, (Set<AbstractState>)inductionHypothesis, pLifting.canLift());
                    return BMCHelper.disjoinStateViolationAssertions(this.bfmgr, succViolationAssertions);
                };
                InvariantStrengthening.NextCti nextCti = () -> {
                    ImmutableList<Model.ValueAssignment> modelAssignments = this.prover.getModelAssignments();
                    Set<CounterexampleToInductivity> detectedCtis = this.extractCTIs(reached, (Iterable<Model.ValueAssignment>)modelAssignments, pCheckedKeys, pCandidateInvariant, pK + 1, pLifting.canLift()).keySet();
                    if (Iterables.isEmpty(detectedCtis)) {
                        return Optional.empty();
                    }
                    return Optional.of((CounterexampleToInductivity)detectedCtis.iterator().next());
                };
                T abstractedInvariant = pInvariantAbstraction.strengthenInvariant(this.prover, this.fmgr, this.pam, pCandidateInvariant, assertPredecessor, assertSuccessorViolation, assertPredecessor, successorViolationAssertions, Optional.of(loopHeadInv), nextCti);
                result = InductionResult.getSuccessful(abstractedInvariant);
            }
            this.prover.pop();
        }
        if (result.isSuccessful()) {
            this.violationFormulas.remove(pCandidateInvariant);
        }
        this.prover.pop();
        this.prover.pop();
        this.prover.pop();
        this.stats.inductionCheck.stop();
        this.logger.log(Level.FINER, new Object[]{"Soundness after induction check:", result.isSuccessful()});
        return result;
    }

    private BooleanFormula assertCandidate(Iterable<AbstractState> pReached, CandidateInvariant pCandidateInvariant, int pK) throws CPATransferException, InterruptedException {
        FluentIterable<AbstractState> states = BMCHelper.filterIteration(pReached, pK, this.loopHeads);
        ArrayList<BooleanFormula> assertions = new ArrayList<BooleanFormula>();
        for (CandidateInvariant component : CandidateInvariantCombination.getConjunctiveParts(pCandidateInvariant)) {
            FluentIterable candidateAssertionStates;
            if (component instanceof TargetLocationCandidateInvariant) {
                candidateAssertionStates = states.filter(s -> {
                    ARGState argState = AbstractStates.extractStateByType(s, ARGState.class);
                    if (argState.isTarget()) return false;
                    if (argState.getChildren().isEmpty()) return true;
                    if (!FluentIterable.from(AbstractStates.extractLocations(s)).anyMatch(arg_0 -> this.loopHeads.contains(arg_0))) return false;
                    return true;
                });
                assertions.add(BMCHelper.createFormulaFor((Iterable<AbstractState>)candidateAssertionStates, this.bfmgr));
                continue;
            }
            candidateAssertionStates = states.filter(s -> FluentIterable.from(AbstractStates.extractLocations(s)).anyMatch(component::appliesTo));
            assertions.add(BMCHelper.createFormulaFor((Iterable<AbstractState>)candidateAssertionStates, this.bfmgr));
            assertions.add(component.getAssertion((Iterable<AbstractState>)candidateAssertionStates, this.fmgr, this.pfmgr));
        }
        return this.bfmgr.and(assertions);
    }

    private BooleanFormula inductiveLoopHeadInvariantAssertion(Iterable<AbstractState> pLoopHeadStates) throws CPATransferException, InterruptedException {
        FluentIterable<AbstractState> loopHeadStates = this.filterInductiveAssertionIteration(pLoopHeadStates);
        return BMCHelper.assertAt(loopHeadStates, this.getCurrentLoopHeadInvariants((Iterable<AbstractState>)loopHeadStates), this.fmgr);
    }

    private FluentIterable<AbstractState> filterInductiveAssertionIteration(Iterable<AbstractState> pStates) {
        return BMCHelper.filterIteration(pStates, 1, this.loopHeads);
    }

    private Algorithm.AlgorithmStatus ensureK(Algorithm pAlg, ConfigurableProgramAnalysis pCPA, ReachedSet pReached) throws InterruptedException, CPAException {
        if (pReached.size() <= 1 && this.cfa.getLoopStructure().isPresent()) {
            Stream<CFANode> relevantLoopHeads = this.cfa.getLoopStructure().orElseThrow().getAllLoops().stream().filter(loop -> !BMCHelper.isTrivialSelfLoop(loop)).map(LoopStructure.Loop::getLoopHeads).flatMap(Collection::stream).filter(arg_0 -> this.loopHeads.contains(arg_0)).distinct();
            Iterator relevantLoopHeadIterator = relevantLoopHeads.iterator();
            while (relevantLoopHeadIterator.hasNext()) {
                CFANode relevantLoopHead = (CFANode)relevantLoopHeadIterator.next();
                Precision precision = pCPA.getInitialPrecision(relevantLoopHead, StateSpacePartition.getDefaultPartition());
                AbstractState initialState = pCPA.getInitialState(relevantLoopHead, StateSpacePartition.getDefaultPartition());
                pReached.add(initialState, precision);
            }
            if (pReached.isEmpty()) {
                return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
            }
        }
        return BMCHelper.unroll(this.logger, pReached, pAlg, pCPA);
    }

    private Multimap<String, Integer> extractInputs(Iterable<AbstractState> pReached, Map<String, CType> types) {
        LinkedHashMultimap inputs = LinkedHashMultimap.create();
        HashSet visited = new HashSet();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        Iterables.addAll(waitlist, pReached);
        visited.addAll(waitlist);
        while (!waitlist.isEmpty()) {
            ARGState argState;
            AbstractState current = (AbstractState)waitlist.poll();
            InputState is = AbstractStates.extractStateByType(current, InputState.class);
            PredicateAbstractState pas = AbstractStates.extractStateByType(current, PredicateAbstractState.class);
            if (is != null && pas != null) {
                SSAMap ssaMap = pas.getPathFormula().getSsa();
                for (String input : is.getInputs()) {
                    if (!ssaMap.containsVariable(input)) continue;
                    inputs.put((Object)input, (Object)(ssaMap.getIndex(input) - 1));
                    inputs.put((Object)input, (Object)ssaMap.getIndex(input));
                    types.put(input, ssaMap.getType(input));
                }
                for (String varName : ssaMap.allVariables()) {
                    types.put(varName, ssaMap.getType(varName));
                }
            }
            if ((argState = AbstractStates.extractStateByType(current, ARGState.class)) == null) continue;
            for (ARGState parent : argState.getParents()) {
                if (!visited.add(parent)) continue;
                waitlist.offer(parent);
            }
        }
        return inputs;
    }

    private Map<CounterexampleToInductivity, BooleanFormula> extractCTIs(Iterable<AbstractState> pReached, Iterable<Model.ValueAssignment> pModelAssignments, Set<Object> pCheckedKeys, CandidateInvariant pCandidateInvariant, int pK, boolean pCanLift) {
        HashMap<String, CType> types = new HashMap<String, CType>();
        FluentIterable inputStates = BMCHelper.filterIteration(pCandidateInvariant.filterApplicable(pReached), pK, this.loopHeads);
        if (pCandidateInvariant == TargetLocationCandidateInvariant.INSTANCE) {
            inputStates = inputStates.filter(AbstractStates::isTargetState);
        }
        Multimap<String, Integer> inputs = this.extractInputs((Iterable<AbstractState>)inputStates, types);
        LinkedHashMap<CounterexampleToInductivity, BooleanFormula> ctis = new LinkedHashMap<CounterexampleToInductivity, BooleanFormula>();
        for (CFANode loopHead : this.loopHeads) {
            int loopIterationForCTI = !pCanLift && pCandidateInvariant instanceof SingleLocationFormulaInvariant ? 0 : 1;
            FluentIterable<AbstractState> loopHeadStates = BMCHelper.filterIteration(AbstractStates.filterLocations(BMCHelper.filterBmcChecked(pReached, pCheckedKeys), (Set<CFANode>)ImmutableSet.of((Object)loopHead)), loopIterationForCTI, this.loopHeads);
            for (AbstractState loopHeadState : loopHeadStates) {
                CounterexampleToInductivity cti;
                PredicateAbstractState pas = AbstractStates.extractStateByType(loopHeadState, PredicateAbstractState.class);
                SSAMap ssaMap = pas.getPathFormula().getSsa();
                Supplier variableFormulas = Suppliers.memoize(() -> {
                    VariableMapper variableMapper = new VariableMapper();
                    this.fmgr.visitRecursively((Formula)pas.getPathFormula().getFormula(), variableMapper);
                    return variableMapper.variableFormulas;
                });
                PersistentSortedMap model = PathCopyingPersistentTreeMap.of();
                ArrayList<BooleanFormula> input = new ArrayList<BooleanFormula>();
                for (Model.ValueAssignment valueAssignment : pModelAssignments) {
                    if (valueAssignment.isFunction()) continue;
                    String fullName = valueAssignment.getName();
                    Pair<String, OptionalInt> pair = FormulaManagerView.parseName(fullName);
                    String actualName = pair.getFirst();
                    OptionalInt index = pair.getSecond();
                    Object value = valueAssignment.getValue();
                    if (!index.isPresent() || !(ssaMap.containsVariable(actualName) ? ssaMap.getIndex(actualName) == index.orElseThrow() : index.orElseThrow() == 1) || !(value instanceof Number) || inputs.containsKey((Object)actualName)) continue;
                    BooleanFormula assignment = this.fmgr.uninstantiate(valueAssignment.getAssignmentAsFormula());
                    model = model.putAndCopy((Object)actualName, (Object)new ModelValue(actualName, assignment, this.fmgr));
                }
                if (model.isEmpty() || ctis.containsKey(cti = new CounterexampleToInductivity(loopHead, (Map<String, ModelValue>)model))) continue;
                for (Model.ValueAssignment valueAssignment : pModelAssignments) {
                    String fullName = valueAssignment.getName();
                    Pair<String, OptionalInt> pair = FormulaManagerView.parseName(fullName);
                    String actualName = pair.getSecond().isPresent() ? pair.getFirst() : fullName;
                    OptionalInt index = pair.getSecond();
                    boolean isUnconnected = false;
                    if (index.isPresent() && ssaMap.containsVariable(actualName) && index.orElseThrow() < ssaMap.getIndex(actualName)) {
                        boolean bl = isUnconnected = !((Map)variableFormulas.get()).containsKey(fullName);
                    }
                    if (index.isPresent() && (!index.isPresent() || !isUnconnected && !inputs.get((Object)actualName).contains(index.orElseThrow()))) continue;
                    input.add(valueAssignment.getAssignmentAsFormula());
                }
                ctis.put(cti, this.bfmgr.and(input));
            }
        }
        return ctis;
    }

    private Multimap<BooleanFormula, BooleanFormula> getSuccessorViolationAssertions(CandidateInvariant pCandidateInvariant, int pK, Set<AbstractState> pHypothesis, boolean pCanLift) throws CPATransferException, InterruptedException {
        ReachedSet reached = this.reachedSet.getReachedSet();
        ImmutableListMultimap.Builder stateViolationAssertionsBuilder = ImmutableListMultimap.builder();
        FluentIterable assertionStates = !pCanLift && pCandidateInvariant instanceof SingleLocationFormulaInvariant ? FluentIterable.from(pCandidateInvariant.filterApplicable(reached)).filter(state -> !pHypothesis.contains(state)) : BMCHelper.filterIteration(pCandidateInvariant.filterApplicable(reached), pK, this.loopHeads);
        for (AbstractState state2 : assertionStates) {
            Set<AbstractState> stateAsSet = Collections.singleton(state2);
            BooleanFormula stateFormula = BMCHelper.createFormulaFor(stateAsSet, this.bfmgr, Optional.of(this.shutdownNotifier));
            BooleanFormula invariantFormula = this.bfmgr.makeTrue();
            for (CandidateInvariant component : CandidateInvariantCombination.getConjunctiveParts(pCandidateInvariant)) {
                if (Iterables.isEmpty(component.filterApplicable(stateAsSet))) continue;
                this.shutdownNotifier.shutdownIfNecessary();
                invariantFormula = this.bfmgr.and(invariantFormula, BMCHelper.assertAt(stateAsSet, component, this.fmgr, this.pfmgr, true));
            }
            stateViolationAssertionsBuilder.put((Object)stateFormula, (Object)this.bfmgr.not(invariantFormula));
        }
        return stateViolationAssertionsBuilder.build();
    }

    private /* synthetic */ BooleanFormula lambda$getCurrentLoopHeadInvariants$0(Set stopLoopHeads, PathFormula pContext) throws CPATransferException, InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        if (!this.bfmgr.isFalse(this.loopHeadInvariants) && this.invariantGenerationRunning) {
            BooleanFormula lhi = this.bfmgr.makeFalse();
            for (CFANode loopHead : stopLoopHeads) {
                lhi = this.bfmgr.or(lhi, this.getCurrentLocationInvariants(loopHead, this.fmgr, this.pfmgr, pContext));
                this.shutdownNotifier.shutdownIfNecessary();
            }
            this.loopHeadInvariants = lhi;
        }
        return this.loopHeadInvariants;
    }

    private static class VariableMapper
    implements FormulaVisitor<TraversalProcess> {
        private final Map<String, Formula> variableFormulas = new HashMap<String, Formula>();

        private VariableMapper() {
        }

        public TraversalProcess visitQuantifier(BooleanFormula pArg0, QuantifiedFormulaManager.Quantifier pArg1, List<Formula> pArg2, BooleanFormula pArg3) {
            return TraversalProcess.CONTINUE;
        }

        public TraversalProcess visitFunction(Formula pArg0, List<Formula> pArg1, FunctionDeclaration<?> pArg2) {
            return TraversalProcess.CONTINUE;
        }

        public TraversalProcess visitFreeVariable(Formula pArg0, String pArg1) {
            this.variableFormulas.put(pArg1, pArg0);
            return TraversalProcess.CONTINUE;
        }

        public TraversalProcess visitConstant(Formula pArg0, Object pArg1) {
            return TraversalProcess.CONTINUE;
        }

        public TraversalProcess visitBoundVariable(Formula pArg0, int pArg1) {
            return TraversalProcess.CONTINUE;
        }
    }
}

