/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import java.util.Objects;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class ModelValue {
    private final String variableName;
    private final FormulaManagerView fmgr;
    private final BooleanFormula formula;

    public ModelValue(String pVariableName, BooleanFormula pFormula, FormulaManagerView pFmgr) {
        this.variableName = Objects.requireNonNull(pVariableName);
        this.formula = Objects.requireNonNull(pFormula);
        this.fmgr = Objects.requireNonNull(pFmgr);
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String toString() {
        return this.formula.toString();
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof ModelValue) {
            ModelValue other = (ModelValue)pOther;
            return this.variableName.equals(other.variableName) && this.formula.equals(other.formula) && this.fmgr.equals(other.fmgr);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.variableName, this.formula);
    }

    public BooleanFormula toAssignment(FormulaManagerView pFMGR) {
        return pFMGR.translateFrom(this.formula, this.fmgr);
    }
}

