/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.algorithm.bmc.InterpolationHelper;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

class PartitionedFormulas {
    private static final String UNINITIALIZED_MSG = "The partitioned formulas have not been initialized yet, #collectFormulasFromARG must be called beforehand.";
    private final BooleanFormulaManagerView bfmgr;
    private final LogManager logger;
    private final boolean assertAllTargets;
    private boolean isInitialized;
    private BooleanFormula prefixFormula;
    private SSAMap prefixSsaMap;
    private ImmutableList<BooleanFormula> loopFormulas;
    private BooleanFormula targetAssertion;

    PartitionedFormulas(BooleanFormulaManagerView bfmgr, LogManager logger, boolean assertAllTargets) {
        this.bfmgr = bfmgr;
        this.logger = logger;
        this.assertAllTargets = assertAllTargets;
        this.isInitialized = false;
        this.prefixFormula = bfmgr.makeFalse();
        this.prefixSsaMap = SSAMap.emptySSAMap();
        this.loopFormulas = ImmutableList.of();
        this.targetAssertion = bfmgr.makeFalse();
    }

    int getNumLoops() {
        Preconditions.checkState((boolean)this.isInitialized, (Object)UNINITIALIZED_MSG);
        return this.loopFormulas.size();
    }

    SSAMap getPrefixSsaMap() {
        Preconditions.checkState((boolean)this.isInitialized, (Object)UNINITIALIZED_MSG);
        return this.prefixSsaMap;
    }

    BooleanFormula getPrefixFormula() {
        Preconditions.checkState((boolean)this.isInitialized, (Object)UNINITIALIZED_MSG);
        return this.prefixFormula;
    }

    List<BooleanFormula> getLoopFormulas() {
        Preconditions.checkState((boolean)this.isInitialized, (Object)UNINITIALIZED_MSG);
        return this.loopFormulas;
    }

    BooleanFormula getAssertionFormula() {
        Preconditions.checkState((boolean)this.isInitialized, (Object)UNINITIALIZED_MSG);
        return this.targetAssertion;
    }

    void collectFormulasFromARG(ReachedSet reachedSet) {
        this.logger.log(Level.FINE, new Object[]{"Collecting BMC-partitioning formulas"});
        this.isInitialized = true;
        FluentIterable<AbstractState> targetStatesAfterLoop = InterpolationHelper.getTargetStatesAfterLoop(reachedSet);
        if (targetStatesAfterLoop.isEmpty()) {
            this.prefixFormula = this.bfmgr.makeFalse();
            this.prefixSsaMap = SSAMap.emptySSAMap();
            this.loopFormulas = ImmutableList.of();
            this.targetAssertion = this.bfmgr.makeFalse();
            return;
        }
        ImmutableList abstractionStates = InterpolationHelper.getAbstractionStatesToRoot((AbstractState)targetStatesAfterLoop.get(0)).toList();
        assert (abstractionStates.size() > 3);
        PathFormula prefixPathFormula = InterpolationHelper.getPredicateAbstractionBlockFormula((AbstractState)abstractionStates.get(1));
        this.prefixFormula = prefixPathFormula.getFormula();
        this.prefixSsaMap = prefixPathFormula.getSsa();
        this.loopFormulas = Collections3.transformedImmutableListCopy(abstractionStates.subList(2, abstractionStates.size() - 1), absState -> InterpolationHelper.getPredicateAbstractionBlockFormula(absState).getFormula());
        BooleanFormula currentAssertion = InterpolationHelper.createDisjunctionFromStates(this.bfmgr, targetStatesAfterLoop);
        this.targetAssertion = this.assertAllTargets ? this.bfmgr.or(this.targetAssertion, currentAssertion) : currentAssertion;
        assert (!this.loopFormulas.isEmpty());
        this.logCollectedFormulas();
    }

    private void logCollectedFormulas() {
        if (this.loopFormulas.isEmpty()) {
            this.logger.log(Level.ALL, new Object[]{"No formulas collected yet"});
            return;
        }
        this.logger.log(Level.ALL, new Object[]{"Prefix:", this.prefixFormula});
        for (int i = 0; i < this.loopFormulas.size(); ++i) {
            this.logger.log(Level.ALL, new Object[]{"Loop ", i, ": ", this.loopFormulas.get(i)});
        }
        this.logger.log(Level.ALL, new Object[]{"Target:", this.targetAssertion});
    }
}

