/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import java.util.Optional;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;

public class ProofResult {
    private final boolean successful;
    private final Optional<Algorithm.AlgorithmStatus> earlyReturn;

    protected ProofResult(boolean pSuccessful) {
        this.successful = pSuccessful;
        this.earlyReturn = Optional.empty();
    }

    protected ProofResult(Algorithm.AlgorithmStatus pEarlyReturn) {
        this.successful = false;
        this.earlyReturn = Optional.of(pEarlyReturn);
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public Optional<Algorithm.AlgorithmStatus> getEarlyReturn() {
        return this.earlyReturn;
    }

    public String toString() {
        if (this.earlyReturn.isPresent()) {
            return this.earlyReturn.orElseThrow().toString();
        }
        return this.successful ? "Successful" : "Failure";
    }
}

