/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class ProverEnvironmentWithFallback
implements AutoCloseable,
InterpolatingProverEnvironment<Object> {
    private final Deque<BooleanFormula> stack = new ArrayDeque<BooleanFormula>();
    private final boolean useInterpolation;
    private final Solver solver;
    private @Nullable InterpolatingProverEnvironment<Object> interpolatingProverEnvironment;
    private @Nullable ProverEnvironment proverEnvironment;
    private boolean closed = false;
    private EnumSet<SolverContext.ProverOptions> proverOptions;
    private boolean isUnsat = false;

    public ProverEnvironmentWithFallback(Solver pSolver, SolverContext.ProverOptions ... pProverOptions) {
        this.solver = pSolver;
        this.proverOptions = EnumSet.copyOf(Arrays.asList(pProverOptions));
        this.useInterpolation = this.proverOptions.contains(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
    }

    private SolverContext.ProverOptions[] getOptions() {
        return this.proverOptions.toArray(new SolverContext.ProverOptions[0]);
    }

    private void ensureInitialized() {
        if (this.interpolatingProverEnvironment == null && this.proverEnvironment == null) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Already closed.");
            if (this.useInterpolation) {
                this.interpolatingProverEnvironment = this.solver.newProverEnvironmentWithInterpolation(this.getOptions());
            } else {
                this.proverEnvironment = this.solver.newProverEnvironment(this.getOptions());
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.interpolatingProverEnvironment != null) {
                this.interpolatingProverEnvironment.close();
            }
            if (this.proverEnvironment != null) {
                this.proverEnvironment.close();
            }
            this.stack.clear();
            this.closed = true;
        }
    }

    public boolean supportsInterpolation() {
        this.ensureInitialized();
        return this.interpolatingProverEnvironment != null;
    }

    public boolean supportsUnsatCoreGeneration() {
        return this.proverOptions.contains(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
    }

    public int size() {
        if (this.supportsInterpolation()) {
            return this.interpolatingProverEnvironment.size();
        }
        return this.proverEnvironment.size();
    }

    public Object push(BooleanFormula pFormula) throws InterruptedException {
        this.ensureInitialized();
        this.stack.push(pFormula);
        if (this.supportsInterpolation()) {
            return this.interpolatingProverEnvironment.push(pFormula);
        }
        this.proverEnvironment.push(pFormula);
        return this;
    }

    public void pop() {
        this.isUnsat = false;
        this.ensureInitialized();
        if (this.supportsInterpolation()) {
            this.interpolatingProverEnvironment.pop();
        } else {
            this.proverEnvironment.pop();
        }
        this.stack.pop();
    }

    public boolean isUnsat() throws SolverException, InterruptedException {
        this.ensureInitialized();
        if (this.supportsInterpolation()) {
            try {
                this.isUnsat = this.interpolatingProverEnvironment.isUnsat();
                return this.isUnsat;
            }
            catch (SolverException solverException) {
                this.interpolatingProverEnvironment.close();
                this.interpolatingProverEnvironment = null;
                this.proverEnvironment = this.solver.newProverEnvironment(this.getOptions());
                Iterator<BooleanFormula> it = this.stack.descendingIterator();
                while (it.hasNext()) {
                    this.proverEnvironment.push(it.next());
                }
                try {
                    return this.isUnsat();
                }
                catch (SolverException solverException2) {
                    solverException.addSuppressed((Throwable)solverException2);
                    throw solverException;
                }
            }
        }
        try {
            this.isUnsat = this.proverEnvironment.isUnsat();
            return this.isUnsat;
        }
        catch (SolverException solverException) {
            if (!this.supportsUnsatCoreGeneration()) {
                throw solverException;
            }
            this.proverEnvironment.close();
            this.proverEnvironment = null;
            this.proverOptions.remove(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
            this.proverEnvironment = this.solver.newProverEnvironment(this.getOptions());
            Iterator<BooleanFormula> it = this.stack.descendingIterator();
            while (it.hasNext()) {
                this.proverEnvironment.push(it.next());
            }
            try {
                return this.isUnsat();
            }
            catch (SolverException solverException2) {
                solverException.addSuppressed((Throwable)solverException2);
                throw solverException;
            }
        }
    }

    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pArg0) throws SolverException, InterruptedException {
        this.ensureInitialized();
        if (this.supportsInterpolation()) {
            return this.interpolatingProverEnvironment.isUnsatWithAssumptions(pArg0);
        }
        return this.proverEnvironment.isUnsatWithAssumptions(pArg0);
    }

    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pArg0) throws SolverException, InterruptedException {
        if (this.supportsInterpolation()) {
            return this.interpolatingProverEnvironment.unsatCoreOverAssumptions(pArg0);
        }
        return this.proverEnvironment.unsatCoreOverAssumptions(pArg0);
    }

    public List<BooleanFormula> getUnsatCore() {
        this.ensureInitialized();
        if (this.isUnsat && this.supportsUnsatCoreGeneration()) {
            return new ArrayList<BooleanFormula>(this.stack);
        }
        if (this.supportsInterpolation()) {
            return this.interpolatingProverEnvironment.getUnsatCore();
        }
        return this.proverEnvironment.getUnsatCore();
    }

    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        this.ensureInitialized();
        if (this.supportsInterpolation()) {
            return this.interpolatingProverEnvironment.getModelAssignments();
        }
        return this.proverEnvironment.getModelAssignments();
    }

    public BooleanFormula getInterpolant(Iterable<Object> pAssertionIds) throws SolverException, InterruptedException {
        this.ensureInitialized();
        Preconditions.checkState((boolean)this.supportsInterpolation(), (Object)"Interpolation has been switched off.");
        List assertionIds = pAssertionIds instanceof List ? (List)pAssertionIds : ImmutableList.copyOf(pAssertionIds);
        try {
            return this.interpolatingProverEnvironment.getInterpolant((Collection)assertionIds);
        }
        catch (SolverException solverException) {
            this.interpolatingProverEnvironment.close();
            this.interpolatingProverEnvironment = null;
            this.proverEnvironment = this.solver.newProverEnvironment(this.getOptions());
            Iterator<BooleanFormula> it = this.stack.descendingIterator();
            while (it.hasNext()) {
                this.proverEnvironment.push(it.next());
            }
            throw solverException;
        }
    }

    public @Nullable Object addConstraint(BooleanFormula pArg0) throws InterruptedException {
        this.ensureInitialized();
        if (this.supportsInterpolation()) {
            return this.interpolatingProverEnvironment.addConstraint(pArg0);
        }
        return this.proverEnvironment.addConstraint(pArg0);
    }

    public Model getModel() throws SolverException {
        this.ensureInitialized();
        if (this.supportsInterpolation()) {
            return this.interpolatingProverEnvironment.getModel();
        }
        return this.proverEnvironment.getModel();
    }

    public void push() {
        this.ensureInitialized();
        if (this.supportsInterpolation()) {
            this.interpolatingProverEnvironment.push();
        }
        this.proverEnvironment.push();
    }

    public List<BooleanFormula> getSeqInterpolants(List<? extends Collection<Object>> pArg0) throws SolverException, InterruptedException {
        this.ensureInitialized();
        Preconditions.checkState((boolean)this.supportsInterpolation(), (Object)"Interpolation has been switched off.");
        return this.interpolatingProverEnvironment.getSeqInterpolants(pArg0);
    }

    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<Object>> pArg0, int[] pArg1) throws SolverException, InterruptedException {
        this.ensureInitialized();
        Preconditions.checkState((boolean)this.supportsInterpolation(), (Object)"Interpolation has been switched off.");
        return this.interpolatingProverEnvironment.getTreeInterpolants(pArg0, pArg1);
    }

    public BooleanFormula getInterpolant(Collection<Object> pArg0) throws SolverException, InterruptedException {
        return this.getInterpolant((Iterable<Object>)pArg0);
    }

    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> pArg0, List<BooleanFormula> pArg1) throws InterruptedException, SolverException {
        this.ensureInitialized();
        if (this.supportsInterpolation()) {
            return (R)this.interpolatingProverEnvironment.allSat(pArg0, pArg1);
        }
        return (R)this.proverEnvironment.allSat(pArg0, pArg1);
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }
}

