/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.sosy_lab.cpachecker.core.algorithm.bmc.AssertCandidate;
import org.sosy_lab.cpachecker.core.algorithm.bmc.Lifting;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ProverEnvironmentWithFallback;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SymbolicCandiateInvariant;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public enum StandardLiftings implements Lifting
{
    NO_LIFTING{

        @Override
        public boolean canLift() {
            return false;
        }

        @Override
        public SymbolicCandiateInvariant lift(FormulaManagerView pFMGR, PredicateAbstractionManager pPam, ProverEnvironmentWithFallback pProver, SymbolicCandiateInvariant.BlockedCounterexampleToInductivity pBlockedConcreteCti, AssertCandidate pAssertPredecessor, Iterable<Object> pAssertionIds) {
            return pBlockedConcreteCti;
        }
    }
    ,
    UNSAT_BASED_LIFTING{

        @Override
        public boolean canLift() {
            return true;
        }

        @Override
        public SymbolicCandiateInvariant lift(FormulaManagerView pFMGR, PredicateAbstractionManager pPam, ProverEnvironmentWithFallback pProver, SymbolicCandiateInvariant.BlockedCounterexampleToInductivity pBlockedConcreteCti, AssertCandidate pAssertPredecessor, Iterable<Object> pAssertionIds) throws CPATransferException, InterruptedException, SolverException {
            return 2.unsatBasedLifting(pFMGR, pProver, pBlockedConcreteCti, pBlockedConcreteCti.getCti().splitLiterals(pFMGR, false), pAssertPredecessor, pAssertionIds, DoNothingUnsatCallback.INSTANCE);
        }
    };


    public static <T extends SymbolicCandiateInvariant> SymbolicCandiateInvariant unsatBasedLifting(FormulaManagerView pFMGR, ProverEnvironmentWithFallback pProver, T pBlockedCti, Iterable<? extends CandidateInvariant> pCtiLiterals, AssertCandidate pAssertPredecessor, Iterable<Object> pAssertionIds, UnsatCallback pUnsatCallback) throws CPATransferException, InterruptedException, SolverException {
        Object liftedBlockedCti;
        Iterator<? extends CandidateInvariant> literalIterator = pCtiLiterals.iterator();
        boolean isUnsat = false;
        boolean checked = false;
        ArrayList<BooleanFormula> assertedLiterals = new ArrayList<BooleanFormula>();
        ArrayList<Object> ctiLiteralAssertionIds = new ArrayList<Object>();
        while (literalIterator.hasNext() && !isUnsat) {
            CandidateInvariant literal = literalIterator.next();
            BooleanFormula literalFormula = pAssertPredecessor.assertCandidate(literal);
            for (BooleanFormula component : pFMGR.splitNumeralEqualityIfPossible(literalFormula)) {
                assertedLiterals.add(component);
                checked = false;
                ctiLiteralAssertionIds.add(pProver.push(component));
            }
            if (pProver.supportsUnsatCoreGeneration()) continue;
            isUnsat = pProver.isUnsat();
            checked = true;
        }
        if (!checked) {
            isUnsat = pProver.isUnsat();
            checked = true;
        }
        int pushes = ctiLiteralAssertionIds.size();
        if (isUnsat) {
            if (assertedLiterals.size() > 1 && pProver.supportsUnsatCoreGeneration()) {
                assertedLiterals.retainAll(pProver.getUnsatCore());
            }
            BooleanFormulaManagerView bfmgr = pFMGR.getBooleanFormulaManager();
            liftedBlockedCti = SymbolicCandiateInvariant.makeSymbolicInvariant(pBlockedCti.getApplicableLocations(), pBlockedCti.getStateFilter(), pFMGR.makeNot(pFMGR.uninstantiate(bfmgr.and(assertedLiterals))), pFMGR);
            pUnsatCallback.unsat((SymbolicCandiateInvariant)liftedBlockedCti, (Iterable<Object>)ctiLiteralAssertionIds, pAssertionIds);
        } else {
            liftedBlockedCti = pBlockedCti;
        }
        IntStream.range(0, pushes).forEach(i -> pProver.pop());
        return liftedBlockedCti;
    }

    static enum DoNothingUnsatCallback implements UnsatCallback
    {
        INSTANCE;


        @Override
        public void unsat(SymbolicCandiateInvariant pLiftedCTI, Iterable<Object> pCtiLiteralAssertionIds, Iterable<Object> pOtherAssertionIds) {
        }
    }

    static interface UnsatCallback {
        public void unsat(SymbolicCandiateInvariant var1, Iterable<Object> var2, Iterable<Object> var3) throws SolverException, InterruptedException;
    }
}

