/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CandidateGenerator;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;

public class StaticCandidateProvider
implements CandidateGenerator {
    private int nextOrdinal = Integer.MIN_VALUE;
    private final Map<CandidateInvariant, Integer> order = new HashMap<CandidateInvariant, Integer>();
    private final Set<CandidateInvariant> allCandidates;
    private final Set<CandidateInvariant> confirmedInvariants = new LinkedHashSet<CandidateInvariant>();
    private final Set<CandidateInvariant> refutedInvariants = new LinkedHashSet<CandidateInvariant>();
    private final NavigableSet<CandidateInvariant> candidates = new TreeSet<CandidateInvariant>(Comparator.comparingInt(this.order::get));
    private boolean produced = false;

    public StaticCandidateProvider(Iterable<? extends CandidateInvariant> pCandidates) {
        this.addAllCandidates(pCandidates);
        this.allCandidates = ImmutableSet.copyOf(pCandidates);
    }

    private boolean addAllCandidates(Iterable<? extends CandidateInvariant> pCandidateInvariants) {
        boolean changed = false;
        for (CandidateInvariant candidateInvariant : pCandidateInvariants) {
            if (!this.addCandidate(candidateInvariant)) continue;
            changed = true;
        }
        return changed;
    }

    private boolean addCandidate(CandidateInvariant pCandidateInvariant) {
        if (this.confirmedInvariants.contains(pCandidateInvariant) || this.refutedInvariants.contains(pCandidateInvariant) || this.order.containsKey(pCandidateInvariant)) {
            return false;
        }
        Integer oldValue = this.order.put(pCandidateInvariant, this.nextOrdinal++);
        assert (oldValue == null);
        if (!this.candidates.add(pCandidateInvariant)) {
            this.order.remove(pCandidateInvariant);
            return false;
        }
        return true;
    }

    @Override
    public boolean produceMoreCandidates() {
        if (this.produced) {
            return false;
        }
        this.produced = true;
        return !this.candidates.isEmpty();
    }

    @Override
    public boolean hasCandidatesAvailable() {
        return this.produced && !this.candidates.isEmpty();
    }

    @Override
    public void confirmCandidates(Iterable<CandidateInvariant> pCandidates) {
        for (CandidateInvariant candidate : pCandidates) {
            if (!this.order.containsKey(candidate)) continue;
            this.candidates.remove(candidate);
            this.order.remove(candidate);
        }
        Iterables.addAll(this.confirmedInvariants, pCandidates);
    }

    @Override
    public Iterator<CandidateInvariant> iterator() {
        if (!this.produced) {
            return Collections.emptyIterator();
        }
        final Iterator<CandidateInvariant> iterator = this.candidates.descendingIterator();
        return new Iterator<CandidateInvariant>(){
            private @Nullable CandidateInvariant candidate;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public CandidateInvariant next() {
                this.candidate = (CandidateInvariant)iterator.next();
                return this.candidate;
            }

            @Override
            public void remove() {
                Preconditions.checkState((this.candidate != null ? 1 : 0) != 0);
                StaticCandidateProvider.this.refutedInvariants.add(this.candidate);
                iterator.remove();
                StaticCandidateProvider.this.order.remove(this.candidate);
                this.candidate = null;
            }
        };
    }

    public Set<CandidateInvariant> getConfirmedCandidates() {
        return Collections.unmodifiableSet(this.confirmedInvariants);
    }

    @Override
    public boolean suggestCandidates(Iterable<? extends CandidateInvariant> pCandidates) {
        return this.addAllCandidates(pCandidates);
    }

    public Set<CandidateInvariant> getAllCandidates() {
        return this.allCandidates;
    }
}

