/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.LoopIterationReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;

public class UnrolledReachedSet {
    private final Algorithm algorithm;
    private final ConfigurableProgramAnalysis cpa;
    private final Set<CFANode> loopHeads;
    private final ReachedSet reachedSet;
    private final EnsureK ensureK;
    private @Nullable Set<Object> containedLoopBoundKeys = null;
    private int k = -1;
    private Algorithm.AlgorithmStatus lastStatus = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;

    public UnrolledReachedSet(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCPA, Set<CFANode> pLoopHeads, ReachedSet pReachedSet, EnsureK pEnsureK) {
        this.algorithm = Objects.requireNonNull(pAlgorithm);
        this.cpa = Objects.requireNonNull(pCPA);
        this.loopHeads = Objects.requireNonNull(pLoopHeads);
        this.reachedSet = Objects.requireNonNull(pReachedSet);
        this.ensureK = Objects.requireNonNull(pEnsureK);
    }

    public ReachedSet getReachedSet() {
        return this.reachedSet;
    }

    public int getCurrentMaxK() {
        return this.k;
    }

    public int getDesiredK() {
        LoopBoundCPA loopBoundCPA = CPAs.retrieveCPA(this.cpa, LoopBoundCPA.class);
        return loopBoundCPA == null ? Integer.MAX_VALUE : loopBoundCPA.getMaxLoopIterations();
    }

    public void setDesiredK(int pK) {
        LoopBoundCPA loopBoundCPA = CPAs.retrieveCPA(this.cpa, LoopBoundCPA.class);
        if (loopBoundCPA != null) {
            loopBoundCPA.setMaxLoopIterations(pK);
        }
    }

    public Algorithm.AlgorithmStatus ensureK() throws InterruptedException, CPAException {
        if (this.getDesiredK() > this.k) {
            this.lastStatus = this.ensureK.ensureK(this.algorithm, this.cpa, this.reachedSet);
            this.k = this.getDesiredK();
            this.containedLoopBoundKeys = null;
        }
        return this.lastStatus;
    }

    public Set<Object> getContainedLoopBoundKeys() {
        if (this.containedLoopBoundKeys == null) {
            this.getContainedLoopBoundKeys(this.k);
        }
        return this.containedLoopBoundKeys;
    }

    public Set<Object> getContainedLoopBoundKeys(int pK) {
        if (pK == this.k && this.containedLoopBoundKeys != null) {
            return this.containedLoopBoundKeys;
        }
        ImmutableSet containedLoopBoundKeysK = AbstractStates.filterLocations(this.reachedSet, this.loopHeads).transform(s -> AbstractStates.extractStateByType(s, LoopIterationReportingState.class)).filter(ls -> ls.getDeepestIteration() <= pK).transform(Partitionable::getPartitionKey).toSet();
        if (pK == this.k) {
            this.containedLoopBoundKeys = containedLoopBoundKeysK;
        }
        return containedLoopBoundKeysK;
    }

    public static interface EnsureK {
        public Algorithm.AlgorithmStatus ensureK(Algorithm var1, ConfigurableProgramAnalysis var2, ReachedSet var3) throws InterruptedException, CPAException;
    }
}

