/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SingleLocationFormulaInvariant;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class CandidateInvariantCombination {
    public static CandidateInvariant conjunction(Iterable<? extends CandidateInvariant> pOperands) {
        return CandidateInvariantCombination.of(pOperands, true);
    }

    private static CandidateInvariant of(Iterable<? extends CandidateInvariant> pOperands, boolean pConjunction) {
        ImmutableSet locations;
        ImmutableSet operands = ImmutableSet.copyOf(CandidateInvariantCombination.flatten(pOperands));
        if (operands.size() == 1) {
            return (CandidateInvariant)operands.iterator().next();
        }
        FluentIterable singleLocationOperands = FluentIterable.from((Iterable)operands).filter(SingleLocationFormulaInvariant.class);
        if (singleLocationOperands.size() == operands.size() && (locations = singleLocationOperands.transform(SingleLocationFormulaInvariant::getLocation).toSet()).size() == 1) {
            SingleLocationFormulaInvariant result = CandidateInvariantCombination.singleLocationConjunction((Iterable<? extends SingleLocationFormulaInvariant>)operands);
            return result;
        }
        return new GenericCombination((ImmutableSet<? extends CandidateInvariant>)operands, pConjunction);
    }

    public static SingleLocationFormulaInvariant singleLocationConjunction(SingleLocationFormulaInvariant ... pOperands) {
        return CandidateInvariantCombination.singleLocationConjunction(Arrays.asList(pOperands));
    }

    public static SingleLocationFormulaInvariant singleLocationConjunction(Iterable<? extends SingleLocationFormulaInvariant> pOperands) {
        ImmutableSet operands = ImmutableSet.copyOf(pOperands);
        if (operands.size() == 1) {
            return (SingleLocationFormulaInvariant)operands.iterator().next();
        }
        return new SingleLocationCombination((Iterable<SingleLocationFormulaInvariant>)operands, true);
    }

    public static SingleLocationFormulaInvariant singleLocationDisjunction(SingleLocationFormulaInvariant ... pOperands) {
        return CandidateInvariantCombination.singleLocationConjunction(Arrays.asList(pOperands));
    }

    public static SingleLocationFormulaInvariant singleLocationDisjunction(Iterable<? extends SingleLocationFormulaInvariant> pOperands) {
        ImmutableSet operands = ImmutableSet.copyOf(pOperands);
        if (operands.size() == 1) {
            return (SingleLocationFormulaInvariant)operands.iterator().next();
        }
        return new SingleLocationCombination((Iterable<SingleLocationFormulaInvariant>)operands, false);
    }

    private static Iterable<CandidateInvariant> flatten(Iterable<? extends CandidateInvariant> pOperands) {
        return FluentIterable.from(pOperands).transformAndConcat(operand -> {
            if (operand instanceof Combination) {
                return CandidateInvariantCombination.flatten(((Combination)operand).getOperands());
            }
            return Collections.singleton(operand);
        });
    }

    public static Iterable<CandidateInvariant> getConjunctiveParts(CandidateInvariant pCandidateInvariant) {
        if (pCandidateInvariant instanceof Combination && ((Combination)pCandidateInvariant).isConjunction()) {
            return ((Combination)pCandidateInvariant).getOperands();
        }
        return Collections.singleton(pCandidateInvariant);
    }

    public static Iterable<CandidateInvariant> getDisjunctiveParts(Iterable<CandidateInvariant> pCandidateInvariants) {
        return FluentIterable.from(pCandidateInvariants).transformAndConcat(CandidateInvariantCombination::getDisjunctiveParts);
    }

    public static Iterable<CandidateInvariant> getDisjunctiveParts(CandidateInvariant pCandidateInvariant) {
        if (pCandidateInvariant instanceof Combination && !((Combination)pCandidateInvariant).isConjunction()) {
            return ((Combination)pCandidateInvariant).getOperands();
        }
        return Collections.singleton(pCandidateInvariant);
    }

    public static Iterable<CandidateInvariant> getConjunctiveParts(Iterable<CandidateInvariant> pCandidateInvariants) {
        return FluentIterable.from(pCandidateInvariants).transformAndConcat(CandidateInvariantCombination::getConjunctiveParts);
    }

    private static CFANode getSingleLocation(Iterable<SingleLocationFormulaInvariant> pSingleLocationFormulaInvariants) {
        Iterator<SingleLocationFormulaInvariant> it = pSingleLocationFormulaInvariants.iterator();
        if (it.hasNext()) {
            CFANode location = it.next().getLocation();
            if (it.hasNext()) {
                assert (Iterators.all(it, inv -> inv.getLocation().equals(location))) : "Expected all operands to apply to the same single location, but at least two are different: " + pSingleLocationFormulaInvariants;
                return location;
            }
        }
        throw new IllegalArgumentException("It makes no sense to use a CandidateInvariantConjunction unless there are at least two operands.");
    }

    private static class SingleLocationCombination
    extends SingleLocationFormulaInvariant
    implements Combination {
        private final Combination delegate;

        private SingleLocationCombination(Iterable<SingleLocationFormulaInvariant> pOperands, boolean pConjunction) {
            super(CandidateInvariantCombination.getSingleLocation(pOperands));
            this.delegate = new GenericCombination((ImmutableSet<? extends CandidateInvariant>)ImmutableSet.copyOf(pOperands), pConjunction);
        }

        @Override
        public BooleanFormula getFormula(FormulaManagerView pFMGR, PathFormulaManager pPFMGR, @Nullable PathFormula pContext) throws CPATransferException, InterruptedException {
            return this.delegate.getFormula(pFMGR, pPFMGR, pContext);
        }

        @Override
        public void assumeTruth(ReachedSet pReachedSet) {
            this.delegate.assumeTruth(pReachedSet);
        }

        @Override
        public Set<CandidateInvariant> getOperands() {
            return this.delegate.getOperands();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public boolean isConjunction() {
            return this.delegate.isConjunction();
        }
    }

    private static class GenericCombination
    implements Combination {
        private final Set<CandidateInvariant> operands;
        private final boolean conjunction;

        private GenericCombination(ImmutableSet<? extends CandidateInvariant> pOperands, boolean pConjunction) {
            Preconditions.checkArgument((pOperands.size() > 1 ? 1 : 0) != 0, (Object)"It makes no sense to use a CandidateInvariantCombination unless there are at least two operands.");
            this.conjunction = pConjunction;
            this.operands = ImmutableSet.copyOf(pOperands);
        }

        @Override
        public BooleanFormula getFormula(FormulaManagerView pFMGR, PathFormulaManager pPFMGR, @Nullable PathFormula pContext) throws CPATransferException, InterruptedException {
            BooleanFormula formula;
            BooleanFormulaManagerView bfmgr = pFMGR.getBooleanFormulaManager();
            if (this.isConjunction()) {
                formula = bfmgr.makeTrue();
                for (CandidateInvariant operand : this.operands) {
                    formula = bfmgr.and(formula, operand.getFormula(pFMGR, pPFMGR, pContext));
                }
            } else {
                formula = bfmgr.makeFalse();
                for (CandidateInvariant operand : this.operands) {
                    formula = bfmgr.or(formula, operand.getFormula(pFMGR, pPFMGR, pContext));
                }
            }
            return formula;
        }

        @Override
        public BooleanFormula getAssertion(Iterable<AbstractState> pReachedSet, FormulaManagerView pFMGR, PathFormulaManager pPFMGR) throws CPATransferException, InterruptedException {
            BooleanFormula formula;
            BooleanFormulaManagerView bfmgr = pFMGR.getBooleanFormulaManager();
            if (this.isConjunction()) {
                formula = bfmgr.makeTrue();
                for (CandidateInvariant operand : this.operands) {
                    formula = bfmgr.and(formula, operand.getAssertion(pReachedSet, pFMGR, pPFMGR));
                }
            } else {
                formula = bfmgr.makeFalse();
                for (CandidateInvariant operand : this.operands) {
                    formula = bfmgr.or(formula, operand.getAssertion(pReachedSet, pFMGR, pPFMGR));
                }
            }
            return formula;
        }

        @Override
        public void assumeTruth(ReachedSet pReachedSet) {
            if (this.isConjunction()) {
                for (CandidateInvariant element : this.operands) {
                    element.assumeTruth(pReachedSet);
                }
            }
        }

        public int hashCode() {
            return this.operands.hashCode() << 1 | (this.isConjunction() ? 1 : 0);
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther instanceof GenericCombination) {
                GenericCombination other = (GenericCombination)pOther;
                return this.conjunction == other.conjunction && this.operands.equals(((GenericCombination)pOther).operands);
            }
            return false;
        }

        public String toString() {
            return this.operands.stream().map(Object::toString).collect(Collectors.joining(this.isConjunction() ? " and " : " or "));
        }

        @Override
        public boolean appliesTo(CFANode pLocation) {
            return Iterables.any(this.operands, e -> e.appliesTo(pLocation));
        }

        @Override
        public Set<CandidateInvariant> getOperands() {
            return this.operands;
        }

        @Override
        public boolean isConjunction() {
            return this.conjunction;
        }

        @Override
        public Iterable<AbstractState> filterApplicable(Iterable<AbstractState> pStates) {
            return FluentIterable.from(pStates).filter(s -> this.operands.stream().anyMatch(op -> !Iterables.isEmpty(op.filterApplicable(Collections.singleton(s)))));
        }
    }

    private static interface Combination
    extends CandidateInvariant {
        public Set<CandidateInvariant> getOperands();

        public boolean isConjunction();

        @Override
        public Iterable<AbstractState> filterApplicable(Iterable<AbstractState> var1);
    }
}

