/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.ExpressionTreeCandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SingleLocationFormulaInvariant;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class EdgeFormulaNegation
extends SingleLocationFormulaInvariant
implements ExpressionTreeCandidateInvariant {
    private final AssumeEdge edge;

    public EdgeFormulaNegation(CFANode pLocation, AssumeEdge pEdge) {
        super(pLocation);
        Preconditions.checkNotNull((Object)pEdge);
        this.edge = pEdge;
    }

    @Override
    public BooleanFormula getFormula(FormulaManagerView pFMGR, PathFormulaManager pPFMGR, PathFormula pContext) throws CPATransferException, InterruptedException {
        PathFormula clearContext = pPFMGR.makeEmptyPathFormulaWithContextFrom(pContext);
        PathFormula invariantPathFormula = pPFMGR.makeAnd(clearContext, this.edge);
        return pFMGR.getBooleanFormulaManager().not(pFMGR.uninstantiate(invariantPathFormula.getFormula()));
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO instanceof EdgeFormulaNegation) {
            EdgeFormulaNegation other = (EdgeFormulaNegation)pO;
            return this.getLocation().equals(other.getLocation()) && this.edge.getTruthAssumption() == other.edge.getTruthAssumption() && this.edge.getExpression().equals(other.edge.getExpression());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getLocation(), this.edge.getTruthAssumption(), this.edge.getExpression());
    }

    public String toString() {
        return this.asExpressionTree().toString();
    }

    @Override
    public void assumeTruth(ReachedSet pReachedSet) {
        if (this.appliesTo(this.edge.getPredecessor())) {
            ImmutableList infeasibleStates = ImmutableList.copyOf(AbstractStates.filterLocation(pReachedSet, this.edge.getSuccessor()));
            pReachedSet.removeAll((Iterable<? extends AbstractState>)infeasibleStates);
            for (ARGState s : FluentIterable.from((Iterable)infeasibleStates).filter(ARGState.class)) {
                s.removeFromARG();
            }
        }
    }

    @Override
    public ExpressionTree<Object> asExpressionTree() {
        return LeafExpression.of(this.edge.getExpression(), !this.edge.getTruthAssumption());
    }
}

